/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.OrderBy;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeLogStreamsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeLogStreamsRequest> {
    private final String logGroupName;
    private final String logStreamNamePrefix;
    private final String orderBy;
    private final Boolean descending;
    private final String nextToken;
    private final Integer limit;

    private DescribeLogStreamsRequest(BuilderImpl builder) {
        this.logGroupName = builder.logGroupName;
        this.logStreamNamePrefix = builder.logStreamNamePrefix;
        this.orderBy = builder.orderBy;
        this.descending = builder.descending;
        this.nextToken = builder.nextToken;
        this.limit = builder.limit;
    }

    public String logGroupName() {
        return this.logGroupName;
    }

    public String logStreamNamePrefix() {
        return this.logStreamNamePrefix;
    }

    public String orderBy() {
        return this.orderBy;
    }

    public Boolean descending() {
        return this.descending;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer limit() {
        return this.limit;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.logGroupName() == null ? 0 : this.logGroupName().hashCode());
        hashCode = 31 * hashCode + (this.logStreamNamePrefix() == null ? 0 : this.logStreamNamePrefix().hashCode());
        hashCode = 31 * hashCode + (this.orderBy() == null ? 0 : this.orderBy().hashCode());
        hashCode = 31 * hashCode + (this.descending() == null ? 0 : this.descending().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        hashCode = 31 * hashCode + (this.limit() == null ? 0 : this.limit().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLogStreamsRequest)) {
            return false;
        }
        DescribeLogStreamsRequest other = (DescribeLogStreamsRequest)((Object)obj);
        if (other.logGroupName() == null ^ this.logGroupName() == null) {
            return false;
        }
        if (other.logGroupName() != null && !other.logGroupName().equals(this.logGroupName())) {
            return false;
        }
        if (other.logStreamNamePrefix() == null ^ this.logStreamNamePrefix() == null) {
            return false;
        }
        if (other.logStreamNamePrefix() != null && !other.logStreamNamePrefix().equals(this.logStreamNamePrefix())) {
            return false;
        }
        if (other.orderBy() == null ^ this.orderBy() == null) {
            return false;
        }
        if (other.orderBy() != null && !other.orderBy().equals(this.orderBy())) {
            return false;
        }
        if (other.descending() == null ^ this.descending() == null) {
            return false;
        }
        if (other.descending() != null && !other.descending().equals(this.descending())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.limit() == null ^ this.limit() == null) {
            return false;
        }
        return other.limit() == null || other.limit().equals(this.limit());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.logGroupName() != null) {
            sb.append("LogGroupName: ").append(this.logGroupName()).append(",");
        }
        if (this.logStreamNamePrefix() != null) {
            sb.append("LogStreamNamePrefix: ").append(this.logStreamNamePrefix()).append(",");
        }
        if (this.orderBy() != null) {
            sb.append("OrderBy: ").append(this.orderBy()).append(",");
        }
        if (this.descending() != null) {
            sb.append("Descending: ").append(this.descending()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (this.limit() != null) {
            sb.append("Limit: ").append(this.limit()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String logGroupName;
        private String logStreamNamePrefix;
        private String orderBy;
        private Boolean descending;
        private String nextToken;
        private Integer limit;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLogStreamsRequest model) {
            this.setLogGroupName(model.logGroupName);
            this.setLogStreamNamePrefix(model.logStreamNamePrefix);
            this.setOrderBy(model.orderBy);
            this.setDescending(model.descending);
            this.setNextToken(model.nextToken);
            this.setLimit(model.limit);
        }

        public final String getLogGroupName() {
            return this.logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        public final String getLogStreamNamePrefix() {
            return this.logStreamNamePrefix;
        }

        @Override
        public final Builder logStreamNamePrefix(String logStreamNamePrefix) {
            this.logStreamNamePrefix = logStreamNamePrefix;
            return this;
        }

        public final void setLogStreamNamePrefix(String logStreamNamePrefix) {
            this.logStreamNamePrefix = logStreamNamePrefix;
        }

        public final String getOrderBy() {
            return this.orderBy;
        }

        @Override
        public final Builder orderBy(String orderBy) {
            this.orderBy = orderBy;
            return this;
        }

        @Override
        public final Builder orderBy(OrderBy orderBy) {
            this.orderBy(orderBy.toString());
            return this;
        }

        public final void setOrderBy(String orderBy) {
            this.orderBy = orderBy;
        }

        public final void setOrderBy(OrderBy orderBy) {
            this.orderBy(orderBy.toString());
        }

        public final Boolean getDescending() {
            return this.descending;
        }

        @Override
        public final Builder descending(Boolean descending) {
            this.descending = descending;
            return this;
        }

        public final void setDescending(Boolean descending) {
            this.descending = descending;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public DescribeLogStreamsRequest build() {
            return new DescribeLogStreamsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeLogStreamsRequest> {
        public Builder logGroupName(String var1);

        public Builder logStreamNamePrefix(String var1);

        public Builder orderBy(String var1);

        public Builder orderBy(OrderBy var1);

        public Builder descending(Boolean var1);

        public Builder nextToken(String var1);

        public Builder limit(Integer var1);
    }
}

