/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.cloudwatchlogs.model.LogGroup;
import software.amazon.awssdk.services.cloudwatchlogs.model.LogGroupsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeLogGroupsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeLogGroupsResponse> {
    private final List<LogGroup> logGroups;
    private final String nextToken;

    private DescribeLogGroupsResponse(BuilderImpl builder) {
        this.logGroups = builder.logGroups;
        this.nextToken = builder.nextToken;
    }

    public List<LogGroup> logGroups() {
        return this.logGroups;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.logGroups() == null ? 0 : this.logGroups().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLogGroupsResponse)) {
            return false;
        }
        DescribeLogGroupsResponse other = (DescribeLogGroupsResponse)((Object)obj);
        if (other.logGroups() == null ^ this.logGroups() == null) {
            return false;
        }
        if (other.logGroups() != null && !other.logGroups().equals(this.logGroups())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.logGroups() != null) {
            sb.append("LogGroups: ").append(this.logGroups()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<LogGroup> logGroups = new SdkInternalList();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLogGroupsResponse model) {
            this.setLogGroups(model.logGroups);
            this.setNextToken(model.nextToken);
        }

        public final Collection<LogGroup> getLogGroups() {
            return this.logGroups;
        }

        @Override
        public final Builder logGroups(Collection<LogGroup> logGroups) {
            this.logGroups = LogGroupsCopier.copy(logGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logGroups(LogGroup ... logGroups) {
            if (this.logGroups == null) {
                this.logGroups = new SdkInternalList(logGroups.length);
            }
            for (LogGroup e : logGroups) {
                this.logGroups.add(e);
            }
            return this;
        }

        public final void setLogGroups(Collection<LogGroup> logGroups) {
            this.logGroups = LogGroupsCopier.copy(logGroups);
        }

        @SafeVarargs
        public final void setLogGroups(LogGroup ... logGroups) {
            if (this.logGroups == null) {
                this.logGroups = new SdkInternalList(logGroups.length);
            }
            for (LogGroup e : logGroups) {
                this.logGroups.add(e);
            }
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeLogGroupsResponse build() {
            return new DescribeLogGroupsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeLogGroupsResponse> {
        public Builder logGroups(Collection<LogGroup> var1);

        public Builder logGroups(LogGroup ... var1);

        public Builder nextToken(String var1);
    }
}

