/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeLogGroupsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeLogGroupsRequest> {
    private final String logGroupNamePrefix;
    private final String nextToken;
    private final Integer limit;

    private DescribeLogGroupsRequest(BuilderImpl builder) {
        this.logGroupNamePrefix = builder.logGroupNamePrefix;
        this.nextToken = builder.nextToken;
        this.limit = builder.limit;
    }

    public String logGroupNamePrefix() {
        return this.logGroupNamePrefix;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer limit() {
        return this.limit;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.logGroupNamePrefix() == null ? 0 : this.logGroupNamePrefix().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        hashCode = 31 * hashCode + (this.limit() == null ? 0 : this.limit().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLogGroupsRequest)) {
            return false;
        }
        DescribeLogGroupsRequest other = (DescribeLogGroupsRequest)((Object)obj);
        if (other.logGroupNamePrefix() == null ^ this.logGroupNamePrefix() == null) {
            return false;
        }
        if (other.logGroupNamePrefix() != null && !other.logGroupNamePrefix().equals(this.logGroupNamePrefix())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.limit() == null ^ this.limit() == null) {
            return false;
        }
        return other.limit() == null || other.limit().equals(this.limit());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.logGroupNamePrefix() != null) {
            sb.append("LogGroupNamePrefix: ").append(this.logGroupNamePrefix()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (this.limit() != null) {
            sb.append("Limit: ").append(this.limit()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String logGroupNamePrefix;
        private String nextToken;
        private Integer limit;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLogGroupsRequest model) {
            this.setLogGroupNamePrefix(model.logGroupNamePrefix);
            this.setNextToken(model.nextToken);
            this.setLimit(model.limit);
        }

        public final String getLogGroupNamePrefix() {
            return this.logGroupNamePrefix;
        }

        @Override
        public final Builder logGroupNamePrefix(String logGroupNamePrefix) {
            this.logGroupNamePrefix = logGroupNamePrefix;
            return this;
        }

        public final void setLogGroupNamePrefix(String logGroupNamePrefix) {
            this.logGroupNamePrefix = logGroupNamePrefix;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public DescribeLogGroupsRequest build() {
            return new DescribeLogGroupsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeLogGroupsRequest> {
        public Builder logGroupNamePrefix(String var1);

        public Builder nextToken(String var1);

        public Builder limit(Integer var1);
    }
}

