/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.cloudwatchlogs.model.ExportTask;
import software.amazon.awssdk.services.cloudwatchlogs.model.ExportTasksCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeExportTasksResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeExportTasksResponse> {
    private final List<ExportTask> exportTasks;
    private final String nextToken;

    private DescribeExportTasksResponse(BuilderImpl builder) {
        this.exportTasks = builder.exportTasks;
        this.nextToken = builder.nextToken;
    }

    public List<ExportTask> exportTasks() {
        return this.exportTasks;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.exportTasks() == null ? 0 : this.exportTasks().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeExportTasksResponse)) {
            return false;
        }
        DescribeExportTasksResponse other = (DescribeExportTasksResponse)((Object)obj);
        if (other.exportTasks() == null ^ this.exportTasks() == null) {
            return false;
        }
        if (other.exportTasks() != null && !other.exportTasks().equals(this.exportTasks())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.exportTasks() != null) {
            sb.append("ExportTasks: ").append(this.exportTasks()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<ExportTask> exportTasks = new SdkInternalList();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeExportTasksResponse model) {
            this.setExportTasks(model.exportTasks);
            this.setNextToken(model.nextToken);
        }

        public final Collection<ExportTask> getExportTasks() {
            return this.exportTasks;
        }

        @Override
        public final Builder exportTasks(Collection<ExportTask> exportTasks) {
            this.exportTasks = ExportTasksCopier.copy(exportTasks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exportTasks(ExportTask ... exportTasks) {
            if (this.exportTasks == null) {
                this.exportTasks = new SdkInternalList(exportTasks.length);
            }
            for (ExportTask e : exportTasks) {
                this.exportTasks.add(e);
            }
            return this;
        }

        public final void setExportTasks(Collection<ExportTask> exportTasks) {
            this.exportTasks = ExportTasksCopier.copy(exportTasks);
        }

        @SafeVarargs
        public final void setExportTasks(ExportTask ... exportTasks) {
            if (this.exportTasks == null) {
                this.exportTasks = new SdkInternalList(exportTasks.length);
            }
            for (ExportTask e : exportTasks) {
                this.exportTasks.add(e);
            }
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeExportTasksResponse build() {
            return new DescribeExportTasksResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeExportTasksResponse> {
        public Builder exportTasks(Collection<ExportTask> var1);

        public Builder exportTasks(ExportTask ... var1);

        public Builder nextToken(String var1);
    }
}

