/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.ExportTaskStatusCode;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeExportTasksRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeExportTasksRequest> {
    private final String taskId;
    private final String statusCode;
    private final String nextToken;
    private final Integer limit;

    private DescribeExportTasksRequest(BuilderImpl builder) {
        this.taskId = builder.taskId;
        this.statusCode = builder.statusCode;
        this.nextToken = builder.nextToken;
        this.limit = builder.limit;
    }

    public String taskId() {
        return this.taskId;
    }

    public String statusCode() {
        return this.statusCode;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer limit() {
        return this.limit;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.taskId() == null ? 0 : this.taskId().hashCode());
        hashCode = 31 * hashCode + (this.statusCode() == null ? 0 : this.statusCode().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        hashCode = 31 * hashCode + (this.limit() == null ? 0 : this.limit().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeExportTasksRequest)) {
            return false;
        }
        DescribeExportTasksRequest other = (DescribeExportTasksRequest)((Object)obj);
        if (other.taskId() == null ^ this.taskId() == null) {
            return false;
        }
        if (other.taskId() != null && !other.taskId().equals(this.taskId())) {
            return false;
        }
        if (other.statusCode() == null ^ this.statusCode() == null) {
            return false;
        }
        if (other.statusCode() != null && !other.statusCode().equals(this.statusCode())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.limit() == null ^ this.limit() == null) {
            return false;
        }
        return other.limit() == null || other.limit().equals(this.limit());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.taskId() != null) {
            sb.append("TaskId: ").append(this.taskId()).append(",");
        }
        if (this.statusCode() != null) {
            sb.append("StatusCode: ").append(this.statusCode()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (this.limit() != null) {
            sb.append("Limit: ").append(this.limit()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String taskId;
        private String statusCode;
        private String nextToken;
        private Integer limit;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeExportTasksRequest model) {
            this.setTaskId(model.taskId);
            this.setStatusCode(model.statusCode);
            this.setNextToken(model.nextToken);
            this.setLimit(model.limit);
        }

        public final String getTaskId() {
            return this.taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        public final String getStatusCode() {
            return this.statusCode;
        }

        @Override
        public final Builder statusCode(String statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public final Builder statusCode(ExportTaskStatusCode statusCode) {
            this.statusCode(statusCode.toString());
            return this;
        }

        public final void setStatusCode(String statusCode) {
            this.statusCode = statusCode;
        }

        public final void setStatusCode(ExportTaskStatusCode statusCode) {
            this.statusCode(statusCode.toString());
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public DescribeExportTasksRequest build() {
            return new DescribeExportTasksRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeExportTasksRequest> {
        public Builder taskId(String var1);

        public Builder statusCode(String var1);

        public Builder statusCode(ExportTaskStatusCode var1);

        public Builder nextToken(String var1);

        public Builder limit(Integer var1);
    }
}

