/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.cloudwatchlogs.model.Destination;
import software.amazon.awssdk.services.cloudwatchlogs.model.DestinationsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeDestinationsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeDestinationsResponse> {
    private final List<Destination> destinations;
    private final String nextToken;

    private DescribeDestinationsResponse(BuilderImpl builder) {
        this.destinations = builder.destinations;
        this.nextToken = builder.nextToken;
    }

    public List<Destination> destinations() {
        return this.destinations;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.destinations() == null ? 0 : this.destinations().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDestinationsResponse)) {
            return false;
        }
        DescribeDestinationsResponse other = (DescribeDestinationsResponse)((Object)obj);
        if (other.destinations() == null ^ this.destinations() == null) {
            return false;
        }
        if (other.destinations() != null && !other.destinations().equals(this.destinations())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.destinations() != null) {
            sb.append("Destinations: ").append(this.destinations()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Destination> destinations = new SdkInternalList();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDestinationsResponse model) {
            this.setDestinations(model.destinations);
            this.setNextToken(model.nextToken);
        }

        public final Collection<Destination> getDestinations() {
            return this.destinations;
        }

        @Override
        public final Builder destinations(Collection<Destination> destinations) {
            this.destinations = DestinationsCopier.copy(destinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(Destination ... destinations) {
            if (this.destinations == null) {
                this.destinations = new SdkInternalList(destinations.length);
            }
            for (Destination e : destinations) {
                this.destinations.add(e);
            }
            return this;
        }

        public final void setDestinations(Collection<Destination> destinations) {
            this.destinations = DestinationsCopier.copy(destinations);
        }

        @SafeVarargs
        public final void setDestinations(Destination ... destinations) {
            if (this.destinations == null) {
                this.destinations = new SdkInternalList(destinations.length);
            }
            for (Destination e : destinations) {
                this.destinations.add(e);
            }
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeDestinationsResponse build() {
            return new DescribeDestinationsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeDestinationsResponse> {
        public Builder destinations(Collection<Destination> var1);

        public Builder destinations(Destination ... var1);

        public Builder nextToken(String var1);
    }
}

