/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeDestinationsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeDestinationsRequest> {
    private final String destinationNamePrefix;
    private final String nextToken;
    private final Integer limit;

    private DescribeDestinationsRequest(BuilderImpl builder) {
        this.destinationNamePrefix = builder.destinationNamePrefix;
        this.nextToken = builder.nextToken;
        this.limit = builder.limit;
    }

    public String destinationNamePrefix() {
        return this.destinationNamePrefix;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer limit() {
        return this.limit;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.destinationNamePrefix() == null ? 0 : this.destinationNamePrefix().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        hashCode = 31 * hashCode + (this.limit() == null ? 0 : this.limit().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDestinationsRequest)) {
            return false;
        }
        DescribeDestinationsRequest other = (DescribeDestinationsRequest)((Object)obj);
        if (other.destinationNamePrefix() == null ^ this.destinationNamePrefix() == null) {
            return false;
        }
        if (other.destinationNamePrefix() != null && !other.destinationNamePrefix().equals(this.destinationNamePrefix())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.limit() == null ^ this.limit() == null) {
            return false;
        }
        return other.limit() == null || other.limit().equals(this.limit());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.destinationNamePrefix() != null) {
            sb.append("DestinationNamePrefix: ").append(this.destinationNamePrefix()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (this.limit() != null) {
            sb.append("Limit: ").append(this.limit()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String destinationNamePrefix;
        private String nextToken;
        private Integer limit;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDestinationsRequest model) {
            this.setDestinationNamePrefix(model.destinationNamePrefix);
            this.setNextToken(model.nextToken);
            this.setLimit(model.limit);
        }

        public final String getDestinationNamePrefix() {
            return this.destinationNamePrefix;
        }

        @Override
        public final Builder destinationNamePrefix(String destinationNamePrefix) {
            this.destinationNamePrefix = destinationNamePrefix;
            return this;
        }

        public final void setDestinationNamePrefix(String destinationNamePrefix) {
            this.destinationNamePrefix = destinationNamePrefix;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public DescribeDestinationsRequest build() {
            return new DescribeDestinationsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeDestinationsRequest> {
        public Builder destinationNamePrefix(String var1);

        public Builder nextToken(String var1);

        public Builder limit(Integer var1);
    }
}

