/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateLogStreamRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateLogStreamRequest> {
    private final String logGroupName;
    private final String logStreamName;

    private CreateLogStreamRequest(BuilderImpl builder) {
        this.logGroupName = builder.logGroupName;
        this.logStreamName = builder.logStreamName;
    }

    public String logGroupName() {
        return this.logGroupName;
    }

    public String logStreamName() {
        return this.logStreamName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.logGroupName() == null ? 0 : this.logGroupName().hashCode());
        hashCode = 31 * hashCode + (this.logStreamName() == null ? 0 : this.logStreamName().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLogStreamRequest)) {
            return false;
        }
        CreateLogStreamRequest other = (CreateLogStreamRequest)((Object)obj);
        if (other.logGroupName() == null ^ this.logGroupName() == null) {
            return false;
        }
        if (other.logGroupName() != null && !other.logGroupName().equals(this.logGroupName())) {
            return false;
        }
        if (other.logStreamName() == null ^ this.logStreamName() == null) {
            return false;
        }
        return other.logStreamName() == null || other.logStreamName().equals(this.logStreamName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.logGroupName() != null) {
            sb.append("LogGroupName: ").append(this.logGroupName()).append(",");
        }
        if (this.logStreamName() != null) {
            sb.append("LogStreamName: ").append(this.logStreamName()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String logGroupName;
        private String logStreamName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLogStreamRequest model) {
            this.setLogGroupName(model.logGroupName);
            this.setLogStreamName(model.logStreamName);
        }

        public final String getLogGroupName() {
            return this.logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        public final String getLogStreamName() {
            return this.logStreamName;
        }

        @Override
        public final Builder logStreamName(String logStreamName) {
            this.logStreamName = logStreamName;
            return this;
        }

        public final void setLogStreamName(String logStreamName) {
            this.logStreamName = logStreamName;
        }

        public CreateLogStreamRequest build() {
            return new CreateLogStreamRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateLogStreamRequest> {
        public Builder logGroupName(String var1);

        public Builder logStreamName(String var1);
    }
}

