/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateExportTaskRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateExportTaskRequest> {
    private final String taskName;
    private final String logGroupName;
    private final String logStreamNamePrefix;
    private final Long from;
    private final Long to;
    private final String destination;
    private final String destinationPrefix;

    private CreateExportTaskRequest(BuilderImpl builder) {
        this.taskName = builder.taskName;
        this.logGroupName = builder.logGroupName;
        this.logStreamNamePrefix = builder.logStreamNamePrefix;
        this.from = builder.from;
        this.to = builder.to;
        this.destination = builder.destination;
        this.destinationPrefix = builder.destinationPrefix;
    }

    public String taskName() {
        return this.taskName;
    }

    public String logGroupName() {
        return this.logGroupName;
    }

    public String logStreamNamePrefix() {
        return this.logStreamNamePrefix;
    }

    public Long from() {
        return this.from;
    }

    public Long to() {
        return this.to;
    }

    public String destination() {
        return this.destination;
    }

    public String destinationPrefix() {
        return this.destinationPrefix;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.taskName() == null ? 0 : this.taskName().hashCode());
        hashCode = 31 * hashCode + (this.logGroupName() == null ? 0 : this.logGroupName().hashCode());
        hashCode = 31 * hashCode + (this.logStreamNamePrefix() == null ? 0 : this.logStreamNamePrefix().hashCode());
        hashCode = 31 * hashCode + (this.from() == null ? 0 : this.from().hashCode());
        hashCode = 31 * hashCode + (this.to() == null ? 0 : this.to().hashCode());
        hashCode = 31 * hashCode + (this.destination() == null ? 0 : this.destination().hashCode());
        hashCode = 31 * hashCode + (this.destinationPrefix() == null ? 0 : this.destinationPrefix().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateExportTaskRequest)) {
            return false;
        }
        CreateExportTaskRequest other = (CreateExportTaskRequest)((Object)obj);
        if (other.taskName() == null ^ this.taskName() == null) {
            return false;
        }
        if (other.taskName() != null && !other.taskName().equals(this.taskName())) {
            return false;
        }
        if (other.logGroupName() == null ^ this.logGroupName() == null) {
            return false;
        }
        if (other.logGroupName() != null && !other.logGroupName().equals(this.logGroupName())) {
            return false;
        }
        if (other.logStreamNamePrefix() == null ^ this.logStreamNamePrefix() == null) {
            return false;
        }
        if (other.logStreamNamePrefix() != null && !other.logStreamNamePrefix().equals(this.logStreamNamePrefix())) {
            return false;
        }
        if (other.from() == null ^ this.from() == null) {
            return false;
        }
        if (other.from() != null && !other.from().equals(this.from())) {
            return false;
        }
        if (other.to() == null ^ this.to() == null) {
            return false;
        }
        if (other.to() != null && !other.to().equals(this.to())) {
            return false;
        }
        if (other.destination() == null ^ this.destination() == null) {
            return false;
        }
        if (other.destination() != null && !other.destination().equals(this.destination())) {
            return false;
        }
        if (other.destinationPrefix() == null ^ this.destinationPrefix() == null) {
            return false;
        }
        return other.destinationPrefix() == null || other.destinationPrefix().equals(this.destinationPrefix());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.taskName() != null) {
            sb.append("TaskName: ").append(this.taskName()).append(",");
        }
        if (this.logGroupName() != null) {
            sb.append("LogGroupName: ").append(this.logGroupName()).append(",");
        }
        if (this.logStreamNamePrefix() != null) {
            sb.append("LogStreamNamePrefix: ").append(this.logStreamNamePrefix()).append(",");
        }
        if (this.from() != null) {
            sb.append("From: ").append(this.from()).append(",");
        }
        if (this.to() != null) {
            sb.append("To: ").append(this.to()).append(",");
        }
        if (this.destination() != null) {
            sb.append("Destination: ").append(this.destination()).append(",");
        }
        if (this.destinationPrefix() != null) {
            sb.append("DestinationPrefix: ").append(this.destinationPrefix()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String taskName;
        private String logGroupName;
        private String logStreamNamePrefix;
        private Long from;
        private Long to;
        private String destination;
        private String destinationPrefix;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateExportTaskRequest model) {
            this.setTaskName(model.taskName);
            this.setLogGroupName(model.logGroupName);
            this.setLogStreamNamePrefix(model.logStreamNamePrefix);
            this.setFrom(model.from);
            this.setTo(model.to);
            this.setDestination(model.destination);
            this.setDestinationPrefix(model.destinationPrefix);
        }

        public final String getTaskName() {
            return this.taskName;
        }

        @Override
        public final Builder taskName(String taskName) {
            this.taskName = taskName;
            return this;
        }

        public final void setTaskName(String taskName) {
            this.taskName = taskName;
        }

        public final String getLogGroupName() {
            return this.logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        public final String getLogStreamNamePrefix() {
            return this.logStreamNamePrefix;
        }

        @Override
        public final Builder logStreamNamePrefix(String logStreamNamePrefix) {
            this.logStreamNamePrefix = logStreamNamePrefix;
            return this;
        }

        public final void setLogStreamNamePrefix(String logStreamNamePrefix) {
            this.logStreamNamePrefix = logStreamNamePrefix;
        }

        public final Long getFrom() {
            return this.from;
        }

        @Override
        public final Builder from(Long from) {
            this.from = from;
            return this;
        }

        public final void setFrom(Long from) {
            this.from = from;
        }

        public final Long getTo() {
            return this.to;
        }

        @Override
        public final Builder to(Long to) {
            this.to = to;
            return this;
        }

        public final void setTo(Long to) {
            this.to = to;
        }

        public final String getDestination() {
            return this.destination;
        }

        @Override
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        public final String getDestinationPrefix() {
            return this.destinationPrefix;
        }

        @Override
        public final Builder destinationPrefix(String destinationPrefix) {
            this.destinationPrefix = destinationPrefix;
            return this;
        }

        public final void setDestinationPrefix(String destinationPrefix) {
            this.destinationPrefix = destinationPrefix;
        }

        public CreateExportTaskRequest build() {
            return new CreateExportTaskRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateExportTaskRequest> {
        public Builder taskName(String var1);

        public Builder logGroupName(String var1);

        public Builder logStreamNamePrefix(String var1);

        public Builder from(Long var1);

        public Builder to(Long var1);

        public Builder destination(String var1);

        public Builder destinationPrefix(String var1);
    }
}

