/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs;

import java.net.URI;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.auth.Aws4Signer;
import software.amazon.awssdk.auth.Signer;
import software.amazon.awssdk.auth.StaticSignerProvider;
import software.amazon.awssdk.client.builder.ClientBuilder;
import software.amazon.awssdk.client.builder.DefaultClientBuilder;
import software.amazon.awssdk.config.defaults.ClientConfigurationDefaults;
import software.amazon.awssdk.config.defaults.ServiceBuilderConfigurationDefaults;
import software.amazon.awssdk.runtime.auth.SignerProvider;
import software.amazon.awssdk.services.cloudwatchlogs.CloudWatchLogsBaseClientBuilder;

@SdkInternalApi
abstract class DefaultCloudWatchLogsBaseClientBuilder<B extends CloudWatchLogsBaseClientBuilder<B, C>, C>
extends DefaultClientBuilder<B, C>
implements ClientBuilder<B, C> {
    DefaultCloudWatchLogsBaseClientBuilder() {
    }

    protected final String serviceEndpointPrefix() {
        return "logs";
    }

    protected final ClientConfigurationDefaults serviceDefaults() {
        return ServiceBuilderConfigurationDefaults.builder().defaultSignerProvider(this::defaultSignerProvider).addRequestHandlerPath("/software/amazon/awssdk/services/cloudwatchlogs/request.handler2s").defaultEndpoint(this::defaultEndpoint).build();
    }

    private SignerProvider defaultSignerProvider() {
        Aws4Signer signer = new Aws4Signer();
        signer.setServiceName("logs");
        signer.setRegionName(this.signingRegion().value());
        return new StaticSignerProvider((Signer)signer);
    }

    private URI defaultEndpoint() {
        return null;
    }
}

