/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.location.model.BatchGetDevicePositionRequestDeviceIdsListCopier;
import software.amazon.awssdk.services.location.model.LocationRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetDevicePositionRequest
extends LocationRequest
implements ToCopyableBuilder<Builder, BatchGetDevicePositionRequest> {
    private static final SdkField<String> TRACKER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrackerName").getter(BatchGetDevicePositionRequest.getter(BatchGetDevicePositionRequest::trackerName)).setter(BatchGetDevicePositionRequest.setter(Builder::trackerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("TrackerName").build()}).build();
    private static final SdkField<List<String>> DEVICE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DeviceIds").getter(BatchGetDevicePositionRequest.getter(BatchGetDevicePositionRequest::deviceIds)).setter(BatchGetDevicePositionRequest.setter(Builder::deviceIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRACKER_NAME_FIELD, DEVICE_IDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchGetDevicePositionRequest.memberNameToFieldInitializer();
    private final String trackerName;
    private final List<String> deviceIds;

    private BatchGetDevicePositionRequest(BuilderImpl builder) {
        super(builder);
        this.trackerName = builder.trackerName;
        this.deviceIds = builder.deviceIds;
    }

    public final String trackerName() {
        return this.trackerName;
    }

    public final boolean hasDeviceIds() {
        return this.deviceIds != null && !(this.deviceIds instanceof SdkAutoConstructList);
    }

    public final List<String> deviceIds() {
        return this.deviceIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.trackerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDeviceIds() ? this.deviceIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetDevicePositionRequest)) {
            return false;
        }
        BatchGetDevicePositionRequest other = (BatchGetDevicePositionRequest)((Object)obj);
        return Objects.equals(this.trackerName(), other.trackerName()) && this.hasDeviceIds() == other.hasDeviceIds() && Objects.equals(this.deviceIds(), other.deviceIds());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetDevicePositionRequest").add("TrackerName", (Object)this.trackerName()).add("DeviceIds", this.hasDeviceIds() ? this.deviceIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrackerName": {
                return Optional.ofNullable(clazz.cast(this.trackerName()));
            }
            case "DeviceIds": {
                return Optional.ofNullable(clazz.cast(this.deviceIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TrackerName", TRACKER_NAME_FIELD);
        map.put("DeviceIds", DEVICE_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetDevicePositionRequest, T> g) {
        return obj -> g.apply((BatchGetDevicePositionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LocationRequest.BuilderImpl
    implements Builder {
        private String trackerName;
        private List<String> deviceIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetDevicePositionRequest model) {
            super(model);
            this.trackerName(model.trackerName);
            this.deviceIds(model.deviceIds);
        }

        public final String getTrackerName() {
            return this.trackerName;
        }

        public final void setTrackerName(String trackerName) {
            this.trackerName = trackerName;
        }

        @Override
        public final Builder trackerName(String trackerName) {
            this.trackerName = trackerName;
            return this;
        }

        public final Collection<String> getDeviceIds() {
            if (this.deviceIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.deviceIds;
        }

        public final void setDeviceIds(Collection<String> deviceIds) {
            this.deviceIds = BatchGetDevicePositionRequestDeviceIdsListCopier.copy(deviceIds);
        }

        @Override
        public final Builder deviceIds(Collection<String> deviceIds) {
            this.deviceIds = BatchGetDevicePositionRequestDeviceIdsListCopier.copy(deviceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deviceIds(String ... deviceIds) {
            this.deviceIds(Arrays.asList(deviceIds));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchGetDevicePositionRequest build() {
            return new BatchGetDevicePositionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LocationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetDevicePositionRequest> {
        public Builder trackerName(String var1);

        public Builder deviceIds(Collection<String> var1);

        public Builder deviceIds(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

