/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.location.model.LocationRequest;
import software.amazon.awssdk.services.location.model.TrackingFilterGeometry;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDevicePositionsRequest
extends LocationRequest
implements ToCopyableBuilder<Builder, ListDevicePositionsRequest> {
    private static final SdkField<String> TRACKER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrackerName").getter(ListDevicePositionsRequest.getter(ListDevicePositionsRequest::trackerName)).setter(ListDevicePositionsRequest.setter(Builder::trackerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("TrackerName").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListDevicePositionsRequest.getter(ListDevicePositionsRequest::maxResults)).setter(ListDevicePositionsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListDevicePositionsRequest.getter(ListDevicePositionsRequest::nextToken)).setter(ListDevicePositionsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<TrackingFilterGeometry> FILTER_GEOMETRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FilterGeometry").getter(ListDevicePositionsRequest.getter(ListDevicePositionsRequest::filterGeometry)).setter(ListDevicePositionsRequest.setter(Builder::filterGeometry)).constructor(TrackingFilterGeometry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterGeometry").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRACKER_NAME_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, FILTER_GEOMETRY_FIELD));
    private final String trackerName;
    private final Integer maxResults;
    private final String nextToken;
    private final TrackingFilterGeometry filterGeometry;

    private ListDevicePositionsRequest(BuilderImpl builder) {
        super(builder);
        this.trackerName = builder.trackerName;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.filterGeometry = builder.filterGeometry;
    }

    public final String trackerName() {
        return this.trackerName;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final TrackingFilterGeometry filterGeometry() {
        return this.filterGeometry;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.trackerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterGeometry());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDevicePositionsRequest)) {
            return false;
        }
        ListDevicePositionsRequest other = (ListDevicePositionsRequest)((Object)obj);
        return Objects.equals(this.trackerName(), other.trackerName()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.filterGeometry(), other.filterGeometry());
    }

    public final String toString() {
        return ToString.builder((String)"ListDevicePositionsRequest").add("TrackerName", (Object)this.trackerName()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("FilterGeometry", (Object)this.filterGeometry()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrackerName": {
                return Optional.ofNullable(clazz.cast(this.trackerName()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "FilterGeometry": {
                return Optional.ofNullable(clazz.cast(this.filterGeometry()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDevicePositionsRequest, T> g) {
        return obj -> g.apply((ListDevicePositionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LocationRequest.BuilderImpl
    implements Builder {
        private String trackerName;
        private Integer maxResults;
        private String nextToken;
        private TrackingFilterGeometry filterGeometry;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDevicePositionsRequest model) {
            super(model);
            this.trackerName(model.trackerName);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.filterGeometry(model.filterGeometry);
        }

        public final String getTrackerName() {
            return this.trackerName;
        }

        public final void setTrackerName(String trackerName) {
            this.trackerName = trackerName;
        }

        @Override
        public final Builder trackerName(String trackerName) {
            this.trackerName = trackerName;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final TrackingFilterGeometry.Builder getFilterGeometry() {
            return this.filterGeometry != null ? this.filterGeometry.toBuilder() : null;
        }

        public final void setFilterGeometry(TrackingFilterGeometry.BuilderImpl filterGeometry) {
            this.filterGeometry = filterGeometry != null ? filterGeometry.build() : null;
        }

        @Override
        public final Builder filterGeometry(TrackingFilterGeometry filterGeometry) {
            this.filterGeometry = filterGeometry;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListDevicePositionsRequest build() {
            return new ListDevicePositionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LocationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDevicePositionsRequest> {
        public Builder trackerName(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder filterGeometry(TrackingFilterGeometry var1);

        default public Builder filterGeometry(Consumer<TrackingFilterGeometry.Builder> filterGeometry) {
            return this.filterGeometry((TrackingFilterGeometry)((TrackingFilterGeometry.Builder)TrackingFilterGeometry.builder().applyMutation(filterGeometry)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

