/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateMapRequest extends LocationRequest implements
        ToCopyableBuilder<UpdateMapRequest.Builder, UpdateMapRequest> {
    private static final SdkField<String> MAP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MapName").getter(getter(UpdateMapRequest::mapName)).setter(setter(Builder::mapName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("MapName").build()).build();

    private static final SdkField<String> PRICING_PLAN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PricingPlan").getter(getter(UpdateMapRequest::pricingPlanAsString)).setter(setter(Builder::pricingPlan))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PricingPlan").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateMapRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<MapConfigurationUpdate> CONFIGURATION_UPDATE_FIELD = SdkField
            .<MapConfigurationUpdate> builder(MarshallingType.SDK_POJO).memberName("ConfigurationUpdate")
            .getter(getter(UpdateMapRequest::configurationUpdate)).setter(setter(Builder::configurationUpdate))
            .constructor(MapConfigurationUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationUpdate").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAP_NAME_FIELD,
            PRICING_PLAN_FIELD, DESCRIPTION_FIELD, CONFIGURATION_UPDATE_FIELD));

    private final String mapName;

    private final String pricingPlan;

    private final String description;

    private final MapConfigurationUpdate configurationUpdate;

    private UpdateMapRequest(BuilderImpl builder) {
        super(builder);
        this.mapName = builder.mapName;
        this.pricingPlan = builder.pricingPlan;
        this.description = builder.description;
        this.configurationUpdate = builder.configurationUpdate;
    }

    /**
     * <p>
     * The name of the map resource to update.
     * </p>
     * 
     * @return The name of the map resource to update.
     */
    public final String mapName() {
        return mapName;
    }

    /**
     * <p>
     * No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pricingPlan} will
     * return {@link PricingPlan#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #pricingPlanAsString}.
     * </p>
     * 
     * @return No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.
     * @see PricingPlan
     * @deprecated Deprecated. If included, the only allowed value is RequestBasedUsage.
     */
    @Deprecated
    public final PricingPlan pricingPlan() {
        return PricingPlan.fromValue(pricingPlan);
    }

    /**
     * <p>
     * No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pricingPlan} will
     * return {@link PricingPlan#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #pricingPlanAsString}.
     * </p>
     * 
     * @return No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.
     * @see PricingPlan
     * @deprecated Deprecated. If included, the only allowed value is RequestBasedUsage.
     */
    @Deprecated
    public final String pricingPlanAsString() {
        return pricingPlan;
    }

    /**
     * <p>
     * Updates the description for the map resource.
     * </p>
     * 
     * @return Updates the description for the map resource.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Updates the parts of the map configuration that can be updated, including the political view.
     * </p>
     * 
     * @return Updates the parts of the map configuration that can be updated, including the political view.
     */
    public final MapConfigurationUpdate configurationUpdate() {
        return configurationUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(mapName());
        hashCode = 31 * hashCode + Objects.hashCode(pricingPlanAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(configurationUpdate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMapRequest)) {
            return false;
        }
        UpdateMapRequest other = (UpdateMapRequest) obj;
        return Objects.equals(mapName(), other.mapName()) && Objects.equals(pricingPlanAsString(), other.pricingPlanAsString())
                && Objects.equals(description(), other.description())
                && Objects.equals(configurationUpdate(), other.configurationUpdate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateMapRequest").add("MapName", mapName()).add("PricingPlan", pricingPlanAsString())
                .add("Description", description()).add("ConfigurationUpdate", configurationUpdate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MapName":
            return Optional.ofNullable(clazz.cast(mapName()));
        case "PricingPlan":
            return Optional.ofNullable(clazz.cast(pricingPlanAsString()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ConfigurationUpdate":
            return Optional.ofNullable(clazz.cast(configurationUpdate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateMapRequest, T> g) {
        return obj -> g.apply((UpdateMapRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LocationRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateMapRequest> {
        /**
         * <p>
         * The name of the map resource to update.
         * </p>
         * 
         * @param mapName
         *        The name of the map resource to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mapName(String mapName);

        /**
         * <p>
         * No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.
         * </p>
         * 
         * @param pricingPlan
         *        No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.
         * @see PricingPlan
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PricingPlan
         * @deprecated Deprecated. If included, the only allowed value is RequestBasedUsage.
         */
        @Deprecated
        Builder pricingPlan(String pricingPlan);

        /**
         * <p>
         * No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.
         * </p>
         * 
         * @param pricingPlan
         *        No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.
         * @see PricingPlan
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PricingPlan
         * @deprecated Deprecated. If included, the only allowed value is RequestBasedUsage.
         */
        @Deprecated
        Builder pricingPlan(PricingPlan pricingPlan);

        /**
         * <p>
         * Updates the description for the map resource.
         * </p>
         * 
         * @param description
         *        Updates the description for the map resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Updates the parts of the map configuration that can be updated, including the political view.
         * </p>
         * 
         * @param configurationUpdate
         *        Updates the parts of the map configuration that can be updated, including the political view.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationUpdate(MapConfigurationUpdate configurationUpdate);

        /**
         * <p>
         * Updates the parts of the map configuration that can be updated, including the political view.
         * </p>
         * This is a convenience method that creates an instance of the {@link MapConfigurationUpdate.Builder} avoiding
         * the need to create one manually via {@link MapConfigurationUpdate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MapConfigurationUpdate.Builder#build()} is called immediately and
         * its result is passed to {@link #configurationUpdate(MapConfigurationUpdate)}.
         * 
         * @param configurationUpdate
         *        a consumer that will call methods on {@link MapConfigurationUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configurationUpdate(MapConfigurationUpdate)
         */
        default Builder configurationUpdate(Consumer<MapConfigurationUpdate.Builder> configurationUpdate) {
            return configurationUpdate(MapConfigurationUpdate.builder().applyMutation(configurationUpdate).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LocationRequest.BuilderImpl implements Builder {
        private String mapName;

        private String pricingPlan;

        private String description;

        private MapConfigurationUpdate configurationUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMapRequest model) {
            super(model);
            mapName(model.mapName);
            pricingPlan(model.pricingPlan);
            description(model.description);
            configurationUpdate(model.configurationUpdate);
        }

        public final String getMapName() {
            return mapName;
        }

        public final void setMapName(String mapName) {
            this.mapName = mapName;
        }

        @Override
        public final Builder mapName(String mapName) {
            this.mapName = mapName;
            return this;
        }

        @Deprecated
        public final String getPricingPlan() {
            return pricingPlan;
        }

        @Deprecated
        public final void setPricingPlan(String pricingPlan) {
            this.pricingPlan = pricingPlan;
        }

        @Override
        @Deprecated
        public final Builder pricingPlan(String pricingPlan) {
            this.pricingPlan = pricingPlan;
            return this;
        }

        @Override
        @Deprecated
        public final Builder pricingPlan(PricingPlan pricingPlan) {
            this.pricingPlan(pricingPlan == null ? null : pricingPlan.toString());
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final MapConfigurationUpdate.Builder getConfigurationUpdate() {
            return configurationUpdate != null ? configurationUpdate.toBuilder() : null;
        }

        public final void setConfigurationUpdate(MapConfigurationUpdate.BuilderImpl configurationUpdate) {
            this.configurationUpdate = configurationUpdate != null ? configurationUpdate.build() : null;
        }

        @Override
        public final Builder configurationUpdate(MapConfigurationUpdate configurationUpdate) {
            this.configurationUpdate = configurationUpdate;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateMapRequest build() {
            return new UpdateMapRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
