/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The geomerty used to filter device positions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TrackingFilterGeometry implements SdkPojo, Serializable,
        ToCopyableBuilder<TrackingFilterGeometry.Builder, TrackingFilterGeometry> {
    private static final SdkField<List<List<List<Double>>>> POLYGON_FIELD = SdkField
            .<List<List<List<Double>>>> builder(MarshallingType.LIST)
            .memberName("Polygon")
            .getter(getter(TrackingFilterGeometry::polygon))
            .setter(setter(Builder::polygon))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Polygon").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<List<List<Double>>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<List<Double>> builder(MarshallingType.LIST)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build(),
                                                                                    ListTrait
                                                                                            .builder()
                                                                                            .memberLocationName(null)
                                                                                            .memberFieldInfo(
                                                                                                    SdkField.<Double> builder(
                                                                                                            MarshallingType.DOUBLE)
                                                                                                            .traits(LocationTrait
                                                                                                                    .builder()
                                                                                                                    .location(
                                                                                                                            MarshallLocation.PAYLOAD)
                                                                                                                    .locationName(
                                                                                                                            "member")
                                                                                                                    .build())
                                                                                                            .build()).build())
                                                                            .build()).build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLYGON_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<List<List<Double>>> polygon;

    private TrackingFilterGeometry(BuilderImpl builder) {
        this.polygon = builder.polygon;
    }

    /**
     * For responses, this returns true if the service returned a value for the Polygon property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPolygon() {
        return polygon != null && !(polygon instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The set of arrays which define the polygon. A polygon can have between 4 and 1000 vertices.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPolygon} method.
     * </p>
     * 
     * @return The set of arrays which define the polygon. A polygon can have between 4 and 1000 vertices.
     */
    public final List<List<List<Double>>> polygon() {
        return polygon;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasPolygon() ? polygon() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrackingFilterGeometry)) {
            return false;
        }
        TrackingFilterGeometry other = (TrackingFilterGeometry) obj;
        return hasPolygon() == other.hasPolygon() && Objects.equals(polygon(), other.polygon());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TrackingFilterGeometry")
                .add("Polygon", polygon() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Polygon":
            return Optional.ofNullable(clazz.cast(polygon()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TrackingFilterGeometry, T> g) {
        return obj -> g.apply((TrackingFilterGeometry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TrackingFilterGeometry> {
        /**
         * <p>
         * The set of arrays which define the polygon. A polygon can have between 4 and 1000 vertices.
         * </p>
         * 
         * @param polygon
         *        The set of arrays which define the polygon. A polygon can have between 4 and 1000 vertices.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder polygon(Collection<? extends Collection<? extends Collection<Double>>> polygon);

        /**
         * <p>
         * The set of arrays which define the polygon. A polygon can have between 4 and 1000 vertices.
         * </p>
         * 
         * @param polygon
         *        The set of arrays which define the polygon. A polygon can have between 4 and 1000 vertices.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder polygon(Collection<? extends Collection<Double>>... polygon);
    }

    static final class BuilderImpl implements Builder {
        private List<List<List<Double>>> polygon = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TrackingFilterGeometry model) {
            polygon(model.polygon);
        }

        public final Collection<? extends Collection<? extends Collection<Double>>> getPolygon() {
            if (polygon instanceof SdkAutoConstructList) {
                return null;
            }
            return polygon;
        }

        public final void setPolygon(Collection<? extends Collection<? extends Collection<Double>>> polygon) {
            this.polygon = LinearRingsCopier.copy(polygon);
        }

        @Override
        public final Builder polygon(Collection<? extends Collection<? extends Collection<Double>>> polygon) {
            this.polygon = LinearRingsCopier.copy(polygon);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder polygon(Collection<? extends Collection<Double>>... polygon) {
            polygon(Arrays.asList(polygon));
            return this;
        }

        @Override
        public TrackingFilterGeometry build() {
            return new TrackingFilterGeometry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
