/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteKeyRequest extends LocationRequest implements
        ToCopyableBuilder<DeleteKeyRequest.Builder, DeleteKeyRequest> {
    private static final SdkField<String> KEY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KeyName").getter(getter(DeleteKeyRequest::keyName)).setter(setter(Builder::keyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("KeyName").build()).build();

    private static final SdkField<Boolean> FORCE_DELETE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ForceDelete").getter(getter(DeleteKeyRequest::forceDelete)).setter(setter(Builder::forceDelete))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("forceDelete").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_NAME_FIELD,
            FORCE_DELETE_FIELD));

    private final String keyName;

    private final Boolean forceDelete;

    private DeleteKeyRequest(BuilderImpl builder) {
        super(builder);
        this.keyName = builder.keyName;
        this.forceDelete = builder.forceDelete;
    }

    /**
     * <p>
     * The name of the API key to delete.
     * </p>
     * 
     * @return The name of the API key to delete.
     */
    public final String keyName() {
        return keyName;
    }

    /**
     * <p>
     * ForceDelete bypasses an API key's expiry conditions and deletes the key. Set the parameter <code>true</code> to
     * delete the key or to <code>false</code> to not preemptively delete the API key.
     * </p>
     * <p>
     * Valid values: <code>true</code>, or <code>false</code>.
     * </p>
     * <p>
     * Required: No
     * </p>
     * <note>
     * <p>
     * This action is irreversible. Only use ForceDelete if you are certain the key is no longer in use.
     * </p>
     * </note>
     * 
     * @return ForceDelete bypasses an API key's expiry conditions and deletes the key. Set the parameter
     *         <code>true</code> to delete the key or to <code>false</code> to not preemptively delete the API key.</p>
     *         <p>
     *         Valid values: <code>true</code>, or <code>false</code>.
     *         </p>
     *         <p>
     *         Required: No
     *         </p>
     *         <note>
     *         <p>
     *         This action is irreversible. Only use ForceDelete if you are certain the key is no longer in use.
     *         </p>
     */
    public final Boolean forceDelete() {
        return forceDelete;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(keyName());
        hashCode = 31 * hashCode + Objects.hashCode(forceDelete());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteKeyRequest)) {
            return false;
        }
        DeleteKeyRequest other = (DeleteKeyRequest) obj;
        return Objects.equals(keyName(), other.keyName()) && Objects.equals(forceDelete(), other.forceDelete());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteKeyRequest").add("KeyName", keyName()).add("ForceDelete", forceDelete()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KeyName":
            return Optional.ofNullable(clazz.cast(keyName()));
        case "ForceDelete":
            return Optional.ofNullable(clazz.cast(forceDelete()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteKeyRequest, T> g) {
        return obj -> g.apply((DeleteKeyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LocationRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteKeyRequest> {
        /**
         * <p>
         * The name of the API key to delete.
         * </p>
         * 
         * @param keyName
         *        The name of the API key to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyName(String keyName);

        /**
         * <p>
         * ForceDelete bypasses an API key's expiry conditions and deletes the key. Set the parameter <code>true</code>
         * to delete the key or to <code>false</code> to not preemptively delete the API key.
         * </p>
         * <p>
         * Valid values: <code>true</code>, or <code>false</code>.
         * </p>
         * <p>
         * Required: No
         * </p>
         * <note>
         * <p>
         * This action is irreversible. Only use ForceDelete if you are certain the key is no longer in use.
         * </p>
         * </note>
         * 
         * @param forceDelete
         *        ForceDelete bypasses an API key's expiry conditions and deletes the key. Set the parameter
         *        <code>true</code> to delete the key or to <code>false</code> to not preemptively delete the API
         *        key.</p>
         *        <p>
         *        Valid values: <code>true</code>, or <code>false</code>.
         *        </p>
         *        <p>
         *        Required: No
         *        </p>
         *        <note>
         *        <p>
         *        This action is irreversible. Only use ForceDelete if you are certain the key is no longer in use.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forceDelete(Boolean forceDelete);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LocationRequest.BuilderImpl implements Builder {
        private String keyName;

        private Boolean forceDelete;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteKeyRequest model) {
            super(model);
            keyName(model.keyName);
            forceDelete(model.forceDelete);
        }

        public final String getKeyName() {
            return keyName;
        }

        public final void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        @Override
        public final Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public final Boolean getForceDelete() {
            return forceDelete;
        }

        public final void setForceDelete(Boolean forceDelete) {
            this.forceDelete = forceDelete;
        }

        @Override
        public final Builder forceDelete(Boolean forceDelete) {
            this.forceDelete = forceDelete;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteKeyRequest build() {
            return new DeleteKeyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
