/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about additional route preferences for requests that specify <code>TravelMode</code> as
 * <code>Car</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CalculateRouteCarModeOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<CalculateRouteCarModeOptions.Builder, CalculateRouteCarModeOptions> {
    private static final SdkField<Boolean> AVOID_FERRIES_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AvoidFerries").getter(getter(CalculateRouteCarModeOptions::avoidFerries))
            .setter(setter(Builder::avoidFerries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvoidFerries").build()).build();

    private static final SdkField<Boolean> AVOID_TOLLS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AvoidTolls").getter(getter(CalculateRouteCarModeOptions::avoidTolls))
            .setter(setter(Builder::avoidTolls))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvoidTolls").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVOID_FERRIES_FIELD,
            AVOID_TOLLS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean avoidFerries;

    private final Boolean avoidTolls;

    private CalculateRouteCarModeOptions(BuilderImpl builder) {
        this.avoidFerries = builder.avoidFerries;
        this.avoidTolls = builder.avoidTolls;
    }

    /**
     * <p>
     * Avoids ferries when calculating routes.
     * </p>
     * <p>
     * Default Value: <code>false</code>
     * </p>
     * <p>
     * Valid Values: <code>false</code> | <code>true</code>
     * </p>
     * 
     * @return Avoids ferries when calculating routes.</p>
     *         <p>
     *         Default Value: <code>false</code>
     *         </p>
     *         <p>
     *         Valid Values: <code>false</code> | <code>true</code>
     */
    public final Boolean avoidFerries() {
        return avoidFerries;
    }

    /**
     * <p>
     * Avoids tolls when calculating routes.
     * </p>
     * <p>
     * Default Value: <code>false</code>
     * </p>
     * <p>
     * Valid Values: <code>false</code> | <code>true</code>
     * </p>
     * 
     * @return Avoids tolls when calculating routes.</p>
     *         <p>
     *         Default Value: <code>false</code>
     *         </p>
     *         <p>
     *         Valid Values: <code>false</code> | <code>true</code>
     */
    public final Boolean avoidTolls() {
        return avoidTolls;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(avoidFerries());
        hashCode = 31 * hashCode + Objects.hashCode(avoidTolls());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CalculateRouteCarModeOptions)) {
            return false;
        }
        CalculateRouteCarModeOptions other = (CalculateRouteCarModeOptions) obj;
        return Objects.equals(avoidFerries(), other.avoidFerries()) && Objects.equals(avoidTolls(), other.avoidTolls());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CalculateRouteCarModeOptions").add("AvoidFerries", avoidFerries())
                .add("AvoidTolls", avoidTolls()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AvoidFerries":
            return Optional.ofNullable(clazz.cast(avoidFerries()));
        case "AvoidTolls":
            return Optional.ofNullable(clazz.cast(avoidTolls()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CalculateRouteCarModeOptions, T> g) {
        return obj -> g.apply((CalculateRouteCarModeOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CalculateRouteCarModeOptions> {
        /**
         * <p>
         * Avoids ferries when calculating routes.
         * </p>
         * <p>
         * Default Value: <code>false</code>
         * </p>
         * <p>
         * Valid Values: <code>false</code> | <code>true</code>
         * </p>
         * 
         * @param avoidFerries
         *        Avoids ferries when calculating routes.</p>
         *        <p>
         *        Default Value: <code>false</code>
         *        </p>
         *        <p>
         *        Valid Values: <code>false</code> | <code>true</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder avoidFerries(Boolean avoidFerries);

        /**
         * <p>
         * Avoids tolls when calculating routes.
         * </p>
         * <p>
         * Default Value: <code>false</code>
         * </p>
         * <p>
         * Valid Values: <code>false</code> | <code>true</code>
         * </p>
         * 
         * @param avoidTolls
         *        Avoids tolls when calculating routes.</p>
         *        <p>
         *        Default Value: <code>false</code>
         *        </p>
         *        <p>
         *        Valid Values: <code>false</code> | <code>true</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder avoidTolls(Boolean avoidTolls);
    }

    static final class BuilderImpl implements Builder {
        private Boolean avoidFerries;

        private Boolean avoidTolls;

        private BuilderImpl() {
        }

        private BuilderImpl(CalculateRouteCarModeOptions model) {
            avoidFerries(model.avoidFerries);
            avoidTolls(model.avoidTolls);
        }

        public final Boolean getAvoidFerries() {
            return avoidFerries;
        }

        public final void setAvoidFerries(Boolean avoidFerries) {
            this.avoidFerries = avoidFerries;
        }

        @Override
        public final Builder avoidFerries(Boolean avoidFerries) {
            this.avoidFerries = avoidFerries;
            return this;
        }

        public final Boolean getAvoidTolls() {
            return avoidTolls;
        }

        public final void setAvoidTolls(Boolean avoidTolls) {
            this.avoidTolls = avoidTolls;
        }

        @Override
        public final Builder avoidTolls(Boolean avoidTolls) {
            this.avoidTolls = avoidTolls;
            return this;
        }

        @Override
        public CalculateRouteCarModeOptions build() {
            return new CalculateRouteCarModeOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
