/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains a place suggestion resulting from a place suggestion query that is run on a place index resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchForSuggestionsResult implements SdkPojo, Serializable,
        ToCopyableBuilder<SearchForSuggestionsResult.Builder, SearchForSuggestionsResult> {
    private static final SdkField<List<String>> CATEGORIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Categories")
            .getter(getter(SearchForSuggestionsResult::categories))
            .setter(setter(Builder::categories))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Categories").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PLACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PlaceId").getter(getter(SearchForSuggestionsResult::placeId)).setter(setter(Builder::placeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlaceId").build()).build();

    private static final SdkField<List<String>> SUPPLEMENTAL_CATEGORIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SupplementalCategories")
            .getter(getter(SearchForSuggestionsResult::supplementalCategories))
            .setter(setter(Builder::supplementalCategories))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupplementalCategories").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Text")
            .getter(getter(SearchForSuggestionsResult::text)).setter(setter(Builder::text))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Text").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATEGORIES_FIELD,
            PLACE_ID_FIELD, SUPPLEMENTAL_CATEGORIES_FIELD, TEXT_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> categories;

    private final String placeId;

    private final List<String> supplementalCategories;

    private final String text;

    private SearchForSuggestionsResult(BuilderImpl builder) {
        this.categories = builder.categories;
        this.placeId = builder.placeId;
        this.supplementalCategories = builder.supplementalCategories;
        this.text = builder.text;
    }

    /**
     * For responses, this returns true if the service returned a value for the Categories property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasCategories() {
        return categories != null && !(categories instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Location categories that describe the Place.
     * </p>
     * <p>
     * For more information about using categories, including a list of Amazon Location categories, see <a
     * href="https://docs.aws.amazon.com/location/latest/developerguide/category-filtering.html">Categories and
     * filtering</a>, in the <i>Amazon Location Service Developer Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCategories} method.
     * </p>
     * 
     * @return The Amazon Location categories that describe the Place.</p>
     *         <p>
     *         For more information about using categories, including a list of Amazon Location categories, see <a
     *         href="https://docs.aws.amazon.com/location/latest/developerguide/category-filtering.html">Categories and
     *         filtering</a>, in the <i>Amazon Location Service Developer Guide</i>.
     */
    public final List<String> categories() {
        return categories;
    }

    /**
     * <p>
     * The unique identifier of the Place. You can use this with the <code>GetPlace</code> operation to find the place
     * again later, or to get full information for the Place.
     * </p>
     * <p>
     * The <code>GetPlace</code> request must use the same <code>PlaceIndex</code> resource as the
     * <code>SearchPlaceIndexForSuggestions</code> that generated the Place ID.
     * </p>
     * <note>
     * <p>
     * For <code>SearchPlaceIndexForSuggestions</code> operations, the <code>PlaceId</code> is returned by place indexes
     * that use Esri, Grab, or HERE as data providers.
     * </p>
     * </note>
     * <p>
     * While you can use PlaceID in subsequent requests, PlaceID is not intended to be a permanent identifier and the ID
     * can change between consecutive API calls. Please see the following PlaceID behaviour for each data provider:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Esri: Place IDs will change every quarter at a minimum. The typical time period for these changes would be March,
     * June, September, and December. Place IDs might also change between the typical quarterly change but that will be
     * much less frequent.
     * </p>
     * </li>
     * <li>
     * <p>
     * HERE: We recommend that you cache data for no longer than a week to keep your data data fresh. You can assume
     * that less than 1% ID shifts will release over release which is approximately 1 - 2 times per week.
     * </p>
     * </li>
     * <li>
     * <p>
     * Grab: Place IDs can expire or become invalid in the following situations.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Data operations: The POI may be removed from Grab POI database by Grab Map Ops based on the ground-truth, such as
     * being closed in the real world, being detected as a duplicate POI, or having incorrect information. Grab will
     * synchronize data to the Waypoint environment on weekly basis.
     * </p>
     * </li>
     * <li>
     * <p>
     * Interpolated POI: Interpolated POI is a temporary POI generated in real time when serving a request, and it will
     * be marked as derived in the <code>place.result_type</code> field in the response. The information of interpolated
     * POIs will be retained for at least 30 days, which means that within 30 days, you are able to obtain POI details
     * by Place ID from Place Details API. After 30 days, the interpolated POIs(both Place ID and details) may expire
     * and inaccessible from the Places Details API.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * 
     * @return The unique identifier of the Place. You can use this with the <code>GetPlace</code> operation to find the
     *         place again later, or to get full information for the Place.</p>
     *         <p>
     *         The <code>GetPlace</code> request must use the same <code>PlaceIndex</code> resource as the
     *         <code>SearchPlaceIndexForSuggestions</code> that generated the Place ID.
     *         </p>
     *         <note>
     *         <p>
     *         For <code>SearchPlaceIndexForSuggestions</code> operations, the <code>PlaceId</code> is returned by place
     *         indexes that use Esri, Grab, or HERE as data providers.
     *         </p>
     *         </note>
     *         <p>
     *         While you can use PlaceID in subsequent requests, PlaceID is not intended to be a permanent identifier
     *         and the ID can change between consecutive API calls. Please see the following PlaceID behaviour for each
     *         data provider:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Esri: Place IDs will change every quarter at a minimum. The typical time period for these changes would
     *         be March, June, September, and December. Place IDs might also change between the typical quarterly change
     *         but that will be much less frequent.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         HERE: We recommend that you cache data for no longer than a week to keep your data data fresh. You can
     *         assume that less than 1% ID shifts will release over release which is approximately 1 - 2 times per week.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Grab: Place IDs can expire or become invalid in the following situations.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Data operations: The POI may be removed from Grab POI database by Grab Map Ops based on the ground-truth,
     *         such as being closed in the real world, being detected as a duplicate POI, or having incorrect
     *         information. Grab will synchronize data to the Waypoint environment on weekly basis.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Interpolated POI: Interpolated POI is a temporary POI generated in real time when serving a request, and
     *         it will be marked as derived in the <code>place.result_type</code> field in the response. The information
     *         of interpolated POIs will be retained for at least 30 days, which means that within 30 days, you are able
     *         to obtain POI details by Place ID from Place Details API. After 30 days, the interpolated POIs(both Place
     *         ID and details) may expire and inaccessible from the Places Details API.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     */
    public final String placeId() {
        return placeId;
    }

    /**
     * For responses, this returns true if the service returned a value for the SupplementalCategories property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSupplementalCategories() {
        return supplementalCategories != null && !(supplementalCategories instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Categories from the data provider that describe the Place that are not mapped to any Amazon Location categories.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupplementalCategories} method.
     * </p>
     * 
     * @return Categories from the data provider that describe the Place that are not mapped to any Amazon Location
     *         categories.
     */
    public final List<String> supplementalCategories() {
        return supplementalCategories;
    }

    /**
     * <p>
     * The text of the place suggestion, typically formatted as an address string.
     * </p>
     * 
     * @return The text of the place suggestion, typically formatted as an address string.
     */
    public final String text() {
        return text;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasCategories() ? categories() : null);
        hashCode = 31 * hashCode + Objects.hashCode(placeId());
        hashCode = 31 * hashCode + Objects.hashCode(hasSupplementalCategories() ? supplementalCategories() : null);
        hashCode = 31 * hashCode + Objects.hashCode(text());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchForSuggestionsResult)) {
            return false;
        }
        SearchForSuggestionsResult other = (SearchForSuggestionsResult) obj;
        return hasCategories() == other.hasCategories() && Objects.equals(categories(), other.categories())
                && Objects.equals(placeId(), other.placeId()) && hasSupplementalCategories() == other.hasSupplementalCategories()
                && Objects.equals(supplementalCategories(), other.supplementalCategories())
                && Objects.equals(text(), other.text());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchForSuggestionsResult").add("Categories", hasCategories() ? categories() : null)
                .add("PlaceId", placeId())
                .add("SupplementalCategories", hasSupplementalCategories() ? supplementalCategories() : null).add("Text", text())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Categories":
            return Optional.ofNullable(clazz.cast(categories()));
        case "PlaceId":
            return Optional.ofNullable(clazz.cast(placeId()));
        case "SupplementalCategories":
            return Optional.ofNullable(clazz.cast(supplementalCategories()));
        case "Text":
            return Optional.ofNullable(clazz.cast(text()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchForSuggestionsResult, T> g) {
        return obj -> g.apply((SearchForSuggestionsResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SearchForSuggestionsResult> {
        /**
         * <p>
         * The Amazon Location categories that describe the Place.
         * </p>
         * <p>
         * For more information about using categories, including a list of Amazon Location categories, see <a
         * href="https://docs.aws.amazon.com/location/latest/developerguide/category-filtering.html">Categories and
         * filtering</a>, in the <i>Amazon Location Service Developer Guide</i>.
         * </p>
         * 
         * @param categories
         *        The Amazon Location categories that describe the Place.</p>
         *        <p>
         *        For more information about using categories, including a list of Amazon Location categories, see <a
         *        href="https://docs.aws.amazon.com/location/latest/developerguide/category-filtering.html">Categories
         *        and filtering</a>, in the <i>Amazon Location Service Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categories(Collection<String> categories);

        /**
         * <p>
         * The Amazon Location categories that describe the Place.
         * </p>
         * <p>
         * For more information about using categories, including a list of Amazon Location categories, see <a
         * href="https://docs.aws.amazon.com/location/latest/developerguide/category-filtering.html">Categories and
         * filtering</a>, in the <i>Amazon Location Service Developer Guide</i>.
         * </p>
         * 
         * @param categories
         *        The Amazon Location categories that describe the Place.</p>
         *        <p>
         *        For more information about using categories, including a list of Amazon Location categories, see <a
         *        href="https://docs.aws.amazon.com/location/latest/developerguide/category-filtering.html">Categories
         *        and filtering</a>, in the <i>Amazon Location Service Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categories(String... categories);

        /**
         * <p>
         * The unique identifier of the Place. You can use this with the <code>GetPlace</code> operation to find the
         * place again later, or to get full information for the Place.
         * </p>
         * <p>
         * The <code>GetPlace</code> request must use the same <code>PlaceIndex</code> resource as the
         * <code>SearchPlaceIndexForSuggestions</code> that generated the Place ID.
         * </p>
         * <note>
         * <p>
         * For <code>SearchPlaceIndexForSuggestions</code> operations, the <code>PlaceId</code> is returned by place
         * indexes that use Esri, Grab, or HERE as data providers.
         * </p>
         * </note>
         * <p>
         * While you can use PlaceID in subsequent requests, PlaceID is not intended to be a permanent identifier and
         * the ID can change between consecutive API calls. Please see the following PlaceID behaviour for each data
         * provider:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Esri: Place IDs will change every quarter at a minimum. The typical time period for these changes would be
         * March, June, September, and December. Place IDs might also change between the typical quarterly change but
         * that will be much less frequent.
         * </p>
         * </li>
         * <li>
         * <p>
         * HERE: We recommend that you cache data for no longer than a week to keep your data data fresh. You can assume
         * that less than 1% ID shifts will release over release which is approximately 1 - 2 times per week.
         * </p>
         * </li>
         * <li>
         * <p>
         * Grab: Place IDs can expire or become invalid in the following situations.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Data operations: The POI may be removed from Grab POI database by Grab Map Ops based on the ground-truth,
         * such as being closed in the real world, being detected as a duplicate POI, or having incorrect information.
         * Grab will synchronize data to the Waypoint environment on weekly basis.
         * </p>
         * </li>
         * <li>
         * <p>
         * Interpolated POI: Interpolated POI is a temporary POI generated in real time when serving a request, and it
         * will be marked as derived in the <code>place.result_type</code> field in the response. The information of
         * interpolated POIs will be retained for at least 30 days, which means that within 30 days, you are able to
         * obtain POI details by Place ID from Place Details API. After 30 days, the interpolated POIs(both Place ID and
         * details) may expire and inaccessible from the Places Details API.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param placeId
         *        The unique identifier of the Place. You can use this with the <code>GetPlace</code> operation to find
         *        the place again later, or to get full information for the Place.</p>
         *        <p>
         *        The <code>GetPlace</code> request must use the same <code>PlaceIndex</code> resource as the
         *        <code>SearchPlaceIndexForSuggestions</code> that generated the Place ID.
         *        </p>
         *        <note>
         *        <p>
         *        For <code>SearchPlaceIndexForSuggestions</code> operations, the <code>PlaceId</code> is returned by
         *        place indexes that use Esri, Grab, or HERE as data providers.
         *        </p>
         *        </note>
         *        <p>
         *        While you can use PlaceID in subsequent requests, PlaceID is not intended to be a permanent identifier
         *        and the ID can change between consecutive API calls. Please see the following PlaceID behaviour for
         *        each data provider:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Esri: Place IDs will change every quarter at a minimum. The typical time period for these changes
         *        would be March, June, September, and December. Place IDs might also change between the typical
         *        quarterly change but that will be much less frequent.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        HERE: We recommend that you cache data for no longer than a week to keep your data data fresh. You can
         *        assume that less than 1% ID shifts will release over release which is approximately 1 - 2 times per
         *        week.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Grab: Place IDs can expire or become invalid in the following situations.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Data operations: The POI may be removed from Grab POI database by Grab Map Ops based on the
         *        ground-truth, such as being closed in the real world, being detected as a duplicate POI, or having
         *        incorrect information. Grab will synchronize data to the Waypoint environment on weekly basis.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Interpolated POI: Interpolated POI is a temporary POI generated in real time when serving a request,
         *        and it will be marked as derived in the <code>place.result_type</code> field in the response. The
         *        information of interpolated POIs will be retained for at least 30 days, which means that within 30
         *        days, you are able to obtain POI details by Place ID from Place Details API. After 30 days, the
         *        interpolated POIs(both Place ID and details) may expire and inaccessible from the Places Details API.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placeId(String placeId);

        /**
         * <p>
         * Categories from the data provider that describe the Place that are not mapped to any Amazon Location
         * categories.
         * </p>
         * 
         * @param supplementalCategories
         *        Categories from the data provider that describe the Place that are not mapped to any Amazon Location
         *        categories.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supplementalCategories(Collection<String> supplementalCategories);

        /**
         * <p>
         * Categories from the data provider that describe the Place that are not mapped to any Amazon Location
         * categories.
         * </p>
         * 
         * @param supplementalCategories
         *        Categories from the data provider that describe the Place that are not mapped to any Amazon Location
         *        categories.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supplementalCategories(String... supplementalCategories);

        /**
         * <p>
         * The text of the place suggestion, typically formatted as an address string.
         * </p>
         * 
         * @param text
         *        The text of the place suggestion, typically formatted as an address string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder text(String text);
    }

    static final class BuilderImpl implements Builder {
        private List<String> categories = DefaultSdkAutoConstructList.getInstance();

        private String placeId;

        private List<String> supplementalCategories = DefaultSdkAutoConstructList.getInstance();

        private String text;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchForSuggestionsResult model) {
            categories(model.categories);
            placeId(model.placeId);
            supplementalCategories(model.supplementalCategories);
            text(model.text);
        }

        public final Collection<String> getCategories() {
            if (categories instanceof SdkAutoConstructList) {
                return null;
            }
            return categories;
        }

        public final void setCategories(Collection<String> categories) {
            this.categories = PlaceCategoryListCopier.copy(categories);
        }

        @Override
        public final Builder categories(Collection<String> categories) {
            this.categories = PlaceCategoryListCopier.copy(categories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categories(String... categories) {
            categories(Arrays.asList(categories));
            return this;
        }

        public final String getPlaceId() {
            return placeId;
        }

        public final void setPlaceId(String placeId) {
            this.placeId = placeId;
        }

        @Override
        public final Builder placeId(String placeId) {
            this.placeId = placeId;
            return this;
        }

        public final Collection<String> getSupplementalCategories() {
            if (supplementalCategories instanceof SdkAutoConstructList) {
                return null;
            }
            return supplementalCategories;
        }

        public final void setSupplementalCategories(Collection<String> supplementalCategories) {
            this.supplementalCategories = PlaceSupplementalCategoryListCopier.copy(supplementalCategories);
        }

        @Override
        public final Builder supplementalCategories(Collection<String> supplementalCategories) {
            this.supplementalCategories = PlaceSupplementalCategoryListCopier.copy(supplementalCategories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supplementalCategories(String... supplementalCategories) {
            supplementalCategories(Arrays.asList(supplementalCategories));
            return this;
        }

        public final String getText() {
            return text;
        }

        public final void setText(String text) {
            this.text = text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        @Override
        public SearchForSuggestionsResult build() {
            return new SearchForSuggestionsResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
