/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about the truck dimensions in the unit of measurement that you specify. Used to filter out roads
 * that can't support or allow the specified dimensions for requests that specify <code>TravelMode</code> as
 * <code>Truck</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TruckDimensions implements SdkPojo, Serializable, ToCopyableBuilder<TruckDimensions.Builder, TruckDimensions> {
    private static final SdkField<Double> HEIGHT_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("Height")
            .getter(getter(TruckDimensions::height)).setter(setter(Builder::height))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Height").build()).build();

    private static final SdkField<Double> LENGTH_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("Length")
            .getter(getter(TruckDimensions::length)).setter(setter(Builder::length))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Length").build()).build();

    private static final SdkField<String> UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Unit")
            .getter(getter(TruckDimensions::unitAsString)).setter(setter(Builder::unit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Unit").build()).build();

    private static final SdkField<Double> WIDTH_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("Width")
            .getter(getter(TruckDimensions::width)).setter(setter(Builder::width))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Width").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HEIGHT_FIELD, LENGTH_FIELD,
            UNIT_FIELD, WIDTH_FIELD));

    private static final long serialVersionUID = 1L;

    private final Double height;

    private final Double length;

    private final String unit;

    private final Double width;

    private TruckDimensions(BuilderImpl builder) {
        this.height = builder.height;
        this.length = builder.length;
        this.unit = builder.unit;
        this.width = builder.width;
    }

    /**
     * <p>
     * The height of the truck.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For example, <code>4.5</code>.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * For routes calculated with a HERE resource, this value must be between 0 and 50 meters.
     * </p>
     * </note>
     * 
     * @return The height of the truck.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For example, <code>4.5</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         For routes calculated with a HERE resource, this value must be between 0 and 50 meters.
     *         </p>
     */
    public final Double height() {
        return height;
    }

    /**
     * <p>
     * The length of the truck.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For example, <code>15.5</code>.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * For routes calculated with a HERE resource, this value must be between 0 and 300 meters.
     * </p>
     * </note>
     * 
     * @return The length of the truck.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For example, <code>15.5</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         For routes calculated with a HERE resource, this value must be between 0 and 300 meters.
     *         </p>
     */
    public final Double length() {
        return length;
    }

    /**
     * <p>
     * Specifies the unit of measurement for the truck dimensions.
     * </p>
     * <p>
     * Default Value: <code>Meters</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #unit} will return
     * {@link DimensionUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #unitAsString}.
     * </p>
     * 
     * @return Specifies the unit of measurement for the truck dimensions.</p>
     *         <p>
     *         Default Value: <code>Meters</code>
     * @see DimensionUnit
     */
    public final DimensionUnit unit() {
        return DimensionUnit.fromValue(unit);
    }

    /**
     * <p>
     * Specifies the unit of measurement for the truck dimensions.
     * </p>
     * <p>
     * Default Value: <code>Meters</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #unit} will return
     * {@link DimensionUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #unitAsString}.
     * </p>
     * 
     * @return Specifies the unit of measurement for the truck dimensions.</p>
     *         <p>
     *         Default Value: <code>Meters</code>
     * @see DimensionUnit
     */
    public final String unitAsString() {
        return unit;
    }

    /**
     * <p>
     * The width of the truck.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For example, <code>4.5</code>.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * For routes calculated with a HERE resource, this value must be between 0 and 50 meters.
     * </p>
     * </note>
     * 
     * @return The width of the truck.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For example, <code>4.5</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         For routes calculated with a HERE resource, this value must be between 0 and 50 meters.
     *         </p>
     */
    public final Double width() {
        return width;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(height());
        hashCode = 31 * hashCode + Objects.hashCode(length());
        hashCode = 31 * hashCode + Objects.hashCode(unitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(width());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TruckDimensions)) {
            return false;
        }
        TruckDimensions other = (TruckDimensions) obj;
        return Objects.equals(height(), other.height()) && Objects.equals(length(), other.length())
                && Objects.equals(unitAsString(), other.unitAsString()) && Objects.equals(width(), other.width());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TruckDimensions").add("Height", height()).add("Length", length()).add("Unit", unitAsString())
                .add("Width", width()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Height":
            return Optional.ofNullable(clazz.cast(height()));
        case "Length":
            return Optional.ofNullable(clazz.cast(length()));
        case "Unit":
            return Optional.ofNullable(clazz.cast(unitAsString()));
        case "Width":
            return Optional.ofNullable(clazz.cast(width()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TruckDimensions, T> g) {
        return obj -> g.apply((TruckDimensions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TruckDimensions> {
        /**
         * <p>
         * The height of the truck.
         * </p>
         * <ul>
         * <li>
         * <p>
         * For example, <code>4.5</code>.
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * For routes calculated with a HERE resource, this value must be between 0 and 50 meters.
         * </p>
         * </note>
         * 
         * @param height
         *        The height of the truck.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        For example, <code>4.5</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        For routes calculated with a HERE resource, this value must be between 0 and 50 meters.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder height(Double height);

        /**
         * <p>
         * The length of the truck.
         * </p>
         * <ul>
         * <li>
         * <p>
         * For example, <code>15.5</code>.
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * For routes calculated with a HERE resource, this value must be between 0 and 300 meters.
         * </p>
         * </note>
         * 
         * @param length
         *        The length of the truck.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        For example, <code>15.5</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        For routes calculated with a HERE resource, this value must be between 0 and 300 meters.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder length(Double length);

        /**
         * <p>
         * Specifies the unit of measurement for the truck dimensions.
         * </p>
         * <p>
         * Default Value: <code>Meters</code>
         * </p>
         * 
         * @param unit
         *        Specifies the unit of measurement for the truck dimensions.</p>
         *        <p>
         *        Default Value: <code>Meters</code>
         * @see DimensionUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DimensionUnit
         */
        Builder unit(String unit);

        /**
         * <p>
         * Specifies the unit of measurement for the truck dimensions.
         * </p>
         * <p>
         * Default Value: <code>Meters</code>
         * </p>
         * 
         * @param unit
         *        Specifies the unit of measurement for the truck dimensions.</p>
         *        <p>
         *        Default Value: <code>Meters</code>
         * @see DimensionUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DimensionUnit
         */
        Builder unit(DimensionUnit unit);

        /**
         * <p>
         * The width of the truck.
         * </p>
         * <ul>
         * <li>
         * <p>
         * For example, <code>4.5</code>.
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * For routes calculated with a HERE resource, this value must be between 0 and 50 meters.
         * </p>
         * </note>
         * 
         * @param width
         *        The width of the truck.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        For example, <code>4.5</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        For routes calculated with a HERE resource, this value must be between 0 and 50 meters.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder width(Double width);
    }

    static final class BuilderImpl implements Builder {
        private Double height;

        private Double length;

        private String unit;

        private Double width;

        private BuilderImpl() {
        }

        private BuilderImpl(TruckDimensions model) {
            height(model.height);
            length(model.length);
            unit(model.unit);
            width(model.width);
        }

        public final Double getHeight() {
            return height;
        }

        public final void setHeight(Double height) {
            this.height = height;
        }

        @Override
        public final Builder height(Double height) {
            this.height = height;
            return this;
        }

        public final Double getLength() {
            return length;
        }

        public final void setLength(Double length) {
            this.length = length;
        }

        @Override
        public final Builder length(Double length) {
            this.length = length;
            return this;
        }

        public final String getUnit() {
            return unit;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public final Builder unit(DimensionUnit unit) {
            this.unit(unit == null ? null : unit.toString());
            return this;
        }

        public final Double getWidth() {
            return width;
        }

        public final void setWidth(Double width) {
            this.width = width;
        }

        @Override
        public final Builder width(Double width) {
            this.width = width;
            return this;
        }

        @Override
        public TruckDimensions build() {
            return new TruckDimensions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
