/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class BatchEvaluateGeofencesRequestDevicePositionUpdatesListCopier {
    static List<DevicePositionUpdate> copy(
            Collection<? extends DevicePositionUpdate> batchEvaluateGeofencesRequestDevicePositionUpdatesListParam) {
        List<DevicePositionUpdate> list;
        if (batchEvaluateGeofencesRequestDevicePositionUpdatesListParam == null
                || batchEvaluateGeofencesRequestDevicePositionUpdatesListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<DevicePositionUpdate> modifiableList = new ArrayList<>();
            batchEvaluateGeofencesRequestDevicePositionUpdatesListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<DevicePositionUpdate> copyFromBuilder(
            Collection<? extends DevicePositionUpdate.Builder> batchEvaluateGeofencesRequestDevicePositionUpdatesListParam) {
        List<DevicePositionUpdate> list;
        if (batchEvaluateGeofencesRequestDevicePositionUpdatesListParam == null
                || batchEvaluateGeofencesRequestDevicePositionUpdatesListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<DevicePositionUpdate> modifiableList = new ArrayList<>();
            batchEvaluateGeofencesRequestDevicePositionUpdatesListParam.forEach(entry -> {
                DevicePositionUpdate member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<DevicePositionUpdate.Builder> copyToBuilder(
            Collection<? extends DevicePositionUpdate> batchEvaluateGeofencesRequestDevicePositionUpdatesListParam) {
        List<DevicePositionUpdate.Builder> list;
        if (batchEvaluateGeofencesRequestDevicePositionUpdatesListParam == null
                || batchEvaluateGeofencesRequestDevicePositionUpdatesListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<DevicePositionUpdate.Builder> modifiableList = new ArrayList<>();
            batchEvaluateGeofencesRequestDevicePositionUpdatesListParam.forEach(entry -> {
                DevicePositionUpdate.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
