/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum OptimizationMode {
    FASTEST_ROUTE("FastestRoute"),
    SHORTEST_ROUTE("ShortestRoute"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, OptimizationMode> VALUE_MAP;
    private final String value;

    private OptimizationMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OptimizationMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<OptimizationMode> knownValues() {
        EnumSet<OptimizationMode> knownValues = EnumSet.allOf(OptimizationMode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(OptimizationMode.class, OptimizationMode::toString);
    }
}

