/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains a search result from a position search query that is run on a place index resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchForPositionResult implements SdkPojo, Serializable,
        ToCopyableBuilder<SearchForPositionResult.Builder, SearchForPositionResult> {
    private static final SdkField<Double> DISTANCE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("Distance").getter(getter(SearchForPositionResult::distance)).setter(setter(Builder::distance))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Distance").build()).build();

    private static final SdkField<Place> PLACE_FIELD = SdkField.<Place> builder(MarshallingType.SDK_POJO).memberName("Place")
            .getter(getter(SearchForPositionResult::place)).setter(setter(Builder::place)).constructor(Place::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Place").build()).build();

    private static final SdkField<String> PLACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PlaceId").getter(getter(SearchForPositionResult::placeId)).setter(setter(Builder::placeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlaceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISTANCE_FIELD, PLACE_FIELD,
            PLACE_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final Double distance;

    private final Place place;

    private final String placeId;

    private SearchForPositionResult(BuilderImpl builder) {
        this.distance = builder.distance;
        this.place = builder.place;
        this.placeId = builder.placeId;
    }

    /**
     * <p>
     * The distance in meters of a great-circle arc between the query position and the result.
     * </p>
     * <note>
     * <p>
     * A great-circle arc is the shortest path on a sphere, in this case the Earth. This returns the shortest distance
     * between two locations.
     * </p>
     * </note>
     * 
     * @return The distance in meters of a great-circle arc between the query position and the result.</p> <note>
     *         <p>
     *         A great-circle arc is the shortest path on a sphere, in this case the Earth. This returns the shortest
     *         distance between two locations.
     *         </p>
     */
    public final Double distance() {
        return distance;
    }

    /**
     * <p>
     * Details about the search result, such as its address and position.
     * </p>
     * 
     * @return Details about the search result, such as its address and position.
     */
    public final Place place() {
        return place;
    }

    /**
     * <p>
     * The unique identifier of the place. You can use this with the <code>GetPlace</code> operation to find the place
     * again later.
     * </p>
     * <note>
     * <p>
     * For <code>SearchPlaceIndexForPosition</code> operations, the <code>PlaceId</code> is returned only by place
     * indexes that use HERE or Grab as a data provider.
     * </p>
     * </note>
     * 
     * @return The unique identifier of the place. You can use this with the <code>GetPlace</code> operation to find the
     *         place again later.</p> <note>
     *         <p>
     *         For <code>SearchPlaceIndexForPosition</code> operations, the <code>PlaceId</code> is returned only by
     *         place indexes that use HERE or Grab as a data provider.
     *         </p>
     */
    public final String placeId() {
        return placeId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(distance());
        hashCode = 31 * hashCode + Objects.hashCode(place());
        hashCode = 31 * hashCode + Objects.hashCode(placeId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchForPositionResult)) {
            return false;
        }
        SearchForPositionResult other = (SearchForPositionResult) obj;
        return Objects.equals(distance(), other.distance()) && Objects.equals(place(), other.place())
                && Objects.equals(placeId(), other.placeId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchForPositionResult").add("Distance", distance()).add("Place", place())
                .add("PlaceId", placeId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Distance":
            return Optional.ofNullable(clazz.cast(distance()));
        case "Place":
            return Optional.ofNullable(clazz.cast(place()));
        case "PlaceId":
            return Optional.ofNullable(clazz.cast(placeId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchForPositionResult, T> g) {
        return obj -> g.apply((SearchForPositionResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SearchForPositionResult> {
        /**
         * <p>
         * The distance in meters of a great-circle arc between the query position and the result.
         * </p>
         * <note>
         * <p>
         * A great-circle arc is the shortest path on a sphere, in this case the Earth. This returns the shortest
         * distance between two locations.
         * </p>
         * </note>
         * 
         * @param distance
         *        The distance in meters of a great-circle arc between the query position and the result.</p> <note>
         *        <p>
         *        A great-circle arc is the shortest path on a sphere, in this case the Earth. This returns the shortest
         *        distance between two locations.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder distance(Double distance);

        /**
         * <p>
         * Details about the search result, such as its address and position.
         * </p>
         * 
         * @param place
         *        Details about the search result, such as its address and position.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder place(Place place);

        /**
         * <p>
         * Details about the search result, such as its address and position.
         * </p>
         * This is a convenience method that creates an instance of the {@link Place.Builder} avoiding the need to
         * create one manually via {@link Place#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Place.Builder#build()} is called immediately and its result is
         * passed to {@link #place(Place)}.
         * 
         * @param place
         *        a consumer that will call methods on {@link Place.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #place(Place)
         */
        default Builder place(Consumer<Place.Builder> place) {
            return place(Place.builder().applyMutation(place).build());
        }

        /**
         * <p>
         * The unique identifier of the place. You can use this with the <code>GetPlace</code> operation to find the
         * place again later.
         * </p>
         * <note>
         * <p>
         * For <code>SearchPlaceIndexForPosition</code> operations, the <code>PlaceId</code> is returned only by place
         * indexes that use HERE or Grab as a data provider.
         * </p>
         * </note>
         * 
         * @param placeId
         *        The unique identifier of the place. You can use this with the <code>GetPlace</code> operation to find
         *        the place again later.</p> <note>
         *        <p>
         *        For <code>SearchPlaceIndexForPosition</code> operations, the <code>PlaceId</code> is returned only by
         *        place indexes that use HERE or Grab as a data provider.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placeId(String placeId);
    }

    static final class BuilderImpl implements Builder {
        private Double distance;

        private Place place;

        private String placeId;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchForPositionResult model) {
            distance(model.distance);
            place(model.place);
            placeId(model.placeId);
        }

        public final Double getDistance() {
            return distance;
        }

        public final void setDistance(Double distance) {
            this.distance = distance;
        }

        @Override
        public final Builder distance(Double distance) {
            this.distance = distance;
            return this;
        }

        public final Place.Builder getPlace() {
            return place != null ? place.toBuilder() : null;
        }

        public final void setPlace(Place.BuilderImpl place) {
            this.place = place != null ? place.build() : null;
        }

        @Override
        public final Builder place(Place place) {
            this.place = place;
            return this;
        }

        public final String getPlaceId() {
            return placeId;
        }

        public final void setPlaceId(String placeId) {
            this.placeId = placeId;
        }

        @Override
        public final Builder placeId(String placeId) {
            this.placeId = placeId;
            return this;
        }

        @Override
        public SearchForPositionResult build() {
            return new SearchForPositionResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
