/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.location.model.ListKeysResponseEntry;
import software.amazon.awssdk.services.location.model.ListKeysResponseEntryListCopier;
import software.amazon.awssdk.services.location.model.LocationResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListKeysResponse
extends LocationResponse
implements ToCopyableBuilder<Builder, ListKeysResponse> {
    private static final SdkField<List<ListKeysResponseEntry>> ENTRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Entries").getter(ListKeysResponse.getter(ListKeysResponse::entries)).setter(ListKeysResponse.setter(Builder::entries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Entries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ListKeysResponseEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListKeysResponse.getter(ListKeysResponse::nextToken)).setter(ListKeysResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTRIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<ListKeysResponseEntry> entries;
    private final String nextToken;

    private ListKeysResponse(BuilderImpl builder) {
        super(builder);
        this.entries = builder.entries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasEntries() {
        return this.entries != null && !(this.entries instanceof SdkAutoConstructList);
    }

    public final List<ListKeysResponseEntry> entries() {
        return this.entries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEntries() ? this.entries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListKeysResponse)) {
            return false;
        }
        ListKeysResponse other = (ListKeysResponse)((Object)obj);
        return this.hasEntries() == other.hasEntries() && Objects.equals(this.entries(), other.entries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListKeysResponse").add("Entries", this.hasEntries() ? this.entries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Entries": {
                return Optional.ofNullable(clazz.cast(this.entries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListKeysResponse, T> g) {
        return obj -> g.apply((ListKeysResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LocationResponse.BuilderImpl
    implements Builder {
        private List<ListKeysResponseEntry> entries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListKeysResponse model) {
            super(model);
            this.entries(model.entries);
            this.nextToken(model.nextToken);
        }

        public final List<ListKeysResponseEntry.Builder> getEntries() {
            List<ListKeysResponseEntry.Builder> result = ListKeysResponseEntryListCopier.copyToBuilder(this.entries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEntries(Collection<ListKeysResponseEntry.BuilderImpl> entries) {
            this.entries = ListKeysResponseEntryListCopier.copyFromBuilder(entries);
        }

        @Override
        public final Builder entries(Collection<ListKeysResponseEntry> entries) {
            this.entries = ListKeysResponseEntryListCopier.copy(entries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entries(ListKeysResponseEntry ... entries) {
            this.entries(Arrays.asList(entries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entries(Consumer<ListKeysResponseEntry.Builder> ... entries) {
            this.entries(Stream.of(entries).map(c -> (ListKeysResponseEntry)((ListKeysResponseEntry.Builder)ListKeysResponseEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListKeysResponse build() {
            return new ListKeysResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LocationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListKeysResponse> {
        public Builder entries(Collection<ListKeysResponseEntry> var1);

        public Builder entries(ListKeysResponseEntry ... var1);

        public Builder entries(Consumer<ListKeysResponseEntry.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

