/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.location.LocationAsyncClient;
import software.amazon.awssdk.services.location.model.ListPlaceIndexesRequest;
import software.amazon.awssdk.services.location.model.ListPlaceIndexesResponse;
import software.amazon.awssdk.services.location.model.ListPlaceIndexesResponseEntry;

public class ListPlaceIndexesPublisher
implements SdkPublisher<ListPlaceIndexesResponse> {
    private final LocationAsyncClient client;
    private final ListPlaceIndexesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPlaceIndexesPublisher(LocationAsyncClient client, ListPlaceIndexesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPlaceIndexesPublisher(LocationAsyncClient client, ListPlaceIndexesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPlaceIndexesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPlaceIndexesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ListPlaceIndexesResponseEntry> entries() {
        Function<ListPlaceIndexesResponse, Iterator> getIterator = response -> {
            if (response != null && response.entries() != null) {
                return response.entries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListPlaceIndexesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListPlaceIndexesResponseFetcher
    implements AsyncPageFetcher<ListPlaceIndexesResponse> {
        private ListPlaceIndexesResponseFetcher() {
        }

        public boolean hasNextPage(ListPlaceIndexesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPlaceIndexesResponse> nextPage(ListPlaceIndexesResponse previousPage) {
            if (previousPage == null) {
                return ListPlaceIndexesPublisher.this.client.listPlaceIndexes(ListPlaceIndexesPublisher.this.firstRequest);
            }
            return ListPlaceIndexesPublisher.this.client.listPlaceIndexes((ListPlaceIndexesRequest)((Object)ListPlaceIndexesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

