/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateGeofenceCollectionResponse extends LocationResponse implements
        ToCopyableBuilder<UpdateGeofenceCollectionResponse.Builder, UpdateGeofenceCollectionResponse> {
    private static final SdkField<String> COLLECTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CollectionArn").getter(getter(UpdateGeofenceCollectionResponse::collectionArn))
            .setter(setter(Builder::collectionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CollectionArn").build()).build();

    private static final SdkField<String> COLLECTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CollectionName").getter(getter(UpdateGeofenceCollectionResponse::collectionName))
            .setter(setter(Builder::collectionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CollectionName").build()).build();

    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdateTime")
            .getter(getter(UpdateGeofenceCollectionResponse::updateTime))
            .setter(setter(Builder::updateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLLECTION_ARN_FIELD,
            COLLECTION_NAME_FIELD, UPDATE_TIME_FIELD));

    private final String collectionArn;

    private final String collectionName;

    private final Instant updateTime;

    private UpdateGeofenceCollectionResponse(BuilderImpl builder) {
        super(builder);
        this.collectionArn = builder.collectionArn;
        this.collectionName = builder.collectionName;
        this.updateTime = builder.updateTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the updated geofence collection. Used to specify a resource across Amazon Web
     * Services.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Format example: <code>arn:aws:geo:region:account-id:geofence-collection/ExampleGeofenceCollection</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The Amazon Resource Name (ARN) of the updated geofence collection. Used to specify a resource across
     *         Amazon Web Services.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Format example: <code>arn:aws:geo:region:account-id:geofence-collection/ExampleGeofenceCollection</code>
     *         </p>
     *         </li>
     */
    public final String collectionArn() {
        return collectionArn;
    }

    /**
     * <p>
     * The name of the updated geofence collection.
     * </p>
     * 
     * @return The name of the updated geofence collection.
     */
    public final String collectionName() {
        return collectionName;
    }

    /**
     * <p>
     * The time when the geofence collection was last updated in <a
     * href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format:
     * <code>YYYY-MM-DDThh:mm:ss.sssZ</code>
     * </p>
     * 
     * @return The time when the geofence collection was last updated in <a
     *         href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format:
     *         <code>YYYY-MM-DDThh:mm:ss.sssZ</code>
     */
    public final Instant updateTime() {
        return updateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(collectionArn());
        hashCode = 31 * hashCode + Objects.hashCode(collectionName());
        hashCode = 31 * hashCode + Objects.hashCode(updateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateGeofenceCollectionResponse)) {
            return false;
        }
        UpdateGeofenceCollectionResponse other = (UpdateGeofenceCollectionResponse) obj;
        return Objects.equals(collectionArn(), other.collectionArn()) && Objects.equals(collectionName(), other.collectionName())
                && Objects.equals(updateTime(), other.updateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateGeofenceCollectionResponse").add("CollectionArn", collectionArn())
                .add("CollectionName", collectionName()).add("UpdateTime", updateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CollectionArn":
            return Optional.ofNullable(clazz.cast(collectionArn()));
        case "CollectionName":
            return Optional.ofNullable(clazz.cast(collectionName()));
        case "UpdateTime":
            return Optional.ofNullable(clazz.cast(updateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateGeofenceCollectionResponse, T> g) {
        return obj -> g.apply((UpdateGeofenceCollectionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LocationResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateGeofenceCollectionResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the updated geofence collection. Used to specify a resource across Amazon
         * Web Services.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Format example: <code>arn:aws:geo:region:account-id:geofence-collection/ExampleGeofenceCollection</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param collectionArn
         *        The Amazon Resource Name (ARN) of the updated geofence collection. Used to specify a resource across
         *        Amazon Web Services.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Format example:
         *        <code>arn:aws:geo:region:account-id:geofence-collection/ExampleGeofenceCollection</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collectionArn(String collectionArn);

        /**
         * <p>
         * The name of the updated geofence collection.
         * </p>
         * 
         * @param collectionName
         *        The name of the updated geofence collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collectionName(String collectionName);

        /**
         * <p>
         * The time when the geofence collection was last updated in <a
         * href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format:
         * <code>YYYY-MM-DDThh:mm:ss.sssZ</code>
         * </p>
         * 
         * @param updateTime
         *        The time when the geofence collection was last updated in <a
         *        href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format:
         *        <code>YYYY-MM-DDThh:mm:ss.sssZ</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateTime(Instant updateTime);
    }

    static final class BuilderImpl extends LocationResponse.BuilderImpl implements Builder {
        private String collectionArn;

        private String collectionName;

        private Instant updateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateGeofenceCollectionResponse model) {
            super(model);
            collectionArn(model.collectionArn);
            collectionName(model.collectionName);
            updateTime(model.updateTime);
        }

        public final String getCollectionArn() {
            return collectionArn;
        }

        public final void setCollectionArn(String collectionArn) {
            this.collectionArn = collectionArn;
        }

        @Override
        public final Builder collectionArn(String collectionArn) {
            this.collectionArn = collectionArn;
            return this;
        }

        public final String getCollectionName() {
            return collectionName;
        }

        public final void setCollectionName(String collectionName) {
            this.collectionName = collectionName;
        }

        @Override
        public final Builder collectionName(String collectionName) {
            this.collectionName = collectionName;
            return this;
        }

        public final Instant getUpdateTime() {
            return updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        @Override
        public UpdateGeofenceCollectionResponse build() {
            return new UpdateGeofenceCollectionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
