/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchPlaceIndexForTextRequest extends LocationRequest implements
        ToCopyableBuilder<SearchPlaceIndexForTextRequest.Builder, SearchPlaceIndexForTextRequest> {
    private static final SdkField<List<Double>> BIAS_POSITION_FIELD = SdkField
            .<List<Double>> builder(MarshallingType.LIST)
            .memberName("BiasPosition")
            .getter(getter(SearchPlaceIndexForTextRequest::biasPosition))
            .setter(setter(Builder::biasPosition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BiasPosition").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Double> builder(MarshallingType.DOUBLE)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Double>> FILTER_B_BOX_FIELD = SdkField
            .<List<Double>> builder(MarshallingType.LIST)
            .memberName("FilterBBox")
            .getter(getter(SearchPlaceIndexForTextRequest::filterBBox))
            .setter(setter(Builder::filterBBox))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterBBox").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Double> builder(MarshallingType.DOUBLE)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> FILTER_COUNTRIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("FilterCountries")
            .getter(getter(SearchPlaceIndexForTextRequest::filterCountries))
            .setter(setter(Builder::filterCountries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterCountries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> INDEX_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IndexName").getter(getter(SearchPlaceIndexForTextRequest::indexName)).setter(setter(Builder::indexName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("IndexName").build()).build();

    private static final SdkField<String> LANGUAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Language").getter(getter(SearchPlaceIndexForTextRequest::language)).setter(setter(Builder::language))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Language").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(SearchPlaceIndexForTextRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Text")
            .getter(getter(SearchPlaceIndexForTextRequest::text)).setter(setter(Builder::text))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Text").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BIAS_POSITION_FIELD,
            FILTER_B_BOX_FIELD, FILTER_COUNTRIES_FIELD, INDEX_NAME_FIELD, LANGUAGE_FIELD, MAX_RESULTS_FIELD, TEXT_FIELD));

    private final List<Double> biasPosition;

    private final List<Double> filterBBox;

    private final List<String> filterCountries;

    private final String indexName;

    private final String language;

    private final Integer maxResults;

    private final String text;

    private SearchPlaceIndexForTextRequest(BuilderImpl builder) {
        super(builder);
        this.biasPosition = builder.biasPosition;
        this.filterBBox = builder.filterBBox;
        this.filterCountries = builder.filterCountries;
        this.indexName = builder.indexName;
        this.language = builder.language;
        this.maxResults = builder.maxResults;
        this.text = builder.text;
    }

    /**
     * For responses, this returns true if the service returned a value for the BiasPosition property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBiasPosition() {
        return biasPosition != null && !(biasPosition instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An optional parameter that indicates a preference for places that are closer to a specified position.
     * </p>
     * <p>
     * If provided, this parameter must contain a pair of numbers. The first number represents the X coordinate, or
     * longitude; the second number represents the Y coordinate, or latitude.
     * </p>
     * <p>
     * For example, <code>[-123.1174, 49.2847]</code> represents the position with longitude <code>-123.1174</code> and
     * latitude <code>49.2847</code>.
     * </p>
     * <note>
     * <p>
     * <code>BiasPosition</code> and <code>FilterBBox</code> are mutually exclusive. Specifying both options results in
     * an error.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBiasPosition} method.
     * </p>
     * 
     * @return An optional parameter that indicates a preference for places that are closer to a specified position.</p>
     *         <p>
     *         If provided, this parameter must contain a pair of numbers. The first number represents the X coordinate,
     *         or longitude; the second number represents the Y coordinate, or latitude.
     *         </p>
     *         <p>
     *         For example, <code>[-123.1174, 49.2847]</code> represents the position with longitude
     *         <code>-123.1174</code> and latitude <code>49.2847</code>.
     *         </p>
     *         <note>
     *         <p>
     *         <code>BiasPosition</code> and <code>FilterBBox</code> are mutually exclusive. Specifying both options
     *         results in an error.
     *         </p>
     */
    public final List<Double> biasPosition() {
        return biasPosition;
    }

    /**
     * For responses, this returns true if the service returned a value for the FilterBBox property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilterBBox() {
        return filterBBox != null && !(filterBBox instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An optional parameter that limits the search results by returning only places that are within the provided
     * bounding box.
     * </p>
     * <p>
     * If provided, this parameter must contain a total of four consecutive numbers in two pairs. The first pair of
     * numbers represents the X and Y coordinates (longitude and latitude, respectively) of the southwest corner of the
     * bounding box; the second pair of numbers represents the X and Y coordinates (longitude and latitude,
     * respectively) of the northeast corner of the bounding box.
     * </p>
     * <p>
     * For example, <code>[-12.7935, -37.4835, -12.0684, -36.9542]</code> represents a bounding box where the southwest
     * corner has longitude <code>-12.7935</code> and latitude <code>-37.4835</code>, and the northeast corner has
     * longitude <code>-12.0684</code> and latitude <code>-36.9542</code>.
     * </p>
     * <note>
     * <p>
     * <code>FilterBBox</code> and <code>BiasPosition</code> are mutually exclusive. Specifying both options results in
     * an error.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilterBBox} method.
     * </p>
     * 
     * @return An optional parameter that limits the search results by returning only places that are within the
     *         provided bounding box.</p>
     *         <p>
     *         If provided, this parameter must contain a total of four consecutive numbers in two pairs. The first pair
     *         of numbers represents the X and Y coordinates (longitude and latitude, respectively) of the southwest
     *         corner of the bounding box; the second pair of numbers represents the X and Y coordinates (longitude and
     *         latitude, respectively) of the northeast corner of the bounding box.
     *         </p>
     *         <p>
     *         For example, <code>[-12.7935, -37.4835, -12.0684, -36.9542]</code> represents a bounding box where the
     *         southwest corner has longitude <code>-12.7935</code> and latitude <code>-37.4835</code>, and the
     *         northeast corner has longitude <code>-12.0684</code> and latitude <code>-36.9542</code>.
     *         </p>
     *         <note>
     *         <p>
     *         <code>FilterBBox</code> and <code>BiasPosition</code> are mutually exclusive. Specifying both options
     *         results in an error.
     *         </p>
     */
    public final List<Double> filterBBox() {
        return filterBBox;
    }

    /**
     * For responses, this returns true if the service returned a value for the FilterCountries property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFilterCountries() {
        return filterCountries != null && !(filterCountries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An optional parameter that limits the search results by returning only places that are in a specified list of
     * countries.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Valid values include <a href="https://www.iso.org/iso-3166-country-codes.html">ISO 3166</a> 3-digit country
     * codes. For example, Australia uses three upper-case characters: <code>AUS</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilterCountries} method.
     * </p>
     * 
     * @return An optional parameter that limits the search results by returning only places that are in a specified
     *         list of countries.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Valid values include <a href="https://www.iso.org/iso-3166-country-codes.html">ISO 3166</a> 3-digit
     *         country codes. For example, Australia uses three upper-case characters: <code>AUS</code>.
     *         </p>
     *         </li>
     */
    public final List<String> filterCountries() {
        return filterCountries;
    }

    /**
     * <p>
     * The name of the place index resource you want to use for the search.
     * </p>
     * 
     * @return The name of the place index resource you want to use for the search.
     */
    public final String indexName() {
        return indexName;
    }

    /**
     * <p>
     * The preferred language used to return results. The value must be a valid <a
     * href="https://tools.ietf.org/search/bcp47">BCP 47</a> language tag, for example, <code>en</code> for English.
     * </p>
     * <p>
     * This setting affects the languages used in the results, but not the results themselves. If no language is
     * specified, or not supported for a particular result, the partner automatically chooses a language for the result.
     * </p>
     * <p>
     * For an example, we'll use the Greek language. You search for <code>Athens, Greece</code>, with the
     * <code>language</code> parameter set to <code>en</code>. The result found will most likely be returned as
     * <code>Athens</code>.
     * </p>
     * <p>
     * If you set the <code>language</code> parameter to <code>el</code>, for Greek, then the result found will more
     * likely be returned as <code>Αθήνα</code>.
     * </p>
     * <p>
     * If the data provider does not have a value for Greek, the result will be in a language that the provider does
     * support.
     * </p>
     * 
     * @return The preferred language used to return results. The value must be a valid <a
     *         href="https://tools.ietf.org/search/bcp47">BCP 47</a> language tag, for example, <code>en</code> for
     *         English.</p>
     *         <p>
     *         This setting affects the languages used in the results, but not the results themselves. If no language is
     *         specified, or not supported for a particular result, the partner automatically chooses a language for the
     *         result.
     *         </p>
     *         <p>
     *         For an example, we'll use the Greek language. You search for <code>Athens, Greece</code>, with the
     *         <code>language</code> parameter set to <code>en</code>. The result found will most likely be returned as
     *         <code>Athens</code>.
     *         </p>
     *         <p>
     *         If you set the <code>language</code> parameter to <code>el</code>, for Greek, then the result found will
     *         more likely be returned as <code>Αθήνα</code>.
     *         </p>
     *         <p>
     *         If the data provider does not have a value for Greek, the result will be in a language that the provider
     *         does support.
     */
    public final String language() {
        return language;
    }

    /**
     * <p>
     * An optional parameter. The maximum number of results returned per request.
     * </p>
     * <p>
     * The default: <code>50</code>
     * </p>
     * 
     * @return An optional parameter. The maximum number of results returned per request. </p>
     *         <p>
     *         The default: <code>50</code>
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The address, name, city, or region to be used in the search in free-form text format. For example,
     * <code>123 Any Street</code>.
     * </p>
     * 
     * @return The address, name, city, or region to be used in the search in free-form text format. For example,
     *         <code>123 Any Street</code>.
     */
    public final String text() {
        return text;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasBiasPosition() ? biasPosition() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFilterBBox() ? filterBBox() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFilterCountries() ? filterCountries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(indexName());
        hashCode = 31 * hashCode + Objects.hashCode(language());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(text());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchPlaceIndexForTextRequest)) {
            return false;
        }
        SearchPlaceIndexForTextRequest other = (SearchPlaceIndexForTextRequest) obj;
        return hasBiasPosition() == other.hasBiasPosition() && Objects.equals(biasPosition(), other.biasPosition())
                && hasFilterBBox() == other.hasFilterBBox() && Objects.equals(filterBBox(), other.filterBBox())
                && hasFilterCountries() == other.hasFilterCountries()
                && Objects.equals(filterCountries(), other.filterCountries()) && Objects.equals(indexName(), other.indexName())
                && Objects.equals(language(), other.language()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(text(), other.text());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchPlaceIndexForTextRequest")
                .add("BiasPosition", biasPosition() == null ? null : "*** Sensitive Data Redacted ***")
                .add("FilterBBox", filterBBox() == null ? null : "*** Sensitive Data Redacted ***")
                .add("FilterCountries", hasFilterCountries() ? filterCountries() : null).add("IndexName", indexName())
                .add("Language", language()).add("MaxResults", maxResults())
                .add("Text", text() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BiasPosition":
            return Optional.ofNullable(clazz.cast(biasPosition()));
        case "FilterBBox":
            return Optional.ofNullable(clazz.cast(filterBBox()));
        case "FilterCountries":
            return Optional.ofNullable(clazz.cast(filterCountries()));
        case "IndexName":
            return Optional.ofNullable(clazz.cast(indexName()));
        case "Language":
            return Optional.ofNullable(clazz.cast(language()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "Text":
            return Optional.ofNullable(clazz.cast(text()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchPlaceIndexForTextRequest, T> g) {
        return obj -> g.apply((SearchPlaceIndexForTextRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LocationRequest.Builder, SdkPojo, CopyableBuilder<Builder, SearchPlaceIndexForTextRequest> {
        /**
         * <p>
         * An optional parameter that indicates a preference for places that are closer to a specified position.
         * </p>
         * <p>
         * If provided, this parameter must contain a pair of numbers. The first number represents the X coordinate, or
         * longitude; the second number represents the Y coordinate, or latitude.
         * </p>
         * <p>
         * For example, <code>[-123.1174, 49.2847]</code> represents the position with longitude <code>-123.1174</code>
         * and latitude <code>49.2847</code>.
         * </p>
         * <note>
         * <p>
         * <code>BiasPosition</code> and <code>FilterBBox</code> are mutually exclusive. Specifying both options results
         * in an error.
         * </p>
         * </note>
         * 
         * @param biasPosition
         *        An optional parameter that indicates a preference for places that are closer to a specified
         *        position.</p>
         *        <p>
         *        If provided, this parameter must contain a pair of numbers. The first number represents the X
         *        coordinate, or longitude; the second number represents the Y coordinate, or latitude.
         *        </p>
         *        <p>
         *        For example, <code>[-123.1174, 49.2847]</code> represents the position with longitude
         *        <code>-123.1174</code> and latitude <code>49.2847</code>.
         *        </p>
         *        <note>
         *        <p>
         *        <code>BiasPosition</code> and <code>FilterBBox</code> are mutually exclusive. Specifying both options
         *        results in an error.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder biasPosition(Collection<Double> biasPosition);

        /**
         * <p>
         * An optional parameter that indicates a preference for places that are closer to a specified position.
         * </p>
         * <p>
         * If provided, this parameter must contain a pair of numbers. The first number represents the X coordinate, or
         * longitude; the second number represents the Y coordinate, or latitude.
         * </p>
         * <p>
         * For example, <code>[-123.1174, 49.2847]</code> represents the position with longitude <code>-123.1174</code>
         * and latitude <code>49.2847</code>.
         * </p>
         * <note>
         * <p>
         * <code>BiasPosition</code> and <code>FilterBBox</code> are mutually exclusive. Specifying both options results
         * in an error.
         * </p>
         * </note>
         * 
         * @param biasPosition
         *        An optional parameter that indicates a preference for places that are closer to a specified
         *        position.</p>
         *        <p>
         *        If provided, this parameter must contain a pair of numbers. The first number represents the X
         *        coordinate, or longitude; the second number represents the Y coordinate, or latitude.
         *        </p>
         *        <p>
         *        For example, <code>[-123.1174, 49.2847]</code> represents the position with longitude
         *        <code>-123.1174</code> and latitude <code>49.2847</code>.
         *        </p>
         *        <note>
         *        <p>
         *        <code>BiasPosition</code> and <code>FilterBBox</code> are mutually exclusive. Specifying both options
         *        results in an error.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder biasPosition(Double... biasPosition);

        /**
         * <p>
         * An optional parameter that limits the search results by returning only places that are within the provided
         * bounding box.
         * </p>
         * <p>
         * If provided, this parameter must contain a total of four consecutive numbers in two pairs. The first pair of
         * numbers represents the X and Y coordinates (longitude and latitude, respectively) of the southwest corner of
         * the bounding box; the second pair of numbers represents the X and Y coordinates (longitude and latitude,
         * respectively) of the northeast corner of the bounding box.
         * </p>
         * <p>
         * For example, <code>[-12.7935, -37.4835, -12.0684, -36.9542]</code> represents a bounding box where the
         * southwest corner has longitude <code>-12.7935</code> and latitude <code>-37.4835</code>, and the northeast
         * corner has longitude <code>-12.0684</code> and latitude <code>-36.9542</code>.
         * </p>
         * <note>
         * <p>
         * <code>FilterBBox</code> and <code>BiasPosition</code> are mutually exclusive. Specifying both options results
         * in an error.
         * </p>
         * </note>
         * 
         * @param filterBBox
         *        An optional parameter that limits the search results by returning only places that are within the
         *        provided bounding box.</p>
         *        <p>
         *        If provided, this parameter must contain a total of four consecutive numbers in two pairs. The first
         *        pair of numbers represents the X and Y coordinates (longitude and latitude, respectively) of the
         *        southwest corner of the bounding box; the second pair of numbers represents the X and Y coordinates
         *        (longitude and latitude, respectively) of the northeast corner of the bounding box.
         *        </p>
         *        <p>
         *        For example, <code>[-12.7935, -37.4835, -12.0684, -36.9542]</code> represents a bounding box where the
         *        southwest corner has longitude <code>-12.7935</code> and latitude <code>-37.4835</code>, and the
         *        northeast corner has longitude <code>-12.0684</code> and latitude <code>-36.9542</code>.
         *        </p>
         *        <note>
         *        <p>
         *        <code>FilterBBox</code> and <code>BiasPosition</code> are mutually exclusive. Specifying both options
         *        results in an error.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterBBox(Collection<Double> filterBBox);

        /**
         * <p>
         * An optional parameter that limits the search results by returning only places that are within the provided
         * bounding box.
         * </p>
         * <p>
         * If provided, this parameter must contain a total of four consecutive numbers in two pairs. The first pair of
         * numbers represents the X and Y coordinates (longitude and latitude, respectively) of the southwest corner of
         * the bounding box; the second pair of numbers represents the X and Y coordinates (longitude and latitude,
         * respectively) of the northeast corner of the bounding box.
         * </p>
         * <p>
         * For example, <code>[-12.7935, -37.4835, -12.0684, -36.9542]</code> represents a bounding box where the
         * southwest corner has longitude <code>-12.7935</code> and latitude <code>-37.4835</code>, and the northeast
         * corner has longitude <code>-12.0684</code> and latitude <code>-36.9542</code>.
         * </p>
         * <note>
         * <p>
         * <code>FilterBBox</code> and <code>BiasPosition</code> are mutually exclusive. Specifying both options results
         * in an error.
         * </p>
         * </note>
         * 
         * @param filterBBox
         *        An optional parameter that limits the search results by returning only places that are within the
         *        provided bounding box.</p>
         *        <p>
         *        If provided, this parameter must contain a total of four consecutive numbers in two pairs. The first
         *        pair of numbers represents the X and Y coordinates (longitude and latitude, respectively) of the
         *        southwest corner of the bounding box; the second pair of numbers represents the X and Y coordinates
         *        (longitude and latitude, respectively) of the northeast corner of the bounding box.
         *        </p>
         *        <p>
         *        For example, <code>[-12.7935, -37.4835, -12.0684, -36.9542]</code> represents a bounding box where the
         *        southwest corner has longitude <code>-12.7935</code> and latitude <code>-37.4835</code>, and the
         *        northeast corner has longitude <code>-12.0684</code> and latitude <code>-36.9542</code>.
         *        </p>
         *        <note>
         *        <p>
         *        <code>FilterBBox</code> and <code>BiasPosition</code> are mutually exclusive. Specifying both options
         *        results in an error.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterBBox(Double... filterBBox);

        /**
         * <p>
         * An optional parameter that limits the search results by returning only places that are in a specified list of
         * countries.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Valid values include <a href="https://www.iso.org/iso-3166-country-codes.html">ISO 3166</a> 3-digit country
         * codes. For example, Australia uses three upper-case characters: <code>AUS</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filterCountries
         *        An optional parameter that limits the search results by returning only places that are in a specified
         *        list of countries.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Valid values include <a href="https://www.iso.org/iso-3166-country-codes.html">ISO 3166</a> 3-digit
         *        country codes. For example, Australia uses three upper-case characters: <code>AUS</code>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterCountries(Collection<String> filterCountries);

        /**
         * <p>
         * An optional parameter that limits the search results by returning only places that are in a specified list of
         * countries.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Valid values include <a href="https://www.iso.org/iso-3166-country-codes.html">ISO 3166</a> 3-digit country
         * codes. For example, Australia uses three upper-case characters: <code>AUS</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filterCountries
         *        An optional parameter that limits the search results by returning only places that are in a specified
         *        list of countries.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Valid values include <a href="https://www.iso.org/iso-3166-country-codes.html">ISO 3166</a> 3-digit
         *        country codes. For example, Australia uses three upper-case characters: <code>AUS</code>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterCountries(String... filterCountries);

        /**
         * <p>
         * The name of the place index resource you want to use for the search.
         * </p>
         * 
         * @param indexName
         *        The name of the place index resource you want to use for the search.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexName(String indexName);

        /**
         * <p>
         * The preferred language used to return results. The value must be a valid <a
         * href="https://tools.ietf.org/search/bcp47">BCP 47</a> language tag, for example, <code>en</code> for English.
         * </p>
         * <p>
         * This setting affects the languages used in the results, but not the results themselves. If no language is
         * specified, or not supported for a particular result, the partner automatically chooses a language for the
         * result.
         * </p>
         * <p>
         * For an example, we'll use the Greek language. You search for <code>Athens, Greece</code>, with the
         * <code>language</code> parameter set to <code>en</code>. The result found will most likely be returned as
         * <code>Athens</code>.
         * </p>
         * <p>
         * If you set the <code>language</code> parameter to <code>el</code>, for Greek, then the result found will more
         * likely be returned as <code>Αθήνα</code>.
         * </p>
         * <p>
         * If the data provider does not have a value for Greek, the result will be in a language that the provider does
         * support.
         * </p>
         * 
         * @param language
         *        The preferred language used to return results. The value must be a valid <a
         *        href="https://tools.ietf.org/search/bcp47">BCP 47</a> language tag, for example, <code>en</code> for
         *        English.</p>
         *        <p>
         *        This setting affects the languages used in the results, but not the results themselves. If no language
         *        is specified, or not supported for a particular result, the partner automatically chooses a language
         *        for the result.
         *        </p>
         *        <p>
         *        For an example, we'll use the Greek language. You search for <code>Athens, Greece</code>, with the
         *        <code>language</code> parameter set to <code>en</code>. The result found will most likely be returned
         *        as <code>Athens</code>.
         *        </p>
         *        <p>
         *        If you set the <code>language</code> parameter to <code>el</code>, for Greek, then the result found
         *        will more likely be returned as <code>Αθήνα</code>.
         *        </p>
         *        <p>
         *        If the data provider does not have a value for Greek, the result will be in a language that the
         *        provider does support.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder language(String language);

        /**
         * <p>
         * An optional parameter. The maximum number of results returned per request.
         * </p>
         * <p>
         * The default: <code>50</code>
         * </p>
         * 
         * @param maxResults
         *        An optional parameter. The maximum number of results returned per request. </p>
         *        <p>
         *        The default: <code>50</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The address, name, city, or region to be used in the search in free-form text format. For example,
         * <code>123 Any Street</code>.
         * </p>
         * 
         * @param text
         *        The address, name, city, or region to be used in the search in free-form text format. For example,
         *        <code>123 Any Street</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder text(String text);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LocationRequest.BuilderImpl implements Builder {
        private List<Double> biasPosition = DefaultSdkAutoConstructList.getInstance();

        private List<Double> filterBBox = DefaultSdkAutoConstructList.getInstance();

        private List<String> filterCountries = DefaultSdkAutoConstructList.getInstance();

        private String indexName;

        private String language;

        private Integer maxResults;

        private String text;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchPlaceIndexForTextRequest model) {
            super(model);
            biasPosition(model.biasPosition);
            filterBBox(model.filterBBox);
            filterCountries(model.filterCountries);
            indexName(model.indexName);
            language(model.language);
            maxResults(model.maxResults);
            text(model.text);
        }

        public final Collection<Double> getBiasPosition() {
            if (biasPosition instanceof SdkAutoConstructList) {
                return null;
            }
            return biasPosition;
        }

        public final void setBiasPosition(Collection<Double> biasPosition) {
            this.biasPosition = PositionCopier.copy(biasPosition);
        }

        @Override
        public final Builder biasPosition(Collection<Double> biasPosition) {
            this.biasPosition = PositionCopier.copy(biasPosition);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder biasPosition(Double... biasPosition) {
            biasPosition(Arrays.asList(biasPosition));
            return this;
        }

        public final Collection<Double> getFilterBBox() {
            if (filterBBox instanceof SdkAutoConstructList) {
                return null;
            }
            return filterBBox;
        }

        public final void setFilterBBox(Collection<Double> filterBBox) {
            this.filterBBox = BoundingBoxCopier.copy(filterBBox);
        }

        @Override
        public final Builder filterBBox(Collection<Double> filterBBox) {
            this.filterBBox = BoundingBoxCopier.copy(filterBBox);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterBBox(Double... filterBBox) {
            filterBBox(Arrays.asList(filterBBox));
            return this;
        }

        public final Collection<String> getFilterCountries() {
            if (filterCountries instanceof SdkAutoConstructList) {
                return null;
            }
            return filterCountries;
        }

        public final void setFilterCountries(Collection<String> filterCountries) {
            this.filterCountries = CountryCodeListCopier.copy(filterCountries);
        }

        @Override
        public final Builder filterCountries(Collection<String> filterCountries) {
            this.filterCountries = CountryCodeListCopier.copy(filterCountries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterCountries(String... filterCountries) {
            filterCountries(Arrays.asList(filterCountries));
            return this;
        }

        public final String getIndexName() {
            return indexName;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final String getLanguage() {
            return language;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        @Override
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getText() {
            return text;
        }

        public final void setText(String text) {
            this.text = text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SearchPlaceIndexForTextRequest build() {
            return new SearchPlaceIndexForTextRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
