/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetGeofenceResponse extends LocationResponse implements
        ToCopyableBuilder<GetGeofenceResponse.Builder, GetGeofenceResponse> {
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreateTime")
            .getter(getter(GetGeofenceResponse::createTime))
            .setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> GEOFENCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GeofenceId").getter(getter(GetGeofenceResponse::geofenceId)).setter(setter(Builder::geofenceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeofenceId").build()).build();

    private static final SdkField<GeofenceGeometry> GEOMETRY_FIELD = SdkField
            .<GeofenceGeometry> builder(MarshallingType.SDK_POJO).memberName("Geometry")
            .getter(getter(GetGeofenceResponse::geometry)).setter(setter(Builder::geometry))
            .constructor(GeofenceGeometry::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Geometry").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(GetGeofenceResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdateTime")
            .getter(getter(GetGeofenceResponse::updateTime))
            .setter(setter(Builder::updateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATE_TIME_FIELD,
            GEOFENCE_ID_FIELD, GEOMETRY_FIELD, STATUS_FIELD, UPDATE_TIME_FIELD));

    private final Instant createTime;

    private final String geofenceId;

    private final GeofenceGeometry geometry;

    private final String status;

    private final Instant updateTime;

    private GetGeofenceResponse(BuilderImpl builder) {
        super(builder);
        this.createTime = builder.createTime;
        this.geofenceId = builder.geofenceId;
        this.geometry = builder.geometry;
        this.status = builder.status;
        this.updateTime = builder.updateTime;
    }

    /**
     * <p>
     * The timestamp for when the geofence collection was created in <a
     * href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format:
     * <code>YYYY-MM-DDThh:mm:ss.sssZ</code>
     * </p>
     * 
     * @return The timestamp for when the geofence collection was created in <a
     *         href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format:
     *         <code>YYYY-MM-DDThh:mm:ss.sssZ</code>
     */
    public final Instant createTime() {
        return createTime;
    }

    /**
     * <p>
     * The geofence identifier.
     * </p>
     * 
     * @return The geofence identifier.
     */
    public final String geofenceId() {
        return geofenceId;
    }

    /**
     * <p>
     * Contains the geofence geometry details describing a polygon or a circle.
     * </p>
     * 
     * @return Contains the geofence geometry details describing a polygon or a circle.
     */
    public final GeofenceGeometry geometry() {
        return geometry;
    }

    /**
     * <p>
     * Identifies the state of the geofence. A geofence will hold one of the following states:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACTIVE</code> — The geofence has been indexed by the system.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PENDING</code> — The geofence is being processed by the system.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code> — The geofence failed to be indexed by the system.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETED</code> — The geofence has been deleted from the system index.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETING</code> — The geofence is being deleted from the system index.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Identifies the state of the geofence. A geofence will hold one of the following states:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code> — The geofence has been indexed by the system.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PENDING</code> — The geofence is being processed by the system.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code> — The geofence failed to be indexed by the system.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETED</code> — The geofence has been deleted from the system index.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETING</code> — The geofence is being deleted from the system index.
     *         </p>
     *         </li>
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The timestamp for when the geofence collection was last updated in <a
     * href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format:
     * <code>YYYY-MM-DDThh:mm:ss.sssZ</code>
     * </p>
     * 
     * @return The timestamp for when the geofence collection was last updated in <a
     *         href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format:
     *         <code>YYYY-MM-DDThh:mm:ss.sssZ</code>
     */
    public final Instant updateTime() {
        return updateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(geofenceId());
        hashCode = 31 * hashCode + Objects.hashCode(geometry());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(updateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetGeofenceResponse)) {
            return false;
        }
        GetGeofenceResponse other = (GetGeofenceResponse) obj;
        return Objects.equals(createTime(), other.createTime()) && Objects.equals(geofenceId(), other.geofenceId())
                && Objects.equals(geometry(), other.geometry()) && Objects.equals(status(), other.status())
                && Objects.equals(updateTime(), other.updateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetGeofenceResponse").add("CreateTime", createTime()).add("GeofenceId", geofenceId())
                .add("Geometry", geometry()).add("Status", status()).add("UpdateTime", updateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreateTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "GeofenceId":
            return Optional.ofNullable(clazz.cast(geofenceId()));
        case "Geometry":
            return Optional.ofNullable(clazz.cast(geometry()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "UpdateTime":
            return Optional.ofNullable(clazz.cast(updateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetGeofenceResponse, T> g) {
        return obj -> g.apply((GetGeofenceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LocationResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetGeofenceResponse> {
        /**
         * <p>
         * The timestamp for when the geofence collection was created in <a
         * href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format:
         * <code>YYYY-MM-DDThh:mm:ss.sssZ</code>
         * </p>
         * 
         * @param createTime
         *        The timestamp for when the geofence collection was created in <a
         *        href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format:
         *        <code>YYYY-MM-DDThh:mm:ss.sssZ</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * The geofence identifier.
         * </p>
         * 
         * @param geofenceId
         *        The geofence identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder geofenceId(String geofenceId);

        /**
         * <p>
         * Contains the geofence geometry details describing a polygon or a circle.
         * </p>
         * 
         * @param geometry
         *        Contains the geofence geometry details describing a polygon or a circle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder geometry(GeofenceGeometry geometry);

        /**
         * <p>
         * Contains the geofence geometry details describing a polygon or a circle.
         * </p>
         * This is a convenience method that creates an instance of the {@link GeofenceGeometry.Builder} avoiding the
         * need to create one manually via {@link GeofenceGeometry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GeofenceGeometry.Builder#build()} is called immediately and its
         * result is passed to {@link #geometry(GeofenceGeometry)}.
         * 
         * @param geometry
         *        a consumer that will call methods on {@link GeofenceGeometry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #geometry(GeofenceGeometry)
         */
        default Builder geometry(Consumer<GeofenceGeometry.Builder> geometry) {
            return geometry(GeofenceGeometry.builder().applyMutation(geometry).build());
        }

        /**
         * <p>
         * Identifies the state of the geofence. A geofence will hold one of the following states:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ACTIVE</code> — The geofence has been indexed by the system.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PENDING</code> — The geofence is being processed by the system.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code> — The geofence failed to be indexed by the system.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETED</code> — The geofence has been deleted from the system index.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETING</code> — The geofence is being deleted from the system index.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        Identifies the state of the geofence. A geofence will hold one of the following states:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code> — The geofence has been indexed by the system.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PENDING</code> — The geofence is being processed by the system.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code> — The geofence failed to be indexed by the system.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETED</code> — The geofence has been deleted from the system index.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETING</code> — The geofence is being deleted from the system index.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The timestamp for when the geofence collection was last updated in <a
         * href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format:
         * <code>YYYY-MM-DDThh:mm:ss.sssZ</code>
         * </p>
         * 
         * @param updateTime
         *        The timestamp for when the geofence collection was last updated in <a
         *        href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format:
         *        <code>YYYY-MM-DDThh:mm:ss.sssZ</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateTime(Instant updateTime);
    }

    static final class BuilderImpl extends LocationResponse.BuilderImpl implements Builder {
        private Instant createTime;

        private String geofenceId;

        private GeofenceGeometry geometry;

        private String status;

        private Instant updateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(GetGeofenceResponse model) {
            super(model);
            createTime(model.createTime);
            geofenceId(model.geofenceId);
            geometry(model.geometry);
            status(model.status);
            updateTime(model.updateTime);
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final String getGeofenceId() {
            return geofenceId;
        }

        public final void setGeofenceId(String geofenceId) {
            this.geofenceId = geofenceId;
        }

        @Override
        public final Builder geofenceId(String geofenceId) {
            this.geofenceId = geofenceId;
            return this;
        }

        public final GeofenceGeometry.Builder getGeometry() {
            return geometry != null ? geometry.toBuilder() : null;
        }

        public final void setGeometry(GeofenceGeometry.BuilderImpl geometry) {
            this.geometry = geometry != null ? geometry.build() : null;
        }

        @Override
        public final Builder geometry(GeofenceGeometry geometry) {
            this.geometry = geometry;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Instant getUpdateTime() {
            return updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        @Override
        public GetGeofenceResponse build() {
            return new GetGeofenceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
