/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateTrackerRequest extends LocationRequest implements
        ToCopyableBuilder<CreateTrackerRequest.Builder, CreateTrackerRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateTrackerRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(CreateTrackerRequest::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<String> POSITION_FILTERING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PositionFiltering").getter(getter(CreateTrackerRequest::positionFilteringAsString))
            .setter(setter(Builder::positionFiltering))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PositionFiltering").build()).build();

    private static final SdkField<String> PRICING_PLAN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PricingPlan").getter(getter(CreateTrackerRequest::pricingPlanAsString))
            .setter(setter(Builder::pricingPlan))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PricingPlan").build()).build();

    private static final SdkField<String> PRICING_PLAN_DATA_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PricingPlanDataSource").getter(getter(CreateTrackerRequest::pricingPlanDataSource))
            .setter(setter(Builder::pricingPlanDataSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PricingPlanDataSource").build())
            .build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateTrackerRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> TRACKER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrackerName").getter(getter(CreateTrackerRequest::trackerName)).setter(setter(Builder::trackerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrackerName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            KMS_KEY_ID_FIELD, POSITION_FILTERING_FIELD, PRICING_PLAN_FIELD, PRICING_PLAN_DATA_SOURCE_FIELD, TAGS_FIELD,
            TRACKER_NAME_FIELD));

    private final String description;

    private final String kmsKeyId;

    private final String positionFiltering;

    private final String pricingPlan;

    private final String pricingPlanDataSource;

    private final Map<String, String> tags;

    private final String trackerName;

    private CreateTrackerRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.kmsKeyId = builder.kmsKeyId;
        this.positionFiltering = builder.positionFiltering;
        this.pricingPlan = builder.pricingPlan;
        this.pricingPlanDataSource = builder.pricingPlanDataSource;
        this.tags = builder.tags;
        this.trackerName = builder.trackerName;
    }

    /**
     * <p>
     * An optional description for the tracker resource.
     * </p>
     * 
     * @return An optional description for the tracker resource.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * A key identifier for an <a href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html">AWS KMS
     * customer managed key</a>. Enter a key ID, key ARN, alias name, or alias ARN.
     * </p>
     * 
     * @return A key identifier for an <a
     *         href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html">AWS KMS customer managed
     *         key</a>. Enter a key ID, key ARN, alias name, or alias ARN.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * Specifies the position filtering for the tracker resource.
     * </p>
     * <p>
     * Valid values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>TimeBased</code> - Location updates are evaluated against linked geofence collections, but not every
     * location update is stored. If your update frequency is more often than 30 seconds, only one update per 30 seconds
     * is stored for each unique device ID.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DistanceBased</code> - If the device has moved less than 30 m (98.4 ft), location updates are ignored.
     * Location updates within this area are neither evaluated against linked geofence collections, nor stored. This
     * helps control costs by reducing the number of geofence evaluations and historical device positions to paginate
     * through. Distance-based filtering can also reduce the effects of GPS noise when displaying device trajectories on
     * a map.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AccuracyBased</code> - If the device has moved less than the measured accuracy, location updates are
     * ignored. For example, if two consecutive updates from a device have a horizontal accuracy of 5 m and 10 m, the
     * second update is ignored if the device has moved less than 15 m. Ignored location updates are neither evaluated
     * against linked geofence collections, nor stored. This can reduce the effects of GPS noise when displaying device
     * trajectories on a map, and can help control your costs by reducing the number of geofence evaluations.
     * </p>
     * </li>
     * </ul>
     * <p>
     * This field is optional. If not specified, the default value is <code>TimeBased</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #positionFiltering}
     * will return {@link PositionFiltering#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #positionFilteringAsString}.
     * </p>
     * 
     * @return Specifies the position filtering for the tracker resource.</p>
     *         <p>
     *         Valid values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>TimeBased</code> - Location updates are evaluated against linked geofence collections, but not
     *         every location update is stored. If your update frequency is more often than 30 seconds, only one update
     *         per 30 seconds is stored for each unique device ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DistanceBased</code> - If the device has moved less than 30 m (98.4 ft), location updates are
     *         ignored. Location updates within this area are neither evaluated against linked geofence collections, nor
     *         stored. This helps control costs by reducing the number of geofence evaluations and historical device
     *         positions to paginate through. Distance-based filtering can also reduce the effects of GPS noise when
     *         displaying device trajectories on a map.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AccuracyBased</code> - If the device has moved less than the measured accuracy, location updates
     *         are ignored. For example, if two consecutive updates from a device have a horizontal accuracy of 5 m and
     *         10 m, the second update is ignored if the device has moved less than 15 m. Ignored location updates are
     *         neither evaluated against linked geofence collections, nor stored. This can reduce the effects of GPS
     *         noise when displaying device trajectories on a map, and can help control your costs by reducing the
     *         number of geofence evaluations.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         This field is optional. If not specified, the default value is <code>TimeBased</code>.
     * @see PositionFiltering
     */
    public final PositionFiltering positionFiltering() {
        return PositionFiltering.fromValue(positionFiltering);
    }

    /**
     * <p>
     * Specifies the position filtering for the tracker resource.
     * </p>
     * <p>
     * Valid values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>TimeBased</code> - Location updates are evaluated against linked geofence collections, but not every
     * location update is stored. If your update frequency is more often than 30 seconds, only one update per 30 seconds
     * is stored for each unique device ID.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DistanceBased</code> - If the device has moved less than 30 m (98.4 ft), location updates are ignored.
     * Location updates within this area are neither evaluated against linked geofence collections, nor stored. This
     * helps control costs by reducing the number of geofence evaluations and historical device positions to paginate
     * through. Distance-based filtering can also reduce the effects of GPS noise when displaying device trajectories on
     * a map.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AccuracyBased</code> - If the device has moved less than the measured accuracy, location updates are
     * ignored. For example, if two consecutive updates from a device have a horizontal accuracy of 5 m and 10 m, the
     * second update is ignored if the device has moved less than 15 m. Ignored location updates are neither evaluated
     * against linked geofence collections, nor stored. This can reduce the effects of GPS noise when displaying device
     * trajectories on a map, and can help control your costs by reducing the number of geofence evaluations.
     * </p>
     * </li>
     * </ul>
     * <p>
     * This field is optional. If not specified, the default value is <code>TimeBased</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #positionFiltering}
     * will return {@link PositionFiltering#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #positionFilteringAsString}.
     * </p>
     * 
     * @return Specifies the position filtering for the tracker resource.</p>
     *         <p>
     *         Valid values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>TimeBased</code> - Location updates are evaluated against linked geofence collections, but not
     *         every location update is stored. If your update frequency is more often than 30 seconds, only one update
     *         per 30 seconds is stored for each unique device ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DistanceBased</code> - If the device has moved less than 30 m (98.4 ft), location updates are
     *         ignored. Location updates within this area are neither evaluated against linked geofence collections, nor
     *         stored. This helps control costs by reducing the number of geofence evaluations and historical device
     *         positions to paginate through. Distance-based filtering can also reduce the effects of GPS noise when
     *         displaying device trajectories on a map.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AccuracyBased</code> - If the device has moved less than the measured accuracy, location updates
     *         are ignored. For example, if two consecutive updates from a device have a horizontal accuracy of 5 m and
     *         10 m, the second update is ignored if the device has moved less than 15 m. Ignored location updates are
     *         neither evaluated against linked geofence collections, nor stored. This can reduce the effects of GPS
     *         noise when displaying device trajectories on a map, and can help control your costs by reducing the
     *         number of geofence evaluations.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         This field is optional. If not specified, the default value is <code>TimeBased</code>.
     * @see PositionFiltering
     */
    public final String positionFilteringAsString() {
        return positionFiltering;
    }

    /**
     * <p>
     * No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pricingPlan} will
     * return {@link PricingPlan#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #pricingPlanAsString}.
     * </p>
     * 
     * @return No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.
     * @see PricingPlan
     * @deprecated Deprecated. If included, the only allowed value is RequestBasedUsage.
     */
    @Deprecated
    public final PricingPlan pricingPlan() {
        return PricingPlan.fromValue(pricingPlan);
    }

    /**
     * <p>
     * No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pricingPlan} will
     * return {@link PricingPlan#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #pricingPlanAsString}.
     * </p>
     * 
     * @return No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.
     * @see PricingPlan
     * @deprecated Deprecated. If included, the only allowed value is RequestBasedUsage.
     */
    @Deprecated
    public final String pricingPlanAsString() {
        return pricingPlan;
    }

    /**
     * <p>
     * This parameter is no longer used.
     * </p>
     * 
     * @return This parameter is no longer used.
     * @deprecated Deprecated. No longer allowed.
     */
    @Deprecated
    public final String pricingPlanDataSource() {
        return pricingPlanDataSource;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Applies one or more tags to the tracker resource. A tag is a key-value pair helps manage, identify, search, and
     * filter your resources by labelling them.
     * </p>
     * <p>
     * Format: <code>"key" : "value"</code>
     * </p>
     * <p>
     * Restrictions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Maximum 50 tags per resource
     * </p>
     * </li>
     * <li>
     * <p>
     * Each resource tag must be unique with a maximum of one value.
     * </p>
     * </li>
     * <li>
     * <p>
     * Maximum key length: 128 Unicode characters in UTF-8
     * </p>
     * </li>
     * <li>
     * <p>
     * Maximum value length: 256 Unicode characters in UTF-8
     * </p>
     * </li>
     * <li>
     * <p>
     * Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters: + - = . _ : / @.
     * </p>
     * </li>
     * <li>
     * <p>
     * Cannot use "aws:" as a prefix for a key.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Applies one or more tags to the tracker resource. A tag is a key-value pair helps manage, identify,
     *         search, and filter your resources by labelling them.</p>
     *         <p>
     *         Format: <code>"key" : "value"</code>
     *         </p>
     *         <p>
     *         Restrictions:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Maximum 50 tags per resource
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Each resource tag must be unique with a maximum of one value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Maximum key length: 128 Unicode characters in UTF-8
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Maximum value length: 256 Unicode characters in UTF-8
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters: + - = . _ : / @.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Cannot use "aws:" as a prefix for a key.
     *         </p>
     *         </li>
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The name for the tracker resource.
     * </p>
     * <p>
     * Requirements:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Contain only alphanumeric characters (A-Z, a-z, 0-9) , hyphens (-), periods (.), and underscores (_).
     * </p>
     * </li>
     * <li>
     * <p>
     * Must be a unique tracker resource name.
     * </p>
     * </li>
     * <li>
     * <p>
     * No spaces allowed. For example, <code>ExampleTracker</code>.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name for the tracker resource.</p>
     *         <p>
     *         Requirements:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only alphanumeric characters (A-Z, a-z, 0-9) , hyphens (-), periods (.), and underscores (_).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must be a unique tracker resource name.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         No spaces allowed. For example, <code>ExampleTracker</code>.
     *         </p>
     *         </li>
     */
    public final String trackerName() {
        return trackerName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(positionFilteringAsString());
        hashCode = 31 * hashCode + Objects.hashCode(pricingPlanAsString());
        hashCode = 31 * hashCode + Objects.hashCode(pricingPlanDataSource());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(trackerName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTrackerRequest)) {
            return false;
        }
        CreateTrackerRequest other = (CreateTrackerRequest) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && Objects.equals(positionFilteringAsString(), other.positionFilteringAsString())
                && Objects.equals(pricingPlanAsString(), other.pricingPlanAsString())
                && Objects.equals(pricingPlanDataSource(), other.pricingPlanDataSource()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(trackerName(), other.trackerName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateTrackerRequest").add("Description", description()).add("KmsKeyId", kmsKeyId())
                .add("PositionFiltering", positionFilteringAsString()).add("PricingPlan", pricingPlanAsString())
                .add("PricingPlanDataSource", pricingPlanDataSource()).add("Tags", hasTags() ? tags() : null)
                .add("TrackerName", trackerName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "PositionFiltering":
            return Optional.ofNullable(clazz.cast(positionFilteringAsString()));
        case "PricingPlan":
            return Optional.ofNullable(clazz.cast(pricingPlanAsString()));
        case "PricingPlanDataSource":
            return Optional.ofNullable(clazz.cast(pricingPlanDataSource()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "TrackerName":
            return Optional.ofNullable(clazz.cast(trackerName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTrackerRequest, T> g) {
        return obj -> g.apply((CreateTrackerRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LocationRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateTrackerRequest> {
        /**
         * <p>
         * An optional description for the tracker resource.
         * </p>
         * 
         * @param description
         *        An optional description for the tracker resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A key identifier for an <a href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html">AWS
         * KMS customer managed key</a>. Enter a key ID, key ARN, alias name, or alias ARN.
         * </p>
         * 
         * @param kmsKeyId
         *        A key identifier for an <a
         *        href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html">AWS KMS customer managed
         *        key</a>. Enter a key ID, key ARN, alias name, or alias ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * Specifies the position filtering for the tracker resource.
         * </p>
         * <p>
         * Valid values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>TimeBased</code> - Location updates are evaluated against linked geofence collections, but not every
         * location update is stored. If your update frequency is more often than 30 seconds, only one update per 30
         * seconds is stored for each unique device ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DistanceBased</code> - If the device has moved less than 30 m (98.4 ft), location updates are ignored.
         * Location updates within this area are neither evaluated against linked geofence collections, nor stored. This
         * helps control costs by reducing the number of geofence evaluations and historical device positions to
         * paginate through. Distance-based filtering can also reduce the effects of GPS noise when displaying device
         * trajectories on a map.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AccuracyBased</code> - If the device has moved less than the measured accuracy, location updates are
         * ignored. For example, if two consecutive updates from a device have a horizontal accuracy of 5 m and 10 m,
         * the second update is ignored if the device has moved less than 15 m. Ignored location updates are neither
         * evaluated against linked geofence collections, nor stored. This can reduce the effects of GPS noise when
         * displaying device trajectories on a map, and can help control your costs by reducing the number of geofence
         * evaluations.
         * </p>
         * </li>
         * </ul>
         * <p>
         * This field is optional. If not specified, the default value is <code>TimeBased</code>.
         * </p>
         * 
         * @param positionFiltering
         *        Specifies the position filtering for the tracker resource.</p>
         *        <p>
         *        Valid values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>TimeBased</code> - Location updates are evaluated against linked geofence collections, but not
         *        every location update is stored. If your update frequency is more often than 30 seconds, only one
         *        update per 30 seconds is stored for each unique device ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DistanceBased</code> - If the device has moved less than 30 m (98.4 ft), location updates are
         *        ignored. Location updates within this area are neither evaluated against linked geofence collections,
         *        nor stored. This helps control costs by reducing the number of geofence evaluations and historical
         *        device positions to paginate through. Distance-based filtering can also reduce the effects of GPS
         *        noise when displaying device trajectories on a map.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AccuracyBased</code> - If the device has moved less than the measured accuracy, location updates
         *        are ignored. For example, if two consecutive updates from a device have a horizontal accuracy of 5 m
         *        and 10 m, the second update is ignored if the device has moved less than 15 m. Ignored location
         *        updates are neither evaluated against linked geofence collections, nor stored. This can reduce the
         *        effects of GPS noise when displaying device trajectories on a map, and can help control your costs by
         *        reducing the number of geofence evaluations.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        This field is optional. If not specified, the default value is <code>TimeBased</code>.
         * @see PositionFiltering
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PositionFiltering
         */
        Builder positionFiltering(String positionFiltering);

        /**
         * <p>
         * Specifies the position filtering for the tracker resource.
         * </p>
         * <p>
         * Valid values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>TimeBased</code> - Location updates are evaluated against linked geofence collections, but not every
         * location update is stored. If your update frequency is more often than 30 seconds, only one update per 30
         * seconds is stored for each unique device ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DistanceBased</code> - If the device has moved less than 30 m (98.4 ft), location updates are ignored.
         * Location updates within this area are neither evaluated against linked geofence collections, nor stored. This
         * helps control costs by reducing the number of geofence evaluations and historical device positions to
         * paginate through. Distance-based filtering can also reduce the effects of GPS noise when displaying device
         * trajectories on a map.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AccuracyBased</code> - If the device has moved less than the measured accuracy, location updates are
         * ignored. For example, if two consecutive updates from a device have a horizontal accuracy of 5 m and 10 m,
         * the second update is ignored if the device has moved less than 15 m. Ignored location updates are neither
         * evaluated against linked geofence collections, nor stored. This can reduce the effects of GPS noise when
         * displaying device trajectories on a map, and can help control your costs by reducing the number of geofence
         * evaluations.
         * </p>
         * </li>
         * </ul>
         * <p>
         * This field is optional. If not specified, the default value is <code>TimeBased</code>.
         * </p>
         * 
         * @param positionFiltering
         *        Specifies the position filtering for the tracker resource.</p>
         *        <p>
         *        Valid values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>TimeBased</code> - Location updates are evaluated against linked geofence collections, but not
         *        every location update is stored. If your update frequency is more often than 30 seconds, only one
         *        update per 30 seconds is stored for each unique device ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DistanceBased</code> - If the device has moved less than 30 m (98.4 ft), location updates are
         *        ignored. Location updates within this area are neither evaluated against linked geofence collections,
         *        nor stored. This helps control costs by reducing the number of geofence evaluations and historical
         *        device positions to paginate through. Distance-based filtering can also reduce the effects of GPS
         *        noise when displaying device trajectories on a map.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AccuracyBased</code> - If the device has moved less than the measured accuracy, location updates
         *        are ignored. For example, if two consecutive updates from a device have a horizontal accuracy of 5 m
         *        and 10 m, the second update is ignored if the device has moved less than 15 m. Ignored location
         *        updates are neither evaluated against linked geofence collections, nor stored. This can reduce the
         *        effects of GPS noise when displaying device trajectories on a map, and can help control your costs by
         *        reducing the number of geofence evaluations.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        This field is optional. If not specified, the default value is <code>TimeBased</code>.
         * @see PositionFiltering
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PositionFiltering
         */
        Builder positionFiltering(PositionFiltering positionFiltering);

        /**
         * <p>
         * No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.
         * </p>
         * 
         * @param pricingPlan
         *        No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.
         * @see PricingPlan
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PricingPlan
         * @deprecated Deprecated. If included, the only allowed value is RequestBasedUsage.
         */
        @Deprecated
        Builder pricingPlan(String pricingPlan);

        /**
         * <p>
         * No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.
         * </p>
         * 
         * @param pricingPlan
         *        No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.
         * @see PricingPlan
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PricingPlan
         * @deprecated Deprecated. If included, the only allowed value is RequestBasedUsage.
         */
        @Deprecated
        Builder pricingPlan(PricingPlan pricingPlan);

        /**
         * <p>
         * This parameter is no longer used.
         * </p>
         * 
         * @param pricingPlanDataSource
         *        This parameter is no longer used.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated Deprecated. No longer allowed.
         */
        @Deprecated
        Builder pricingPlanDataSource(String pricingPlanDataSource);

        /**
         * <p>
         * Applies one or more tags to the tracker resource. A tag is a key-value pair helps manage, identify, search,
         * and filter your resources by labelling them.
         * </p>
         * <p>
         * Format: <code>"key" : "value"</code>
         * </p>
         * <p>
         * Restrictions:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Maximum 50 tags per resource
         * </p>
         * </li>
         * <li>
         * <p>
         * Each resource tag must be unique with a maximum of one value.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum key length: 128 Unicode characters in UTF-8
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum value length: 256 Unicode characters in UTF-8
         * </p>
         * </li>
         * <li>
         * <p>
         * Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters: + - = . _ : / @.
         * </p>
         * </li>
         * <li>
         * <p>
         * Cannot use "aws:" as a prefix for a key.
         * </p>
         * </li>
         * </ul>
         * 
         * @param tags
         *        Applies one or more tags to the tracker resource. A tag is a key-value pair helps manage, identify,
         *        search, and filter your resources by labelling them.</p>
         *        <p>
         *        Format: <code>"key" : "value"</code>
         *        </p>
         *        <p>
         *        Restrictions:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Maximum 50 tags per resource
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Each resource tag must be unique with a maximum of one value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum key length: 128 Unicode characters in UTF-8
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum value length: 256 Unicode characters in UTF-8
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters: + - = . _ : / @.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Cannot use "aws:" as a prefix for a key.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The name for the tracker resource.
         * </p>
         * <p>
         * Requirements:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Contain only alphanumeric characters (A-Z, a-z, 0-9) , hyphens (-), periods (.), and underscores (_).
         * </p>
         * </li>
         * <li>
         * <p>
         * Must be a unique tracker resource name.
         * </p>
         * </li>
         * <li>
         * <p>
         * No spaces allowed. For example, <code>ExampleTracker</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param trackerName
         *        The name for the tracker resource.</p>
         *        <p>
         *        Requirements:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Contain only alphanumeric characters (A-Z, a-z, 0-9) , hyphens (-), periods (.), and underscores (_).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must be a unique tracker resource name.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        No spaces allowed. For example, <code>ExampleTracker</code>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trackerName(String trackerName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LocationRequest.BuilderImpl implements Builder {
        private String description;

        private String kmsKeyId;

        private String positionFiltering;

        private String pricingPlan;

        private String pricingPlanDataSource;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String trackerName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTrackerRequest model) {
            super(model);
            description(model.description);
            kmsKeyId(model.kmsKeyId);
            positionFiltering(model.positionFiltering);
            pricingPlan(model.pricingPlan);
            pricingPlanDataSource(model.pricingPlanDataSource);
            tags(model.tags);
            trackerName(model.trackerName);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getPositionFiltering() {
            return positionFiltering;
        }

        public final void setPositionFiltering(String positionFiltering) {
            this.positionFiltering = positionFiltering;
        }

        @Override
        public final Builder positionFiltering(String positionFiltering) {
            this.positionFiltering = positionFiltering;
            return this;
        }

        @Override
        public final Builder positionFiltering(PositionFiltering positionFiltering) {
            this.positionFiltering(positionFiltering == null ? null : positionFiltering.toString());
            return this;
        }

        @Deprecated
        public final String getPricingPlan() {
            return pricingPlan;
        }

        @Deprecated
        public final void setPricingPlan(String pricingPlan) {
            this.pricingPlan = pricingPlan;
        }

        @Override
        @Deprecated
        public final Builder pricingPlan(String pricingPlan) {
            this.pricingPlan = pricingPlan;
            return this;
        }

        @Override
        @Deprecated
        public final Builder pricingPlan(PricingPlan pricingPlan) {
            this.pricingPlan(pricingPlan == null ? null : pricingPlan.toString());
            return this;
        }

        @Deprecated
        public final String getPricingPlanDataSource() {
            return pricingPlanDataSource;
        }

        @Deprecated
        public final void setPricingPlanDataSource(String pricingPlanDataSource) {
            this.pricingPlanDataSource = pricingPlanDataSource;
        }

        @Override
        @Deprecated
        public final Builder pricingPlanDataSource(String pricingPlanDataSource) {
            this.pricingPlanDataSource = pricingPlanDataSource;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getTrackerName() {
            return trackerName;
        }

        public final void setTrackerName(String trackerName) {
            this.trackerName = trackerName;
        }

        @Override
        public final Builder trackerName(String trackerName) {
            this.trackerName = trackerName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTrackerRequest build() {
            return new CreateTrackerRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
