/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains geofence geometry details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchPutGeofenceRequestEntry implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchPutGeofenceRequestEntry.Builder, BatchPutGeofenceRequestEntry> {
    private static final SdkField<String> GEOFENCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GeofenceId").getter(getter(BatchPutGeofenceRequestEntry::geofenceId))
            .setter(setter(Builder::geofenceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeofenceId").build()).build();

    private static final SdkField<GeofenceGeometry> GEOMETRY_FIELD = SdkField
            .<GeofenceGeometry> builder(MarshallingType.SDK_POJO).memberName("Geometry")
            .getter(getter(BatchPutGeofenceRequestEntry::geometry)).setter(setter(Builder::geometry))
            .constructor(GeofenceGeometry::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Geometry").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GEOFENCE_ID_FIELD,
            GEOMETRY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String geofenceId;

    private final GeofenceGeometry geometry;

    private BatchPutGeofenceRequestEntry(BuilderImpl builder) {
        this.geofenceId = builder.geofenceId;
        this.geometry = builder.geometry;
    }

    /**
     * <p>
     * The identifier for the geofence to be stored in a given geofence collection.
     * </p>
     * 
     * @return The identifier for the geofence to be stored in a given geofence collection.
     */
    public final String geofenceId() {
        return geofenceId;
    }

    /**
     * <p>
     * Contains the details of the position of the geofence. Can be either a polygon or a circle. Including both will
     * return a validation error.
     * </p>
     * <note>
     * <p>
     * Each <a href="https://docs.aws.amazon.com/location-geofences/latest/APIReference/API_GeofenceGeometry.html">
     * geofence polygon</a> can have a maximum of 1,000 vertices.
     * </p>
     * </note>
     * 
     * @return Contains the details of the position of the geofence. Can be either a polygon or a circle. Including both
     *         will return a validation error.</p> <note>
     *         <p>
     *         Each <a
     *         href="https://docs.aws.amazon.com/location-geofences/latest/APIReference/API_GeofenceGeometry.html">
     *         geofence polygon</a> can have a maximum of 1,000 vertices.
     *         </p>
     */
    public final GeofenceGeometry geometry() {
        return geometry;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(geofenceId());
        hashCode = 31 * hashCode + Objects.hashCode(geometry());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchPutGeofenceRequestEntry)) {
            return false;
        }
        BatchPutGeofenceRequestEntry other = (BatchPutGeofenceRequestEntry) obj;
        return Objects.equals(geofenceId(), other.geofenceId()) && Objects.equals(geometry(), other.geometry());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchPutGeofenceRequestEntry").add("GeofenceId", geofenceId()).add("Geometry", geometry())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GeofenceId":
            return Optional.ofNullable(clazz.cast(geofenceId()));
        case "Geometry":
            return Optional.ofNullable(clazz.cast(geometry()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchPutGeofenceRequestEntry, T> g) {
        return obj -> g.apply((BatchPutGeofenceRequestEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchPutGeofenceRequestEntry> {
        /**
         * <p>
         * The identifier for the geofence to be stored in a given geofence collection.
         * </p>
         * 
         * @param geofenceId
         *        The identifier for the geofence to be stored in a given geofence collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder geofenceId(String geofenceId);

        /**
         * <p>
         * Contains the details of the position of the geofence. Can be either a polygon or a circle. Including both
         * will return a validation error.
         * </p>
         * <note>
         * <p>
         * Each <a href="https://docs.aws.amazon.com/location-geofences/latest/APIReference/API_GeofenceGeometry.html">
         * geofence polygon</a> can have a maximum of 1,000 vertices.
         * </p>
         * </note>
         * 
         * @param geometry
         *        Contains the details of the position of the geofence. Can be either a polygon or a circle. Including
         *        both will return a validation error.</p> <note>
         *        <p>
         *        Each <a
         *        href="https://docs.aws.amazon.com/location-geofences/latest/APIReference/API_GeofenceGeometry.html">
         *        geofence polygon</a> can have a maximum of 1,000 vertices.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder geometry(GeofenceGeometry geometry);

        /**
         * <p>
         * Contains the details of the position of the geofence. Can be either a polygon or a circle. Including both
         * will return a validation error.
         * </p>
         * <note>
         * <p>
         * Each <a href="https://docs.aws.amazon.com/location-geofences/latest/APIReference/API_GeofenceGeometry.html">
         * geofence polygon</a> can have a maximum of 1,000 vertices.
         * </p>
         * </note> This is a convenience method that creates an instance of the {@link GeofenceGeometry.Builder}
         * avoiding the need to create one manually via {@link GeofenceGeometry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GeofenceGeometry.Builder#build()} is called immediately and its
         * result is passed to {@link #geometry(GeofenceGeometry)}.
         * 
         * @param geometry
         *        a consumer that will call methods on {@link GeofenceGeometry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #geometry(GeofenceGeometry)
         */
        default Builder geometry(Consumer<GeofenceGeometry.Builder> geometry) {
            return geometry(GeofenceGeometry.builder().applyMutation(geometry).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String geofenceId;

        private GeofenceGeometry geometry;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchPutGeofenceRequestEntry model) {
            geofenceId(model.geofenceId);
            geometry(model.geometry);
        }

        public final String getGeofenceId() {
            return geofenceId;
        }

        public final void setGeofenceId(String geofenceId) {
            this.geofenceId = geofenceId;
        }

        @Override
        public final Builder geofenceId(String geofenceId) {
            this.geofenceId = geofenceId;
            return this;
        }

        public final GeofenceGeometry.Builder getGeometry() {
            return geometry != null ? geometry.toBuilder() : null;
        }

        public final void setGeometry(GeofenceGeometry.BuilderImpl geometry) {
            this.geometry = geometry != null ? geometry.build() : null;
        }

        @Override
        public final Builder geometry(GeofenceGeometry geometry) {
            this.geometry = geometry;
            return this;
        }

        @Override
        public BatchPutGeofenceRequestEntry build() {
            return new BatchPutGeofenceRequestEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
