/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.location.model.BatchItemError;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchUpdateDevicePositionError
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BatchUpdateDevicePositionError> {
    private static final SdkField<String> DEVICE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceId").getter(BatchUpdateDevicePositionError.getter(BatchUpdateDevicePositionError::deviceId)).setter(BatchUpdateDevicePositionError.setter(Builder::deviceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceId").build()}).build();
    private static final SdkField<BatchItemError> ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Error").getter(BatchUpdateDevicePositionError.getter(BatchUpdateDevicePositionError::error)).setter(BatchUpdateDevicePositionError.setter(Builder::error)).constructor(BatchItemError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error").build()}).build();
    private static final SdkField<Instant> SAMPLE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("SampleTime").getter(BatchUpdateDevicePositionError.getter(BatchUpdateDevicePositionError::sampleTime)).setter(BatchUpdateDevicePositionError.setter(Builder::sampleTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SampleTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_ID_FIELD, ERROR_FIELD, SAMPLE_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String deviceId;
    private final BatchItemError error;
    private final Instant sampleTime;

    private BatchUpdateDevicePositionError(BuilderImpl builder) {
        this.deviceId = builder.deviceId;
        this.error = builder.error;
        this.sampleTime = builder.sampleTime;
    }

    public final String deviceId() {
        return this.deviceId;
    }

    public final BatchItemError error() {
        return this.error;
    }

    public final Instant sampleTime() {
        return this.sampleTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.error());
        hashCode = 31 * hashCode + Objects.hashCode(this.sampleTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpdateDevicePositionError)) {
            return false;
        }
        BatchUpdateDevicePositionError other = (BatchUpdateDevicePositionError)obj;
        return Objects.equals(this.deviceId(), other.deviceId()) && Objects.equals(this.error(), other.error()) && Objects.equals(this.sampleTime(), other.sampleTime());
    }

    public final String toString() {
        return ToString.builder((String)"BatchUpdateDevicePositionError").add("DeviceId", (Object)this.deviceId()).add("Error", (Object)this.error()).add("SampleTime", (Object)this.sampleTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeviceId": {
                return Optional.ofNullable(clazz.cast(this.deviceId()));
            }
            case "Error": {
                return Optional.ofNullable(clazz.cast(this.error()));
            }
            case "SampleTime": {
                return Optional.ofNullable(clazz.cast(this.sampleTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchUpdateDevicePositionError, T> g) {
        return obj -> g.apply((BatchUpdateDevicePositionError)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String deviceId;
        private BatchItemError error;
        private Instant sampleTime;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchUpdateDevicePositionError model) {
            this.deviceId(model.deviceId);
            this.error(model.error);
            this.sampleTime(model.sampleTime);
        }

        public final String getDeviceId() {
            return this.deviceId;
        }

        public final void setDeviceId(String deviceId) {
            this.deviceId = deviceId;
        }

        @Override
        @Transient
        public final Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public final BatchItemError.Builder getError() {
            return this.error != null ? this.error.toBuilder() : null;
        }

        public final void setError(BatchItemError.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        @Transient
        public final Builder error(BatchItemError error) {
            this.error = error;
            return this;
        }

        public final Instant getSampleTime() {
            return this.sampleTime;
        }

        public final void setSampleTime(Instant sampleTime) {
            this.sampleTime = sampleTime;
        }

        @Override
        @Transient
        public final Builder sampleTime(Instant sampleTime) {
            this.sampleTime = sampleTime;
            return this;
        }

        public BatchUpdateDevicePositionError build() {
            return new BatchUpdateDevicePositionError(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BatchUpdateDevicePositionError> {
        public Builder deviceId(String var1);

        public Builder error(BatchItemError var1);

        default public Builder error(Consumer<BatchItemError.Builder> error) {
            return this.error((BatchItemError)((BatchItemError.Builder)BatchItemError.builder().applyMutation(error)).build());
        }

        public Builder sampleTime(Instant var1);
    }
}

