/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.location.model.BatchPutGeofenceRequestEntriesListCopier;
import software.amazon.awssdk.services.location.model.BatchPutGeofenceRequestEntry;
import software.amazon.awssdk.services.location.model.LocationRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchPutGeofenceRequest
extends LocationRequest
implements ToCopyableBuilder<Builder, BatchPutGeofenceRequest> {
    private static final SdkField<String> COLLECTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CollectionName").getter(BatchPutGeofenceRequest.getter(BatchPutGeofenceRequest::collectionName)).setter(BatchPutGeofenceRequest.setter(Builder::collectionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("CollectionName").build()}).build();
    private static final SdkField<List<BatchPutGeofenceRequestEntry>> ENTRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Entries").getter(BatchPutGeofenceRequest.getter(BatchPutGeofenceRequest::entries)).setter(BatchPutGeofenceRequest.setter(Builder::entries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Entries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchPutGeofenceRequestEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLLECTION_NAME_FIELD, ENTRIES_FIELD));
    private final String collectionName;
    private final List<BatchPutGeofenceRequestEntry> entries;

    private BatchPutGeofenceRequest(BuilderImpl builder) {
        super(builder);
        this.collectionName = builder.collectionName;
        this.entries = builder.entries;
    }

    public final String collectionName() {
        return this.collectionName;
    }

    public final boolean hasEntries() {
        return this.entries != null && !(this.entries instanceof SdkAutoConstructList);
    }

    public final List<BatchPutGeofenceRequestEntry> entries() {
        return this.entries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.collectionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEntries() ? this.entries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchPutGeofenceRequest)) {
            return false;
        }
        BatchPutGeofenceRequest other = (BatchPutGeofenceRequest)((Object)obj);
        return Objects.equals(this.collectionName(), other.collectionName()) && this.hasEntries() == other.hasEntries() && Objects.equals(this.entries(), other.entries());
    }

    public final String toString() {
        return ToString.builder((String)"BatchPutGeofenceRequest").add("CollectionName", (Object)this.collectionName()).add("Entries", this.hasEntries() ? this.entries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CollectionName": {
                return Optional.ofNullable(clazz.cast(this.collectionName()));
            }
            case "Entries": {
                return Optional.ofNullable(clazz.cast(this.entries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchPutGeofenceRequest, T> g) {
        return obj -> g.apply((BatchPutGeofenceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LocationRequest.BuilderImpl
    implements Builder {
        private String collectionName;
        private List<BatchPutGeofenceRequestEntry> entries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchPutGeofenceRequest model) {
            super(model);
            this.collectionName(model.collectionName);
            this.entries(model.entries);
        }

        public final String getCollectionName() {
            return this.collectionName;
        }

        public final void setCollectionName(String collectionName) {
            this.collectionName = collectionName;
        }

        @Override
        @Transient
        public final Builder collectionName(String collectionName) {
            this.collectionName = collectionName;
            return this;
        }

        public final List<BatchPutGeofenceRequestEntry.Builder> getEntries() {
            List<BatchPutGeofenceRequestEntry.Builder> result = BatchPutGeofenceRequestEntriesListCopier.copyToBuilder(this.entries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEntries(Collection<BatchPutGeofenceRequestEntry.BuilderImpl> entries) {
            this.entries = BatchPutGeofenceRequestEntriesListCopier.copyFromBuilder(entries);
        }

        @Override
        @Transient
        public final Builder entries(Collection<BatchPutGeofenceRequestEntry> entries) {
            this.entries = BatchPutGeofenceRequestEntriesListCopier.copy(entries);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder entries(BatchPutGeofenceRequestEntry ... entries) {
            this.entries(Arrays.asList(entries));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder entries(Consumer<BatchPutGeofenceRequestEntry.Builder> ... entries) {
            this.entries(Stream.of(entries).map(c -> (BatchPutGeofenceRequestEntry)((BatchPutGeofenceRequestEntry.Builder)BatchPutGeofenceRequestEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchPutGeofenceRequest build() {
            return new BatchPutGeofenceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LocationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchPutGeofenceRequest> {
        public Builder collectionName(String var1);

        public Builder entries(Collection<BatchPutGeofenceRequestEntry> var1);

        public Builder entries(BatchPutGeofenceRequestEntry ... var1);

        public Builder entries(Consumer<BatchPutGeofenceRequestEntry.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

