/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchPlaceIndexForPositionResponse extends LocationResponse implements
        ToCopyableBuilder<SearchPlaceIndexForPositionResponse.Builder, SearchPlaceIndexForPositionResponse> {
    private static final SdkField<List<SearchForPositionResult>> RESULTS_FIELD = SdkField
            .<List<SearchForPositionResult>> builder(MarshallingType.LIST)
            .memberName("Results")
            .getter(getter(SearchPlaceIndexForPositionResponse::results))
            .setter(setter(Builder::results))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Results").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SearchForPositionResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(SearchForPositionResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<SearchPlaceIndexForPositionSummary> SUMMARY_FIELD = SdkField
            .<SearchPlaceIndexForPositionSummary> builder(MarshallingType.SDK_POJO).memberName("Summary")
            .getter(getter(SearchPlaceIndexForPositionResponse::summary)).setter(setter(Builder::summary))
            .constructor(SearchPlaceIndexForPositionSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Summary").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESULTS_FIELD, SUMMARY_FIELD));

    private final List<SearchForPositionResult> results;

    private final SearchPlaceIndexForPositionSummary summary;

    private SearchPlaceIndexForPositionResponse(BuilderImpl builder) {
        super(builder);
        this.results = builder.results;
        this.summary = builder.summary;
    }

    /**
     * For responses, this returns true if the service returned a value for the Results property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasResults() {
        return results != null && !(results instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns a list of Places closest to the specified position. Each result contains additional information about the
     * Places returned.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResults} method.
     * </p>
     * 
     * @return Returns a list of Places closest to the specified position. Each result contains additional information
     *         about the Places returned.
     */
    public final List<SearchForPositionResult> results() {
        return results;
    }

    /**
     * <p>
     * Contains a summary of the request.
     * </p>
     * 
     * @return Contains a summary of the request.
     */
    public final SearchPlaceIndexForPositionSummary summary() {
        return summary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasResults() ? results() : null);
        hashCode = 31 * hashCode + Objects.hashCode(summary());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchPlaceIndexForPositionResponse)) {
            return false;
        }
        SearchPlaceIndexForPositionResponse other = (SearchPlaceIndexForPositionResponse) obj;
        return hasResults() == other.hasResults() && Objects.equals(results(), other.results())
                && Objects.equals(summary(), other.summary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchPlaceIndexForPositionResponse").add("Results", hasResults() ? results() : null)
                .add("Summary", summary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Results":
            return Optional.ofNullable(clazz.cast(results()));
        case "Summary":
            return Optional.ofNullable(clazz.cast(summary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchPlaceIndexForPositionResponse, T> g) {
        return obj -> g.apply((SearchPlaceIndexForPositionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LocationResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, SearchPlaceIndexForPositionResponse> {
        /**
         * <p>
         * Returns a list of Places closest to the specified position. Each result contains additional information about
         * the Places returned.
         * </p>
         * 
         * @param results
         *        Returns a list of Places closest to the specified position. Each result contains additional
         *        information about the Places returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder results(Collection<SearchForPositionResult> results);

        /**
         * <p>
         * Returns a list of Places closest to the specified position. Each result contains additional information about
         * the Places returned.
         * </p>
         * 
         * @param results
         *        Returns a list of Places closest to the specified position. Each result contains additional
         *        information about the Places returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder results(SearchForPositionResult... results);

        /**
         * <p>
         * Returns a list of Places closest to the specified position. Each result contains additional information about
         * the Places returned.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SearchForPositionResult>.Builder} avoiding
         * the need to create one manually via {@link List<SearchForPositionResult>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SearchForPositionResult>.Builder#build()} is called
         * immediately and its result is passed to {@link #results(List<SearchForPositionResult>)}.
         * 
         * @param results
         *        a consumer that will call methods on {@link List<SearchForPositionResult>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #results(List<SearchForPositionResult>)
         */
        Builder results(Consumer<SearchForPositionResult.Builder>... results);

        /**
         * <p>
         * Contains a summary of the request.
         * </p>
         * 
         * @param summary
         *        Contains a summary of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder summary(SearchPlaceIndexForPositionSummary summary);

        /**
         * <p>
         * Contains a summary of the request.
         * </p>
         * This is a convenience that creates an instance of the {@link SearchPlaceIndexForPositionSummary.Builder}
         * avoiding the need to create one manually via {@link SearchPlaceIndexForPositionSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link SearchPlaceIndexForPositionSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #summary(SearchPlaceIndexForPositionSummary)}.
         * 
         * @param summary
         *        a consumer that will call methods on {@link SearchPlaceIndexForPositionSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #summary(SearchPlaceIndexForPositionSummary)
         */
        default Builder summary(Consumer<SearchPlaceIndexForPositionSummary.Builder> summary) {
            return summary(SearchPlaceIndexForPositionSummary.builder().applyMutation(summary).build());
        }
    }

    static final class BuilderImpl extends LocationResponse.BuilderImpl implements Builder {
        private List<SearchForPositionResult> results = DefaultSdkAutoConstructList.getInstance();

        private SearchPlaceIndexForPositionSummary summary;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchPlaceIndexForPositionResponse model) {
            super(model);
            results(model.results);
            summary(model.summary);
        }

        public final List<SearchForPositionResult.Builder> getResults() {
            List<SearchForPositionResult.Builder> result = SearchForPositionResultListCopier.copyToBuilder(this.results);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResults(Collection<SearchForPositionResult.BuilderImpl> results) {
            this.results = SearchForPositionResultListCopier.copyFromBuilder(results);
        }

        @Override
        @Transient
        public final Builder results(Collection<SearchForPositionResult> results) {
            this.results = SearchForPositionResultListCopier.copy(results);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder results(SearchForPositionResult... results) {
            results(Arrays.asList(results));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder results(Consumer<SearchForPositionResult.Builder>... results) {
            results(Stream.of(results).map(c -> SearchForPositionResult.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final SearchPlaceIndexForPositionSummary.Builder getSummary() {
            return summary != null ? summary.toBuilder() : null;
        }

        public final void setSummary(SearchPlaceIndexForPositionSummary.BuilderImpl summary) {
            this.summary = summary != null ? summary.build() : null;
        }

        @Override
        @Transient
        public final Builder summary(SearchPlaceIndexForPositionSummary summary) {
            this.summary = summary;
            return this;
        }

        @Override
        public SearchPlaceIndexForPositionResponse build() {
            return new SearchPlaceIndexForPositionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
