/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about additional route preferences for requests that specify <code>TravelMode</code> as
 * <code>Truck</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CalculateRouteTruckModeOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<CalculateRouteTruckModeOptions.Builder, CalculateRouteTruckModeOptions> {
    private static final SdkField<Boolean> AVOID_FERRIES_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AvoidFerries").getter(getter(CalculateRouteTruckModeOptions::avoidFerries))
            .setter(setter(Builder::avoidFerries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvoidFerries").build()).build();

    private static final SdkField<Boolean> AVOID_TOLLS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AvoidTolls").getter(getter(CalculateRouteTruckModeOptions::avoidTolls))
            .setter(setter(Builder::avoidTolls))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvoidTolls").build()).build();

    private static final SdkField<TruckDimensions> DIMENSIONS_FIELD = SdkField
            .<TruckDimensions> builder(MarshallingType.SDK_POJO).memberName("Dimensions")
            .getter(getter(CalculateRouteTruckModeOptions::dimensions)).setter(setter(Builder::dimensions))
            .constructor(TruckDimensions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dimensions").build()).build();

    private static final SdkField<TruckWeight> WEIGHT_FIELD = SdkField.<TruckWeight> builder(MarshallingType.SDK_POJO)
            .memberName("Weight").getter(getter(CalculateRouteTruckModeOptions::weight)).setter(setter(Builder::weight))
            .constructor(TruckWeight::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Weight").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVOID_FERRIES_FIELD,
            AVOID_TOLLS_FIELD, DIMENSIONS_FIELD, WEIGHT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean avoidFerries;

    private final Boolean avoidTolls;

    private final TruckDimensions dimensions;

    private final TruckWeight weight;

    private CalculateRouteTruckModeOptions(BuilderImpl builder) {
        this.avoidFerries = builder.avoidFerries;
        this.avoidTolls = builder.avoidTolls;
        this.dimensions = builder.dimensions;
        this.weight = builder.weight;
    }

    /**
     * <p>
     * Avoids ferries when calculating routes.
     * </p>
     * <p>
     * Default Value: <code>false</code>
     * </p>
     * <p>
     * Valid Values: <code>false</code> | <code>true</code>
     * </p>
     * 
     * @return Avoids ferries when calculating routes.</p>
     *         <p>
     *         Default Value: <code>false</code>
     *         </p>
     *         <p>
     *         Valid Values: <code>false</code> | <code>true</code>
     */
    public final Boolean avoidFerries() {
        return avoidFerries;
    }

    /**
     * <p>
     * Avoids ferries when calculating routes.
     * </p>
     * <p>
     * Default Value: <code>false</code>
     * </p>
     * <p>
     * Valid Values: <code>false</code> | <code>true</code>
     * </p>
     * 
     * @return Avoids ferries when calculating routes.</p>
     *         <p>
     *         Default Value: <code>false</code>
     *         </p>
     *         <p>
     *         Valid Values: <code>false</code> | <code>true</code>
     */
    public final Boolean avoidTolls() {
        return avoidTolls;
    }

    /**
     * <p>
     * Specifies the truck's dimension specifications including length, height, width, and unit of measurement. Used to
     * avoid roads that can't support the truck's dimensions.
     * </p>
     * 
     * @return Specifies the truck's dimension specifications including length, height, width, and unit of measurement.
     *         Used to avoid roads that can't support the truck's dimensions.
     */
    public final TruckDimensions dimensions() {
        return dimensions;
    }

    /**
     * <p>
     * Specifies the truck's weight specifications including total weight and unit of measurement. Used to avoid roads
     * that can't support the truck's weight.
     * </p>
     * 
     * @return Specifies the truck's weight specifications including total weight and unit of measurement. Used to avoid
     *         roads that can't support the truck's weight.
     */
    public final TruckWeight weight() {
        return weight;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(avoidFerries());
        hashCode = 31 * hashCode + Objects.hashCode(avoidTolls());
        hashCode = 31 * hashCode + Objects.hashCode(dimensions());
        hashCode = 31 * hashCode + Objects.hashCode(weight());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CalculateRouteTruckModeOptions)) {
            return false;
        }
        CalculateRouteTruckModeOptions other = (CalculateRouteTruckModeOptions) obj;
        return Objects.equals(avoidFerries(), other.avoidFerries()) && Objects.equals(avoidTolls(), other.avoidTolls())
                && Objects.equals(dimensions(), other.dimensions()) && Objects.equals(weight(), other.weight());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CalculateRouteTruckModeOptions").add("AvoidFerries", avoidFerries())
                .add("AvoidTolls", avoidTolls()).add("Dimensions", dimensions()).add("Weight", weight()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AvoidFerries":
            return Optional.ofNullable(clazz.cast(avoidFerries()));
        case "AvoidTolls":
            return Optional.ofNullable(clazz.cast(avoidTolls()));
        case "Dimensions":
            return Optional.ofNullable(clazz.cast(dimensions()));
        case "Weight":
            return Optional.ofNullable(clazz.cast(weight()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CalculateRouteTruckModeOptions, T> g) {
        return obj -> g.apply((CalculateRouteTruckModeOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CalculateRouteTruckModeOptions> {
        /**
         * <p>
         * Avoids ferries when calculating routes.
         * </p>
         * <p>
         * Default Value: <code>false</code>
         * </p>
         * <p>
         * Valid Values: <code>false</code> | <code>true</code>
         * </p>
         * 
         * @param avoidFerries
         *        Avoids ferries when calculating routes.</p>
         *        <p>
         *        Default Value: <code>false</code>
         *        </p>
         *        <p>
         *        Valid Values: <code>false</code> | <code>true</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder avoidFerries(Boolean avoidFerries);

        /**
         * <p>
         * Avoids ferries when calculating routes.
         * </p>
         * <p>
         * Default Value: <code>false</code>
         * </p>
         * <p>
         * Valid Values: <code>false</code> | <code>true</code>
         * </p>
         * 
         * @param avoidTolls
         *        Avoids ferries when calculating routes.</p>
         *        <p>
         *        Default Value: <code>false</code>
         *        </p>
         *        <p>
         *        Valid Values: <code>false</code> | <code>true</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder avoidTolls(Boolean avoidTolls);

        /**
         * <p>
         * Specifies the truck's dimension specifications including length, height, width, and unit of measurement. Used
         * to avoid roads that can't support the truck's dimensions.
         * </p>
         * 
         * @param dimensions
         *        Specifies the truck's dimension specifications including length, height, width, and unit of
         *        measurement. Used to avoid roads that can't support the truck's dimensions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensions(TruckDimensions dimensions);

        /**
         * <p>
         * Specifies the truck's dimension specifications including length, height, width, and unit of measurement. Used
         * to avoid roads that can't support the truck's dimensions.
         * </p>
         * This is a convenience that creates an instance of the {@link TruckDimensions.Builder} avoiding the need to
         * create one manually via {@link TruckDimensions#builder()}.
         *
         * When the {@link Consumer} completes, {@link TruckDimensions.Builder#build()} is called immediately and its
         * result is passed to {@link #dimensions(TruckDimensions)}.
         * 
         * @param dimensions
         *        a consumer that will call methods on {@link TruckDimensions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dimensions(TruckDimensions)
         */
        default Builder dimensions(Consumer<TruckDimensions.Builder> dimensions) {
            return dimensions(TruckDimensions.builder().applyMutation(dimensions).build());
        }

        /**
         * <p>
         * Specifies the truck's weight specifications including total weight and unit of measurement. Used to avoid
         * roads that can't support the truck's weight.
         * </p>
         * 
         * @param weight
         *        Specifies the truck's weight specifications including total weight and unit of measurement. Used to
         *        avoid roads that can't support the truck's weight.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder weight(TruckWeight weight);

        /**
         * <p>
         * Specifies the truck's weight specifications including total weight and unit of measurement. Used to avoid
         * roads that can't support the truck's weight.
         * </p>
         * This is a convenience that creates an instance of the {@link TruckWeight.Builder} avoiding the need to create
         * one manually via {@link TruckWeight#builder()}.
         *
         * When the {@link Consumer} completes, {@link TruckWeight.Builder#build()} is called immediately and its result
         * is passed to {@link #weight(TruckWeight)}.
         * 
         * @param weight
         *        a consumer that will call methods on {@link TruckWeight.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #weight(TruckWeight)
         */
        default Builder weight(Consumer<TruckWeight.Builder> weight) {
            return weight(TruckWeight.builder().applyMutation(weight).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Boolean avoidFerries;

        private Boolean avoidTolls;

        private TruckDimensions dimensions;

        private TruckWeight weight;

        private BuilderImpl() {
        }

        private BuilderImpl(CalculateRouteTruckModeOptions model) {
            avoidFerries(model.avoidFerries);
            avoidTolls(model.avoidTolls);
            dimensions(model.dimensions);
            weight(model.weight);
        }

        public final Boolean getAvoidFerries() {
            return avoidFerries;
        }

        public final void setAvoidFerries(Boolean avoidFerries) {
            this.avoidFerries = avoidFerries;
        }

        @Override
        @Transient
        public final Builder avoidFerries(Boolean avoidFerries) {
            this.avoidFerries = avoidFerries;
            return this;
        }

        public final Boolean getAvoidTolls() {
            return avoidTolls;
        }

        public final void setAvoidTolls(Boolean avoidTolls) {
            this.avoidTolls = avoidTolls;
        }

        @Override
        @Transient
        public final Builder avoidTolls(Boolean avoidTolls) {
            this.avoidTolls = avoidTolls;
            return this;
        }

        public final TruckDimensions.Builder getDimensions() {
            return dimensions != null ? dimensions.toBuilder() : null;
        }

        public final void setDimensions(TruckDimensions.BuilderImpl dimensions) {
            this.dimensions = dimensions != null ? dimensions.build() : null;
        }

        @Override
        @Transient
        public final Builder dimensions(TruckDimensions dimensions) {
            this.dimensions = dimensions;
            return this;
        }

        public final TruckWeight.Builder getWeight() {
            return weight != null ? weight.toBuilder() : null;
        }

        public final void setWeight(TruckWeight.BuilderImpl weight) {
            this.weight = weight != null ? weight.build() : null;
        }

        @Override
        @Transient
        public final Builder weight(TruckWeight weight) {
            this.weight = weight;
            return this;
        }

        @Override
        public CalculateRouteTruckModeOptions build() {
            return new CalculateRouteTruckModeOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
