/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchUpdateDevicePositionRequest extends LocationRequest implements
        ToCopyableBuilder<BatchUpdateDevicePositionRequest.Builder, BatchUpdateDevicePositionRequest> {
    private static final SdkField<String> TRACKER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrackerName").getter(getter(BatchUpdateDevicePositionRequest::trackerName))
            .setter(setter(Builder::trackerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("TrackerName").build()).build();

    private static final SdkField<List<DevicePositionUpdate>> UPDATES_FIELD = SdkField
            .<List<DevicePositionUpdate>> builder(MarshallingType.LIST)
            .memberName("Updates")
            .getter(getter(BatchUpdateDevicePositionRequest::updates))
            .setter(setter(Builder::updates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Updates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DevicePositionUpdate> builder(MarshallingType.SDK_POJO)
                                            .constructor(DevicePositionUpdate::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRACKER_NAME_FIELD,
            UPDATES_FIELD));

    private final String trackerName;

    private final List<DevicePositionUpdate> updates;

    private BatchUpdateDevicePositionRequest(BuilderImpl builder) {
        super(builder);
        this.trackerName = builder.trackerName;
        this.updates = builder.updates;
    }

    /**
     * <p>
     * The name of the tracker resource to update.
     * </p>
     * 
     * @return The name of the tracker resource to update.
     */
    public final String trackerName() {
        return trackerName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Updates property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasUpdates() {
        return updates != null && !(updates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains the position update details for each device.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUpdates} method.
     * </p>
     * 
     * @return Contains the position update details for each device.
     */
    public final List<DevicePositionUpdate> updates() {
        return updates;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(trackerName());
        hashCode = 31 * hashCode + Objects.hashCode(hasUpdates() ? updates() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpdateDevicePositionRequest)) {
            return false;
        }
        BatchUpdateDevicePositionRequest other = (BatchUpdateDevicePositionRequest) obj;
        return Objects.equals(trackerName(), other.trackerName()) && hasUpdates() == other.hasUpdates()
                && Objects.equals(updates(), other.updates());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchUpdateDevicePositionRequest").add("TrackerName", trackerName())
                .add("Updates", hasUpdates() ? updates() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrackerName":
            return Optional.ofNullable(clazz.cast(trackerName()));
        case "Updates":
            return Optional.ofNullable(clazz.cast(updates()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchUpdateDevicePositionRequest, T> g) {
        return obj -> g.apply((BatchUpdateDevicePositionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LocationRequest.Builder, SdkPojo, CopyableBuilder<Builder, BatchUpdateDevicePositionRequest> {
        /**
         * <p>
         * The name of the tracker resource to update.
         * </p>
         * 
         * @param trackerName
         *        The name of the tracker resource to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trackerName(String trackerName);

        /**
         * <p>
         * Contains the position update details for each device.
         * </p>
         * 
         * @param updates
         *        Contains the position update details for each device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updates(Collection<DevicePositionUpdate> updates);

        /**
         * <p>
         * Contains the position update details for each device.
         * </p>
         * 
         * @param updates
         *        Contains the position update details for each device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updates(DevicePositionUpdate... updates);

        /**
         * <p>
         * Contains the position update details for each device.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DevicePositionUpdate>.Builder} avoiding the
         * need to create one manually via {@link List<DevicePositionUpdate>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DevicePositionUpdate>.Builder#build()} is called immediately
         * and its result is passed to {@link #updates(List<DevicePositionUpdate>)}.
         * 
         * @param updates
         *        a consumer that will call methods on {@link List<DevicePositionUpdate>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #updates(List<DevicePositionUpdate>)
         */
        Builder updates(Consumer<DevicePositionUpdate.Builder>... updates);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LocationRequest.BuilderImpl implements Builder {
        private String trackerName;

        private List<DevicePositionUpdate> updates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchUpdateDevicePositionRequest model) {
            super(model);
            trackerName(model.trackerName);
            updates(model.updates);
        }

        public final String getTrackerName() {
            return trackerName;
        }

        public final void setTrackerName(String trackerName) {
            this.trackerName = trackerName;
        }

        @Override
        @Transient
        public final Builder trackerName(String trackerName) {
            this.trackerName = trackerName;
            return this;
        }

        public final List<DevicePositionUpdate.Builder> getUpdates() {
            List<DevicePositionUpdate.Builder> result = BatchUpdateDevicePositionRequestUpdatesListCopier
                    .copyToBuilder(this.updates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUpdates(Collection<DevicePositionUpdate.BuilderImpl> updates) {
            this.updates = BatchUpdateDevicePositionRequestUpdatesListCopier.copyFromBuilder(updates);
        }

        @Override
        @Transient
        public final Builder updates(Collection<DevicePositionUpdate> updates) {
            this.updates = BatchUpdateDevicePositionRequestUpdatesListCopier.copy(updates);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder updates(DevicePositionUpdate... updates) {
            updates(Arrays.asList(updates));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder updates(Consumer<DevicePositionUpdate.Builder>... updates) {
            updates(Stream.of(updates).map(c -> DevicePositionUpdate.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchUpdateDevicePositionRequest build() {
            return new BatchUpdateDevicePositionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
