/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.location.model.AccessDeniedException;
import software.amazon.awssdk.services.location.model.AssociateTrackerConsumerRequest;
import software.amazon.awssdk.services.location.model.AssociateTrackerConsumerResponse;
import software.amazon.awssdk.services.location.model.BatchDeleteDevicePositionHistoryRequest;
import software.amazon.awssdk.services.location.model.BatchDeleteDevicePositionHistoryResponse;
import software.amazon.awssdk.services.location.model.BatchDeleteGeofenceRequest;
import software.amazon.awssdk.services.location.model.BatchDeleteGeofenceResponse;
import software.amazon.awssdk.services.location.model.BatchEvaluateGeofencesRequest;
import software.amazon.awssdk.services.location.model.BatchEvaluateGeofencesResponse;
import software.amazon.awssdk.services.location.model.BatchGetDevicePositionRequest;
import software.amazon.awssdk.services.location.model.BatchGetDevicePositionResponse;
import software.amazon.awssdk.services.location.model.BatchPutGeofenceRequest;
import software.amazon.awssdk.services.location.model.BatchPutGeofenceResponse;
import software.amazon.awssdk.services.location.model.BatchUpdateDevicePositionRequest;
import software.amazon.awssdk.services.location.model.BatchUpdateDevicePositionResponse;
import software.amazon.awssdk.services.location.model.CalculateRouteRequest;
import software.amazon.awssdk.services.location.model.CalculateRouteResponse;
import software.amazon.awssdk.services.location.model.ConflictException;
import software.amazon.awssdk.services.location.model.CreateGeofenceCollectionRequest;
import software.amazon.awssdk.services.location.model.CreateGeofenceCollectionResponse;
import software.amazon.awssdk.services.location.model.CreateMapRequest;
import software.amazon.awssdk.services.location.model.CreateMapResponse;
import software.amazon.awssdk.services.location.model.CreatePlaceIndexRequest;
import software.amazon.awssdk.services.location.model.CreatePlaceIndexResponse;
import software.amazon.awssdk.services.location.model.CreateRouteCalculatorRequest;
import software.amazon.awssdk.services.location.model.CreateRouteCalculatorResponse;
import software.amazon.awssdk.services.location.model.CreateTrackerRequest;
import software.amazon.awssdk.services.location.model.CreateTrackerResponse;
import software.amazon.awssdk.services.location.model.DeleteGeofenceCollectionRequest;
import software.amazon.awssdk.services.location.model.DeleteGeofenceCollectionResponse;
import software.amazon.awssdk.services.location.model.DeleteMapRequest;
import software.amazon.awssdk.services.location.model.DeleteMapResponse;
import software.amazon.awssdk.services.location.model.DeletePlaceIndexRequest;
import software.amazon.awssdk.services.location.model.DeletePlaceIndexResponse;
import software.amazon.awssdk.services.location.model.DeleteRouteCalculatorRequest;
import software.amazon.awssdk.services.location.model.DeleteRouteCalculatorResponse;
import software.amazon.awssdk.services.location.model.DeleteTrackerRequest;
import software.amazon.awssdk.services.location.model.DeleteTrackerResponse;
import software.amazon.awssdk.services.location.model.DescribeGeofenceCollectionRequest;
import software.amazon.awssdk.services.location.model.DescribeGeofenceCollectionResponse;
import software.amazon.awssdk.services.location.model.DescribeMapRequest;
import software.amazon.awssdk.services.location.model.DescribeMapResponse;
import software.amazon.awssdk.services.location.model.DescribePlaceIndexRequest;
import software.amazon.awssdk.services.location.model.DescribePlaceIndexResponse;
import software.amazon.awssdk.services.location.model.DescribeRouteCalculatorRequest;
import software.amazon.awssdk.services.location.model.DescribeRouteCalculatorResponse;
import software.amazon.awssdk.services.location.model.DescribeTrackerRequest;
import software.amazon.awssdk.services.location.model.DescribeTrackerResponse;
import software.amazon.awssdk.services.location.model.DisassociateTrackerConsumerRequest;
import software.amazon.awssdk.services.location.model.DisassociateTrackerConsumerResponse;
import software.amazon.awssdk.services.location.model.GetDevicePositionHistoryRequest;
import software.amazon.awssdk.services.location.model.GetDevicePositionHistoryResponse;
import software.amazon.awssdk.services.location.model.GetDevicePositionRequest;
import software.amazon.awssdk.services.location.model.GetDevicePositionResponse;
import software.amazon.awssdk.services.location.model.GetGeofenceRequest;
import software.amazon.awssdk.services.location.model.GetGeofenceResponse;
import software.amazon.awssdk.services.location.model.GetMapGlyphsRequest;
import software.amazon.awssdk.services.location.model.GetMapGlyphsResponse;
import software.amazon.awssdk.services.location.model.GetMapSpritesRequest;
import software.amazon.awssdk.services.location.model.GetMapSpritesResponse;
import software.amazon.awssdk.services.location.model.GetMapStyleDescriptorRequest;
import software.amazon.awssdk.services.location.model.GetMapStyleDescriptorResponse;
import software.amazon.awssdk.services.location.model.GetMapTileRequest;
import software.amazon.awssdk.services.location.model.GetMapTileResponse;
import software.amazon.awssdk.services.location.model.InternalServerException;
import software.amazon.awssdk.services.location.model.ListDevicePositionsRequest;
import software.amazon.awssdk.services.location.model.ListDevicePositionsResponse;
import software.amazon.awssdk.services.location.model.ListGeofenceCollectionsRequest;
import software.amazon.awssdk.services.location.model.ListGeofenceCollectionsResponse;
import software.amazon.awssdk.services.location.model.ListGeofencesRequest;
import software.amazon.awssdk.services.location.model.ListGeofencesResponse;
import software.amazon.awssdk.services.location.model.ListMapsRequest;
import software.amazon.awssdk.services.location.model.ListMapsResponse;
import software.amazon.awssdk.services.location.model.ListPlaceIndexesRequest;
import software.amazon.awssdk.services.location.model.ListPlaceIndexesResponse;
import software.amazon.awssdk.services.location.model.ListRouteCalculatorsRequest;
import software.amazon.awssdk.services.location.model.ListRouteCalculatorsResponse;
import software.amazon.awssdk.services.location.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.location.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.location.model.ListTrackerConsumersRequest;
import software.amazon.awssdk.services.location.model.ListTrackerConsumersResponse;
import software.amazon.awssdk.services.location.model.ListTrackersRequest;
import software.amazon.awssdk.services.location.model.ListTrackersResponse;
import software.amazon.awssdk.services.location.model.LocationException;
import software.amazon.awssdk.services.location.model.PutGeofenceRequest;
import software.amazon.awssdk.services.location.model.PutGeofenceResponse;
import software.amazon.awssdk.services.location.model.ResourceNotFoundException;
import software.amazon.awssdk.services.location.model.SearchPlaceIndexForPositionRequest;
import software.amazon.awssdk.services.location.model.SearchPlaceIndexForPositionResponse;
import software.amazon.awssdk.services.location.model.SearchPlaceIndexForTextRequest;
import software.amazon.awssdk.services.location.model.SearchPlaceIndexForTextResponse;
import software.amazon.awssdk.services.location.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.location.model.TagResourceRequest;
import software.amazon.awssdk.services.location.model.TagResourceResponse;
import software.amazon.awssdk.services.location.model.ThrottlingException;
import software.amazon.awssdk.services.location.model.UntagResourceRequest;
import software.amazon.awssdk.services.location.model.UntagResourceResponse;
import software.amazon.awssdk.services.location.model.UpdateGeofenceCollectionRequest;
import software.amazon.awssdk.services.location.model.UpdateGeofenceCollectionResponse;
import software.amazon.awssdk.services.location.model.UpdateMapRequest;
import software.amazon.awssdk.services.location.model.UpdateMapResponse;
import software.amazon.awssdk.services.location.model.UpdatePlaceIndexRequest;
import software.amazon.awssdk.services.location.model.UpdatePlaceIndexResponse;
import software.amazon.awssdk.services.location.model.UpdateRouteCalculatorRequest;
import software.amazon.awssdk.services.location.model.UpdateRouteCalculatorResponse;
import software.amazon.awssdk.services.location.model.UpdateTrackerRequest;
import software.amazon.awssdk.services.location.model.UpdateTrackerResponse;
import software.amazon.awssdk.services.location.model.ValidationException;
import software.amazon.awssdk.services.location.paginators.GetDevicePositionHistoryIterable;
import software.amazon.awssdk.services.location.paginators.ListDevicePositionsIterable;
import software.amazon.awssdk.services.location.paginators.ListGeofenceCollectionsIterable;
import software.amazon.awssdk.services.location.paginators.ListGeofencesIterable;
import software.amazon.awssdk.services.location.paginators.ListMapsIterable;
import software.amazon.awssdk.services.location.paginators.ListPlaceIndexesIterable;
import software.amazon.awssdk.services.location.paginators.ListRouteCalculatorsIterable;
import software.amazon.awssdk.services.location.paginators.ListTrackerConsumersIterable;
import software.amazon.awssdk.services.location.paginators.ListTrackersIterable;

/**
 * Service client for accessing Amazon Location Service. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * Suite of geospatial services including Maps, Places, Routes, Tracking, and Geofencing
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface LocationClient extends SdkClient {
    String SERVICE_NAME = "geo";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "geo";

    /**
     * Create a {@link LocationClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static LocationClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link LocationClient}.
     */
    static LocationClientBuilder builder() {
        return new DefaultLocationClientBuilder();
    }

    /**
     * <p>
     * Creates an association between a geofence collection and a tracker resource. This allows the tracker resource to
     * communicate location data to the linked geofence collection.
     * </p>
     * <p>
     * You can associate up to five geofence collections to each tracker resource.
     * </p>
     * <note>
     * <p>
     * Currently not supported — Cross-account configurations, such as creating associations between a tracker resource
     * in one account and a geofence collection in another account.
     * </p>
     * </note>
     *
     * @param associateTrackerConsumerRequest
     * @return Result of the AssociateTrackerConsumer operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ResourceNotFoundException
     *         The resource that you've entered was not found in your AWS account.
     * @throws ConflictException
     *         The request was unsuccessful because of a conflict.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ServiceQuotaExceededException
     *         The operation was denied because the request would exceed the maximum <a
     *         href="https://docs.aws.amazon.com/location/latest/developerguide/location-quotas.html">quota</a> set for
     *         Amazon Location Service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.AssociateTrackerConsumer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/AssociateTrackerConsumer"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateTrackerConsumerResponse associateTrackerConsumer(
            AssociateTrackerConsumerRequest associateTrackerConsumerRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, AccessDeniedException, ValidationException,
            ServiceQuotaExceededException, ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an association between a geofence collection and a tracker resource. This allows the tracker resource to
     * communicate location data to the linked geofence collection.
     * </p>
     * <p>
     * You can associate up to five geofence collections to each tracker resource.
     * </p>
     * <note>
     * <p>
     * Currently not supported — Cross-account configurations, such as creating associations between a tracker resource
     * in one account and a geofence collection in another account.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateTrackerConsumerRequest.Builder} avoiding
     * the need to create one manually via {@link AssociateTrackerConsumerRequest#builder()}
     * </p>
     *
     * @param associateTrackerConsumerRequest
     *        A {@link Consumer} that will call methods on {@link AssociateTrackerConsumerRequest.Builder} to create a
     *        request.
     * @return Result of the AssociateTrackerConsumer operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ResourceNotFoundException
     *         The resource that you've entered was not found in your AWS account.
     * @throws ConflictException
     *         The request was unsuccessful because of a conflict.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ServiceQuotaExceededException
     *         The operation was denied because the request would exceed the maximum <a
     *         href="https://docs.aws.amazon.com/location/latest/developerguide/location-quotas.html">quota</a> set for
     *         Amazon Location Service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.AssociateTrackerConsumer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/AssociateTrackerConsumer"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateTrackerConsumerResponse associateTrackerConsumer(
            Consumer<AssociateTrackerConsumerRequest.Builder> associateTrackerConsumerRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, AccessDeniedException, ValidationException,
            ServiceQuotaExceededException, ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        return associateTrackerConsumer(AssociateTrackerConsumerRequest.builder().applyMutation(associateTrackerConsumerRequest)
                .build());
    }

    /**
     * <p>
     * Deletes the position history of one or more devices from a tracker resource.
     * </p>
     *
     * @param batchDeleteDevicePositionHistoryRequest
     * @return Result of the BatchDeleteDevicePositionHistory operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ResourceNotFoundException
     *         The resource that you've entered was not found in your AWS account.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.BatchDeleteDevicePositionHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/BatchDeleteDevicePositionHistory"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchDeleteDevicePositionHistoryResponse batchDeleteDevicePositionHistory(
            BatchDeleteDevicePositionHistoryRequest batchDeleteDevicePositionHistoryRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException,
            SdkClientException, LocationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the position history of one or more devices from a tracker resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDeleteDevicePositionHistoryRequest.Builder}
     * avoiding the need to create one manually via {@link BatchDeleteDevicePositionHistoryRequest#builder()}
     * </p>
     *
     * @param batchDeleteDevicePositionHistoryRequest
     *        A {@link Consumer} that will call methods on {@link BatchDeleteDevicePositionHistoryRequest.Builder} to
     *        create a request.
     * @return Result of the BatchDeleteDevicePositionHistory operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ResourceNotFoundException
     *         The resource that you've entered was not found in your AWS account.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.BatchDeleteDevicePositionHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/BatchDeleteDevicePositionHistory"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchDeleteDevicePositionHistoryResponse batchDeleteDevicePositionHistory(
            Consumer<BatchDeleteDevicePositionHistoryRequest.Builder> batchDeleteDevicePositionHistoryRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException,
            ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        return batchDeleteDevicePositionHistory(BatchDeleteDevicePositionHistoryRequest.builder()
                .applyMutation(batchDeleteDevicePositionHistoryRequest).build());
    }

    /**
     * <p>
     * Deletes a batch of geofences from a geofence collection.
     * </p>
     * <note>
     * <p>
     * This operation deletes the resource permanently.
     * </p>
     * </note>
     *
     * @param batchDeleteGeofenceRequest
     * @return Result of the BatchDeleteGeofence operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ResourceNotFoundException
     *         The resource that you've entered was not found in your AWS account.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.BatchDeleteGeofence
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/BatchDeleteGeofence" target="_top">AWS
     *      API Documentation</a>
     */
    default BatchDeleteGeofenceResponse batchDeleteGeofence(BatchDeleteGeofenceRequest batchDeleteGeofenceRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException,
            ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a batch of geofences from a geofence collection.
     * </p>
     * <note>
     * <p>
     * This operation deletes the resource permanently.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDeleteGeofenceRequest.Builder} avoiding the
     * need to create one manually via {@link BatchDeleteGeofenceRequest#builder()}
     * </p>
     *
     * @param batchDeleteGeofenceRequest
     *        A {@link Consumer} that will call methods on {@link BatchDeleteGeofenceRequest.Builder} to create a
     *        request.
     * @return Result of the BatchDeleteGeofence operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ResourceNotFoundException
     *         The resource that you've entered was not found in your AWS account.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.BatchDeleteGeofence
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/BatchDeleteGeofence" target="_top">AWS
     *      API Documentation</a>
     */
    default BatchDeleteGeofenceResponse batchDeleteGeofence(
            Consumer<BatchDeleteGeofenceRequest.Builder> batchDeleteGeofenceRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException,
            SdkClientException, LocationException {
        return batchDeleteGeofence(BatchDeleteGeofenceRequest.builder().applyMutation(batchDeleteGeofenceRequest).build());
    }

    /**
     * <p>
     * Evaluates device positions against the geofence geometries from a given geofence collection.
     * </p>
     * <p>
     * This operation always returns an empty response because geofences are asynchronously evaluated. The evaluation
     * determines if the device has entered or exited a geofenced area, and then publishes one of the following events
     * to Amazon EventBridge:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ENTER</code> if Amazon Location determines that the tracked device has entered a geofenced area.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EXIT</code> if Amazon Location determines that the tracked device has exited a geofenced area.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * The last geofence that a device was observed within is tracked for 30 days after the most recent device position
     * update.
     * </p>
     * </note>
     *
     * @param batchEvaluateGeofencesRequest
     * @return Result of the BatchEvaluateGeofences operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ResourceNotFoundException
     *         The resource that you've entered was not found in your AWS account.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.BatchEvaluateGeofences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/BatchEvaluateGeofences"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchEvaluateGeofencesResponse batchEvaluateGeofences(BatchEvaluateGeofencesRequest batchEvaluateGeofencesRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException,
            ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Evaluates device positions against the geofence geometries from a given geofence collection.
     * </p>
     * <p>
     * This operation always returns an empty response because geofences are asynchronously evaluated. The evaluation
     * determines if the device has entered or exited a geofenced area, and then publishes one of the following events
     * to Amazon EventBridge:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ENTER</code> if Amazon Location determines that the tracked device has entered a geofenced area.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EXIT</code> if Amazon Location determines that the tracked device has exited a geofenced area.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * The last geofence that a device was observed within is tracked for 30 days after the most recent device position
     * update.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchEvaluateGeofencesRequest.Builder} avoiding the
     * need to create one manually via {@link BatchEvaluateGeofencesRequest#builder()}
     * </p>
     *
     * @param batchEvaluateGeofencesRequest
     *        A {@link Consumer} that will call methods on {@link BatchEvaluateGeofencesRequest.Builder} to create a
     *        request.
     * @return Result of the BatchEvaluateGeofences operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ResourceNotFoundException
     *         The resource that you've entered was not found in your AWS account.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.BatchEvaluateGeofences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/BatchEvaluateGeofences"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchEvaluateGeofencesResponse batchEvaluateGeofences(
            Consumer<BatchEvaluateGeofencesRequest.Builder> batchEvaluateGeofencesRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException,
            SdkClientException, LocationException {
        return batchEvaluateGeofences(BatchEvaluateGeofencesRequest.builder().applyMutation(batchEvaluateGeofencesRequest)
                .build());
    }

    /**
     * <p>
     * Lists the latest device positions for requested devices.
     * </p>
     *
     * @param batchGetDevicePositionRequest
     * @return Result of the BatchGetDevicePosition operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ResourceNotFoundException
     *         The resource that you've entered was not found in your AWS account.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.BatchGetDevicePosition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/BatchGetDevicePosition"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetDevicePositionResponse batchGetDevicePosition(BatchGetDevicePositionRequest batchGetDevicePositionRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException,
            ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the latest device positions for requested devices.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetDevicePositionRequest.Builder} avoiding the
     * need to create one manually via {@link BatchGetDevicePositionRequest#builder()}
     * </p>
     *
     * @param batchGetDevicePositionRequest
     *        A {@link Consumer} that will call methods on {@link BatchGetDevicePositionRequest.Builder} to create a
     *        request.
     * @return Result of the BatchGetDevicePosition operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ResourceNotFoundException
     *         The resource that you've entered was not found in your AWS account.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.BatchGetDevicePosition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/BatchGetDevicePosition"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetDevicePositionResponse batchGetDevicePosition(
            Consumer<BatchGetDevicePositionRequest.Builder> batchGetDevicePositionRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException,
            SdkClientException, LocationException {
        return batchGetDevicePosition(BatchGetDevicePositionRequest.builder().applyMutation(batchGetDevicePositionRequest)
                .build());
    }

    /**
     * <p>
     * A batch request for storing geofence geometries into a given geofence collection, or updates the geometry of an
     * existing geofence if a geofence ID is included in the request.
     * </p>
     *
     * @param batchPutGeofenceRequest
     * @return Result of the BatchPutGeofence operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ResourceNotFoundException
     *         The resource that you've entered was not found in your AWS account.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.BatchPutGeofence
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/BatchPutGeofence" target="_top">AWS API
     *      Documentation</a>
     */
    default BatchPutGeofenceResponse batchPutGeofence(BatchPutGeofenceRequest batchPutGeofenceRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException,
            ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * A batch request for storing geofence geometries into a given geofence collection, or updates the geometry of an
     * existing geofence if a geofence ID is included in the request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchPutGeofenceRequest.Builder} avoiding the need
     * to create one manually via {@link BatchPutGeofenceRequest#builder()}
     * </p>
     *
     * @param batchPutGeofenceRequest
     *        A {@link Consumer} that will call methods on {@link BatchPutGeofenceRequest.Builder} to create a request.
     * @return Result of the BatchPutGeofence operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ResourceNotFoundException
     *         The resource that you've entered was not found in your AWS account.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.BatchPutGeofence
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/BatchPutGeofence" target="_top">AWS API
     *      Documentation</a>
     */
    default BatchPutGeofenceResponse batchPutGeofence(Consumer<BatchPutGeofenceRequest.Builder> batchPutGeofenceRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException,
            ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        return batchPutGeofence(BatchPutGeofenceRequest.builder().applyMutation(batchPutGeofenceRequest).build());
    }

    /**
     * <p>
     * Uploads position update data for one or more devices to a tracker resource. Amazon Location uses the data when
     * reporting the last known device position and position history.
     * </p>
     * <note>
     * <p>
     * Only one position update is stored per sample time. Location data is sampled at a fixed rate of one position per
     * 30-second interval and retained for 30 days before it's deleted.
     * </p>
     * </note>
     *
     * @param batchUpdateDevicePositionRequest
     * @return Result of the BatchUpdateDevicePosition operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ResourceNotFoundException
     *         The resource that you've entered was not found in your AWS account.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.BatchUpdateDevicePosition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/BatchUpdateDevicePosition"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchUpdateDevicePositionResponse batchUpdateDevicePosition(
            BatchUpdateDevicePositionRequest batchUpdateDevicePositionRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException,
            SdkClientException, LocationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Uploads position update data for one or more devices to a tracker resource. Amazon Location uses the data when
     * reporting the last known device position and position history.
     * </p>
     * <note>
     * <p>
     * Only one position update is stored per sample time. Location data is sampled at a fixed rate of one position per
     * 30-second interval and retained for 30 days before it's deleted.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchUpdateDevicePositionRequest.Builder} avoiding
     * the need to create one manually via {@link BatchUpdateDevicePositionRequest#builder()}
     * </p>
     *
     * @param batchUpdateDevicePositionRequest
     *        A {@link Consumer} that will call methods on {@link BatchUpdateDevicePositionRequest.Builder} to create a
     *        request.
     * @return Result of the BatchUpdateDevicePosition operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ResourceNotFoundException
     *         The resource that you've entered was not found in your AWS account.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.BatchUpdateDevicePosition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/BatchUpdateDevicePosition"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchUpdateDevicePositionResponse batchUpdateDevicePosition(
            Consumer<BatchUpdateDevicePositionRequest.Builder> batchUpdateDevicePositionRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException,
            SdkClientException, LocationException {
        return batchUpdateDevicePosition(BatchUpdateDevicePositionRequest.builder()
                .applyMutation(batchUpdateDevicePositionRequest).build());
    }

    /**
     * <p>
     * <a href="https://docs.aws.amazon.com/location/latest/developerguide/calculate-route.html">Calculates a route</a>
     * given the following required parameters: <code>DeparturePostiton</code> and <code>DestinationPosition</code>.
     * Requires that you first <a
     * href="https://docs.aws.amazon.com/location-routes/latest/APIReference/API_CreateRouteCalculator.html">create a
     * route calculator resource</a>
     * </p>
     * <p>
     * By default, a request that doesn't specify a departure time uses the best time of day to travel with the best
     * traffic conditions when calculating the route.
     * </p>
     * <p>
     * Additional options include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/location/latest/developerguide/calculate-route.html#departure-time">
     * Specifying a departure time</a> using either <code>DepartureTime</code> or <code>DepartureNow</code>. This
     * calculates a route based on predictive traffic data at the given time.
     * </p>
     * <note>
     * <p>
     * You can't specify both <code>DepartureTime</code> and <code>DepartureNow</code> in a single request. Specifying
     * both parameters returns an error message.
     * </p>
     * </note></li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/location/latest/developerguide/calculate-route.html#travel-mode">Specifying
     * a travel mode</a> using TravelMode. This lets you specify an additional route preference such as
     * <code>CarModeOptions</code> if traveling by <code>Car</code>, or <code>TruckModeOptions</code> if traveling by
     * <code>Truck</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * </p>
     *
     * @param calculateRouteRequest
     * @return Result of the CalculateRoute operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ResourceNotFoundException
     *         The resource that you've entered was not found in your AWS account.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.CalculateRoute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/CalculateRoute" target="_top">AWS API
     *      Documentation</a>
     */
    default CalculateRouteResponse calculateRoute(CalculateRouteRequest calculateRouteRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException,
            SdkClientException, LocationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * <a href="https://docs.aws.amazon.com/location/latest/developerguide/calculate-route.html">Calculates a route</a>
     * given the following required parameters: <code>DeparturePostiton</code> and <code>DestinationPosition</code>.
     * Requires that you first <a
     * href="https://docs.aws.amazon.com/location-routes/latest/APIReference/API_CreateRouteCalculator.html">create a
     * route calculator resource</a>
     * </p>
     * <p>
     * By default, a request that doesn't specify a departure time uses the best time of day to travel with the best
     * traffic conditions when calculating the route.
     * </p>
     * <p>
     * Additional options include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/location/latest/developerguide/calculate-route.html#departure-time">
     * Specifying a departure time</a> using either <code>DepartureTime</code> or <code>DepartureNow</code>. This
     * calculates a route based on predictive traffic data at the given time.
     * </p>
     * <note>
     * <p>
     * You can't specify both <code>DepartureTime</code> and <code>DepartureNow</code> in a single request. Specifying
     * both parameters returns an error message.
     * </p>
     * </note></li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/location/latest/developerguide/calculate-route.html#travel-mode">Specifying
     * a travel mode</a> using TravelMode. This lets you specify an additional route preference such as
     * <code>CarModeOptions</code> if traveling by <code>Car</code>, or <code>TruckModeOptions</code> if traveling by
     * <code>Truck</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CalculateRouteRequest.Builder} avoiding the need to
     * create one manually via {@link CalculateRouteRequest#builder()}
     * </p>
     *
     * @param calculateRouteRequest
     *        A {@link Consumer} that will call methods on {@link CalculateRouteRequest.Builder} to create a request.
     * @return Result of the CalculateRoute operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ResourceNotFoundException
     *         The resource that you've entered was not found in your AWS account.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.CalculateRoute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/CalculateRoute" target="_top">AWS API
     *      Documentation</a>
     */
    default CalculateRouteResponse calculateRoute(Consumer<CalculateRouteRequest.Builder> calculateRouteRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException,
            ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        return calculateRoute(CalculateRouteRequest.builder().applyMutation(calculateRouteRequest).build());
    }

    /**
     * <p>
     * Creates a geofence collection, which manages and stores geofences.
     * </p>
     *
     * @param createGeofenceCollectionRequest
     * @return Result of the CreateGeofenceCollection operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ConflictException
     *         The request was unsuccessful because of a conflict.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.CreateGeofenceCollection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/CreateGeofenceCollection"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateGeofenceCollectionResponse createGeofenceCollection(
            CreateGeofenceCollectionRequest createGeofenceCollectionRequest) throws InternalServerException, ConflictException,
            AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException,
            LocationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a geofence collection, which manages and stores geofences.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateGeofenceCollectionRequest.Builder} avoiding
     * the need to create one manually via {@link CreateGeofenceCollectionRequest#builder()}
     * </p>
     *
     * @param createGeofenceCollectionRequest
     *        A {@link Consumer} that will call methods on {@link CreateGeofenceCollectionRequest.Builder} to create a
     *        request.
     * @return Result of the CreateGeofenceCollection operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ConflictException
     *         The request was unsuccessful because of a conflict.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.CreateGeofenceCollection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/CreateGeofenceCollection"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateGeofenceCollectionResponse createGeofenceCollection(
            Consumer<CreateGeofenceCollectionRequest.Builder> createGeofenceCollectionRequest) throws InternalServerException,
            ConflictException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException,
            SdkClientException, LocationException {
        return createGeofenceCollection(CreateGeofenceCollectionRequest.builder().applyMutation(createGeofenceCollectionRequest)
                .build());
    }

    /**
     * <p>
     * Creates a map resource in your AWS account, which provides map tiles of different styles sourced from global
     * location data providers.
     * </p>
     *
     * @param createMapRequest
     * @return Result of the CreateMap operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ConflictException
     *         The request was unsuccessful because of a conflict.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.CreateMap
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/CreateMap" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateMapResponse createMap(CreateMapRequest createMapRequest) throws InternalServerException, ConflictException,
            AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException,
            LocationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a map resource in your AWS account, which provides map tiles of different styles sourced from global
     * location data providers.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateMapRequest.Builder} avoiding the need to
     * create one manually via {@link CreateMapRequest#builder()}
     * </p>
     *
     * @param createMapRequest
     *        A {@link Consumer} that will call methods on {@link CreateMapRequest.Builder} to create a request.
     * @return Result of the CreateMap operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ConflictException
     *         The request was unsuccessful because of a conflict.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.CreateMap
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/CreateMap" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateMapResponse createMap(Consumer<CreateMapRequest.Builder> createMapRequest) throws InternalServerException,
            ConflictException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException,
            SdkClientException, LocationException {
        return createMap(CreateMapRequest.builder().applyMutation(createMapRequest).build());
    }

    /**
     * <p>
     * Creates a place index resource in your AWS account, which supports functions with geospatial data sourced from
     * your chosen data provider.
     * </p>
     *
     * @param createPlaceIndexRequest
     * @return Result of the CreatePlaceIndex operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ConflictException
     *         The request was unsuccessful because of a conflict.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.CreatePlaceIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/CreatePlaceIndex" target="_top">AWS API
     *      Documentation</a>
     */
    default CreatePlaceIndexResponse createPlaceIndex(CreatePlaceIndexRequest createPlaceIndexRequest)
            throws InternalServerException, ConflictException, AccessDeniedException, ValidationException, ThrottlingException,
            AwsServiceException, SdkClientException, LocationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a place index resource in your AWS account, which supports functions with geospatial data sourced from
     * your chosen data provider.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePlaceIndexRequest.Builder} avoiding the need
     * to create one manually via {@link CreatePlaceIndexRequest#builder()}
     * </p>
     *
     * @param createPlaceIndexRequest
     *        A {@link Consumer} that will call methods on {@link CreatePlaceIndexRequest.Builder} to create a request.
     * @return Result of the CreatePlaceIndex operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ConflictException
     *         The request was unsuccessful because of a conflict.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.CreatePlaceIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/CreatePlaceIndex" target="_top">AWS API
     *      Documentation</a>
     */
    default CreatePlaceIndexResponse createPlaceIndex(Consumer<CreatePlaceIndexRequest.Builder> createPlaceIndexRequest)
            throws InternalServerException, ConflictException, AccessDeniedException, ValidationException, ThrottlingException,
            AwsServiceException, SdkClientException, LocationException {
        return createPlaceIndex(CreatePlaceIndexRequest.builder().applyMutation(createPlaceIndexRequest).build());
    }

    /**
     * <p>
     * Creates a route calculator resource in your AWS account.
     * </p>
     * <p>
     * You can send requests to a route calculator resource to estimate travel time, distance, and get directions. A
     * route calculator sources traffic and road network data from your chosen data provider.
     * </p>
     *
     * @param createRouteCalculatorRequest
     * @return Result of the CreateRouteCalculator operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ConflictException
     *         The request was unsuccessful because of a conflict.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.CreateRouteCalculator
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/CreateRouteCalculator"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateRouteCalculatorResponse createRouteCalculator(CreateRouteCalculatorRequest createRouteCalculatorRequest)
            throws InternalServerException, ConflictException, AccessDeniedException, ValidationException, ThrottlingException,
            AwsServiceException, SdkClientException, LocationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a route calculator resource in your AWS account.
     * </p>
     * <p>
     * You can send requests to a route calculator resource to estimate travel time, distance, and get directions. A
     * route calculator sources traffic and road network data from your chosen data provider.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRouteCalculatorRequest.Builder} avoiding the
     * need to create one manually via {@link CreateRouteCalculatorRequest#builder()}
     * </p>
     *
     * @param createRouteCalculatorRequest
     *        A {@link Consumer} that will call methods on {@link CreateRouteCalculatorRequest.Builder} to create a
     *        request.
     * @return Result of the CreateRouteCalculator operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ConflictException
     *         The request was unsuccessful because of a conflict.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.CreateRouteCalculator
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/CreateRouteCalculator"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateRouteCalculatorResponse createRouteCalculator(
            Consumer<CreateRouteCalculatorRequest.Builder> createRouteCalculatorRequest) throws InternalServerException,
            ConflictException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException,
            SdkClientException, LocationException {
        return createRouteCalculator(CreateRouteCalculatorRequest.builder().applyMutation(createRouteCalculatorRequest).build());
    }

    /**
     * <p>
     * Creates a tracker resource in your AWS account, which lets you retrieve current and historical location of
     * devices.
     * </p>
     *
     * @param createTrackerRequest
     * @return Result of the CreateTracker operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ConflictException
     *         The request was unsuccessful because of a conflict.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.CreateTracker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/CreateTracker" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateTrackerResponse createTracker(CreateTrackerRequest createTrackerRequest) throws InternalServerException,
            ConflictException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException,
            SdkClientException, LocationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a tracker resource in your AWS account, which lets you retrieve current and historical location of
     * devices.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTrackerRequest.Builder} avoiding the need to
     * create one manually via {@link CreateTrackerRequest#builder()}
     * </p>
     *
     * @param createTrackerRequest
     *        A {@link Consumer} that will call methods on {@link CreateTrackerRequest.Builder} to create a request.
     * @return Result of the CreateTracker operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ConflictException
     *         The request was unsuccessful because of a conflict.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.CreateTracker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/CreateTracker" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateTrackerResponse createTracker(Consumer<CreateTrackerRequest.Builder> createTrackerRequest)
            throws InternalServerException, ConflictException, AccessDeniedException, ValidationException, ThrottlingException,
            AwsServiceException, SdkClientException, LocationException {
        return createTracker(CreateTrackerRequest.builder().applyMutation(createTrackerRequest).build());
    }

    /**
     * <p>
     * Deletes a geofence collection from your AWS account.
     * </p>
     * <note>
     * <p>
     * This operation deletes the resource permanently. If the geofence collection is the target of a tracker resource,
     * the devices will no longer be monitored.
     * </p>
     * </note>
     *
     * @param deleteGeofenceCollectionRequest
     * @return Result of the DeleteGeofenceCollection operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ResourceNotFoundException
     *         The resource that you've entered was not found in your AWS account.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.DeleteGeofenceCollection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/DeleteGeofenceCollection"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteGeofenceCollectionResponse deleteGeofenceCollection(
            DeleteGeofenceCollectionRequest deleteGeofenceCollectionRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException,
            SdkClientException, LocationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a geofence collection from your AWS account.
     * </p>
     * <note>
     * <p>
     * This operation deletes the resource permanently. If the geofence collection is the target of a tracker resource,
     * the devices will no longer be monitored.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteGeofenceCollectionRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteGeofenceCollectionRequest#builder()}
     * </p>
     *
     * @param deleteGeofenceCollectionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteGeofenceCollectionRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteGeofenceCollection operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ResourceNotFoundException
     *         The resource that you've entered was not found in your AWS account.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.DeleteGeofenceCollection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/DeleteGeofenceCollection"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteGeofenceCollectionResponse deleteGeofenceCollection(
            Consumer<DeleteGeofenceCollectionRequest.Builder> deleteGeofenceCollectionRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException,
            SdkClientException, LocationException {
        return deleteGeofenceCollection(DeleteGeofenceCollectionRequest.builder().applyMutation(deleteGeofenceCollectionRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a map resource from your AWS account.
     * </p>
     * <note>
     * <p>
     * This operation deletes the resource permanently. If the map is being used in an application, the map may not
     * render.
     * </p>
     * </note>
     *
     * @param deleteMapRequest
     * @return Result of the DeleteMap operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ResourceNotFoundException
     *         The resource that you've entered was not found in your AWS account.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.DeleteMap
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/DeleteMap" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteMapResponse deleteMap(DeleteMapRequest deleteMapRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException,
            SdkClientException, LocationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a map resource from your AWS account.
     * </p>
     * <note>
     * <p>
     * This operation deletes the resource permanently. If the map is being used in an application, the map may not
     * render.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteMapRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteMapRequest#builder()}
     * </p>
     *
     * @param deleteMapRequest
     *        A {@link Consumer} that will call methods on {@link DeleteMapRequest.Builder} to create a request.
     * @return Result of the DeleteMap operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ResourceNotFoundException
     *         The resource that you've entered was not found in your AWS account.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.DeleteMap
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/DeleteMap" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteMapResponse deleteMap(Consumer<DeleteMapRequest.Builder> deleteMapRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException,
            SdkClientException, LocationException {
        return deleteMap(DeleteMapRequest.builder().applyMutation(deleteMapRequest).build());
    }

    /**
     * <p>
     * Deletes a place index resource from your AWS account.
     * </p>
     * <note>
     * <p>
     * This operation deletes the resource permanently.
     * </p>
     * </note>
     *
     * @param deletePlaceIndexRequest
     * @return Result of the DeletePlaceIndex operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ResourceNotFoundException
     *         The resource that you've entered was not found in your AWS account.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.DeletePlaceIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/DeletePlaceIndex" target="_top">AWS API
     *      Documentation</a>
     */
    default DeletePlaceIndexResponse deletePlaceIndex(DeletePlaceIndexRequest deletePlaceIndexRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException,
            ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a place index resource from your AWS account.
     * </p>
     * <note>
     * <p>
     * This operation deletes the resource permanently.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePlaceIndexRequest.Builder} avoiding the need
     * to create one manually via {@link DeletePlaceIndexRequest#builder()}
     * </p>
     *
     * @param deletePlaceIndexRequest
     *        A {@link Consumer} that will call methods on {@link DeletePlaceIndexRequest.Builder} to create a request.
     * @return Result of the DeletePlaceIndex operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ResourceNotFoundException
     *         The resource that you've entered was not found in your AWS account.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.DeletePlaceIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/DeletePlaceIndex" target="_top">AWS API
     *      Documentation</a>
     */
    default DeletePlaceIndexResponse deletePlaceIndex(Consumer<DeletePlaceIndexRequest.Builder> deletePlaceIndexRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException,
            ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        return deletePlaceIndex(DeletePlaceIndexRequest.builder().applyMutation(deletePlaceIndexRequest).build());
    }

    /**
     * <p>
     * Deletes a route calculator resource from your AWS account.
     * </p>
     * <note>
     * <p>
     * This operation deletes the resource permanently.
     * </p>
     * </note>
     *
     * @param deleteRouteCalculatorRequest
     * @return Result of the DeleteRouteCalculator operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ResourceNotFoundException
     *         The resource that you've entered was not found in your AWS account.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.DeleteRouteCalculator
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/DeleteRouteCalculator"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteRouteCalculatorResponse deleteRouteCalculator(DeleteRouteCalculatorRequest deleteRouteCalculatorRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException,
            ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a route calculator resource from your AWS account.
     * </p>
     * <note>
     * <p>
     * This operation deletes the resource permanently.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRouteCalculatorRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteRouteCalculatorRequest#builder()}
     * </p>
     *
     * @param deleteRouteCalculatorRequest
     *        A {@link Consumer} that will call methods on {@link DeleteRouteCalculatorRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteRouteCalculator operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ResourceNotFoundException
     *         The resource that you've entered was not found in your AWS account.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.DeleteRouteCalculator
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/DeleteRouteCalculator"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteRouteCalculatorResponse deleteRouteCalculator(
            Consumer<DeleteRouteCalculatorRequest.Builder> deleteRouteCalculatorRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException,
            SdkClientException, LocationException {
        return deleteRouteCalculator(DeleteRouteCalculatorRequest.builder().applyMutation(deleteRouteCalculatorRequest).build());
    }

    /**
     * <p>
     * Deletes a tracker resource from your AWS account.
     * </p>
     * <note>
     * <p>
     * This operation deletes the resource permanently. If the tracker resource is in use, you may encounter an error.
     * Make sure that the target resource isn't a dependency for your applications.
     * </p>
     * </note>
     *
     * @param deleteTrackerRequest
     * @return Result of the DeleteTracker operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ResourceNotFoundException
     *         The resource that you've entered was not found in your AWS account.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.DeleteTracker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/DeleteTracker" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteTrackerResponse deleteTracker(DeleteTrackerRequest deleteTrackerRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException,
            SdkClientException, LocationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a tracker resource from your AWS account.
     * </p>
     * <note>
     * <p>
     * This operation deletes the resource permanently. If the tracker resource is in use, you may encounter an error.
     * Make sure that the target resource isn't a dependency for your applications.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTrackerRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteTrackerRequest#builder()}
     * </p>
     *
     * @param deleteTrackerRequest
     *        A {@link Consumer} that will call methods on {@link DeleteTrackerRequest.Builder} to create a request.
     * @return Result of the DeleteTracker operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ResourceNotFoundException
     *         The resource that you've entered was not found in your AWS account.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.DeleteTracker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/DeleteTracker" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteTrackerResponse deleteTracker(Consumer<DeleteTrackerRequest.Builder> deleteTrackerRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException,
            ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        return deleteTracker(DeleteTrackerRequest.builder().applyMutation(deleteTrackerRequest).build());
    }

    /**
     * <p>
     * Retrieves the geofence collection details.
     * </p>
     *
     * @param describeGeofenceCollectionRequest
     * @return Result of the DescribeGeofenceCollection operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ResourceNotFoundException
     *         The resource that you've entered was not found in your AWS account.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.DescribeGeofenceCollection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/DescribeGeofenceCollection"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeGeofenceCollectionResponse describeGeofenceCollection(
            DescribeGeofenceCollectionRequest describeGeofenceCollectionRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException,
            SdkClientException, LocationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the geofence collection details.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeGeofenceCollectionRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeGeofenceCollectionRequest#builder()}
     * </p>
     *
     * @param describeGeofenceCollectionRequest
     *        A {@link Consumer} that will call methods on {@link DescribeGeofenceCollectionRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeGeofenceCollection operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ResourceNotFoundException
     *         The resource that you've entered was not found in your AWS account.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.DescribeGeofenceCollection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/DescribeGeofenceCollection"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeGeofenceCollectionResponse describeGeofenceCollection(
            Consumer<DescribeGeofenceCollectionRequest.Builder> describeGeofenceCollectionRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException,
            ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        return describeGeofenceCollection(DescribeGeofenceCollectionRequest.builder()
                .applyMutation(describeGeofenceCollectionRequest).build());
    }

    /**
     * <p>
     * Retrieves the map resource details.
     * </p>
     *
     * @param describeMapRequest
     * @return Result of the DescribeMap operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ResourceNotFoundException
     *         The resource that you've entered was not found in your AWS account.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.DescribeMap
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/DescribeMap" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeMapResponse describeMap(DescribeMapRequest describeMapRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException,
            SdkClientException, LocationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the map resource details.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeMapRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeMapRequest#builder()}
     * </p>
     *
     * @param describeMapRequest
     *        A {@link Consumer} that will call methods on {@link DescribeMapRequest.Builder} to create a request.
     * @return Result of the DescribeMap operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ResourceNotFoundException
     *         The resource that you've entered was not found in your AWS account.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.DescribeMap
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/DescribeMap" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeMapResponse describeMap(Consumer<DescribeMapRequest.Builder> describeMapRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException,
            ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        return describeMap(DescribeMapRequest.builder().applyMutation(describeMapRequest).build());
    }

    /**
     * <p>
     * Retrieves the place index resource details.
     * </p>
     *
     * @param describePlaceIndexRequest
     * @return Result of the DescribePlaceIndex operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ResourceNotFoundException
     *         The resource that you've entered was not found in your AWS account.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.DescribePlaceIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/DescribePlaceIndex" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribePlaceIndexResponse describePlaceIndex(DescribePlaceIndexRequest describePlaceIndexRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException,
            ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the place index resource details.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePlaceIndexRequest.Builder} avoiding the
     * need to create one manually via {@link DescribePlaceIndexRequest#builder()}
     * </p>
     *
     * @param describePlaceIndexRequest
     *        A {@link Consumer} that will call methods on {@link DescribePlaceIndexRequest.Builder} to create a
     *        request.
     * @return Result of the DescribePlaceIndex operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ResourceNotFoundException
     *         The resource that you've entered was not found in your AWS account.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.DescribePlaceIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/DescribePlaceIndex" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribePlaceIndexResponse describePlaceIndex(Consumer<DescribePlaceIndexRequest.Builder> describePlaceIndexRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException,
            ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        return describePlaceIndex(DescribePlaceIndexRequest.builder().applyMutation(describePlaceIndexRequest).build());
    }

    /**
     * <p>
     * Retrieves the route calculator resource details.
     * </p>
     *
     * @param describeRouteCalculatorRequest
     * @return Result of the DescribeRouteCalculator operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ResourceNotFoundException
     *         The resource that you've entered was not found in your AWS account.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.DescribeRouteCalculator
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/DescribeRouteCalculator"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRouteCalculatorResponse describeRouteCalculator(DescribeRouteCalculatorRequest describeRouteCalculatorRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException,
            ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the route calculator resource details.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRouteCalculatorRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeRouteCalculatorRequest#builder()}
     * </p>
     *
     * @param describeRouteCalculatorRequest
     *        A {@link Consumer} that will call methods on {@link DescribeRouteCalculatorRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeRouteCalculator operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ResourceNotFoundException
     *         The resource that you've entered was not found in your AWS account.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.DescribeRouteCalculator
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/DescribeRouteCalculator"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRouteCalculatorResponse describeRouteCalculator(
            Consumer<DescribeRouteCalculatorRequest.Builder> describeRouteCalculatorRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException,
            SdkClientException, LocationException {
        return describeRouteCalculator(DescribeRouteCalculatorRequest.builder().applyMutation(describeRouteCalculatorRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves the tracker resource details.
     * </p>
     *
     * @param describeTrackerRequest
     * @return Result of the DescribeTracker operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ResourceNotFoundException
     *         The resource that you've entered was not found in your AWS account.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.DescribeTracker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/DescribeTracker" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeTrackerResponse describeTracker(DescribeTrackerRequest describeTrackerRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException,
            ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the tracker resource details.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTrackerRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeTrackerRequest#builder()}
     * </p>
     *
     * @param describeTrackerRequest
     *        A {@link Consumer} that will call methods on {@link DescribeTrackerRequest.Builder} to create a request.
     * @return Result of the DescribeTracker operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ResourceNotFoundException
     *         The resource that you've entered was not found in your AWS account.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.DescribeTracker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/DescribeTracker" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeTrackerResponse describeTracker(Consumer<DescribeTrackerRequest.Builder> describeTrackerRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException,
            ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        return describeTracker(DescribeTrackerRequest.builder().applyMutation(describeTrackerRequest).build());
    }

    /**
     * <p>
     * Removes the association between a tracker resource and a geofence collection.
     * </p>
     * <note>
     * <p>
     * Once you unlink a tracker resource from a geofence collection, the tracker positions will no longer be
     * automatically evaluated against geofences.
     * </p>
     * </note>
     *
     * @param disassociateTrackerConsumerRequest
     * @return Result of the DisassociateTrackerConsumer operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ResourceNotFoundException
     *         The resource that you've entered was not found in your AWS account.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.DisassociateTrackerConsumer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/DisassociateTrackerConsumer"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateTrackerConsumerResponse disassociateTrackerConsumer(
            DisassociateTrackerConsumerRequest disassociateTrackerConsumerRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException,
            SdkClientException, LocationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the association between a tracker resource and a geofence collection.
     * </p>
     * <note>
     * <p>
     * Once you unlink a tracker resource from a geofence collection, the tracker positions will no longer be
     * automatically evaluated against geofences.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateTrackerConsumerRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateTrackerConsumerRequest#builder()}
     * </p>
     *
     * @param disassociateTrackerConsumerRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateTrackerConsumerRequest.Builder} to create
     *        a request.
     * @return Result of the DisassociateTrackerConsumer operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ResourceNotFoundException
     *         The resource that you've entered was not found in your AWS account.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.DisassociateTrackerConsumer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/DisassociateTrackerConsumer"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateTrackerConsumerResponse disassociateTrackerConsumer(
            Consumer<DisassociateTrackerConsumerRequest.Builder> disassociateTrackerConsumerRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException,
            ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        return disassociateTrackerConsumer(DisassociateTrackerConsumerRequest.builder()
                .applyMutation(disassociateTrackerConsumerRequest).build());
    }

    /**
     * <p>
     * Retrieves a device's most recent position according to its sample time.
     * </p>
     * <note>
     * <p>
     * Device positions are deleted after 30 days.
     * </p>
     * </note>
     *
     * @param getDevicePositionRequest
     * @return Result of the GetDevicePosition operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ResourceNotFoundException
     *         The resource that you've entered was not found in your AWS account.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.GetDevicePosition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/GetDevicePosition" target="_top">AWS
     *      API Documentation</a>
     */
    default GetDevicePositionResponse getDevicePosition(GetDevicePositionRequest getDevicePositionRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException,
            ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a device's most recent position according to its sample time.
     * </p>
     * <note>
     * <p>
     * Device positions are deleted after 30 days.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDevicePositionRequest.Builder} avoiding the need
     * to create one manually via {@link GetDevicePositionRequest#builder()}
     * </p>
     *
     * @param getDevicePositionRequest
     *        A {@link Consumer} that will call methods on {@link GetDevicePositionRequest.Builder} to create a request.
     * @return Result of the GetDevicePosition operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ResourceNotFoundException
     *         The resource that you've entered was not found in your AWS account.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.GetDevicePosition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/GetDevicePosition" target="_top">AWS
     *      API Documentation</a>
     */
    default GetDevicePositionResponse getDevicePosition(Consumer<GetDevicePositionRequest.Builder> getDevicePositionRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException,
            ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        return getDevicePosition(GetDevicePositionRequest.builder().applyMutation(getDevicePositionRequest).build());
    }

    /**
     * <p>
     * Retrieves the device position history from a tracker resource within a specified range of time.
     * </p>
     * <note>
     * <p>
     * Device positions are deleted after 30 days.
     * </p>
     * </note>
     *
     * @param getDevicePositionHistoryRequest
     * @return Result of the GetDevicePositionHistory operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ResourceNotFoundException
     *         The resource that you've entered was not found in your AWS account.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.GetDevicePositionHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/GetDevicePositionHistory"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDevicePositionHistoryResponse getDevicePositionHistory(
            GetDevicePositionHistoryRequest getDevicePositionHistoryRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException,
            SdkClientException, LocationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the device position history from a tracker resource within a specified range of time.
     * </p>
     * <note>
     * <p>
     * Device positions are deleted after 30 days.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDevicePositionHistoryRequest.Builder} avoiding
     * the need to create one manually via {@link GetDevicePositionHistoryRequest#builder()}
     * </p>
     *
     * @param getDevicePositionHistoryRequest
     *        A {@link Consumer} that will call methods on {@link GetDevicePositionHistoryRequest.Builder} to create a
     *        request.
     * @return Result of the GetDevicePositionHistory operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ResourceNotFoundException
     *         The resource that you've entered was not found in your AWS account.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.GetDevicePositionHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/GetDevicePositionHistory"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDevicePositionHistoryResponse getDevicePositionHistory(
            Consumer<GetDevicePositionHistoryRequest.Builder> getDevicePositionHistoryRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException,
            SdkClientException, LocationException {
        return getDevicePositionHistory(GetDevicePositionHistoryRequest.builder().applyMutation(getDevicePositionHistoryRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves the device position history from a tracker resource within a specified range of time.
     * </p>
     * <note>
     * <p>
     * Device positions are deleted after 30 days.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #getDevicePositionHistory(software.amazon.awssdk.services.location.model.GetDevicePositionHistoryRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.location.paginators.GetDevicePositionHistoryIterable responses = client.getDevicePositionHistoryPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.location.paginators.GetDevicePositionHistoryIterable responses = client
     *             .getDevicePositionHistoryPaginator(request);
     *     for (software.amazon.awssdk.services.location.model.GetDevicePositionHistoryResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.location.paginators.GetDevicePositionHistoryIterable responses = client.getDevicePositionHistoryPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getDevicePositionHistory(software.amazon.awssdk.services.location.model.GetDevicePositionHistoryRequest)}
     * operation.</b>
     * </p>
     *
     * @param getDevicePositionHistoryRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ResourceNotFoundException
     *         The resource that you've entered was not found in your AWS account.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.GetDevicePositionHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/GetDevicePositionHistory"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDevicePositionHistoryIterable getDevicePositionHistoryPaginator(
            GetDevicePositionHistoryRequest getDevicePositionHistoryRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException,
            SdkClientException, LocationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the device position history from a tracker resource within a specified range of time.
     * </p>
     * <note>
     * <p>
     * Device positions are deleted after 30 days.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #getDevicePositionHistory(software.amazon.awssdk.services.location.model.GetDevicePositionHistoryRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.location.paginators.GetDevicePositionHistoryIterable responses = client.getDevicePositionHistoryPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.location.paginators.GetDevicePositionHistoryIterable responses = client
     *             .getDevicePositionHistoryPaginator(request);
     *     for (software.amazon.awssdk.services.location.model.GetDevicePositionHistoryResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.location.paginators.GetDevicePositionHistoryIterable responses = client.getDevicePositionHistoryPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getDevicePositionHistory(software.amazon.awssdk.services.location.model.GetDevicePositionHistoryRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDevicePositionHistoryRequest.Builder} avoiding
     * the need to create one manually via {@link GetDevicePositionHistoryRequest#builder()}
     * </p>
     *
     * @param getDevicePositionHistoryRequest
     *        A {@link Consumer} that will call methods on {@link GetDevicePositionHistoryRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ResourceNotFoundException
     *         The resource that you've entered was not found in your AWS account.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.GetDevicePositionHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/GetDevicePositionHistory"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDevicePositionHistoryIterable getDevicePositionHistoryPaginator(
            Consumer<GetDevicePositionHistoryRequest.Builder> getDevicePositionHistoryRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException,
            SdkClientException, LocationException {
        return getDevicePositionHistoryPaginator(GetDevicePositionHistoryRequest.builder()
                .applyMutation(getDevicePositionHistoryRequest).build());
    }

    /**
     * <p>
     * Retrieves the geofence details from a geofence collection.
     * </p>
     *
     * @param getGeofenceRequest
     * @return Result of the GetGeofence operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ResourceNotFoundException
     *         The resource that you've entered was not found in your AWS account.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.GetGeofence
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/GetGeofence" target="_top">AWS API
     *      Documentation</a>
     */
    default GetGeofenceResponse getGeofence(GetGeofenceRequest getGeofenceRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException,
            SdkClientException, LocationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the geofence details from a geofence collection.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetGeofenceRequest.Builder} avoiding the need to
     * create one manually via {@link GetGeofenceRequest#builder()}
     * </p>
     *
     * @param getGeofenceRequest
     *        A {@link Consumer} that will call methods on {@link GetGeofenceRequest.Builder} to create a request.
     * @return Result of the GetGeofence operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ResourceNotFoundException
     *         The resource that you've entered was not found in your AWS account.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.GetGeofence
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/GetGeofence" target="_top">AWS API
     *      Documentation</a>
     */
    default GetGeofenceResponse getGeofence(Consumer<GetGeofenceRequest.Builder> getGeofenceRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException,
            ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        return getGeofence(GetGeofenceRequest.builder().applyMutation(getGeofenceRequest).build());
    }

    /**
     * <p>
     * Retrieves glyphs used to display labels on a map.
     * </p>
     *
     * @param getMapGlyphsRequest
     * @return Result of the GetMapGlyphs operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ResourceNotFoundException
     *         The resource that you've entered was not found in your AWS account.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.GetMapGlyphs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/GetMapGlyphs" target="_top">AWS API
     *      Documentation</a>
     */
    default GetMapGlyphsResponse getMapGlyphs(GetMapGlyphsRequest getMapGlyphsRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException,
            SdkClientException, LocationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves glyphs used to display labels on a map.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMapGlyphsRequest.Builder} avoiding the need to
     * create one manually via {@link GetMapGlyphsRequest#builder()}
     * </p>
     *
     * @param getMapGlyphsRequest
     *        A {@link Consumer} that will call methods on {@link GetMapGlyphsRequest.Builder} to create a request.
     * @return Result of the GetMapGlyphs operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ResourceNotFoundException
     *         The resource that you've entered was not found in your AWS account.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.GetMapGlyphs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/GetMapGlyphs" target="_top">AWS API
     *      Documentation</a>
     */
    default GetMapGlyphsResponse getMapGlyphs(Consumer<GetMapGlyphsRequest.Builder> getMapGlyphsRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException,
            ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        return getMapGlyphs(GetMapGlyphsRequest.builder().applyMutation(getMapGlyphsRequest).build());
    }

    /**
     * <p>
     * Retrieves the sprite sheet corresponding to a map resource. The sprite sheet is a PNG image paired with a JSON
     * document describing the offsets of individual icons that will be displayed on a rendered map.
     * </p>
     *
     * @param getMapSpritesRequest
     * @return Result of the GetMapSprites operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ResourceNotFoundException
     *         The resource that you've entered was not found in your AWS account.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.GetMapSprites
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/GetMapSprites" target="_top">AWS API
     *      Documentation</a>
     */
    default GetMapSpritesResponse getMapSprites(GetMapSpritesRequest getMapSpritesRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException,
            SdkClientException, LocationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the sprite sheet corresponding to a map resource. The sprite sheet is a PNG image paired with a JSON
     * document describing the offsets of individual icons that will be displayed on a rendered map.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMapSpritesRequest.Builder} avoiding the need to
     * create one manually via {@link GetMapSpritesRequest#builder()}
     * </p>
     *
     * @param getMapSpritesRequest
     *        A {@link Consumer} that will call methods on {@link GetMapSpritesRequest.Builder} to create a request.
     * @return Result of the GetMapSprites operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ResourceNotFoundException
     *         The resource that you've entered was not found in your AWS account.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.GetMapSprites
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/GetMapSprites" target="_top">AWS API
     *      Documentation</a>
     */
    default GetMapSpritesResponse getMapSprites(Consumer<GetMapSpritesRequest.Builder> getMapSpritesRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException,
            ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        return getMapSprites(GetMapSpritesRequest.builder().applyMutation(getMapSpritesRequest).build());
    }

    /**
     * <p>
     * Retrieves the map style descriptor from a map resource.
     * </p>
     * <p>
     * The style descriptor contains speciﬁcations on how features render on a map. For example, what data to display,
     * what order to display the data in, and the style for the data. Style descriptors follow the Mapbox Style
     * Specification.
     * </p>
     *
     * @param getMapStyleDescriptorRequest
     * @return Result of the GetMapStyleDescriptor operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ResourceNotFoundException
     *         The resource that you've entered was not found in your AWS account.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.GetMapStyleDescriptor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/GetMapStyleDescriptor"
     *      target="_top">AWS API Documentation</a>
     */
    default GetMapStyleDescriptorResponse getMapStyleDescriptor(GetMapStyleDescriptorRequest getMapStyleDescriptorRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException,
            ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the map style descriptor from a map resource.
     * </p>
     * <p>
     * The style descriptor contains speciﬁcations on how features render on a map. For example, what data to display,
     * what order to display the data in, and the style for the data. Style descriptors follow the Mapbox Style
     * Specification.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMapStyleDescriptorRequest.Builder} avoiding the
     * need to create one manually via {@link GetMapStyleDescriptorRequest#builder()}
     * </p>
     *
     * @param getMapStyleDescriptorRequest
     *        A {@link Consumer} that will call methods on {@link GetMapStyleDescriptorRequest.Builder} to create a
     *        request.
     * @return Result of the GetMapStyleDescriptor operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ResourceNotFoundException
     *         The resource that you've entered was not found in your AWS account.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.GetMapStyleDescriptor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/GetMapStyleDescriptor"
     *      target="_top">AWS API Documentation</a>
     */
    default GetMapStyleDescriptorResponse getMapStyleDescriptor(
            Consumer<GetMapStyleDescriptorRequest.Builder> getMapStyleDescriptorRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException,
            SdkClientException, LocationException {
        return getMapStyleDescriptor(GetMapStyleDescriptorRequest.builder().applyMutation(getMapStyleDescriptorRequest).build());
    }

    /**
     * <p>
     * Retrieves a vector data tile from the map resource. Map tiles are used by clients to render a map. they're
     * addressed using a grid arrangement with an X coordinate, Y coordinate, and Z (zoom) level.
     * </p>
     * <p>
     * The origin (0, 0) is the top left of the map. Increasing the zoom level by 1 doubles both the X and Y dimensions,
     * so a tile containing data for the entire world at (0/0/0) will be split into 4 tiles at zoom 1 (1/0/0, 1/0/1,
     * 1/1/0, 1/1/1).
     * </p>
     *
     * @param getMapTileRequest
     * @return Result of the GetMapTile operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ResourceNotFoundException
     *         The resource that you've entered was not found in your AWS account.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.GetMapTile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/GetMapTile" target="_top">AWS API
     *      Documentation</a>
     */
    default GetMapTileResponse getMapTile(GetMapTileRequest getMapTileRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException,
            SdkClientException, LocationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a vector data tile from the map resource. Map tiles are used by clients to render a map. they're
     * addressed using a grid arrangement with an X coordinate, Y coordinate, and Z (zoom) level.
     * </p>
     * <p>
     * The origin (0, 0) is the top left of the map. Increasing the zoom level by 1 doubles both the X and Y dimensions,
     * so a tile containing data for the entire world at (0/0/0) will be split into 4 tiles at zoom 1 (1/0/0, 1/0/1,
     * 1/1/0, 1/1/1).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMapTileRequest.Builder} avoiding the need to
     * create one manually via {@link GetMapTileRequest#builder()}
     * </p>
     *
     * @param getMapTileRequest
     *        A {@link Consumer} that will call methods on {@link GetMapTileRequest.Builder} to create a request.
     * @return Result of the GetMapTile operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ResourceNotFoundException
     *         The resource that you've entered was not found in your AWS account.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.GetMapTile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/GetMapTile" target="_top">AWS API
     *      Documentation</a>
     */
    default GetMapTileResponse getMapTile(Consumer<GetMapTileRequest.Builder> getMapTileRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException,
            SdkClientException, LocationException {
        return getMapTile(GetMapTileRequest.builder().applyMutation(getMapTileRequest).build());
    }

    /**
     * <p>
     * A batch request to retrieve all device positions.
     * </p>
     *
     * @param listDevicePositionsRequest
     * @return Result of the ListDevicePositions operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.ListDevicePositions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListDevicePositions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDevicePositionsResponse listDevicePositions(ListDevicePositionsRequest listDevicePositionsRequest)
            throws InternalServerException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException,
            SdkClientException, LocationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * A batch request to retrieve all device positions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDevicePositionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDevicePositionsRequest#builder()}
     * </p>
     *
     * @param listDevicePositionsRequest
     *        A {@link Consumer} that will call methods on {@link ListDevicePositionsRequest.Builder} to create a
     *        request.
     * @return Result of the ListDevicePositions operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.ListDevicePositions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListDevicePositions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDevicePositionsResponse listDevicePositions(
            Consumer<ListDevicePositionsRequest.Builder> listDevicePositionsRequest) throws InternalServerException,
            AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException,
            LocationException {
        return listDevicePositions(ListDevicePositionsRequest.builder().applyMutation(listDevicePositionsRequest).build());
    }

    /**
     * <p>
     * A batch request to retrieve all device positions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDevicePositions(software.amazon.awssdk.services.location.model.ListDevicePositionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.location.paginators.ListDevicePositionsIterable responses = client.listDevicePositionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.location.paginators.ListDevicePositionsIterable responses = client
     *             .listDevicePositionsPaginator(request);
     *     for (software.amazon.awssdk.services.location.model.ListDevicePositionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.location.paginators.ListDevicePositionsIterable responses = client.listDevicePositionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDevicePositions(software.amazon.awssdk.services.location.model.ListDevicePositionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDevicePositionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.ListDevicePositions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListDevicePositions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDevicePositionsIterable listDevicePositionsPaginator(ListDevicePositionsRequest listDevicePositionsRequest)
            throws InternalServerException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException,
            SdkClientException, LocationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * A batch request to retrieve all device positions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDevicePositions(software.amazon.awssdk.services.location.model.ListDevicePositionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.location.paginators.ListDevicePositionsIterable responses = client.listDevicePositionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.location.paginators.ListDevicePositionsIterable responses = client
     *             .listDevicePositionsPaginator(request);
     *     for (software.amazon.awssdk.services.location.model.ListDevicePositionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.location.paginators.ListDevicePositionsIterable responses = client.listDevicePositionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDevicePositions(software.amazon.awssdk.services.location.model.ListDevicePositionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDevicePositionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDevicePositionsRequest#builder()}
     * </p>
     *
     * @param listDevicePositionsRequest
     *        A {@link Consumer} that will call methods on {@link ListDevicePositionsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.ListDevicePositions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListDevicePositions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDevicePositionsIterable listDevicePositionsPaginator(
            Consumer<ListDevicePositionsRequest.Builder> listDevicePositionsRequest) throws InternalServerException,
            AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException,
            LocationException {
        return listDevicePositionsPaginator(ListDevicePositionsRequest.builder().applyMutation(listDevicePositionsRequest)
                .build());
    }

    /**
     * <p>
     * Lists geofence collections in your AWS account.
     * </p>
     *
     * @param listGeofenceCollectionsRequest
     * @return Result of the ListGeofenceCollections operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.ListGeofenceCollections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListGeofenceCollections"
     *      target="_top">AWS API Documentation</a>
     */
    default ListGeofenceCollectionsResponse listGeofenceCollections(ListGeofenceCollectionsRequest listGeofenceCollectionsRequest)
            throws InternalServerException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException,
            SdkClientException, LocationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists geofence collections in your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGeofenceCollectionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListGeofenceCollectionsRequest#builder()}
     * </p>
     *
     * @param listGeofenceCollectionsRequest
     *        A {@link Consumer} that will call methods on {@link ListGeofenceCollectionsRequest.Builder} to create a
     *        request.
     * @return Result of the ListGeofenceCollections operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.ListGeofenceCollections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListGeofenceCollections"
     *      target="_top">AWS API Documentation</a>
     */
    default ListGeofenceCollectionsResponse listGeofenceCollections(
            Consumer<ListGeofenceCollectionsRequest.Builder> listGeofenceCollectionsRequest) throws InternalServerException,
            AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException,
            LocationException {
        return listGeofenceCollections(ListGeofenceCollectionsRequest.builder().applyMutation(listGeofenceCollectionsRequest)
                .build());
    }

    /**
     * <p>
     * Lists geofence collections in your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listGeofenceCollections(software.amazon.awssdk.services.location.model.ListGeofenceCollectionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.location.paginators.ListGeofenceCollectionsIterable responses = client.listGeofenceCollectionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.location.paginators.ListGeofenceCollectionsIterable responses = client
     *             .listGeofenceCollectionsPaginator(request);
     *     for (software.amazon.awssdk.services.location.model.ListGeofenceCollectionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.location.paginators.ListGeofenceCollectionsIterable responses = client.listGeofenceCollectionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGeofenceCollections(software.amazon.awssdk.services.location.model.ListGeofenceCollectionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listGeofenceCollectionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.ListGeofenceCollections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListGeofenceCollections"
     *      target="_top">AWS API Documentation</a>
     */
    default ListGeofenceCollectionsIterable listGeofenceCollectionsPaginator(
            ListGeofenceCollectionsRequest listGeofenceCollectionsRequest) throws InternalServerException, AccessDeniedException,
            ValidationException, ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists geofence collections in your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listGeofenceCollections(software.amazon.awssdk.services.location.model.ListGeofenceCollectionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.location.paginators.ListGeofenceCollectionsIterable responses = client.listGeofenceCollectionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.location.paginators.ListGeofenceCollectionsIterable responses = client
     *             .listGeofenceCollectionsPaginator(request);
     *     for (software.amazon.awssdk.services.location.model.ListGeofenceCollectionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.location.paginators.ListGeofenceCollectionsIterable responses = client.listGeofenceCollectionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGeofenceCollections(software.amazon.awssdk.services.location.model.ListGeofenceCollectionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGeofenceCollectionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListGeofenceCollectionsRequest#builder()}
     * </p>
     *
     * @param listGeofenceCollectionsRequest
     *        A {@link Consumer} that will call methods on {@link ListGeofenceCollectionsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.ListGeofenceCollections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListGeofenceCollections"
     *      target="_top">AWS API Documentation</a>
     */
    default ListGeofenceCollectionsIterable listGeofenceCollectionsPaginator(
            Consumer<ListGeofenceCollectionsRequest.Builder> listGeofenceCollectionsRequest) throws InternalServerException,
            AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException,
            LocationException {
        return listGeofenceCollectionsPaginator(ListGeofenceCollectionsRequest.builder()
                .applyMutation(listGeofenceCollectionsRequest).build());
    }

    /**
     * <p>
     * Lists geofences stored in a given geofence collection.
     * </p>
     *
     * @param listGeofencesRequest
     * @return Result of the ListGeofences operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ResourceNotFoundException
     *         The resource that you've entered was not found in your AWS account.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.ListGeofences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListGeofences" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGeofencesResponse listGeofences(ListGeofencesRequest listGeofencesRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException,
            SdkClientException, LocationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists geofences stored in a given geofence collection.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGeofencesRequest.Builder} avoiding the need to
     * create one manually via {@link ListGeofencesRequest#builder()}
     * </p>
     *
     * @param listGeofencesRequest
     *        A {@link Consumer} that will call methods on {@link ListGeofencesRequest.Builder} to create a request.
     * @return Result of the ListGeofences operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ResourceNotFoundException
     *         The resource that you've entered was not found in your AWS account.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.ListGeofences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListGeofences" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGeofencesResponse listGeofences(Consumer<ListGeofencesRequest.Builder> listGeofencesRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException,
            ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        return listGeofences(ListGeofencesRequest.builder().applyMutation(listGeofencesRequest).build());
    }

    /**
     * <p>
     * Lists geofences stored in a given geofence collection.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listGeofences(software.amazon.awssdk.services.location.model.ListGeofencesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.location.paginators.ListGeofencesIterable responses = client.listGeofencesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.location.paginators.ListGeofencesIterable responses = client.listGeofencesPaginator(request);
     *     for (software.amazon.awssdk.services.location.model.ListGeofencesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.location.paginators.ListGeofencesIterable responses = client.listGeofencesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGeofences(software.amazon.awssdk.services.location.model.ListGeofencesRequest)} operation.</b>
     * </p>
     *
     * @param listGeofencesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ResourceNotFoundException
     *         The resource that you've entered was not found in your AWS account.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.ListGeofences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListGeofences" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGeofencesIterable listGeofencesPaginator(ListGeofencesRequest listGeofencesRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException,
            ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists geofences stored in a given geofence collection.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listGeofences(software.amazon.awssdk.services.location.model.ListGeofencesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.location.paginators.ListGeofencesIterable responses = client.listGeofencesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.location.paginators.ListGeofencesIterable responses = client.listGeofencesPaginator(request);
     *     for (software.amazon.awssdk.services.location.model.ListGeofencesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.location.paginators.ListGeofencesIterable responses = client.listGeofencesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGeofences(software.amazon.awssdk.services.location.model.ListGeofencesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGeofencesRequest.Builder} avoiding the need to
     * create one manually via {@link ListGeofencesRequest#builder()}
     * </p>
     *
     * @param listGeofencesRequest
     *        A {@link Consumer} that will call methods on {@link ListGeofencesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ResourceNotFoundException
     *         The resource that you've entered was not found in your AWS account.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.ListGeofences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListGeofences" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGeofencesIterable listGeofencesPaginator(Consumer<ListGeofencesRequest.Builder> listGeofencesRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException,
            ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        return listGeofencesPaginator(ListGeofencesRequest.builder().applyMutation(listGeofencesRequest).build());
    }

    /**
     * <p>
     * Lists map resources in your AWS account.
     * </p>
     *
     * @param listMapsRequest
     * @return Result of the ListMaps operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.ListMaps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListMaps" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMapsResponse listMaps(ListMapsRequest listMapsRequest) throws InternalServerException, AccessDeniedException,
            ValidationException, ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists map resources in your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMapsRequest.Builder} avoiding the need to
     * create one manually via {@link ListMapsRequest#builder()}
     * </p>
     *
     * @param listMapsRequest
     *        A {@link Consumer} that will call methods on {@link ListMapsRequest.Builder} to create a request.
     * @return Result of the ListMaps operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.ListMaps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListMaps" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMapsResponse listMaps(Consumer<ListMapsRequest.Builder> listMapsRequest) throws InternalServerException,
            AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException,
            LocationException {
        return listMaps(ListMapsRequest.builder().applyMutation(listMapsRequest).build());
    }

    /**
     * <p>
     * Lists map resources in your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listMaps(software.amazon.awssdk.services.location.model.ListMapsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.location.paginators.ListMapsIterable responses = client.listMapsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.location.paginators.ListMapsIterable responses = client.listMapsPaginator(request);
     *     for (software.amazon.awssdk.services.location.model.ListMapsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.location.paginators.ListMapsIterable responses = client.listMapsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMaps(software.amazon.awssdk.services.location.model.ListMapsRequest)} operation.</b>
     * </p>
     *
     * @param listMapsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.ListMaps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListMaps" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMapsIterable listMapsPaginator(ListMapsRequest listMapsRequest) throws InternalServerException,
            AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException,
            LocationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists map resources in your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listMaps(software.amazon.awssdk.services.location.model.ListMapsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.location.paginators.ListMapsIterable responses = client.listMapsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.location.paginators.ListMapsIterable responses = client.listMapsPaginator(request);
     *     for (software.amazon.awssdk.services.location.model.ListMapsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.location.paginators.ListMapsIterable responses = client.listMapsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMaps(software.amazon.awssdk.services.location.model.ListMapsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMapsRequest.Builder} avoiding the need to
     * create one manually via {@link ListMapsRequest#builder()}
     * </p>
     *
     * @param listMapsRequest
     *        A {@link Consumer} that will call methods on {@link ListMapsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.ListMaps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListMaps" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMapsIterable listMapsPaginator(Consumer<ListMapsRequest.Builder> listMapsRequest) throws InternalServerException,
            AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException,
            LocationException {
        return listMapsPaginator(ListMapsRequest.builder().applyMutation(listMapsRequest).build());
    }

    /**
     * <p>
     * Lists place index resources in your AWS account.
     * </p>
     *
     * @param listPlaceIndexesRequest
     * @return Result of the ListPlaceIndexes operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.ListPlaceIndexes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListPlaceIndexes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPlaceIndexesResponse listPlaceIndexes(ListPlaceIndexesRequest listPlaceIndexesRequest)
            throws InternalServerException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException,
            SdkClientException, LocationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists place index resources in your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPlaceIndexesRequest.Builder} avoiding the need
     * to create one manually via {@link ListPlaceIndexesRequest#builder()}
     * </p>
     *
     * @param listPlaceIndexesRequest
     *        A {@link Consumer} that will call methods on {@link ListPlaceIndexesRequest.Builder} to create a request.
     * @return Result of the ListPlaceIndexes operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.ListPlaceIndexes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListPlaceIndexes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPlaceIndexesResponse listPlaceIndexes(Consumer<ListPlaceIndexesRequest.Builder> listPlaceIndexesRequest)
            throws InternalServerException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException,
            SdkClientException, LocationException {
        return listPlaceIndexes(ListPlaceIndexesRequest.builder().applyMutation(listPlaceIndexesRequest).build());
    }

    /**
     * <p>
     * Lists place index resources in your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPlaceIndexes(software.amazon.awssdk.services.location.model.ListPlaceIndexesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.location.paginators.ListPlaceIndexesIterable responses = client.listPlaceIndexesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.location.paginators.ListPlaceIndexesIterable responses = client
     *             .listPlaceIndexesPaginator(request);
     *     for (software.amazon.awssdk.services.location.model.ListPlaceIndexesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.location.paginators.ListPlaceIndexesIterable responses = client.listPlaceIndexesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPlaceIndexes(software.amazon.awssdk.services.location.model.ListPlaceIndexesRequest)} operation.</b>
     * </p>
     *
     * @param listPlaceIndexesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.ListPlaceIndexes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListPlaceIndexes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPlaceIndexesIterable listPlaceIndexesPaginator(ListPlaceIndexesRequest listPlaceIndexesRequest)
            throws InternalServerException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException,
            SdkClientException, LocationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists place index resources in your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPlaceIndexes(software.amazon.awssdk.services.location.model.ListPlaceIndexesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.location.paginators.ListPlaceIndexesIterable responses = client.listPlaceIndexesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.location.paginators.ListPlaceIndexesIterable responses = client
     *             .listPlaceIndexesPaginator(request);
     *     for (software.amazon.awssdk.services.location.model.ListPlaceIndexesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.location.paginators.ListPlaceIndexesIterable responses = client.listPlaceIndexesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPlaceIndexes(software.amazon.awssdk.services.location.model.ListPlaceIndexesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPlaceIndexesRequest.Builder} avoiding the need
     * to create one manually via {@link ListPlaceIndexesRequest#builder()}
     * </p>
     *
     * @param listPlaceIndexesRequest
     *        A {@link Consumer} that will call methods on {@link ListPlaceIndexesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.ListPlaceIndexes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListPlaceIndexes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPlaceIndexesIterable listPlaceIndexesPaginator(Consumer<ListPlaceIndexesRequest.Builder> listPlaceIndexesRequest)
            throws InternalServerException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException,
            SdkClientException, LocationException {
        return listPlaceIndexesPaginator(ListPlaceIndexesRequest.builder().applyMutation(listPlaceIndexesRequest).build());
    }

    /**
     * <p>
     * Lists route calculator resources in your AWS account.
     * </p>
     *
     * @param listRouteCalculatorsRequest
     * @return Result of the ListRouteCalculators operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.ListRouteCalculators
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListRouteCalculators" target="_top">AWS
     *      API Documentation</a>
     */
    default ListRouteCalculatorsResponse listRouteCalculators(ListRouteCalculatorsRequest listRouteCalculatorsRequest)
            throws InternalServerException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException,
            SdkClientException, LocationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists route calculator resources in your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRouteCalculatorsRequest.Builder} avoiding the
     * need to create one manually via {@link ListRouteCalculatorsRequest#builder()}
     * </p>
     *
     * @param listRouteCalculatorsRequest
     *        A {@link Consumer} that will call methods on {@link ListRouteCalculatorsRequest.Builder} to create a
     *        request.
     * @return Result of the ListRouteCalculators operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.ListRouteCalculators
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListRouteCalculators" target="_top">AWS
     *      API Documentation</a>
     */
    default ListRouteCalculatorsResponse listRouteCalculators(
            Consumer<ListRouteCalculatorsRequest.Builder> listRouteCalculatorsRequest) throws InternalServerException,
            AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException,
            LocationException {
        return listRouteCalculators(ListRouteCalculatorsRequest.builder().applyMutation(listRouteCalculatorsRequest).build());
    }

    /**
     * <p>
     * Lists route calculator resources in your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRouteCalculators(software.amazon.awssdk.services.location.model.ListRouteCalculatorsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.location.paginators.ListRouteCalculatorsIterable responses = client.listRouteCalculatorsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.location.paginators.ListRouteCalculatorsIterable responses = client
     *             .listRouteCalculatorsPaginator(request);
     *     for (software.amazon.awssdk.services.location.model.ListRouteCalculatorsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.location.paginators.ListRouteCalculatorsIterable responses = client.listRouteCalculatorsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRouteCalculators(software.amazon.awssdk.services.location.model.ListRouteCalculatorsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listRouteCalculatorsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.ListRouteCalculators
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListRouteCalculators" target="_top">AWS
     *      API Documentation</a>
     */
    default ListRouteCalculatorsIterable listRouteCalculatorsPaginator(ListRouteCalculatorsRequest listRouteCalculatorsRequest)
            throws InternalServerException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException,
            SdkClientException, LocationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists route calculator resources in your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRouteCalculators(software.amazon.awssdk.services.location.model.ListRouteCalculatorsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.location.paginators.ListRouteCalculatorsIterable responses = client.listRouteCalculatorsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.location.paginators.ListRouteCalculatorsIterable responses = client
     *             .listRouteCalculatorsPaginator(request);
     *     for (software.amazon.awssdk.services.location.model.ListRouteCalculatorsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.location.paginators.ListRouteCalculatorsIterable responses = client.listRouteCalculatorsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRouteCalculators(software.amazon.awssdk.services.location.model.ListRouteCalculatorsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRouteCalculatorsRequest.Builder} avoiding the
     * need to create one manually via {@link ListRouteCalculatorsRequest#builder()}
     * </p>
     *
     * @param listRouteCalculatorsRequest
     *        A {@link Consumer} that will call methods on {@link ListRouteCalculatorsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.ListRouteCalculators
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListRouteCalculators" target="_top">AWS
     *      API Documentation</a>
     */
    default ListRouteCalculatorsIterable listRouteCalculatorsPaginator(
            Consumer<ListRouteCalculatorsRequest.Builder> listRouteCalculatorsRequest) throws InternalServerException,
            AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException,
            LocationException {
        return listRouteCalculatorsPaginator(ListRouteCalculatorsRequest.builder().applyMutation(listRouteCalculatorsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of tags that are applied to the specified Amazon Location resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ResourceNotFoundException
     *         The resource that you've entered was not found in your AWS account.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException,
            ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of tags that are applied to the specified Amazon Location resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ResourceNotFoundException
     *         The resource that you've entered was not found in your AWS account.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException,
            SdkClientException, LocationException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Lists geofence collections currently associated to the given tracker resource.
     * </p>
     *
     * @param listTrackerConsumersRequest
     * @return Result of the ListTrackerConsumers operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ResourceNotFoundException
     *         The resource that you've entered was not found in your AWS account.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.ListTrackerConsumers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListTrackerConsumers" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTrackerConsumersResponse listTrackerConsumers(ListTrackerConsumersRequest listTrackerConsumersRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException,
            ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists geofence collections currently associated to the given tracker resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTrackerConsumersRequest.Builder} avoiding the
     * need to create one manually via {@link ListTrackerConsumersRequest#builder()}
     * </p>
     *
     * @param listTrackerConsumersRequest
     *        A {@link Consumer} that will call methods on {@link ListTrackerConsumersRequest.Builder} to create a
     *        request.
     * @return Result of the ListTrackerConsumers operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ResourceNotFoundException
     *         The resource that you've entered was not found in your AWS account.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.ListTrackerConsumers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListTrackerConsumers" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTrackerConsumersResponse listTrackerConsumers(
            Consumer<ListTrackerConsumersRequest.Builder> listTrackerConsumersRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException,
            SdkClientException, LocationException {
        return listTrackerConsumers(ListTrackerConsumersRequest.builder().applyMutation(listTrackerConsumersRequest).build());
    }

    /**
     * <p>
     * Lists geofence collections currently associated to the given tracker resource.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTrackerConsumers(software.amazon.awssdk.services.location.model.ListTrackerConsumersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.location.paginators.ListTrackerConsumersIterable responses = client.listTrackerConsumersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.location.paginators.ListTrackerConsumersIterable responses = client
     *             .listTrackerConsumersPaginator(request);
     *     for (software.amazon.awssdk.services.location.model.ListTrackerConsumersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.location.paginators.ListTrackerConsumersIterable responses = client.listTrackerConsumersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTrackerConsumers(software.amazon.awssdk.services.location.model.ListTrackerConsumersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTrackerConsumersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ResourceNotFoundException
     *         The resource that you've entered was not found in your AWS account.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.ListTrackerConsumers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListTrackerConsumers" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTrackerConsumersIterable listTrackerConsumersPaginator(ListTrackerConsumersRequest listTrackerConsumersRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException,
            ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists geofence collections currently associated to the given tracker resource.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTrackerConsumers(software.amazon.awssdk.services.location.model.ListTrackerConsumersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.location.paginators.ListTrackerConsumersIterable responses = client.listTrackerConsumersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.location.paginators.ListTrackerConsumersIterable responses = client
     *             .listTrackerConsumersPaginator(request);
     *     for (software.amazon.awssdk.services.location.model.ListTrackerConsumersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.location.paginators.ListTrackerConsumersIterable responses = client.listTrackerConsumersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTrackerConsumers(software.amazon.awssdk.services.location.model.ListTrackerConsumersRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTrackerConsumersRequest.Builder} avoiding the
     * need to create one manually via {@link ListTrackerConsumersRequest#builder()}
     * </p>
     *
     * @param listTrackerConsumersRequest
     *        A {@link Consumer} that will call methods on {@link ListTrackerConsumersRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ResourceNotFoundException
     *         The resource that you've entered was not found in your AWS account.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.ListTrackerConsumers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListTrackerConsumers" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTrackerConsumersIterable listTrackerConsumersPaginator(
            Consumer<ListTrackerConsumersRequest.Builder> listTrackerConsumersRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException,
            SdkClientException, LocationException {
        return listTrackerConsumersPaginator(ListTrackerConsumersRequest.builder().applyMutation(listTrackerConsumersRequest)
                .build());
    }

    /**
     * <p>
     * Lists tracker resources in your AWS account.
     * </p>
     *
     * @param listTrackersRequest
     * @return Result of the ListTrackers operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.ListTrackers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListTrackers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTrackersResponse listTrackers(ListTrackersRequest listTrackersRequest) throws InternalServerException,
            AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException,
            LocationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists tracker resources in your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTrackersRequest.Builder} avoiding the need to
     * create one manually via {@link ListTrackersRequest#builder()}
     * </p>
     *
     * @param listTrackersRequest
     *        A {@link Consumer} that will call methods on {@link ListTrackersRequest.Builder} to create a request.
     * @return Result of the ListTrackers operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.ListTrackers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListTrackers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTrackersResponse listTrackers(Consumer<ListTrackersRequest.Builder> listTrackersRequest)
            throws InternalServerException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException,
            SdkClientException, LocationException {
        return listTrackers(ListTrackersRequest.builder().applyMutation(listTrackersRequest).build());
    }

    /**
     * <p>
     * Lists tracker resources in your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listTrackers(software.amazon.awssdk.services.location.model.ListTrackersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.location.paginators.ListTrackersIterable responses = client.listTrackersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.location.paginators.ListTrackersIterable responses = client.listTrackersPaginator(request);
     *     for (software.amazon.awssdk.services.location.model.ListTrackersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.location.paginators.ListTrackersIterable responses = client.listTrackersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTrackers(software.amazon.awssdk.services.location.model.ListTrackersRequest)} operation.</b>
     * </p>
     *
     * @param listTrackersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.ListTrackers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListTrackers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTrackersIterable listTrackersPaginator(ListTrackersRequest listTrackersRequest) throws InternalServerException,
            AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException,
            LocationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists tracker resources in your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listTrackers(software.amazon.awssdk.services.location.model.ListTrackersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.location.paginators.ListTrackersIterable responses = client.listTrackersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.location.paginators.ListTrackersIterable responses = client.listTrackersPaginator(request);
     *     for (software.amazon.awssdk.services.location.model.ListTrackersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.location.paginators.ListTrackersIterable responses = client.listTrackersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTrackers(software.amazon.awssdk.services.location.model.ListTrackersRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTrackersRequest.Builder} avoiding the need to
     * create one manually via {@link ListTrackersRequest#builder()}
     * </p>
     *
     * @param listTrackersRequest
     *        A {@link Consumer} that will call methods on {@link ListTrackersRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.ListTrackers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListTrackers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTrackersIterable listTrackersPaginator(Consumer<ListTrackersRequest.Builder> listTrackersRequest)
            throws InternalServerException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException,
            SdkClientException, LocationException {
        return listTrackersPaginator(ListTrackersRequest.builder().applyMutation(listTrackersRequest).build());
    }

    /**
     * <p>
     * Stores a geofence geometry in a given geofence collection, or updates the geometry of an existing geofence if a
     * geofence ID is included in the request.
     * </p>
     *
     * @param putGeofenceRequest
     * @return Result of the PutGeofence operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ResourceNotFoundException
     *         The resource that you've entered was not found in your AWS account.
     * @throws ConflictException
     *         The request was unsuccessful because of a conflict.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.PutGeofence
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/PutGeofence" target="_top">AWS API
     *      Documentation</a>
     */
    default PutGeofenceResponse putGeofence(PutGeofenceRequest putGeofenceRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, AccessDeniedException, ValidationException, ThrottlingException,
            AwsServiceException, SdkClientException, LocationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stores a geofence geometry in a given geofence collection, or updates the geometry of an existing geofence if a
     * geofence ID is included in the request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutGeofenceRequest.Builder} avoiding the need to
     * create one manually via {@link PutGeofenceRequest#builder()}
     * </p>
     *
     * @param putGeofenceRequest
     *        A {@link Consumer} that will call methods on {@link PutGeofenceRequest.Builder} to create a request.
     * @return Result of the PutGeofence operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ResourceNotFoundException
     *         The resource that you've entered was not found in your AWS account.
     * @throws ConflictException
     *         The request was unsuccessful because of a conflict.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.PutGeofence
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/PutGeofence" target="_top">AWS API
     *      Documentation</a>
     */
    default PutGeofenceResponse putGeofence(Consumer<PutGeofenceRequest.Builder> putGeofenceRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, AccessDeniedException,
            ValidationException, ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        return putGeofence(PutGeofenceRequest.builder().applyMutation(putGeofenceRequest).build());
    }

    /**
     * <p>
     * Reverse geocodes a given coordinate and returns a legible address. Allows you to search for Places or points of
     * interest near a given position.
     * </p>
     *
     * @param searchPlaceIndexForPositionRequest
     * @return Result of the SearchPlaceIndexForPosition operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ResourceNotFoundException
     *         The resource that you've entered was not found in your AWS account.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.SearchPlaceIndexForPosition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/SearchPlaceIndexForPosition"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchPlaceIndexForPositionResponse searchPlaceIndexForPosition(
            SearchPlaceIndexForPositionRequest searchPlaceIndexForPositionRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException,
            SdkClientException, LocationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Reverse geocodes a given coordinate and returns a legible address. Allows you to search for Places or points of
     * interest near a given position.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchPlaceIndexForPositionRequest.Builder}
     * avoiding the need to create one manually via {@link SearchPlaceIndexForPositionRequest#builder()}
     * </p>
     *
     * @param searchPlaceIndexForPositionRequest
     *        A {@link Consumer} that will call methods on {@link SearchPlaceIndexForPositionRequest.Builder} to create
     *        a request.
     * @return Result of the SearchPlaceIndexForPosition operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ResourceNotFoundException
     *         The resource that you've entered was not found in your AWS account.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.SearchPlaceIndexForPosition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/SearchPlaceIndexForPosition"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchPlaceIndexForPositionResponse searchPlaceIndexForPosition(
            Consumer<SearchPlaceIndexForPositionRequest.Builder> searchPlaceIndexForPositionRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException,
            ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        return searchPlaceIndexForPosition(SearchPlaceIndexForPositionRequest.builder()
                .applyMutation(searchPlaceIndexForPositionRequest).build());
    }

    /**
     * <p>
     * Geocodes free-form text, such as an address, name, city, or region to allow you to search for Places or points of
     * interest.
     * </p>
     * <p>
     * Includes the option to apply additional parameters to narrow your list of results.
     * </p>
     * <note>
     * <p>
     * You can search for places near a given position using <code>BiasPosition</code>, or filter results within a
     * bounding box using <code>FilterBBox</code>. Providing both parameters simultaneously returns an error.
     * </p>
     * </note>
     *
     * @param searchPlaceIndexForTextRequest
     * @return Result of the SearchPlaceIndexForText operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ResourceNotFoundException
     *         The resource that you've entered was not found in your AWS account.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.SearchPlaceIndexForText
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/SearchPlaceIndexForText"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchPlaceIndexForTextResponse searchPlaceIndexForText(SearchPlaceIndexForTextRequest searchPlaceIndexForTextRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException,
            ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Geocodes free-form text, such as an address, name, city, or region to allow you to search for Places or points of
     * interest.
     * </p>
     * <p>
     * Includes the option to apply additional parameters to narrow your list of results.
     * </p>
     * <note>
     * <p>
     * You can search for places near a given position using <code>BiasPosition</code>, or filter results within a
     * bounding box using <code>FilterBBox</code>. Providing both parameters simultaneously returns an error.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchPlaceIndexForTextRequest.Builder} avoiding
     * the need to create one manually via {@link SearchPlaceIndexForTextRequest#builder()}
     * </p>
     *
     * @param searchPlaceIndexForTextRequest
     *        A {@link Consumer} that will call methods on {@link SearchPlaceIndexForTextRequest.Builder} to create a
     *        request.
     * @return Result of the SearchPlaceIndexForText operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ResourceNotFoundException
     *         The resource that you've entered was not found in your AWS account.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.SearchPlaceIndexForText
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/SearchPlaceIndexForText"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchPlaceIndexForTextResponse searchPlaceIndexForText(
            Consumer<SearchPlaceIndexForTextRequest.Builder> searchPlaceIndexForTextRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException,
            SdkClientException, LocationException {
        return searchPlaceIndexForText(SearchPlaceIndexForTextRequest.builder().applyMutation(searchPlaceIndexForTextRequest)
                .build());
    }

    /**
     * <p>
     * Assigns one or more tags (key-value pairs) to the specified Amazon Location Service resource.
     * </p>
     * 
     * <pre>
     * <code> &lt;p&gt;Tags can help you organize and categorize your resources. You can also use them to scope user permissions, by granting a user permission to access or change only resources with certain tag values.&lt;/p&gt; &lt;p&gt;You can use the &lt;code&gt;TagResource&lt;/code&gt; operation with an Amazon Location Service resource that already has tags. If you specify a new tag key for the resource, this tag is appended to the tags already associated with the resource. If you specify a tag key that's already associated with the resource, the new tag value that you specify replaces the previous value for that tag. &lt;/p&gt; &lt;p&gt;You can associate up to 50 tags with a resource.&lt;/p&gt; </code>
     * </pre>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ResourceNotFoundException
     *         The resource that you've entered was not found in your AWS account.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException,
            SdkClientException, LocationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Assigns one or more tags (key-value pairs) to the specified Amazon Location Service resource.
     * </p>
     * 
     * <pre>
     * <code> &lt;p&gt;Tags can help you organize and categorize your resources. You can also use them to scope user permissions, by granting a user permission to access or change only resources with certain tag values.&lt;/p&gt; &lt;p&gt;You can use the &lt;code&gt;TagResource&lt;/code&gt; operation with an Amazon Location Service resource that already has tags. If you specify a new tag key for the resource, this tag is appended to the tags already associated with the resource. If you specify a tag key that's already associated with the resource, the new tag value that you specify replaces the previous value for that tag. &lt;/p&gt; &lt;p&gt;You can associate up to 50 tags with a resource.&lt;/p&gt; </code>
     * </pre>
     * 
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ResourceNotFoundException
     *         The resource that you've entered was not found in your AWS account.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException,
            ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes one or more tags from the specified Amazon Location resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ResourceNotFoundException
     *         The resource that you've entered was not found in your AWS account.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException,
            SdkClientException, LocationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes one or more tags from the specified Amazon Location resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ResourceNotFoundException
     *         The resource that you've entered was not found in your AWS account.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException,
            ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates the specified properties of a given geofence collection.
     * </p>
     *
     * @param updateGeofenceCollectionRequest
     * @return Result of the UpdateGeofenceCollection operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ResourceNotFoundException
     *         The resource that you've entered was not found in your AWS account.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.UpdateGeofenceCollection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/UpdateGeofenceCollection"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateGeofenceCollectionResponse updateGeofenceCollection(
            UpdateGeofenceCollectionRequest updateGeofenceCollectionRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException,
            SdkClientException, LocationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified properties of a given geofence collection.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateGeofenceCollectionRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateGeofenceCollectionRequest#builder()}
     * </p>
     *
     * @param updateGeofenceCollectionRequest
     *        A {@link Consumer} that will call methods on {@link UpdateGeofenceCollectionRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateGeofenceCollection operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ResourceNotFoundException
     *         The resource that you've entered was not found in your AWS account.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.UpdateGeofenceCollection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/UpdateGeofenceCollection"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateGeofenceCollectionResponse updateGeofenceCollection(
            Consumer<UpdateGeofenceCollectionRequest.Builder> updateGeofenceCollectionRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException,
            SdkClientException, LocationException {
        return updateGeofenceCollection(UpdateGeofenceCollectionRequest.builder().applyMutation(updateGeofenceCollectionRequest)
                .build());
    }

    /**
     * <p>
     * Updates the specified properties of a given map resource.
     * </p>
     *
     * @param updateMapRequest
     * @return Result of the UpdateMap operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ResourceNotFoundException
     *         The resource that you've entered was not found in your AWS account.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.UpdateMap
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/UpdateMap" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateMapResponse updateMap(UpdateMapRequest updateMapRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException,
            SdkClientException, LocationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified properties of a given map resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateMapRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateMapRequest#builder()}
     * </p>
     *
     * @param updateMapRequest
     *        A {@link Consumer} that will call methods on {@link UpdateMapRequest.Builder} to create a request.
     * @return Result of the UpdateMap operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ResourceNotFoundException
     *         The resource that you've entered was not found in your AWS account.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.UpdateMap
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/UpdateMap" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateMapResponse updateMap(Consumer<UpdateMapRequest.Builder> updateMapRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException,
            SdkClientException, LocationException {
        return updateMap(UpdateMapRequest.builder().applyMutation(updateMapRequest).build());
    }

    /**
     * <p>
     * Updates the specified properties of a given place index resource.
     * </p>
     *
     * @param updatePlaceIndexRequest
     * @return Result of the UpdatePlaceIndex operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ResourceNotFoundException
     *         The resource that you've entered was not found in your AWS account.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.UpdatePlaceIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/UpdatePlaceIndex" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdatePlaceIndexResponse updatePlaceIndex(UpdatePlaceIndexRequest updatePlaceIndexRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException,
            ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified properties of a given place index resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdatePlaceIndexRequest.Builder} avoiding the need
     * to create one manually via {@link UpdatePlaceIndexRequest#builder()}
     * </p>
     *
     * @param updatePlaceIndexRequest
     *        A {@link Consumer} that will call methods on {@link UpdatePlaceIndexRequest.Builder} to create a request.
     * @return Result of the UpdatePlaceIndex operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ResourceNotFoundException
     *         The resource that you've entered was not found in your AWS account.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.UpdatePlaceIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/UpdatePlaceIndex" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdatePlaceIndexResponse updatePlaceIndex(Consumer<UpdatePlaceIndexRequest.Builder> updatePlaceIndexRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException,
            ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        return updatePlaceIndex(UpdatePlaceIndexRequest.builder().applyMutation(updatePlaceIndexRequest).build());
    }

    /**
     * <p>
     * Updates the specified properties for a given route calculator resource.
     * </p>
     *
     * @param updateRouteCalculatorRequest
     * @return Result of the UpdateRouteCalculator operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ResourceNotFoundException
     *         The resource that you've entered was not found in your AWS account.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.UpdateRouteCalculator
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/UpdateRouteCalculator"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateRouteCalculatorResponse updateRouteCalculator(UpdateRouteCalculatorRequest updateRouteCalculatorRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException,
            ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified properties for a given route calculator resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRouteCalculatorRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateRouteCalculatorRequest#builder()}
     * </p>
     *
     * @param updateRouteCalculatorRequest
     *        A {@link Consumer} that will call methods on {@link UpdateRouteCalculatorRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateRouteCalculator operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ResourceNotFoundException
     *         The resource that you've entered was not found in your AWS account.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.UpdateRouteCalculator
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/UpdateRouteCalculator"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateRouteCalculatorResponse updateRouteCalculator(
            Consumer<UpdateRouteCalculatorRequest.Builder> updateRouteCalculatorRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException,
            SdkClientException, LocationException {
        return updateRouteCalculator(UpdateRouteCalculatorRequest.builder().applyMutation(updateRouteCalculatorRequest).build());
    }

    /**
     * <p>
     * Updates the specified properties of a given tracker resource.
     * </p>
     *
     * @param updateTrackerRequest
     * @return Result of the UpdateTracker operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ResourceNotFoundException
     *         The resource that you've entered was not found in your AWS account.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.UpdateTracker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/UpdateTracker" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateTrackerResponse updateTracker(UpdateTrackerRequest updateTrackerRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException,
            SdkClientException, LocationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified properties of a given tracker resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateTrackerRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateTrackerRequest#builder()}
     * </p>
     *
     * @param updateTrackerRequest
     *        A {@link Consumer} that will call methods on {@link UpdateTrackerRequest.Builder} to create a request.
     * @return Result of the UpdateTracker operation returned by the service.
     * @throws InternalServerException
     *         The request has failed to process because of an unknown server error, exception, or failure.
     * @throws ResourceNotFoundException
     *         The resource that you've entered was not found in your AWS account.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input failed to meet the constraints specified by the AWS service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LocationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LocationClient.UpdateTracker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/UpdateTracker" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateTrackerResponse updateTracker(Consumer<UpdateTrackerRequest.Builder> updateTrackerRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException,
            ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        return updateTracker(UpdateTrackerRequest.builder().applyMutation(updateTrackerRequest).build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }
}
