/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies a single point of interest, or Place as a result of a search query obtained from a dataset configured in
 * the Place index Resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchForPositionResult implements SdkPojo, Serializable,
        ToCopyableBuilder<SearchForPositionResult.Builder, SearchForPositionResult> {
    private static final SdkField<Place> PLACE_FIELD = SdkField.<Place> builder(MarshallingType.SDK_POJO).memberName("Place")
            .getter(getter(SearchForPositionResult::place)).setter(setter(Builder::place)).constructor(Place::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Place").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLACE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Place place;

    private SearchForPositionResult(BuilderImpl builder) {
        this.place = builder.place;
    }

    /**
     * <p>
     * Contains details about the relevant point of interest.
     * </p>
     * 
     * @return Contains details about the relevant point of interest.
     */
    public final Place place() {
        return place;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(place());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchForPositionResult)) {
            return false;
        }
        SearchForPositionResult other = (SearchForPositionResult) obj;
        return Objects.equals(place(), other.place());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchForPositionResult").add("Place", place()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Place":
            return Optional.ofNullable(clazz.cast(place()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchForPositionResult, T> g) {
        return obj -> g.apply((SearchForPositionResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SearchForPositionResult> {
        /**
         * <p>
         * Contains details about the relevant point of interest.
         * </p>
         * 
         * @param place
         *        Contains details about the relevant point of interest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder place(Place place);

        /**
         * <p>
         * Contains details about the relevant point of interest.
         * </p>
         * This is a convenience that creates an instance of the {@link Place.Builder} avoiding the need to create one
         * manually via {@link Place#builder()}.
         *
         * When the {@link Consumer} completes, {@link Place.Builder#build()} is called immediately and its result is
         * passed to {@link #place(Place)}.
         * 
         * @param place
         *        a consumer that will call methods on {@link Place.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #place(Place)
         */
        default Builder place(Consumer<Place.Builder> place) {
            return place(Place.builder().applyMutation(place).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Place place;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchForPositionResult model) {
            place(model.place);
        }

        public final Place.Builder getPlace() {
            return place != null ? place.toBuilder() : null;
        }

        @Override
        public final Builder place(Place place) {
            this.place = place;
            return this;
        }

        public final void setPlace(Place.BuilderImpl place) {
            this.place = place != null ? place.build() : null;
        }

        @Override
        public SearchForPositionResult build() {
            return new SearchForPositionResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
