/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A Place index resource listed in your AWS account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPlaceIndexesResponseEntry implements SdkPojo, Serializable,
        ToCopyableBuilder<ListPlaceIndexesResponseEntry.Builder, ListPlaceIndexesResponseEntry> {
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreateTime")
            .getter(getter(ListPlaceIndexesResponseEntry::createTime))
            .setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> DATA_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataSource").getter(getter(ListPlaceIndexesResponseEntry::dataSource))
            .setter(setter(Builder::dataSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSource").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(ListPlaceIndexesResponseEntry::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> INDEX_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IndexName").getter(getter(ListPlaceIndexesResponseEntry::indexName)).setter(setter(Builder::indexName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexName").build()).build();

    private static final SdkField<String> PRICING_PLAN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PricingPlan").getter(getter(ListPlaceIndexesResponseEntry::pricingPlanAsString))
            .setter(setter(Builder::pricingPlan))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PricingPlan").build()).build();

    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdateTime")
            .getter(getter(ListPlaceIndexesResponseEntry::updateTime))
            .setter(setter(Builder::updateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATE_TIME_FIELD,
            DATA_SOURCE_FIELD, DESCRIPTION_FIELD, INDEX_NAME_FIELD, PRICING_PLAN_FIELD, UPDATE_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant createTime;

    private final String dataSource;

    private final String description;

    private final String indexName;

    private final String pricingPlan;

    private final Instant updateTime;

    private ListPlaceIndexesResponseEntry(BuilderImpl builder) {
        this.createTime = builder.createTime;
        this.dataSource = builder.dataSource;
        this.description = builder.description;
        this.indexName = builder.indexName;
        this.pricingPlan = builder.pricingPlan;
        this.updateTime = builder.updateTime;
    }

    /**
     * <p>
     * The timestamp for when the Place index resource was created in <a
     * href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format:
     * <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.
     * </p>
     * 
     * @return The timestamp for when the Place index resource was created in <a
     *         href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format:
     *         <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.
     */
    public final Instant createTime() {
        return createTime;
    }

    /**
     * <p>
     * The data provider of geospatial data. Indicates one of the available providers:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Esri
     * </p>
     * </li>
     * <li>
     * <p>
     * HERE
     * </p>
     * </li>
     * </ul>
     * <p>
     * For additional details on data providers, see the <a
     * href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Amazon Location
     * Service data providers page</a>.
     * </p>
     * 
     * @return The data provider of geospatial data. Indicates one of the available providers:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Esri
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         HERE
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For additional details on data providers, see the <a
     *         href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Amazon
     *         Location Service data providers page</a>.
     */
    public final String dataSource() {
        return dataSource;
    }

    /**
     * <p>
     * The optional description for the Place index resource.
     * </p>
     * 
     * @return The optional description for the Place index resource.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The name of the Place index resource.
     * </p>
     * 
     * @return The name of the Place index resource.
     */
    public final String indexName() {
        return indexName;
    }

    /**
     * <p>
     * The pricing plan for the specified Place index resource.
     * </p>
     * <p>
     * For additional details and restrictions on each pricing plan option, see the <a
     * href="https://aws.amazon.com/location/pricing/">Amazon Location Service pricing page</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pricingPlan} will
     * return {@link PricingPlan#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #pricingPlanAsString}.
     * </p>
     * 
     * @return The pricing plan for the specified Place index resource.</p>
     *         <p>
     *         For additional details and restrictions on each pricing plan option, see the <a
     *         href="https://aws.amazon.com/location/pricing/">Amazon Location Service pricing page</a>.
     * @see PricingPlan
     */
    public final PricingPlan pricingPlan() {
        return PricingPlan.fromValue(pricingPlan);
    }

    /**
     * <p>
     * The pricing plan for the specified Place index resource.
     * </p>
     * <p>
     * For additional details and restrictions on each pricing plan option, see the <a
     * href="https://aws.amazon.com/location/pricing/">Amazon Location Service pricing page</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pricingPlan} will
     * return {@link PricingPlan#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #pricingPlanAsString}.
     * </p>
     * 
     * @return The pricing plan for the specified Place index resource.</p>
     *         <p>
     *         For additional details and restrictions on each pricing plan option, see the <a
     *         href="https://aws.amazon.com/location/pricing/">Amazon Location Service pricing page</a>.
     * @see PricingPlan
     */
    public final String pricingPlanAsString() {
        return pricingPlan;
    }

    /**
     * <p>
     * The timestamp for when the Place index resource was last updated in <a
     * href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format:
     * <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.
     * </p>
     * 
     * @return The timestamp for when the Place index resource was last updated in <a
     *         href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format:
     *         <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.
     */
    public final Instant updateTime() {
        return updateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(dataSource());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(indexName());
        hashCode = 31 * hashCode + Objects.hashCode(pricingPlanAsString());
        hashCode = 31 * hashCode + Objects.hashCode(updateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPlaceIndexesResponseEntry)) {
            return false;
        }
        ListPlaceIndexesResponseEntry other = (ListPlaceIndexesResponseEntry) obj;
        return Objects.equals(createTime(), other.createTime()) && Objects.equals(dataSource(), other.dataSource())
                && Objects.equals(description(), other.description()) && Objects.equals(indexName(), other.indexName())
                && Objects.equals(pricingPlanAsString(), other.pricingPlanAsString())
                && Objects.equals(updateTime(), other.updateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListPlaceIndexesResponseEntry").add("CreateTime", createTime()).add("DataSource", dataSource())
                .add("Description", description()).add("IndexName", indexName()).add("PricingPlan", pricingPlanAsString())
                .add("UpdateTime", updateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreateTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "DataSource":
            return Optional.ofNullable(clazz.cast(dataSource()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "IndexName":
            return Optional.ofNullable(clazz.cast(indexName()));
        case "PricingPlan":
            return Optional.ofNullable(clazz.cast(pricingPlanAsString()));
        case "UpdateTime":
            return Optional.ofNullable(clazz.cast(updateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPlaceIndexesResponseEntry, T> g) {
        return obj -> g.apply((ListPlaceIndexesResponseEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListPlaceIndexesResponseEntry> {
        /**
         * <p>
         * The timestamp for when the Place index resource was created in <a
         * href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format:
         * <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.
         * </p>
         * 
         * @param createTime
         *        The timestamp for when the Place index resource was created in <a
         *        href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format:
         *        <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * The data provider of geospatial data. Indicates one of the available providers:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Esri
         * </p>
         * </li>
         * <li>
         * <p>
         * HERE
         * </p>
         * </li>
         * </ul>
         * <p>
         * For additional details on data providers, see the <a
         * href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Amazon Location
         * Service data providers page</a>.
         * </p>
         * 
         * @param dataSource
         *        The data provider of geospatial data. Indicates one of the available providers:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Esri
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        HERE
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For additional details on data providers, see the <a
         *        href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Amazon
         *        Location Service data providers page</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSource(String dataSource);

        /**
         * <p>
         * The optional description for the Place index resource.
         * </p>
         * 
         * @param description
         *        The optional description for the Place index resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The name of the Place index resource.
         * </p>
         * 
         * @param indexName
         *        The name of the Place index resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexName(String indexName);

        /**
         * <p>
         * The pricing plan for the specified Place index resource.
         * </p>
         * <p>
         * For additional details and restrictions on each pricing plan option, see the <a
         * href="https://aws.amazon.com/location/pricing/">Amazon Location Service pricing page</a>.
         * </p>
         * 
         * @param pricingPlan
         *        The pricing plan for the specified Place index resource.</p>
         *        <p>
         *        For additional details and restrictions on each pricing plan option, see the <a
         *        href="https://aws.amazon.com/location/pricing/">Amazon Location Service pricing page</a>.
         * @see PricingPlan
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PricingPlan
         */
        Builder pricingPlan(String pricingPlan);

        /**
         * <p>
         * The pricing plan for the specified Place index resource.
         * </p>
         * <p>
         * For additional details and restrictions on each pricing plan option, see the <a
         * href="https://aws.amazon.com/location/pricing/">Amazon Location Service pricing page</a>.
         * </p>
         * 
         * @param pricingPlan
         *        The pricing plan for the specified Place index resource.</p>
         *        <p>
         *        For additional details and restrictions on each pricing plan option, see the <a
         *        href="https://aws.amazon.com/location/pricing/">Amazon Location Service pricing page</a>.
         * @see PricingPlan
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PricingPlan
         */
        Builder pricingPlan(PricingPlan pricingPlan);

        /**
         * <p>
         * The timestamp for when the Place index resource was last updated in <a
         * href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format:
         * <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.
         * </p>
         * 
         * @param updateTime
         *        The timestamp for when the Place index resource was last updated in <a
         *        href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format:
         *        <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateTime(Instant updateTime);
    }

    static final class BuilderImpl implements Builder {
        private Instant createTime;

        private String dataSource;

        private String description;

        private String indexName;

        private String pricingPlan;

        private Instant updateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPlaceIndexesResponseEntry model) {
            createTime(model.createTime);
            dataSource(model.dataSource);
            description(model.description);
            indexName(model.indexName);
            pricingPlan(model.pricingPlan);
            updateTime(model.updateTime);
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        public final String getDataSource() {
            return dataSource;
        }

        @Override
        public final Builder dataSource(String dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public final void setDataSource(String dataSource) {
            this.dataSource = dataSource;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getIndexName() {
            return indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        public final String getPricingPlan() {
            return pricingPlan;
        }

        @Override
        public final Builder pricingPlan(String pricingPlan) {
            this.pricingPlan = pricingPlan;
            return this;
        }

        @Override
        public final Builder pricingPlan(PricingPlan pricingPlan) {
            this.pricingPlan(pricingPlan == null ? null : pricingPlan.toString());
            return this;
        }

        public final void setPricingPlan(String pricingPlan) {
            this.pricingPlan = pricingPlan;
        }

        public final Instant getUpdateTime() {
            return updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public ListPlaceIndexesResponseEntry build() {
            return new ListPlaceIndexesResponseEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
