/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreatePlaceIndexRequest extends LocationRequest implements
        ToCopyableBuilder<CreatePlaceIndexRequest.Builder, CreatePlaceIndexRequest> {
    private static final SdkField<String> DATA_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataSource").getter(getter(CreatePlaceIndexRequest::dataSource)).setter(setter(Builder::dataSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSource").build()).build();

    private static final SdkField<DataSourceConfiguration> DATA_SOURCE_CONFIGURATION_FIELD = SdkField
            .<DataSourceConfiguration> builder(MarshallingType.SDK_POJO).memberName("DataSourceConfiguration")
            .getter(getter(CreatePlaceIndexRequest::dataSourceConfiguration)).setter(setter(Builder::dataSourceConfiguration))
            .constructor(DataSourceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSourceConfiguration").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreatePlaceIndexRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> INDEX_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IndexName").getter(getter(CreatePlaceIndexRequest::indexName)).setter(setter(Builder::indexName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexName").build()).build();

    private static final SdkField<String> PRICING_PLAN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PricingPlan").getter(getter(CreatePlaceIndexRequest::pricingPlanAsString))
            .setter(setter(Builder::pricingPlan))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PricingPlan").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCE_FIELD,
            DATA_SOURCE_CONFIGURATION_FIELD, DESCRIPTION_FIELD, INDEX_NAME_FIELD, PRICING_PLAN_FIELD));

    private final String dataSource;

    private final DataSourceConfiguration dataSourceConfiguration;

    private final String description;

    private final String indexName;

    private final String pricingPlan;

    private CreatePlaceIndexRequest(BuilderImpl builder) {
        super(builder);
        this.dataSource = builder.dataSource;
        this.dataSourceConfiguration = builder.dataSourceConfiguration;
        this.description = builder.description;
        this.indexName = builder.indexName;
        this.pricingPlan = builder.pricingPlan;
    }

    /**
     * <p>
     * Specifies the data provider of geospatial data.
     * </p>
     * <note>
     * <p>
     * This field is case-sensitive. Enter the valid values as shown. For example, entering <code>HERE</code> will
     * return an error.
     * </p>
     * </note>
     * <p>
     * Valid values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Esri</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Here</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * For additional details on data providers, see the <a
     * href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Amazon Location
     * Service data providers page</a>.
     * </p>
     * 
     * @return Specifies the data provider of geospatial data.</p> <note>
     *         <p>
     *         This field is case-sensitive. Enter the valid values as shown. For example, entering <code>HERE</code>
     *         will return an error.
     *         </p>
     *         </note>
     *         <p>
     *         Valid values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Esri</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Here</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For additional details on data providers, see the <a
     *         href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Amazon
     *         Location Service data providers page</a>.
     */
    public final String dataSource() {
        return dataSource;
    }

    /**
     * <p>
     * Specifies the data storage option for requesting Places.
     * </p>
     * 
     * @return Specifies the data storage option for requesting Places.
     */
    public final DataSourceConfiguration dataSourceConfiguration() {
        return dataSourceConfiguration;
    }

    /**
     * <p>
     * The optional description for the Place index resource.
     * </p>
     * 
     * @return The optional description for the Place index resource.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The name of the Place index resource.
     * </p>
     * <p>
     * Requirements:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Contain only alphanumeric characters (A-Z, a-z, 0-9) , hyphens (-), periods (.), and underscores (_).
     * </p>
     * </li>
     * <li>
     * <p>
     * Must be a unique Place index resource name.
     * </p>
     * </li>
     * <li>
     * <p>
     * No spaces allowed. For example, <code>ExamplePlaceIndex</code>.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name of the Place index resource. </p>
     *         <p>
     *         Requirements:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only alphanumeric characters (A-Z, a-z, 0-9) , hyphens (-), periods (.), and underscores (_).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must be a unique Place index resource name.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         No spaces allowed. For example, <code>ExamplePlaceIndex</code>.
     *         </p>
     *         </li>
     */
    public final String indexName() {
        return indexName;
    }

    /**
     * <p>
     * Specifies the pricing plan for your Place index resource.
     * </p>
     * <p>
     * For additional details and restrictions on each pricing plan option, see the <a
     * href="https://aws.amazon.com/location/pricing/">Amazon Location Service pricing page</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pricingPlan} will
     * return {@link PricingPlan#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #pricingPlanAsString}.
     * </p>
     * 
     * @return Specifies the pricing plan for your Place index resource.</p>
     *         <p>
     *         For additional details and restrictions on each pricing plan option, see the <a
     *         href="https://aws.amazon.com/location/pricing/">Amazon Location Service pricing page</a>.
     * @see PricingPlan
     */
    public final PricingPlan pricingPlan() {
        return PricingPlan.fromValue(pricingPlan);
    }

    /**
     * <p>
     * Specifies the pricing plan for your Place index resource.
     * </p>
     * <p>
     * For additional details and restrictions on each pricing plan option, see the <a
     * href="https://aws.amazon.com/location/pricing/">Amazon Location Service pricing page</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pricingPlan} will
     * return {@link PricingPlan#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #pricingPlanAsString}.
     * </p>
     * 
     * @return Specifies the pricing plan for your Place index resource.</p>
     *         <p>
     *         For additional details and restrictions on each pricing plan option, see the <a
     *         href="https://aws.amazon.com/location/pricing/">Amazon Location Service pricing page</a>.
     * @see PricingPlan
     */
    public final String pricingPlanAsString() {
        return pricingPlan;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dataSource());
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(indexName());
        hashCode = 31 * hashCode + Objects.hashCode(pricingPlanAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePlaceIndexRequest)) {
            return false;
        }
        CreatePlaceIndexRequest other = (CreatePlaceIndexRequest) obj;
        return Objects.equals(dataSource(), other.dataSource())
                && Objects.equals(dataSourceConfiguration(), other.dataSourceConfiguration())
                && Objects.equals(description(), other.description()) && Objects.equals(indexName(), other.indexName())
                && Objects.equals(pricingPlanAsString(), other.pricingPlanAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreatePlaceIndexRequest").add("DataSource", dataSource())
                .add("DataSourceConfiguration", dataSourceConfiguration()).add("Description", description())
                .add("IndexName", indexName()).add("PricingPlan", pricingPlanAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataSource":
            return Optional.ofNullable(clazz.cast(dataSource()));
        case "DataSourceConfiguration":
            return Optional.ofNullable(clazz.cast(dataSourceConfiguration()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "IndexName":
            return Optional.ofNullable(clazz.cast(indexName()));
        case "PricingPlan":
            return Optional.ofNullable(clazz.cast(pricingPlanAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreatePlaceIndexRequest, T> g) {
        return obj -> g.apply((CreatePlaceIndexRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LocationRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreatePlaceIndexRequest> {
        /**
         * <p>
         * Specifies the data provider of geospatial data.
         * </p>
         * <note>
         * <p>
         * This field is case-sensitive. Enter the valid values as shown. For example, entering <code>HERE</code> will
         * return an error.
         * </p>
         * </note>
         * <p>
         * Valid values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Esri</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Here</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * For additional details on data providers, see the <a
         * href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Amazon Location
         * Service data providers page</a>.
         * </p>
         * 
         * @param dataSource
         *        Specifies the data provider of geospatial data.</p> <note>
         *        <p>
         *        This field is case-sensitive. Enter the valid values as shown. For example, entering <code>HERE</code>
         *        will return an error.
         *        </p>
         *        </note>
         *        <p>
         *        Valid values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Esri</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Here</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For additional details on data providers, see the <a
         *        href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Amazon
         *        Location Service data providers page</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSource(String dataSource);

        /**
         * <p>
         * Specifies the data storage option for requesting Places.
         * </p>
         * 
         * @param dataSourceConfiguration
         *        Specifies the data storage option for requesting Places.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceConfiguration(DataSourceConfiguration dataSourceConfiguration);

        /**
         * <p>
         * Specifies the data storage option for requesting Places.
         * </p>
         * This is a convenience that creates an instance of the {@link DataSourceConfiguration.Builder} avoiding the
         * need to create one manually via {@link DataSourceConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link DataSourceConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #dataSourceConfiguration(DataSourceConfiguration)}.
         * 
         * @param dataSourceConfiguration
         *        a consumer that will call methods on {@link DataSourceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSourceConfiguration(DataSourceConfiguration)
         */
        default Builder dataSourceConfiguration(Consumer<DataSourceConfiguration.Builder> dataSourceConfiguration) {
            return dataSourceConfiguration(DataSourceConfiguration.builder().applyMutation(dataSourceConfiguration).build());
        }

        /**
         * <p>
         * The optional description for the Place index resource.
         * </p>
         * 
         * @param description
         *        The optional description for the Place index resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The name of the Place index resource.
         * </p>
         * <p>
         * Requirements:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Contain only alphanumeric characters (A-Z, a-z, 0-9) , hyphens (-), periods (.), and underscores (_).
         * </p>
         * </li>
         * <li>
         * <p>
         * Must be a unique Place index resource name.
         * </p>
         * </li>
         * <li>
         * <p>
         * No spaces allowed. For example, <code>ExamplePlaceIndex</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param indexName
         *        The name of the Place index resource. </p>
         *        <p>
         *        Requirements:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Contain only alphanumeric characters (A-Z, a-z, 0-9) , hyphens (-), periods (.), and underscores (_).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must be a unique Place index resource name.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        No spaces allowed. For example, <code>ExamplePlaceIndex</code>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexName(String indexName);

        /**
         * <p>
         * Specifies the pricing plan for your Place index resource.
         * </p>
         * <p>
         * For additional details and restrictions on each pricing plan option, see the <a
         * href="https://aws.amazon.com/location/pricing/">Amazon Location Service pricing page</a>.
         * </p>
         * 
         * @param pricingPlan
         *        Specifies the pricing plan for your Place index resource.</p>
         *        <p>
         *        For additional details and restrictions on each pricing plan option, see the <a
         *        href="https://aws.amazon.com/location/pricing/">Amazon Location Service pricing page</a>.
         * @see PricingPlan
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PricingPlan
         */
        Builder pricingPlan(String pricingPlan);

        /**
         * <p>
         * Specifies the pricing plan for your Place index resource.
         * </p>
         * <p>
         * For additional details and restrictions on each pricing plan option, see the <a
         * href="https://aws.amazon.com/location/pricing/">Amazon Location Service pricing page</a>.
         * </p>
         * 
         * @param pricingPlan
         *        Specifies the pricing plan for your Place index resource.</p>
         *        <p>
         *        For additional details and restrictions on each pricing plan option, see the <a
         *        href="https://aws.amazon.com/location/pricing/">Amazon Location Service pricing page</a>.
         * @see PricingPlan
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PricingPlan
         */
        Builder pricingPlan(PricingPlan pricingPlan);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LocationRequest.BuilderImpl implements Builder {
        private String dataSource;

        private DataSourceConfiguration dataSourceConfiguration;

        private String description;

        private String indexName;

        private String pricingPlan;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePlaceIndexRequest model) {
            super(model);
            dataSource(model.dataSource);
            dataSourceConfiguration(model.dataSourceConfiguration);
            description(model.description);
            indexName(model.indexName);
            pricingPlan(model.pricingPlan);
        }

        public final String getDataSource() {
            return dataSource;
        }

        @Override
        public final Builder dataSource(String dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public final void setDataSource(String dataSource) {
            this.dataSource = dataSource;
        }

        public final DataSourceConfiguration.Builder getDataSourceConfiguration() {
            return dataSourceConfiguration != null ? dataSourceConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder dataSourceConfiguration(DataSourceConfiguration dataSourceConfiguration) {
            this.dataSourceConfiguration = dataSourceConfiguration;
            return this;
        }

        public final void setDataSourceConfiguration(DataSourceConfiguration.BuilderImpl dataSourceConfiguration) {
            this.dataSourceConfiguration = dataSourceConfiguration != null ? dataSourceConfiguration.build() : null;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getIndexName() {
            return indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        public final String getPricingPlan() {
            return pricingPlan;
        }

        @Override
        public final Builder pricingPlan(String pricingPlan) {
            this.pricingPlan = pricingPlan;
            return this;
        }

        @Override
        public final Builder pricingPlan(PricingPlan pricingPlan) {
            this.pricingPlan(pricingPlan == null ? null : pricingPlan.toString());
            return this;
        }

        public final void setPricingPlan(String pricingPlan) {
            this.pricingPlan = pricingPlan;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePlaceIndexRequest build() {
            return new CreatePlaceIndexRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
