/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.lexruntime.model.ContentType;
import software.amazon.awssdk.services.lexruntime.model.GenericAttachment;
import software.amazon.awssdk.services.lexruntime.model._genericAttachmentListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResponseCard
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResponseCard> {
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ResponseCard.getter(ResponseCard::version)).setter(ResponseCard.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ResponseCard.getter(ResponseCard::contentTypeAsString)).setter(ResponseCard.setter(Builder::contentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentType").build()}).build();
    private static final SdkField<List<GenericAttachment>> GENERIC_ATTACHMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ResponseCard.getter(ResponseCard::genericAttachments)).setter(ResponseCard.setter(Builder::genericAttachments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("genericAttachments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GenericAttachment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERSION_FIELD, CONTENT_TYPE_FIELD, GENERIC_ATTACHMENTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String version;
    private final String contentType;
    private final List<GenericAttachment> genericAttachments;

    private ResponseCard(BuilderImpl builder) {
        this.version = builder.version;
        this.contentType = builder.contentType;
        this.genericAttachments = builder.genericAttachments;
    }

    public String version() {
        return this.version;
    }

    public ContentType contentType() {
        return ContentType.fromValue(this.contentType);
    }

    public String contentTypeAsString() {
        return this.contentType;
    }

    public List<GenericAttachment> genericAttachments() {
        return this.genericAttachments;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.genericAttachments());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResponseCard)) {
            return false;
        }
        ResponseCard other = (ResponseCard)obj;
        return Objects.equals(this.version(), other.version()) && Objects.equals(this.contentTypeAsString(), other.contentTypeAsString()) && Objects.equals(this.genericAttachments(), other.genericAttachments());
    }

    public String toString() {
        return ToString.builder((String)"ResponseCard").add("Version", (Object)this.version()).add("ContentType", (Object)this.contentTypeAsString()).add("GenericAttachments", this.genericAttachments()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "contentType": {
                return Optional.ofNullable(clazz.cast(this.contentTypeAsString()));
            }
            case "genericAttachments": {
                return Optional.ofNullable(clazz.cast(this.genericAttachments()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResponseCard, T> g) {
        return obj -> g.apply((ResponseCard)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String version;
        private String contentType;
        private List<GenericAttachment> genericAttachments = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ResponseCard model) {
            this.version(model.version);
            this.contentType(model.contentType);
            this.genericAttachments(model.genericAttachments);
        }

        public final String getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final String getContentTypeAsString() {
            return this.contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        @Override
        public final Builder contentType(ContentType contentType) {
            this.contentType(contentType == null ? null : contentType.toString());
            return this;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public final Collection<GenericAttachment.Builder> getGenericAttachments() {
            return this.genericAttachments != null ? (Collection)this.genericAttachments.stream().map(GenericAttachment::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder genericAttachments(Collection<GenericAttachment> genericAttachments) {
            this.genericAttachments = _genericAttachmentListCopier.copy(genericAttachments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder genericAttachments(GenericAttachment ... genericAttachments) {
            this.genericAttachments(Arrays.asList(genericAttachments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder genericAttachments(Consumer<GenericAttachment.Builder> ... genericAttachments) {
            this.genericAttachments(Stream.of(genericAttachments).map(c -> (GenericAttachment)((GenericAttachment.Builder)GenericAttachment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setGenericAttachments(Collection<GenericAttachment.BuilderImpl> genericAttachments) {
            this.genericAttachments = _genericAttachmentListCopier.copyFromBuilder(genericAttachments);
        }

        public ResponseCard build() {
            return new ResponseCard(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResponseCard> {
        public Builder version(String var1);

        public Builder contentType(String var1);

        public Builder contentType(ContentType var1);

        public Builder genericAttachments(Collection<GenericAttachment> var1);

        public Builder genericAttachments(GenericAttachment ... var1);

        public Builder genericAttachments(Consumer<GenericAttachment.Builder> ... var1);
    }
}

