/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexruntime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PostTextRequest extends LexRuntimeRequest implements
        ToCopyableBuilder<PostTextRequest.Builder, PostTextRequest> {
    private static final SdkField<String> BOT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PostTextRequest::botName)).setter(setter(Builder::botName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("botName").build()).build();

    private static final SdkField<String> BOT_ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PostTextRequest::botAlias)).setter(setter(Builder::botAlias))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("botAlias").build()).build();

    private static final SdkField<String> USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PostTextRequest::userId)).setter(setter(Builder::userId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("userId").build()).build();

    private static final SdkField<Map<String, String>> SESSION_ATTRIBUTES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(PostTextRequest::sessionAttributes))
            .setter(setter(Builder::sessionAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionAttributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> REQUEST_ATTRIBUTES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(PostTextRequest::requestAttributes))
            .setter(setter(Builder::requestAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestAttributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> INPUT_TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PostTextRequest::inputText)).setter(setter(Builder::inputText))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputText").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_NAME_FIELD,
            BOT_ALIAS_FIELD, USER_ID_FIELD, SESSION_ATTRIBUTES_FIELD, REQUEST_ATTRIBUTES_FIELD, INPUT_TEXT_FIELD));

    private final String botName;

    private final String botAlias;

    private final String userId;

    private final Map<String, String> sessionAttributes;

    private final Map<String, String> requestAttributes;

    private final String inputText;

    private PostTextRequest(BuilderImpl builder) {
        super(builder);
        this.botName = builder.botName;
        this.botAlias = builder.botAlias;
        this.userId = builder.userId;
        this.sessionAttributes = builder.sessionAttributes;
        this.requestAttributes = builder.requestAttributes;
        this.inputText = builder.inputText;
    }

    /**
     * <p>
     * The name of the Amazon Lex bot.
     * </p>
     * 
     * @return The name of the Amazon Lex bot.
     */
    public String botName() {
        return botName;
    }

    /**
     * <p>
     * The alias of the Amazon Lex bot.
     * </p>
     * 
     * @return The alias of the Amazon Lex bot.
     */
    public String botAlias() {
        return botAlias;
    }

    /**
     * <p>
     * The ID of the client application user. Amazon Lex uses this to identify a user's conversation with your bot. At
     * runtime, each request must contain the <code>userID</code> field.
     * </p>
     * <p>
     * To decide the user ID to use for your application, consider the following factors.
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>userID</code> field must not contain any personally identifiable information of the user, for example,
     * name, personal identification numbers, or other end user personal information.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you want a user to start a conversation on one device and continue on another device, use a user-specific
     * identifier.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you want the same user to be able to have two independent conversations on two different devices, choose a
     * device-specific identifier.
     * </p>
     * </li>
     * <li>
     * <p>
     * A user can't have two independent conversations with two different versions of the same bot. For example, a user
     * can't have a conversation with the PROD and BETA versions of the same bot. If you anticipate that a user will
     * need to have conversation with two different versions, for example, while testing, include the bot alias in the
     * user ID to separate the two conversations.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The ID of the client application user. Amazon Lex uses this to identify a user's conversation with your
     *         bot. At runtime, each request must contain the <code>userID</code> field.</p>
     *         <p>
     *         To decide the user ID to use for your application, consider the following factors.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The <code>userID</code> field must not contain any personally identifiable information of the user, for
     *         example, name, personal identification numbers, or other end user personal information.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you want a user to start a conversation on one device and continue on another device, use a
     *         user-specific identifier.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you want the same user to be able to have two independent conversations on two different devices,
     *         choose a device-specific identifier.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A user can't have two independent conversations with two different versions of the same bot. For example,
     *         a user can't have a conversation with the PROD and BETA versions of the same bot. If you anticipate that
     *         a user will need to have conversation with two different versions, for example, while testing, include
     *         the bot alias in the user ID to separate the two conversations.
     *         </p>
     *         </li>
     */
    public String userId() {
        return userId;
    }

    /**
     * <p>
     * Application-specific information passed between Amazon Lex and a client application.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/lex/latest/dg/context-mgmt.html#context-mgmt-session-attribs">Setting Session
     * Attributes</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Application-specific information passed between Amazon Lex and a client application.</p>
     *         <p>
     *         For more information, see <a
     *         href="http://docs.aws.amazon.com/lex/latest/dg/context-mgmt.html#context-mgmt-session-attribs">Setting
     *         Session Attributes</a>.
     */
    public Map<String, String> sessionAttributes() {
        return sessionAttributes;
    }

    /**
     * <p>
     * Request-specific information passed between Amazon Lex and a client application.
     * </p>
     * <p>
     * The namespace <code>x-amz-lex:</code> is reserved for special attributes. Don't create any request attributes
     * with the prefix <code>x-amz-lex:</code>.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/lex/latest/dg/context-mgmt.html#context-mgmt-request-attribs">Setting Request
     * Attributes</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Request-specific information passed between Amazon Lex and a client application.</p>
     *         <p>
     *         The namespace <code>x-amz-lex:</code> is reserved for special attributes. Don't create any request
     *         attributes with the prefix <code>x-amz-lex:</code>.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="http://docs.aws.amazon.com/lex/latest/dg/context-mgmt.html#context-mgmt-request-attribs">Setting
     *         Request Attributes</a>.
     */
    public Map<String, String> requestAttributes() {
        return requestAttributes;
    }

    /**
     * <p>
     * The text that the user entered (Amazon Lex interprets this text).
     * </p>
     * 
     * @return The text that the user entered (Amazon Lex interprets this text).
     */
    public String inputText() {
        return inputText;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(botName());
        hashCode = 31 * hashCode + Objects.hashCode(botAlias());
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        hashCode = 31 * hashCode + Objects.hashCode(sessionAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(requestAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(inputText());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PostTextRequest)) {
            return false;
        }
        PostTextRequest other = (PostTextRequest) obj;
        return Objects.equals(botName(), other.botName()) && Objects.equals(botAlias(), other.botAlias())
                && Objects.equals(userId(), other.userId()) && Objects.equals(sessionAttributes(), other.sessionAttributes())
                && Objects.equals(requestAttributes(), other.requestAttributes())
                && Objects.equals(inputText(), other.inputText());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PostTextRequest").add("BotName", botName()).add("BotAlias", botAlias()).add("UserId", userId())
                .add("SessionAttributes", sessionAttributes() == null ? null : "*** Sensitive Data Redacted ***")
                .add("RequestAttributes", requestAttributes() == null ? null : "*** Sensitive Data Redacted ***")
                .add("InputText", inputText() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "botName":
            return Optional.ofNullable(clazz.cast(botName()));
        case "botAlias":
            return Optional.ofNullable(clazz.cast(botAlias()));
        case "userId":
            return Optional.ofNullable(clazz.cast(userId()));
        case "sessionAttributes":
            return Optional.ofNullable(clazz.cast(sessionAttributes()));
        case "requestAttributes":
            return Optional.ofNullable(clazz.cast(requestAttributes()));
        case "inputText":
            return Optional.ofNullable(clazz.cast(inputText()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PostTextRequest, T> g) {
        return obj -> g.apply((PostTextRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexRuntimeRequest.Builder, SdkPojo, CopyableBuilder<Builder, PostTextRequest> {
        /**
         * <p>
         * The name of the Amazon Lex bot.
         * </p>
         * 
         * @param botName
         *        The name of the Amazon Lex bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botName(String botName);

        /**
         * <p>
         * The alias of the Amazon Lex bot.
         * </p>
         * 
         * @param botAlias
         *        The alias of the Amazon Lex bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botAlias(String botAlias);

        /**
         * <p>
         * The ID of the client application user. Amazon Lex uses this to identify a user's conversation with your bot.
         * At runtime, each request must contain the <code>userID</code> field.
         * </p>
         * <p>
         * To decide the user ID to use for your application, consider the following factors.
         * </p>
         * <ul>
         * <li>
         * <p>
         * The <code>userID</code> field must not contain any personally identifiable information of the user, for
         * example, name, personal identification numbers, or other end user personal information.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you want a user to start a conversation on one device and continue on another device, use a user-specific
         * identifier.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you want the same user to be able to have two independent conversations on two different devices, choose a
         * device-specific identifier.
         * </p>
         * </li>
         * <li>
         * <p>
         * A user can't have two independent conversations with two different versions of the same bot. For example, a
         * user can't have a conversation with the PROD and BETA versions of the same bot. If you anticipate that a user
         * will need to have conversation with two different versions, for example, while testing, include the bot alias
         * in the user ID to separate the two conversations.
         * </p>
         * </li>
         * </ul>
         * 
         * @param userId
         *        The ID of the client application user. Amazon Lex uses this to identify a user's conversation with
         *        your bot. At runtime, each request must contain the <code>userID</code> field.</p>
         *        <p>
         *        To decide the user ID to use for your application, consider the following factors.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The <code>userID</code> field must not contain any personally identifiable information of the user,
         *        for example, name, personal identification numbers, or other end user personal information.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you want a user to start a conversation on one device and continue on another device, use a
         *        user-specific identifier.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you want the same user to be able to have two independent conversations on two different devices,
         *        choose a device-specific identifier.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        A user can't have two independent conversations with two different versions of the same bot. For
         *        example, a user can't have a conversation with the PROD and BETA versions of the same bot. If you
         *        anticipate that a user will need to have conversation with two different versions, for example, while
         *        testing, include the bot alias in the user ID to separate the two conversations.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);

        /**
         * <p>
         * Application-specific information passed between Amazon Lex and a client application.
         * </p>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/lex/latest/dg/context-mgmt.html#context-mgmt-session-attribs">Setting
         * Session Attributes</a>.
         * </p>
         * 
         * @param sessionAttributes
         *        Application-specific information passed between Amazon Lex and a client application.</p>
         *        <p>
         *        For more information, see <a
         *        href="http://docs.aws.amazon.com/lex/latest/dg/context-mgmt.html#context-mgmt-session-attribs">Setting
         *        Session Attributes</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionAttributes(Map<String, String> sessionAttributes);

        /**
         * <p>
         * Request-specific information passed between Amazon Lex and a client application.
         * </p>
         * <p>
         * The namespace <code>x-amz-lex:</code> is reserved for special attributes. Don't create any request attributes
         * with the prefix <code>x-amz-lex:</code>.
         * </p>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/lex/latest/dg/context-mgmt.html#context-mgmt-request-attribs">Setting
         * Request Attributes</a>.
         * </p>
         * 
         * @param requestAttributes
         *        Request-specific information passed between Amazon Lex and a client application.</p>
         *        <p>
         *        The namespace <code>x-amz-lex:</code> is reserved for special attributes. Don't create any request
         *        attributes with the prefix <code>x-amz-lex:</code>.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="http://docs.aws.amazon.com/lex/latest/dg/context-mgmt.html#context-mgmt-request-attribs">Setting
         *        Request Attributes</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestAttributes(Map<String, String> requestAttributes);

        /**
         * <p>
         * The text that the user entered (Amazon Lex interprets this text).
         * </p>
         * 
         * @param inputText
         *        The text that the user entered (Amazon Lex interprets this text).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputText(String inputText);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LexRuntimeRequest.BuilderImpl implements Builder {
        private String botName;

        private String botAlias;

        private String userId;

        private Map<String, String> sessionAttributes = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> requestAttributes = DefaultSdkAutoConstructMap.getInstance();

        private String inputText;

        private BuilderImpl() {
        }

        private BuilderImpl(PostTextRequest model) {
            super(model);
            botName(model.botName);
            botAlias(model.botAlias);
            userId(model.userId);
            sessionAttributes(model.sessionAttributes);
            requestAttributes(model.requestAttributes);
            inputText(model.inputText);
        }

        public final String getBotName() {
            return botName;
        }

        @Override
        public final Builder botName(String botName) {
            this.botName = botName;
            return this;
        }

        public final void setBotName(String botName) {
            this.botName = botName;
        }

        public final String getBotAlias() {
            return botAlias;
        }

        @Override
        public final Builder botAlias(String botAlias) {
            this.botAlias = botAlias;
            return this;
        }

        public final void setBotAlias(String botAlias) {
            this.botAlias = botAlias;
        }

        public final String getUserId() {
            return userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        public final Map<String, String> getSessionAttributes() {
            return sessionAttributes;
        }

        @Override
        public final Builder sessionAttributes(Map<String, String> sessionAttributes) {
            this.sessionAttributes = StringMapCopier.copy(sessionAttributes);
            return this;
        }

        public final void setSessionAttributes(Map<String, String> sessionAttributes) {
            this.sessionAttributes = StringMapCopier.copy(sessionAttributes);
        }

        public final Map<String, String> getRequestAttributes() {
            return requestAttributes;
        }

        @Override
        public final Builder requestAttributes(Map<String, String> requestAttributes) {
            this.requestAttributes = StringMapCopier.copy(requestAttributes);
            return this;
        }

        public final void setRequestAttributes(Map<String, String> requestAttributes) {
            this.requestAttributes = StringMapCopier.copy(requestAttributes);
        }

        public final String getInputText() {
            return inputText;
        }

        @Override
        public final Builder inputText(String inputText) {
            this.inputText = inputText;
            return this;
        }

        public final void setInputText(String inputText) {
            this.inputText = inputText;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PostTextRequest build() {
            return new PostTextRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
