/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexruntime.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DialogState {
    ELICIT_INTENT("ElicitIntent"),
    CONFIRM_INTENT("ConfirmIntent"),
    ELICIT_SLOT("ElicitSlot"),
    FULFILLED("Fulfilled"),
    READY_FOR_FULFILLMENT("ReadyForFulfillment"),
    FAILED("Failed"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DialogState> VALUE_MAP;
    private final String value;

    private DialogState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DialogState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DialogState> knownValues() {
        EnumSet<DialogState> knownValues = EnumSet.allOf(DialogState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DialogState.class, DialogState::toString);
    }
}

