/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lexruntime.model.Button;
import software.amazon.awssdk.services.lexruntime.model._listOfButtonsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GenericAttachment
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GenericAttachment> {
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("title").getter(GenericAttachment.getter(GenericAttachment::title)).setter(GenericAttachment.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()}).build();
    private static final SdkField<String> SUB_TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("subTitle").getter(GenericAttachment.getter(GenericAttachment::subTitle)).setter(GenericAttachment.setter(Builder::subTitle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subTitle").build()}).build();
    private static final SdkField<String> ATTACHMENT_LINK_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("attachmentLinkUrl").getter(GenericAttachment.getter(GenericAttachment::attachmentLinkUrl)).setter(GenericAttachment.setter(Builder::attachmentLinkUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attachmentLinkUrl").build()}).build();
    private static final SdkField<String> IMAGE_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("imageUrl").getter(GenericAttachment.getter(GenericAttachment::imageUrl)).setter(GenericAttachment.setter(Builder::imageUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageUrl").build()}).build();
    private static final SdkField<List<Button>> BUTTONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("buttons").getter(GenericAttachment.getter(GenericAttachment::buttons)).setter(GenericAttachment.setter(Builder::buttons)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("buttons").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Button::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TITLE_FIELD, SUB_TITLE_FIELD, ATTACHMENT_LINK_URL_FIELD, IMAGE_URL_FIELD, BUTTONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String title;
    private final String subTitle;
    private final String attachmentLinkUrl;
    private final String imageUrl;
    private final List<Button> buttons;

    private GenericAttachment(BuilderImpl builder) {
        this.title = builder.title;
        this.subTitle = builder.subTitle;
        this.attachmentLinkUrl = builder.attachmentLinkUrl;
        this.imageUrl = builder.imageUrl;
        this.buttons = builder.buttons;
    }

    public final String title() {
        return this.title;
    }

    public final String subTitle() {
        return this.subTitle;
    }

    public final String attachmentLinkUrl() {
        return this.attachmentLinkUrl;
    }

    public final String imageUrl() {
        return this.imageUrl;
    }

    public final boolean hasButtons() {
        return this.buttons != null && !(this.buttons instanceof SdkAutoConstructList);
    }

    public final List<Button> buttons() {
        return this.buttons;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.subTitle());
        hashCode = 31 * hashCode + Objects.hashCode(this.attachmentLinkUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasButtons() ? this.buttons() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenericAttachment)) {
            return false;
        }
        GenericAttachment other = (GenericAttachment)obj;
        return Objects.equals(this.title(), other.title()) && Objects.equals(this.subTitle(), other.subTitle()) && Objects.equals(this.attachmentLinkUrl(), other.attachmentLinkUrl()) && Objects.equals(this.imageUrl(), other.imageUrl()) && this.hasButtons() == other.hasButtons() && Objects.equals(this.buttons(), other.buttons());
    }

    public final String toString() {
        return ToString.builder((String)"GenericAttachment").add("Title", (Object)this.title()).add("SubTitle", (Object)this.subTitle()).add("AttachmentLinkUrl", (Object)this.attachmentLinkUrl()).add("ImageUrl", (Object)this.imageUrl()).add("Buttons", this.hasButtons() ? this.buttons() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "subTitle": {
                return Optional.ofNullable(clazz.cast(this.subTitle()));
            }
            case "attachmentLinkUrl": {
                return Optional.ofNullable(clazz.cast(this.attachmentLinkUrl()));
            }
            case "imageUrl": {
                return Optional.ofNullable(clazz.cast(this.imageUrl()));
            }
            case "buttons": {
                return Optional.ofNullable(clazz.cast(this.buttons()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GenericAttachment, T> g) {
        return obj -> g.apply((GenericAttachment)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String title;
        private String subTitle;
        private String attachmentLinkUrl;
        private String imageUrl;
        private List<Button> buttons = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GenericAttachment model) {
            this.title(model.title);
            this.subTitle(model.subTitle);
            this.attachmentLinkUrl(model.attachmentLinkUrl);
            this.imageUrl(model.imageUrl);
            this.buttons(model.buttons);
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getSubTitle() {
            return this.subTitle;
        }

        public final void setSubTitle(String subTitle) {
            this.subTitle = subTitle;
        }

        @Override
        public final Builder subTitle(String subTitle) {
            this.subTitle = subTitle;
            return this;
        }

        public final String getAttachmentLinkUrl() {
            return this.attachmentLinkUrl;
        }

        public final void setAttachmentLinkUrl(String attachmentLinkUrl) {
            this.attachmentLinkUrl = attachmentLinkUrl;
        }

        @Override
        public final Builder attachmentLinkUrl(String attachmentLinkUrl) {
            this.attachmentLinkUrl = attachmentLinkUrl;
            return this;
        }

        public final String getImageUrl() {
            return this.imageUrl;
        }

        public final void setImageUrl(String imageUrl) {
            this.imageUrl = imageUrl;
        }

        @Override
        public final Builder imageUrl(String imageUrl) {
            this.imageUrl = imageUrl;
            return this;
        }

        public final List<Button.Builder> getButtons() {
            List<Button.Builder> result = _listOfButtonsCopier.copyToBuilder(this.buttons);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setButtons(Collection<Button.BuilderImpl> buttons) {
            this.buttons = _listOfButtonsCopier.copyFromBuilder(buttons);
        }

        @Override
        public final Builder buttons(Collection<Button> buttons) {
            this.buttons = _listOfButtonsCopier.copy(buttons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder buttons(Button ... buttons) {
            this.buttons(Arrays.asList(buttons));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder buttons(Consumer<Button.Builder> ... buttons) {
            this.buttons(Stream.of(buttons).map(c -> (Button)((Button.Builder)Button.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public GenericAttachment build() {
            return new GenericAttachment(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GenericAttachment> {
        public Builder title(String var1);

        public Builder subTitle(String var1);

        public Builder attachmentLinkUrl(String var1);

        public Builder imageUrl(String var1);

        public Builder buttons(Collection<Button> var1);

        public Builder buttons(Button ... var1);

        public Builder buttons(Consumer<Button.Builder> ... var1);
    }
}

