/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexruntime;

import java.util.ArrayList;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.auth.signer.Aws4Signer;
import software.amazon.awssdk.awscore.client.builder.AwsDefaultClientBuilder;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkAdvancedClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.interceptor.ClasspathInterceptorChainFactory;
import software.amazon.awssdk.core.signer.Signer;
import software.amazon.awssdk.services.lexruntime.LexRuntimeBaseClientBuilder;
import software.amazon.awssdk.services.lexruntime.endpoints.LexRuntimeEndpointProvider;
import software.amazon.awssdk.services.lexruntime.endpoints.internal.LexRuntimeEndpointAuthSchemeInterceptor;
import software.amazon.awssdk.services.lexruntime.endpoints.internal.LexRuntimeRequestSetEndpointInterceptor;
import software.amazon.awssdk.services.lexruntime.endpoints.internal.LexRuntimeResolveEndpointInterceptor;
import software.amazon.awssdk.utils.CollectionUtils;

@SdkInternalApi
abstract class DefaultLexRuntimeBaseClientBuilder<B extends LexRuntimeBaseClientBuilder<B, C>, C>
extends AwsDefaultClientBuilder<B, C> {
    DefaultLexRuntimeBaseClientBuilder() {
    }

    protected final String serviceEndpointPrefix() {
        return "runtime.lex";
    }

    protected final String serviceName() {
        return "LexRuntime";
    }

    protected final SdkClientConfiguration mergeServiceDefaults(SdkClientConfiguration config) {
        return config.merge(c -> c.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)this.defaultEndpointProvider()).option((ClientOption)SdkAdvancedClientOption.SIGNER, (Object)this.defaultSigner()).option((ClientOption)SdkClientOption.CRC32_FROM_COMPRESSED_DATA_ENABLED, (Object)false));
    }

    protected final SdkClientConfiguration finalizeServiceConfiguration(SdkClientConfiguration config) {
        ArrayList<Object> endpointInterceptors = new ArrayList<Object>();
        endpointInterceptors.add(new LexRuntimeResolveEndpointInterceptor());
        endpointInterceptors.add(new LexRuntimeEndpointAuthSchemeInterceptor());
        endpointInterceptors.add(new LexRuntimeRequestSetEndpointInterceptor());
        ClasspathInterceptorChainFactory interceptorFactory = new ClasspathInterceptorChainFactory();
        List interceptors = interceptorFactory.getInterceptors("software/amazon/awssdk/services/lexruntime/execution.interceptors");
        ArrayList additionalInterceptors = new ArrayList();
        interceptors = CollectionUtils.mergeLists(endpointInterceptors, (List)interceptors);
        interceptors = CollectionUtils.mergeLists((List)interceptors, additionalInterceptors);
        interceptors = CollectionUtils.mergeLists((List)interceptors, (List)((List)config.option((ClientOption)SdkClientOption.EXECUTION_INTERCEPTORS)));
        return config.toBuilder().option((ClientOption)SdkClientOption.EXECUTION_INTERCEPTORS, (Object)interceptors).build();
    }

    private Signer defaultSigner() {
        return Aws4Signer.create();
    }

    protected final String signingName() {
        return "lex";
    }

    private LexRuntimeEndpointProvider defaultEndpointProvider() {
        return LexRuntimeEndpointProvider.defaultProvider();
    }
}

