/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexruntime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteSessionRequest extends LexRuntimeRequest implements
        ToCopyableBuilder<DeleteSessionRequest.Builder, DeleteSessionRequest> {
    private static final SdkField<String> BOT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botName").getter(getter(DeleteSessionRequest::botName)).setter(setter(Builder::botName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("botName").build()).build();

    private static final SdkField<String> BOT_ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botAlias").getter(getter(DeleteSessionRequest::botAlias)).setter(setter(Builder::botAlias))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("botAlias").build()).build();

    private static final SdkField<String> USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("userId")
            .getter(getter(DeleteSessionRequest::userId)).setter(setter(Builder::userId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("userId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_NAME_FIELD,
            BOT_ALIAS_FIELD, USER_ID_FIELD));

    private final String botName;

    private final String botAlias;

    private final String userId;

    private DeleteSessionRequest(BuilderImpl builder) {
        super(builder);
        this.botName = builder.botName;
        this.botAlias = builder.botAlias;
        this.userId = builder.userId;
    }

    /**
     * <p>
     * The name of the bot that contains the session data.
     * </p>
     * 
     * @return The name of the bot that contains the session data.
     */
    public final String botName() {
        return botName;
    }

    /**
     * <p>
     * The alias in use for the bot that contains the session data.
     * </p>
     * 
     * @return The alias in use for the bot that contains the session data.
     */
    public final String botAlias() {
        return botAlias;
    }

    /**
     * <p>
     * The identifier of the user associated with the session data.
     * </p>
     * 
     * @return The identifier of the user associated with the session data.
     */
    public final String userId() {
        return userId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(botName());
        hashCode = 31 * hashCode + Objects.hashCode(botAlias());
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteSessionRequest)) {
            return false;
        }
        DeleteSessionRequest other = (DeleteSessionRequest) obj;
        return Objects.equals(botName(), other.botName()) && Objects.equals(botAlias(), other.botAlias())
                && Objects.equals(userId(), other.userId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteSessionRequest").add("BotName", botName()).add("BotAlias", botAlias())
                .add("UserId", userId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "botName":
            return Optional.ofNullable(clazz.cast(botName()));
        case "botAlias":
            return Optional.ofNullable(clazz.cast(botAlias()));
        case "userId":
            return Optional.ofNullable(clazz.cast(userId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteSessionRequest, T> g) {
        return obj -> g.apply((DeleteSessionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexRuntimeRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteSessionRequest> {
        /**
         * <p>
         * The name of the bot that contains the session data.
         * </p>
         * 
         * @param botName
         *        The name of the bot that contains the session data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botName(String botName);

        /**
         * <p>
         * The alias in use for the bot that contains the session data.
         * </p>
         * 
         * @param botAlias
         *        The alias in use for the bot that contains the session data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botAlias(String botAlias);

        /**
         * <p>
         * The identifier of the user associated with the session data.
         * </p>
         * 
         * @param userId
         *        The identifier of the user associated with the session data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LexRuntimeRequest.BuilderImpl implements Builder {
        private String botName;

        private String botAlias;

        private String userId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteSessionRequest model) {
            super(model);
            botName(model.botName);
            botAlias(model.botAlias);
            userId(model.userId);
        }

        public final String getBotName() {
            return botName;
        }

        @Override
        public final Builder botName(String botName) {
            this.botName = botName;
            return this;
        }

        public final void setBotName(String botName) {
            this.botName = botName;
        }

        public final String getBotAlias() {
            return botAlias;
        }

        @Override
        public final Builder botAlias(String botAlias) {
            this.botAlias = botAlias;
            return this;
        }

        public final void setBotAlias(String botAlias) {
            this.botAlias = botAlias;
        }

        public final String getUserId() {
            return userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteSessionRequest build() {
            return new DeleteSessionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
