/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexruntime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.JsonValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutSessionResponse extends LexRuntimeResponse implements
        ToCopyableBuilder<PutSessionResponse.Builder, PutSessionResponse> {
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("contentType").getter(getter(PutSessionResponse::contentType)).setter(setter(Builder::contentType))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Content-Type").build()).build();

    private static final SdkField<String> INTENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("intentName").getter(getter(PutSessionResponse::intentName)).setter(setter(Builder::intentName))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-lex-intent-name").build())
            .build();

    private static final SdkField<String> SLOTS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("slots")
            .getter(getter(PutSessionResponse::slots))
            .setter(setter(Builder::slots))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-lex-slots").build(),
                    JsonValueTrait.create()).build();

    private static final SdkField<String> SESSION_ATTRIBUTES_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("sessionAttributes")
            .getter(getter(PutSessionResponse::sessionAttributes))
            .setter(setter(Builder::sessionAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-lex-session-attributes")
                    .build(), JsonValueTrait.create()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("message")
            .getter(getter(PutSessionResponse::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-lex-message").build()).build();

    private static final SdkField<String> ENCODED_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("encodedMessage").getter(getter(PutSessionResponse::encodedMessage))
            .setter(setter(Builder::encodedMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-lex-encoded-message").build())
            .build();

    private static final SdkField<String> MESSAGE_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("messageFormat").getter(getter(PutSessionResponse::messageFormatAsString))
            .setter(setter(Builder::messageFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-lex-message-format").build())
            .build();

    private static final SdkField<String> DIALOG_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dialogState").getter(getter(PutSessionResponse::dialogStateAsString))
            .setter(setter(Builder::dialogState))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-lex-dialog-state").build())
            .build();

    private static final SdkField<String> SLOT_TO_ELICIT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("slotToElicit").getter(getter(PutSessionResponse::slotToElicit)).setter(setter(Builder::slotToElicit))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-lex-slot-to-elicit").build())
            .build();

    private static final SdkField<String> SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionId").getter(getter(PutSessionResponse::sessionId)).setter(setter(Builder::sessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-lex-session-id").build())
            .build();

    private static final SdkField<String> ACTIVE_CONTEXTS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("activeContexts")
            .getter(getter(PutSessionResponse::activeContexts))
            .setter(setter(Builder::activeContexts))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-lex-active-contexts").build(),
                    JsonValueTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_TYPE_FIELD,
            INTENT_NAME_FIELD, SLOTS_FIELD, SESSION_ATTRIBUTES_FIELD, MESSAGE_FIELD, ENCODED_MESSAGE_FIELD, MESSAGE_FORMAT_FIELD,
            DIALOG_STATE_FIELD, SLOT_TO_ELICIT_FIELD, SESSION_ID_FIELD, ACTIVE_CONTEXTS_FIELD));

    private final String contentType;

    private final String intentName;

    private final String slots;

    private final String sessionAttributes;

    private final String message;

    private final String encodedMessage;

    private final String messageFormat;

    private final String dialogState;

    private final String slotToElicit;

    private final String sessionId;

    private final String activeContexts;

    private PutSessionResponse(BuilderImpl builder) {
        super(builder);
        this.contentType = builder.contentType;
        this.intentName = builder.intentName;
        this.slots = builder.slots;
        this.sessionAttributes = builder.sessionAttributes;
        this.message = builder.message;
        this.encodedMessage = builder.encodedMessage;
        this.messageFormat = builder.messageFormat;
        this.dialogState = builder.dialogState;
        this.slotToElicit = builder.slotToElicit;
        this.sessionId = builder.sessionId;
        this.activeContexts = builder.activeContexts;
    }

    /**
     * <p>
     * Content type as specified in the <code>Accept</code> HTTP header in the request.
     * </p>
     * 
     * @return Content type as specified in the <code>Accept</code> HTTP header in the request.
     */
    public final String contentType() {
        return contentType;
    }

    /**
     * <p>
     * The name of the current intent.
     * </p>
     * 
     * @return The name of the current intent.
     */
    public final String intentName() {
        return intentName;
    }

    /**
     * <p>
     * Map of zero or more intent slots Amazon Lex detected from the user input during the conversation.
     * </p>
     * <p>
     * Amazon Lex creates a resolution list containing likely values for a slot. The value that it returns is determined
     * by the <code>valueSelectionStrategy</code> selected when the slot type was created or updated. If
     * <code>valueSelectionStrategy</code> is set to <code>ORIGINAL_VALUE</code>, the value provided by the user is
     * returned, if the user value is similar to the slot values. If <code>valueSelectionStrategy</code> is set to
     * <code>TOP_RESOLUTION</code> Amazon Lex returns the first value in the resolution list or, if there is no
     * resolution list, null. If you don't specify a <code>valueSelectionStrategy</code> the default is
     * <code>ORIGINAL_VALUE</code>.
     * </p>
     * 
     * @return Map of zero or more intent slots Amazon Lex detected from the user input during the conversation.</p>
     *         <p>
     *         Amazon Lex creates a resolution list containing likely values for a slot. The value that it returns is
     *         determined by the <code>valueSelectionStrategy</code> selected when the slot type was created or updated.
     *         If <code>valueSelectionStrategy</code> is set to <code>ORIGINAL_VALUE</code>, the value provided by the
     *         user is returned, if the user value is similar to the slot values. If <code>valueSelectionStrategy</code>
     *         is set to <code>TOP_RESOLUTION</code> Amazon Lex returns the first value in the resolution list or, if
     *         there is no resolution list, null. If you don't specify a <code>valueSelectionStrategy</code> the default
     *         is <code>ORIGINAL_VALUE</code>.
     */
    public final String slots() {
        return slots;
    }

    /**
     * <p>
     * Map of key/value pairs representing session-specific context information.
     * </p>
     * 
     * @return Map of key/value pairs representing session-specific context information.
     */
    public final String sessionAttributes() {
        return sessionAttributes;
    }

    /**
     * <p>
     * The next message that should be presented to the user.
     * </p>
     * <p>
     * You can only use this field in the de-DE, en-AU, en-GB, en-US, es-419, es-ES, es-US, fr-CA, fr-FR, and it-IT
     * locales. In all other locales, the <code>message</code> field is null. You should use the
     * <code>encodedMessage</code> field instead.
     * </p>
     * 
     * @return The next message that should be presented to the user.</p>
     *         <p>
     *         You can only use this field in the de-DE, en-AU, en-GB, en-US, es-419, es-ES, es-US, fr-CA, fr-FR, and
     *         it-IT locales. In all other locales, the <code>message</code> field is null. You should use the
     *         <code>encodedMessage</code> field instead.
     */
    public final String message() {
        return message;
    }

    /**
     * <p>
     * The next message that should be presented to the user.
     * </p>
     * <p>
     * The <code>encodedMessage</code> field is base-64 encoded. You must decode the field before you can use the value.
     * </p>
     * 
     * @return The next message that should be presented to the user.</p>
     *         <p>
     *         The <code>encodedMessage</code> field is base-64 encoded. You must decode the field before you can use
     *         the value.
     */
    public final String encodedMessage() {
        return encodedMessage;
    }

    /**
     * <p>
     * The format of the response message. One of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PlainText</code> - The message contains plain UTF-8 text.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CustomPayload</code> - The message is a custom format for the client.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SSML</code> - The message contains text formatted for voice output.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Composite</code> - The message contains an escaped JSON object containing one or more messages from the
     * groups that messages were assigned to when the intent was created.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #messageFormat}
     * will return {@link MessageFormatType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #messageFormatAsString}.
     * </p>
     * 
     * @return The format of the response message. One of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PlainText</code> - The message contains plain UTF-8 text.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CustomPayload</code> - The message is a custom format for the client.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SSML</code> - The message contains text formatted for voice output.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Composite</code> - The message contains an escaped JSON object containing one or more messages from
     *         the groups that messages were assigned to when the intent was created.
     *         </p>
     *         </li>
     * @see MessageFormatType
     */
    public final MessageFormatType messageFormat() {
        return MessageFormatType.fromValue(messageFormat);
    }

    /**
     * <p>
     * The format of the response message. One of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PlainText</code> - The message contains plain UTF-8 text.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CustomPayload</code> - The message is a custom format for the client.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SSML</code> - The message contains text formatted for voice output.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Composite</code> - The message contains an escaped JSON object containing one or more messages from the
     * groups that messages were assigned to when the intent was created.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #messageFormat}
     * will return {@link MessageFormatType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #messageFormatAsString}.
     * </p>
     * 
     * @return The format of the response message. One of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PlainText</code> - The message contains plain UTF-8 text.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CustomPayload</code> - The message is a custom format for the client.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SSML</code> - The message contains text formatted for voice output.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Composite</code> - The message contains an escaped JSON object containing one or more messages from
     *         the groups that messages were assigned to when the intent was created.
     *         </p>
     *         </li>
     * @see MessageFormatType
     */
    public final String messageFormatAsString() {
        return messageFormat;
    }

    /**
     * <p/>
     * <ul>
     * <li>
     * <p>
     * <code>ConfirmIntent</code> - Amazon Lex is expecting a "yes" or "no" response to confirm the intent before
     * fulfilling an intent.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ElicitIntent</code> - Amazon Lex wants to elicit the user's intent.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ElicitSlot</code> - Amazon Lex is expecting the value of a slot for the current intent.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Failed</code> - Conveys that the conversation with the user has failed. This can happen for various
     * reasons, including the user does not provide an appropriate response to prompts from the service, or if the
     * Lambda function fails to fulfill the intent.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Fulfilled</code> - Conveys that the Lambda function has sucessfully fulfilled the intent.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ReadyForFulfillment</code> - Conveys that the client has to fulfill the intent.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dialogState} will
     * return {@link DialogState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dialogStateAsString}.
     * </p>
     * 
     * @return <ul>
     *         <li>
     *         <p>
     *         <code>ConfirmIntent</code> - Amazon Lex is expecting a "yes" or "no" response to confirm the intent
     *         before fulfilling an intent.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ElicitIntent</code> - Amazon Lex wants to elicit the user's intent.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ElicitSlot</code> - Amazon Lex is expecting the value of a slot for the current intent.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Failed</code> - Conveys that the conversation with the user has failed. This can happen for various
     *         reasons, including the user does not provide an appropriate response to prompts from the service, or if
     *         the Lambda function fails to fulfill the intent.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Fulfilled</code> - Conveys that the Lambda function has sucessfully fulfilled the intent.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ReadyForFulfillment</code> - Conveys that the client has to fulfill the intent.
     *         </p>
     *         </li>
     * @see DialogState
     */
    public final DialogState dialogState() {
        return DialogState.fromValue(dialogState);
    }

    /**
     * <p/>
     * <ul>
     * <li>
     * <p>
     * <code>ConfirmIntent</code> - Amazon Lex is expecting a "yes" or "no" response to confirm the intent before
     * fulfilling an intent.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ElicitIntent</code> - Amazon Lex wants to elicit the user's intent.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ElicitSlot</code> - Amazon Lex is expecting the value of a slot for the current intent.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Failed</code> - Conveys that the conversation with the user has failed. This can happen for various
     * reasons, including the user does not provide an appropriate response to prompts from the service, or if the
     * Lambda function fails to fulfill the intent.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Fulfilled</code> - Conveys that the Lambda function has sucessfully fulfilled the intent.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ReadyForFulfillment</code> - Conveys that the client has to fulfill the intent.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dialogState} will
     * return {@link DialogState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dialogStateAsString}.
     * </p>
     * 
     * @return <ul>
     *         <li>
     *         <p>
     *         <code>ConfirmIntent</code> - Amazon Lex is expecting a "yes" or "no" response to confirm the intent
     *         before fulfilling an intent.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ElicitIntent</code> - Amazon Lex wants to elicit the user's intent.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ElicitSlot</code> - Amazon Lex is expecting the value of a slot for the current intent.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Failed</code> - Conveys that the conversation with the user has failed. This can happen for various
     *         reasons, including the user does not provide an appropriate response to prompts from the service, or if
     *         the Lambda function fails to fulfill the intent.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Fulfilled</code> - Conveys that the Lambda function has sucessfully fulfilled the intent.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ReadyForFulfillment</code> - Conveys that the client has to fulfill the intent.
     *         </p>
     *         </li>
     * @see DialogState
     */
    public final String dialogStateAsString() {
        return dialogState;
    }

    /**
     * <p>
     * If the <code>dialogState</code> is <code>ElicitSlot</code>, returns the name of the slot for which Amazon Lex is
     * eliciting a value.
     * </p>
     * 
     * @return If the <code>dialogState</code> is <code>ElicitSlot</code>, returns the name of the slot for which Amazon
     *         Lex is eliciting a value.
     */
    public final String slotToElicit() {
        return slotToElicit;
    }

    /**
     * <p>
     * A unique identifier for the session.
     * </p>
     * 
     * @return A unique identifier for the session.
     */
    public final String sessionId() {
        return sessionId;
    }

    /**
     * <p>
     * A list of active contexts for the session.
     * </p>
     * 
     * @return A list of active contexts for the session.
     */
    public final String activeContexts() {
        return activeContexts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(contentType());
        hashCode = 31 * hashCode + Objects.hashCode(intentName());
        hashCode = 31 * hashCode + Objects.hashCode(slots());
        hashCode = 31 * hashCode + Objects.hashCode(sessionAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(encodedMessage());
        hashCode = 31 * hashCode + Objects.hashCode(messageFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dialogStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(slotToElicit());
        hashCode = 31 * hashCode + Objects.hashCode(sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(activeContexts());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutSessionResponse)) {
            return false;
        }
        PutSessionResponse other = (PutSessionResponse) obj;
        return Objects.equals(contentType(), other.contentType()) && Objects.equals(intentName(), other.intentName())
                && Objects.equals(slots(), other.slots()) && Objects.equals(sessionAttributes(), other.sessionAttributes())
                && Objects.equals(message(), other.message()) && Objects.equals(encodedMessage(), other.encodedMessage())
                && Objects.equals(messageFormatAsString(), other.messageFormatAsString())
                && Objects.equals(dialogStateAsString(), other.dialogStateAsString())
                && Objects.equals(slotToElicit(), other.slotToElicit()) && Objects.equals(sessionId(), other.sessionId())
                && Objects.equals(activeContexts(), other.activeContexts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutSessionResponse").add("ContentType", contentType()).add("IntentName", intentName())
                .add("Slots", slots()).add("SessionAttributes", sessionAttributes())
                .add("Message", message() == null ? null : "*** Sensitive Data Redacted ***")
                .add("EncodedMessage", encodedMessage() == null ? null : "*** Sensitive Data Redacted ***")
                .add("MessageFormat", messageFormatAsString()).add("DialogState", dialogStateAsString())
                .add("SlotToElicit", slotToElicit()).add("SessionId", sessionId())
                .add("ActiveContexts", activeContexts() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "contentType":
            return Optional.ofNullable(clazz.cast(contentType()));
        case "intentName":
            return Optional.ofNullable(clazz.cast(intentName()));
        case "slots":
            return Optional.ofNullable(clazz.cast(slots()));
        case "sessionAttributes":
            return Optional.ofNullable(clazz.cast(sessionAttributes()));
        case "message":
            return Optional.ofNullable(clazz.cast(message()));
        case "encodedMessage":
            return Optional.ofNullable(clazz.cast(encodedMessage()));
        case "messageFormat":
            return Optional.ofNullable(clazz.cast(messageFormatAsString()));
        case "dialogState":
            return Optional.ofNullable(clazz.cast(dialogStateAsString()));
        case "slotToElicit":
            return Optional.ofNullable(clazz.cast(slotToElicit()));
        case "sessionId":
            return Optional.ofNullable(clazz.cast(sessionId()));
        case "activeContexts":
            return Optional.ofNullable(clazz.cast(activeContexts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutSessionResponse, T> g) {
        return obj -> g.apply((PutSessionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexRuntimeResponse.Builder, SdkPojo, CopyableBuilder<Builder, PutSessionResponse> {
        /**
         * <p>
         * Content type as specified in the <code>Accept</code> HTTP header in the request.
         * </p>
         * 
         * @param contentType
         *        Content type as specified in the <code>Accept</code> HTTP header in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentType(String contentType);

        /**
         * <p>
         * The name of the current intent.
         * </p>
         * 
         * @param intentName
         *        The name of the current intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intentName(String intentName);

        /**
         * <p>
         * Map of zero or more intent slots Amazon Lex detected from the user input during the conversation.
         * </p>
         * <p>
         * Amazon Lex creates a resolution list containing likely values for a slot. The value that it returns is
         * determined by the <code>valueSelectionStrategy</code> selected when the slot type was created or updated. If
         * <code>valueSelectionStrategy</code> is set to <code>ORIGINAL_VALUE</code>, the value provided by the user is
         * returned, if the user value is similar to the slot values. If <code>valueSelectionStrategy</code> is set to
         * <code>TOP_RESOLUTION</code> Amazon Lex returns the first value in the resolution list or, if there is no
         * resolution list, null. If you don't specify a <code>valueSelectionStrategy</code> the default is
         * <code>ORIGINAL_VALUE</code>.
         * </p>
         * 
         * @param slots
         *        Map of zero or more intent slots Amazon Lex detected from the user input during the conversation.</p>
         *        <p>
         *        Amazon Lex creates a resolution list containing likely values for a slot. The value that it returns is
         *        determined by the <code>valueSelectionStrategy</code> selected when the slot type was created or
         *        updated. If <code>valueSelectionStrategy</code> is set to <code>ORIGINAL_VALUE</code>, the value
         *        provided by the user is returned, if the user value is similar to the slot values. If
         *        <code>valueSelectionStrategy</code> is set to <code>TOP_RESOLUTION</code> Amazon Lex returns the first
         *        value in the resolution list or, if there is no resolution list, null. If you don't specify a
         *        <code>valueSelectionStrategy</code> the default is <code>ORIGINAL_VALUE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slots(String slots);

        /**
         * <p>
         * Map of key/value pairs representing session-specific context information.
         * </p>
         * 
         * @param sessionAttributes
         *        Map of key/value pairs representing session-specific context information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionAttributes(String sessionAttributes);

        /**
         * <p>
         * The next message that should be presented to the user.
         * </p>
         * <p>
         * You can only use this field in the de-DE, en-AU, en-GB, en-US, es-419, es-ES, es-US, fr-CA, fr-FR, and it-IT
         * locales. In all other locales, the <code>message</code> field is null. You should use the
         * <code>encodedMessage</code> field instead.
         * </p>
         * 
         * @param message
         *        The next message that should be presented to the user.</p>
         *        <p>
         *        You can only use this field in the de-DE, en-AU, en-GB, en-US, es-419, es-ES, es-US, fr-CA, fr-FR, and
         *        it-IT locales. In all other locales, the <code>message</code> field is null. You should use the
         *        <code>encodedMessage</code> field instead.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The next message that should be presented to the user.
         * </p>
         * <p>
         * The <code>encodedMessage</code> field is base-64 encoded. You must decode the field before you can use the
         * value.
         * </p>
         * 
         * @param encodedMessage
         *        The next message that should be presented to the user.</p>
         *        <p>
         *        The <code>encodedMessage</code> field is base-64 encoded. You must decode the field before you can use
         *        the value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encodedMessage(String encodedMessage);

        /**
         * <p>
         * The format of the response message. One of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PlainText</code> - The message contains plain UTF-8 text.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CustomPayload</code> - The message is a custom format for the client.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SSML</code> - The message contains text formatted for voice output.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Composite</code> - The message contains an escaped JSON object containing one or more messages from the
         * groups that messages were assigned to when the intent was created.
         * </p>
         * </li>
         * </ul>
         * 
         * @param messageFormat
         *        The format of the response message. One of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PlainText</code> - The message contains plain UTF-8 text.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CustomPayload</code> - The message is a custom format for the client.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SSML</code> - The message contains text formatted for voice output.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Composite</code> - The message contains an escaped JSON object containing one or more messages
         *        from the groups that messages were assigned to when the intent was created.
         *        </p>
         *        </li>
         * @see MessageFormatType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MessageFormatType
         */
        Builder messageFormat(String messageFormat);

        /**
         * <p>
         * The format of the response message. One of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PlainText</code> - The message contains plain UTF-8 text.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CustomPayload</code> - The message is a custom format for the client.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SSML</code> - The message contains text formatted for voice output.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Composite</code> - The message contains an escaped JSON object containing one or more messages from the
         * groups that messages were assigned to when the intent was created.
         * </p>
         * </li>
         * </ul>
         * 
         * @param messageFormat
         *        The format of the response message. One of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PlainText</code> - The message contains plain UTF-8 text.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CustomPayload</code> - The message is a custom format for the client.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SSML</code> - The message contains text formatted for voice output.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Composite</code> - The message contains an escaped JSON object containing one or more messages
         *        from the groups that messages were assigned to when the intent was created.
         *        </p>
         *        </li>
         * @see MessageFormatType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MessageFormatType
         */
        Builder messageFormat(MessageFormatType messageFormat);

        /**
         * <p/>
         * <ul>
         * <li>
         * <p>
         * <code>ConfirmIntent</code> - Amazon Lex is expecting a "yes" or "no" response to confirm the intent before
         * fulfilling an intent.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ElicitIntent</code> - Amazon Lex wants to elicit the user's intent.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ElicitSlot</code> - Amazon Lex is expecting the value of a slot for the current intent.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Failed</code> - Conveys that the conversation with the user has failed. This can happen for various
         * reasons, including the user does not provide an appropriate response to prompts from the service, or if the
         * Lambda function fails to fulfill the intent.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Fulfilled</code> - Conveys that the Lambda function has sucessfully fulfilled the intent.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ReadyForFulfillment</code> - Conveys that the client has to fulfill the intent.
         * </p>
         * </li>
         * </ul>
         * 
         * @param dialogState
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ConfirmIntent</code> - Amazon Lex is expecting a "yes" or "no" response to confirm the intent
         *        before fulfilling an intent.
         *        </p>
         *        </li> <li>
         *        <p>
         *        <code>ElicitIntent</code> - Amazon Lex wants to elicit the user's intent.
         *        </p>
         *        </li> <li>
         *        <p>
         *        <code>ElicitSlot</code> - Amazon Lex is expecting the value of a slot for the current intent.
         *        </p>
         *        </li> <li>
         *        <p>
         *        <code>Failed</code> - Conveys that the conversation with the user has failed. This can happen for
         *        various reasons, including the user does not provide an appropriate response to prompts from the
         *        service, or if the Lambda function fails to fulfill the intent.
         *        </p>
         *        </li> <li>
         *        <p>
         *        <code>Fulfilled</code> - Conveys that the Lambda function has sucessfully fulfilled the intent.
         *        </p>
         *        </li> <li>
         *        <p>
         *        <code>ReadyForFulfillment</code> - Conveys that the client has to fulfill the intent.
         *        </p>
         *        </li>
         * @see DialogState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DialogState
         */
        Builder dialogState(String dialogState);

        /**
         * <p/>
         * <ul>
         * <li>
         * <p>
         * <code>ConfirmIntent</code> - Amazon Lex is expecting a "yes" or "no" response to confirm the intent before
         * fulfilling an intent.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ElicitIntent</code> - Amazon Lex wants to elicit the user's intent.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ElicitSlot</code> - Amazon Lex is expecting the value of a slot for the current intent.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Failed</code> - Conveys that the conversation with the user has failed. This can happen for various
         * reasons, including the user does not provide an appropriate response to prompts from the service, or if the
         * Lambda function fails to fulfill the intent.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Fulfilled</code> - Conveys that the Lambda function has sucessfully fulfilled the intent.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ReadyForFulfillment</code> - Conveys that the client has to fulfill the intent.
         * </p>
         * </li>
         * </ul>
         * 
         * @param dialogState
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ConfirmIntent</code> - Amazon Lex is expecting a "yes" or "no" response to confirm the intent
         *        before fulfilling an intent.
         *        </p>
         *        </li> <li>
         *        <p>
         *        <code>ElicitIntent</code> - Amazon Lex wants to elicit the user's intent.
         *        </p>
         *        </li> <li>
         *        <p>
         *        <code>ElicitSlot</code> - Amazon Lex is expecting the value of a slot for the current intent.
         *        </p>
         *        </li> <li>
         *        <p>
         *        <code>Failed</code> - Conveys that the conversation with the user has failed. This can happen for
         *        various reasons, including the user does not provide an appropriate response to prompts from the
         *        service, or if the Lambda function fails to fulfill the intent.
         *        </p>
         *        </li> <li>
         *        <p>
         *        <code>Fulfilled</code> - Conveys that the Lambda function has sucessfully fulfilled the intent.
         *        </p>
         *        </li> <li>
         *        <p>
         *        <code>ReadyForFulfillment</code> - Conveys that the client has to fulfill the intent.
         *        </p>
         *        </li>
         * @see DialogState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DialogState
         */
        Builder dialogState(DialogState dialogState);

        /**
         * <p>
         * If the <code>dialogState</code> is <code>ElicitSlot</code>, returns the name of the slot for which Amazon Lex
         * is eliciting a value.
         * </p>
         * 
         * @param slotToElicit
         *        If the <code>dialogState</code> is <code>ElicitSlot</code>, returns the name of the slot for which
         *        Amazon Lex is eliciting a value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slotToElicit(String slotToElicit);

        /**
         * <p>
         * A unique identifier for the session.
         * </p>
         * 
         * @param sessionId
         *        A unique identifier for the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionId(String sessionId);

        /**
         * <p>
         * A list of active contexts for the session.
         * </p>
         * 
         * @param activeContexts
         *        A list of active contexts for the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeContexts(String activeContexts);
    }

    static final class BuilderImpl extends LexRuntimeResponse.BuilderImpl implements Builder {
        private String contentType;

        private String intentName;

        private String slots;

        private String sessionAttributes;

        private String message;

        private String encodedMessage;

        private String messageFormat;

        private String dialogState;

        private String slotToElicit;

        private String sessionId;

        private String activeContexts;

        private BuilderImpl() {
        }

        private BuilderImpl(PutSessionResponse model) {
            super(model);
            contentType(model.contentType);
            intentName(model.intentName);
            slots(model.slots);
            sessionAttributes(model.sessionAttributes);
            message(model.message);
            encodedMessage(model.encodedMessage);
            messageFormat(model.messageFormat);
            dialogState(model.dialogState);
            slotToElicit(model.slotToElicit);
            sessionId(model.sessionId);
            activeContexts(model.activeContexts);
        }

        public final String getContentType() {
            return contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public final String getIntentName() {
            return intentName;
        }

        @Override
        public final Builder intentName(String intentName) {
            this.intentName = intentName;
            return this;
        }

        public final void setIntentName(String intentName) {
            this.intentName = intentName;
        }

        public final String getSlots() {
            return slots;
        }

        @Override
        public final Builder slots(String slots) {
            this.slots = slots;
            return this;
        }

        public final void setSlots(String slots) {
            this.slots = slots;
        }

        public final String getSessionAttributes() {
            return sessionAttributes;
        }

        @Override
        public final Builder sessionAttributes(String sessionAttributes) {
            this.sessionAttributes = sessionAttributes;
            return this;
        }

        public final void setSessionAttributes(String sessionAttributes) {
            this.sessionAttributes = sessionAttributes;
        }

        public final String getMessage() {
            return message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final String getEncodedMessage() {
            return encodedMessage;
        }

        @Override
        public final Builder encodedMessage(String encodedMessage) {
            this.encodedMessage = encodedMessage;
            return this;
        }

        public final void setEncodedMessage(String encodedMessage) {
            this.encodedMessage = encodedMessage;
        }

        public final String getMessageFormat() {
            return messageFormat;
        }

        @Override
        public final Builder messageFormat(String messageFormat) {
            this.messageFormat = messageFormat;
            return this;
        }

        @Override
        public final Builder messageFormat(MessageFormatType messageFormat) {
            this.messageFormat(messageFormat == null ? null : messageFormat.toString());
            return this;
        }

        public final void setMessageFormat(String messageFormat) {
            this.messageFormat = messageFormat;
        }

        public final String getDialogState() {
            return dialogState;
        }

        @Override
        public final Builder dialogState(String dialogState) {
            this.dialogState = dialogState;
            return this;
        }

        @Override
        public final Builder dialogState(DialogState dialogState) {
            this.dialogState(dialogState == null ? null : dialogState.toString());
            return this;
        }

        public final void setDialogState(String dialogState) {
            this.dialogState = dialogState;
        }

        public final String getSlotToElicit() {
            return slotToElicit;
        }

        @Override
        public final Builder slotToElicit(String slotToElicit) {
            this.slotToElicit = slotToElicit;
            return this;
        }

        public final void setSlotToElicit(String slotToElicit) {
            this.slotToElicit = slotToElicit;
        }

        public final String getSessionId() {
            return sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        public final String getActiveContexts() {
            return activeContexts;
        }

        @Override
        public final Builder activeContexts(String activeContexts) {
            this.activeContexts = activeContexts;
            return this;
        }

        public final void setActiveContexts(String activeContexts) {
            this.activeContexts = activeContexts;
        }

        @Override
        public PutSessionResponse build() {
            return new PutSessionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
