/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexruntime.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutSessionRequest extends LexRuntimeRequest implements
        ToCopyableBuilder<PutSessionRequest.Builder, PutSessionRequest> {
    private static final SdkField<String> BOT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botName").getter(getter(PutSessionRequest::botName)).setter(setter(Builder::botName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("botName").build()).build();

    private static final SdkField<String> BOT_ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botAlias").getter(getter(PutSessionRequest::botAlias)).setter(setter(Builder::botAlias))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("botAlias").build()).build();

    private static final SdkField<String> USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("userId")
            .getter(getter(PutSessionRequest::userId)).setter(setter(Builder::userId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("userId").build()).build();

    private static final SdkField<Map<String, String>> SESSION_ATTRIBUTES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("sessionAttributes")
            .getter(getter(PutSessionRequest::sessionAttributes))
            .setter(setter(Builder::sessionAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionAttributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<DialogAction> DIALOG_ACTION_FIELD = SdkField.<DialogAction> builder(MarshallingType.SDK_POJO)
            .memberName("dialogAction").getter(getter(PutSessionRequest::dialogAction)).setter(setter(Builder::dialogAction))
            .constructor(DialogAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dialogAction").build()).build();

    private static final SdkField<List<IntentSummary>> RECENT_INTENT_SUMMARY_VIEW_FIELD = SdkField
            .<List<IntentSummary>> builder(MarshallingType.LIST)
            .memberName("recentIntentSummaryView")
            .getter(getter(PutSessionRequest::recentIntentSummaryView))
            .setter(setter(Builder::recentIntentSummaryView))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recentIntentSummaryView").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IntentSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(IntentSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ACCEPT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("accept")
            .getter(getter(PutSessionRequest::accept)).setter(setter(Builder::accept))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Accept").build()).build();

    private static final SdkField<List<ActiveContext>> ACTIVE_CONTEXTS_FIELD = SdkField
            .<List<ActiveContext>> builder(MarshallingType.LIST)
            .memberName("activeContexts")
            .getter(getter(PutSessionRequest::activeContexts))
            .setter(setter(Builder::activeContexts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activeContexts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ActiveContext> builder(MarshallingType.SDK_POJO)
                                            .constructor(ActiveContext::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_NAME_FIELD,
            BOT_ALIAS_FIELD, USER_ID_FIELD, SESSION_ATTRIBUTES_FIELD, DIALOG_ACTION_FIELD, RECENT_INTENT_SUMMARY_VIEW_FIELD,
            ACCEPT_FIELD, ACTIVE_CONTEXTS_FIELD));

    private final String botName;

    private final String botAlias;

    private final String userId;

    private final Map<String, String> sessionAttributes;

    private final DialogAction dialogAction;

    private final List<IntentSummary> recentIntentSummaryView;

    private final String accept;

    private final List<ActiveContext> activeContexts;

    private PutSessionRequest(BuilderImpl builder) {
        super(builder);
        this.botName = builder.botName;
        this.botAlias = builder.botAlias;
        this.userId = builder.userId;
        this.sessionAttributes = builder.sessionAttributes;
        this.dialogAction = builder.dialogAction;
        this.recentIntentSummaryView = builder.recentIntentSummaryView;
        this.accept = builder.accept;
        this.activeContexts = builder.activeContexts;
    }

    /**
     * <p>
     * The name of the bot that contains the session data.
     * </p>
     * 
     * @return The name of the bot that contains the session data.
     */
    public final String botName() {
        return botName;
    }

    /**
     * <p>
     * The alias in use for the bot that contains the session data.
     * </p>
     * 
     * @return The alias in use for the bot that contains the session data.
     */
    public final String botAlias() {
        return botAlias;
    }

    /**
     * <p>
     * The ID of the client application user. Amazon Lex uses this to identify a user's conversation with your bot.
     * </p>
     * 
     * @return The ID of the client application user. Amazon Lex uses this to identify a user's conversation with your
     *         bot.
     */
    public final String userId() {
        return userId;
    }

    /**
     * Returns true if the SessionAttributes property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasSessionAttributes() {
        return sessionAttributes != null && !(sessionAttributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Map of key/value pairs representing the session-specific context information. It contains application information
     * passed between Amazon Lex and a client application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSessionAttributes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Map of key/value pairs representing the session-specific context information. It contains application
     *         information passed between Amazon Lex and a client application.
     */
    public final Map<String, String> sessionAttributes() {
        return sessionAttributes;
    }

    /**
     * <p>
     * Sets the next action that the bot should take to fulfill the conversation.
     * </p>
     * 
     * @return Sets the next action that the bot should take to fulfill the conversation.
     */
    public final DialogAction dialogAction() {
        return dialogAction;
    }

    /**
     * Returns true if the RecentIntentSummaryView property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasRecentIntentSummaryView() {
        return recentIntentSummaryView != null && !(recentIntentSummaryView instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A summary of the recent intents for the bot. You can use the intent summary view to set a checkpoint label on an
     * intent and modify attributes of intents. You can also use it to remove or add intent summary objects to the list.
     * </p>
     * <p>
     * An intent that you modify or add to the list must make sense for the bot. For example, the intent name must be
     * valid for the bot. You must provide valid values for:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>intentName</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * slot names
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>slotToElict</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you send the <code>recentIntentSummaryView</code> parameter in a <code>PutSession</code> request, the contents
     * of the new summary view replaces the old summary view. For example, if a <code>GetSession</code> request returns
     * three intents in the summary view and you call <code>PutSession</code> with one intent in the summary view, the
     * next call to <code>GetSession</code> will only return one intent.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRecentIntentSummaryView()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A summary of the recent intents for the bot. You can use the intent summary view to set a checkpoint
     *         label on an intent and modify attributes of intents. You can also use it to remove or add intent summary
     *         objects to the list.</p>
     *         <p>
     *         An intent that you modify or add to the list must make sense for the bot. For example, the intent name
     *         must be valid for the bot. You must provide valid values for:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>intentName</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         slot names
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>slotToElict</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If you send the <code>recentIntentSummaryView</code> parameter in a <code>PutSession</code> request, the
     *         contents of the new summary view replaces the old summary view. For example, if a <code>GetSession</code>
     *         request returns three intents in the summary view and you call <code>PutSession</code> with one intent in
     *         the summary view, the next call to <code>GetSession</code> will only return one intent.
     */
    public final List<IntentSummary> recentIntentSummaryView() {
        return recentIntentSummaryView;
    }

    /**
     * <p>
     * The message that Amazon Lex returns in the response can be either text or speech based depending on the value of
     * this field.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the value is <code>text/plain; charset=utf-8</code>, Amazon Lex returns text in the response.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the value begins with <code>audio/</code>, Amazon Lex returns speech in the response. Amazon Lex uses Amazon
     * Polly to generate the speech in the configuration that you specify. For example, if you specify
     * <code>audio/mpeg</code> as the value, Amazon Lex returns speech in the MPEG format.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the value is <code>audio/pcm</code>, the speech is returned as <code>audio/pcm</code> in 16-bit, little endian
     * format.
     * </p>
     * </li>
     * <li>
     * <p>
     * The following are the accepted values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>audio/mpeg</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>audio/ogg</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>audio/pcm</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>audio/*</code> (defaults to mpeg)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>text/plain; charset=utf-8</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * 
     * @return The message that Amazon Lex returns in the response can be either text or speech based depending on the
     *         value of this field.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         If the value is <code>text/plain; charset=utf-8</code>, Amazon Lex returns text in the response.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If the value begins with <code>audio/</code>, Amazon Lex returns speech in the response. Amazon Lex uses
     *         Amazon Polly to generate the speech in the configuration that you specify. For example, if you specify
     *         <code>audio/mpeg</code> as the value, Amazon Lex returns speech in the MPEG format.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If the value is <code>audio/pcm</code>, the speech is returned as <code>audio/pcm</code> in 16-bit,
     *         little endian format.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The following are the accepted values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>audio/mpeg</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>audio/ogg</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>audio/pcm</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>audio/*</code> (defaults to mpeg)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>text/plain; charset=utf-8</code>
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     */
    public final String accept() {
        return accept;
    }

    /**
     * Returns true if the ActiveContexts property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasActiveContexts() {
        return activeContexts != null && !(activeContexts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of contexts active for the request. A context can be activated when a previous intent is fulfilled, or by
     * including the context in the request,
     * </p>
     * <p>
     * If you don't specify a list of contexts, Amazon Lex will use the current list of contexts for the session. If you
     * specify an empty list, all contexts for the session are cleared.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasActiveContexts()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of contexts active for the request. A context can be activated when a previous intent is
     *         fulfilled, or by including the context in the request,</p>
     *         <p>
     *         If you don't specify a list of contexts, Amazon Lex will use the current list of contexts for the
     *         session. If you specify an empty list, all contexts for the session are cleared.
     */
    public final List<ActiveContext> activeContexts() {
        return activeContexts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(botName());
        hashCode = 31 * hashCode + Objects.hashCode(botAlias());
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        hashCode = 31 * hashCode + Objects.hashCode(hasSessionAttributes() ? sessionAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dialogAction());
        hashCode = 31 * hashCode + Objects.hashCode(hasRecentIntentSummaryView() ? recentIntentSummaryView() : null);
        hashCode = 31 * hashCode + Objects.hashCode(accept());
        hashCode = 31 * hashCode + Objects.hashCode(hasActiveContexts() ? activeContexts() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutSessionRequest)) {
            return false;
        }
        PutSessionRequest other = (PutSessionRequest) obj;
        return Objects.equals(botName(), other.botName()) && Objects.equals(botAlias(), other.botAlias())
                && Objects.equals(userId(), other.userId()) && hasSessionAttributes() == other.hasSessionAttributes()
                && Objects.equals(sessionAttributes(), other.sessionAttributes())
                && Objects.equals(dialogAction(), other.dialogAction())
                && hasRecentIntentSummaryView() == other.hasRecentIntentSummaryView()
                && Objects.equals(recentIntentSummaryView(), other.recentIntentSummaryView())
                && Objects.equals(accept(), other.accept()) && hasActiveContexts() == other.hasActiveContexts()
                && Objects.equals(activeContexts(), other.activeContexts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutSessionRequest").add("BotName", botName()).add("BotAlias", botAlias())
                .add("UserId", userId())
                .add("SessionAttributes", sessionAttributes() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DialogAction", dialogAction())
                .add("RecentIntentSummaryView", hasRecentIntentSummaryView() ? recentIntentSummaryView() : null)
                .add("Accept", accept())
                .add("ActiveContexts", activeContexts() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "botName":
            return Optional.ofNullable(clazz.cast(botName()));
        case "botAlias":
            return Optional.ofNullable(clazz.cast(botAlias()));
        case "userId":
            return Optional.ofNullable(clazz.cast(userId()));
        case "sessionAttributes":
            return Optional.ofNullable(clazz.cast(sessionAttributes()));
        case "dialogAction":
            return Optional.ofNullable(clazz.cast(dialogAction()));
        case "recentIntentSummaryView":
            return Optional.ofNullable(clazz.cast(recentIntentSummaryView()));
        case "accept":
            return Optional.ofNullable(clazz.cast(accept()));
        case "activeContexts":
            return Optional.ofNullable(clazz.cast(activeContexts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutSessionRequest, T> g) {
        return obj -> g.apply((PutSessionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexRuntimeRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutSessionRequest> {
        /**
         * <p>
         * The name of the bot that contains the session data.
         * </p>
         * 
         * @param botName
         *        The name of the bot that contains the session data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botName(String botName);

        /**
         * <p>
         * The alias in use for the bot that contains the session data.
         * </p>
         * 
         * @param botAlias
         *        The alias in use for the bot that contains the session data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botAlias(String botAlias);

        /**
         * <p>
         * The ID of the client application user. Amazon Lex uses this to identify a user's conversation with your bot.
         * </p>
         * 
         * @param userId
         *        The ID of the client application user. Amazon Lex uses this to identify a user's conversation with
         *        your bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);

        /**
         * <p>
         * Map of key/value pairs representing the session-specific context information. It contains application
         * information passed between Amazon Lex and a client application.
         * </p>
         * 
         * @param sessionAttributes
         *        Map of key/value pairs representing the session-specific context information. It contains application
         *        information passed between Amazon Lex and a client application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionAttributes(Map<String, String> sessionAttributes);

        /**
         * <p>
         * Sets the next action that the bot should take to fulfill the conversation.
         * </p>
         * 
         * @param dialogAction
         *        Sets the next action that the bot should take to fulfill the conversation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dialogAction(DialogAction dialogAction);

        /**
         * <p>
         * Sets the next action that the bot should take to fulfill the conversation.
         * </p>
         * This is a convenience that creates an instance of the {@link DialogAction.Builder} avoiding the need to
         * create one manually via {@link DialogAction#builder()}.
         *
         * When the {@link Consumer} completes, {@link DialogAction.Builder#build()} is called immediately and its
         * result is passed to {@link #dialogAction(DialogAction)}.
         * 
         * @param dialogAction
         *        a consumer that will call methods on {@link DialogAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dialogAction(DialogAction)
         */
        default Builder dialogAction(Consumer<DialogAction.Builder> dialogAction) {
            return dialogAction(DialogAction.builder().applyMutation(dialogAction).build());
        }

        /**
         * <p>
         * A summary of the recent intents for the bot. You can use the intent summary view to set a checkpoint label on
         * an intent and modify attributes of intents. You can also use it to remove or add intent summary objects to
         * the list.
         * </p>
         * <p>
         * An intent that you modify or add to the list must make sense for the bot. For example, the intent name must
         * be valid for the bot. You must provide valid values for:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>intentName</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * slot names
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>slotToElict</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you send the <code>recentIntentSummaryView</code> parameter in a <code>PutSession</code> request, the
         * contents of the new summary view replaces the old summary view. For example, if a <code>GetSession</code>
         * request returns three intents in the summary view and you call <code>PutSession</code> with one intent in the
         * summary view, the next call to <code>GetSession</code> will only return one intent.
         * </p>
         * 
         * @param recentIntentSummaryView
         *        A summary of the recent intents for the bot. You can use the intent summary view to set a checkpoint
         *        label on an intent and modify attributes of intents. You can also use it to remove or add intent
         *        summary objects to the list.</p>
         *        <p>
         *        An intent that you modify or add to the list must make sense for the bot. For example, the intent name
         *        must be valid for the bot. You must provide valid values for:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>intentName</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        slot names
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>slotToElict</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If you send the <code>recentIntentSummaryView</code> parameter in a <code>PutSession</code> request,
         *        the contents of the new summary view replaces the old summary view. For example, if a
         *        <code>GetSession</code> request returns three intents in the summary view and you call
         *        <code>PutSession</code> with one intent in the summary view, the next call to <code>GetSession</code>
         *        will only return one intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recentIntentSummaryView(Collection<IntentSummary> recentIntentSummaryView);

        /**
         * <p>
         * A summary of the recent intents for the bot. You can use the intent summary view to set a checkpoint label on
         * an intent and modify attributes of intents. You can also use it to remove or add intent summary objects to
         * the list.
         * </p>
         * <p>
         * An intent that you modify or add to the list must make sense for the bot. For example, the intent name must
         * be valid for the bot. You must provide valid values for:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>intentName</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * slot names
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>slotToElict</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you send the <code>recentIntentSummaryView</code> parameter in a <code>PutSession</code> request, the
         * contents of the new summary view replaces the old summary view. For example, if a <code>GetSession</code>
         * request returns three intents in the summary view and you call <code>PutSession</code> with one intent in the
         * summary view, the next call to <code>GetSession</code> will only return one intent.
         * </p>
         * 
         * @param recentIntentSummaryView
         *        A summary of the recent intents for the bot. You can use the intent summary view to set a checkpoint
         *        label on an intent and modify attributes of intents. You can also use it to remove or add intent
         *        summary objects to the list.</p>
         *        <p>
         *        An intent that you modify or add to the list must make sense for the bot. For example, the intent name
         *        must be valid for the bot. You must provide valid values for:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>intentName</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        slot names
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>slotToElict</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If you send the <code>recentIntentSummaryView</code> parameter in a <code>PutSession</code> request,
         *        the contents of the new summary view replaces the old summary view. For example, if a
         *        <code>GetSession</code> request returns three intents in the summary view and you call
         *        <code>PutSession</code> with one intent in the summary view, the next call to <code>GetSession</code>
         *        will only return one intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recentIntentSummaryView(IntentSummary... recentIntentSummaryView);

        /**
         * <p>
         * A summary of the recent intents for the bot. You can use the intent summary view to set a checkpoint label on
         * an intent and modify attributes of intents. You can also use it to remove or add intent summary objects to
         * the list.
         * </p>
         * <p>
         * An intent that you modify or add to the list must make sense for the bot. For example, the intent name must
         * be valid for the bot. You must provide valid values for:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>intentName</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * slot names
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>slotToElict</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you send the <code>recentIntentSummaryView</code> parameter in a <code>PutSession</code> request, the
         * contents of the new summary view replaces the old summary view. For example, if a <code>GetSession</code>
         * request returns three intents in the summary view and you call <code>PutSession</code> with one intent in the
         * summary view, the next call to <code>GetSession</code> will only return one intent.
         * </p>
         * This is a convenience that creates an instance of the {@link List<IntentSummary>.Builder} avoiding the need
         * to create one manually via {@link List<IntentSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<IntentSummary>.Builder#build()} is called immediately and
         * its result is passed to {@link #recentIntentSummaryView(List<IntentSummary>)}.
         * 
         * @param recentIntentSummaryView
         *        a consumer that will call methods on {@link List<IntentSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recentIntentSummaryView(List<IntentSummary>)
         */
        Builder recentIntentSummaryView(Consumer<IntentSummary.Builder>... recentIntentSummaryView);

        /**
         * <p>
         * The message that Amazon Lex returns in the response can be either text or speech based depending on the value
         * of this field.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If the value is <code>text/plain; charset=utf-8</code>, Amazon Lex returns text in the response.
         * </p>
         * </li>
         * <li>
         * <p>
         * If the value begins with <code>audio/</code>, Amazon Lex returns speech in the response. Amazon Lex uses
         * Amazon Polly to generate the speech in the configuration that you specify. For example, if you specify
         * <code>audio/mpeg</code> as the value, Amazon Lex returns speech in the MPEG format.
         * </p>
         * </li>
         * <li>
         * <p>
         * If the value is <code>audio/pcm</code>, the speech is returned as <code>audio/pcm</code> in 16-bit, little
         * endian format.
         * </p>
         * </li>
         * <li>
         * <p>
         * The following are the accepted values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>audio/mpeg</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>audio/ogg</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>audio/pcm</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>audio/*</code> (defaults to mpeg)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>text/plain; charset=utf-8</code>
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param accept
         *        The message that Amazon Lex returns in the response can be either text or speech based depending on
         *        the value of this field.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        If the value is <code>text/plain; charset=utf-8</code>, Amazon Lex returns text in the response.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If the value begins with <code>audio/</code>, Amazon Lex returns speech in the response. Amazon Lex
         *        uses Amazon Polly to generate the speech in the configuration that you specify. For example, if you
         *        specify <code>audio/mpeg</code> as the value, Amazon Lex returns speech in the MPEG format.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If the value is <code>audio/pcm</code>, the speech is returned as <code>audio/pcm</code> in 16-bit,
         *        little endian format.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The following are the accepted values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>audio/mpeg</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>audio/ogg</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>audio/pcm</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>audio/*</code> (defaults to mpeg)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>text/plain; charset=utf-8</code>
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accept(String accept);

        /**
         * <p>
         * A list of contexts active for the request. A context can be activated when a previous intent is fulfilled, or
         * by including the context in the request,
         * </p>
         * <p>
         * If you don't specify a list of contexts, Amazon Lex will use the current list of contexts for the session. If
         * you specify an empty list, all contexts for the session are cleared.
         * </p>
         * 
         * @param activeContexts
         *        A list of contexts active for the request. A context can be activated when a previous intent is
         *        fulfilled, or by including the context in the request,</p>
         *        <p>
         *        If you don't specify a list of contexts, Amazon Lex will use the current list of contexts for the
         *        session. If you specify an empty list, all contexts for the session are cleared.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeContexts(Collection<ActiveContext> activeContexts);

        /**
         * <p>
         * A list of contexts active for the request. A context can be activated when a previous intent is fulfilled, or
         * by including the context in the request,
         * </p>
         * <p>
         * If you don't specify a list of contexts, Amazon Lex will use the current list of contexts for the session. If
         * you specify an empty list, all contexts for the session are cleared.
         * </p>
         * 
         * @param activeContexts
         *        A list of contexts active for the request. A context can be activated when a previous intent is
         *        fulfilled, or by including the context in the request,</p>
         *        <p>
         *        If you don't specify a list of contexts, Amazon Lex will use the current list of contexts for the
         *        session. If you specify an empty list, all contexts for the session are cleared.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeContexts(ActiveContext... activeContexts);

        /**
         * <p>
         * A list of contexts active for the request. A context can be activated when a previous intent is fulfilled, or
         * by including the context in the request,
         * </p>
         * <p>
         * If you don't specify a list of contexts, Amazon Lex will use the current list of contexts for the session. If
         * you specify an empty list, all contexts for the session are cleared.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ActiveContext>.Builder} avoiding the need
         * to create one manually via {@link List<ActiveContext>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ActiveContext>.Builder#build()} is called immediately and
         * its result is passed to {@link #activeContexts(List<ActiveContext>)}.
         * 
         * @param activeContexts
         *        a consumer that will call methods on {@link List<ActiveContext>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #activeContexts(List<ActiveContext>)
         */
        Builder activeContexts(Consumer<ActiveContext.Builder>... activeContexts);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LexRuntimeRequest.BuilderImpl implements Builder {
        private String botName;

        private String botAlias;

        private String userId;

        private Map<String, String> sessionAttributes = DefaultSdkAutoConstructMap.getInstance();

        private DialogAction dialogAction;

        private List<IntentSummary> recentIntentSummaryView = DefaultSdkAutoConstructList.getInstance();

        private String accept;

        private List<ActiveContext> activeContexts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutSessionRequest model) {
            super(model);
            botName(model.botName);
            botAlias(model.botAlias);
            userId(model.userId);
            sessionAttributes(model.sessionAttributes);
            dialogAction(model.dialogAction);
            recentIntentSummaryView(model.recentIntentSummaryView);
            accept(model.accept);
            activeContexts(model.activeContexts);
        }

        public final String getBotName() {
            return botName;
        }

        public final void setBotName(String botName) {
            this.botName = botName;
        }

        @Override
        @Transient
        public final Builder botName(String botName) {
            this.botName = botName;
            return this;
        }

        public final String getBotAlias() {
            return botAlias;
        }

        public final void setBotAlias(String botAlias) {
            this.botAlias = botAlias;
        }

        @Override
        @Transient
        public final Builder botAlias(String botAlias) {
            this.botAlias = botAlias;
            return this;
        }

        public final String getUserId() {
            return userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        @Transient
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final Map<String, String> getSessionAttributes() {
            if (sessionAttributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return sessionAttributes;
        }

        public final void setSessionAttributes(Map<String, String> sessionAttributes) {
            this.sessionAttributes = StringMapCopier.copy(sessionAttributes);
        }

        @Override
        @Transient
        public final Builder sessionAttributes(Map<String, String> sessionAttributes) {
            this.sessionAttributes = StringMapCopier.copy(sessionAttributes);
            return this;
        }

        public final DialogAction.Builder getDialogAction() {
            return dialogAction != null ? dialogAction.toBuilder() : null;
        }

        public final void setDialogAction(DialogAction.BuilderImpl dialogAction) {
            this.dialogAction = dialogAction != null ? dialogAction.build() : null;
        }

        @Override
        @Transient
        public final Builder dialogAction(DialogAction dialogAction) {
            this.dialogAction = dialogAction;
            return this;
        }

        public final List<IntentSummary.Builder> getRecentIntentSummaryView() {
            List<IntentSummary.Builder> result = IntentSummaryListCopier.copyToBuilder(this.recentIntentSummaryView);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecentIntentSummaryView(Collection<IntentSummary.BuilderImpl> recentIntentSummaryView) {
            this.recentIntentSummaryView = IntentSummaryListCopier.copyFromBuilder(recentIntentSummaryView);
        }

        @Override
        @Transient
        public final Builder recentIntentSummaryView(Collection<IntentSummary> recentIntentSummaryView) {
            this.recentIntentSummaryView = IntentSummaryListCopier.copy(recentIntentSummaryView);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder recentIntentSummaryView(IntentSummary... recentIntentSummaryView) {
            recentIntentSummaryView(Arrays.asList(recentIntentSummaryView));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder recentIntentSummaryView(Consumer<IntentSummary.Builder>... recentIntentSummaryView) {
            recentIntentSummaryView(Stream.of(recentIntentSummaryView).map(c -> IntentSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getAccept() {
            return accept;
        }

        public final void setAccept(String accept) {
            this.accept = accept;
        }

        @Override
        @Transient
        public final Builder accept(String accept) {
            this.accept = accept;
            return this;
        }

        public final List<ActiveContext.Builder> getActiveContexts() {
            List<ActiveContext.Builder> result = ActiveContextsListCopier.copyToBuilder(this.activeContexts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActiveContexts(Collection<ActiveContext.BuilderImpl> activeContexts) {
            this.activeContexts = ActiveContextsListCopier.copyFromBuilder(activeContexts);
        }

        @Override
        @Transient
        public final Builder activeContexts(Collection<ActiveContext> activeContexts) {
            this.activeContexts = ActiveContextsListCopier.copy(activeContexts);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder activeContexts(ActiveContext... activeContexts) {
            activeContexts(Arrays.asList(activeContexts));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder activeContexts(Consumer<ActiveContext.Builder>... activeContexts) {
            activeContexts(Stream.of(activeContexts).map(c -> ActiveContext.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutSessionRequest build() {
            return new PutSessionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
