/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexruntime.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.JsonValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lexruntime.model.DialogState;
import software.amazon.awssdk.services.lexruntime.model.LexRuntimeResponse;
import software.amazon.awssdk.services.lexruntime.model.MessageFormatType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PostContentResponse
extends LexRuntimeResponse
implements ToCopyableBuilder<Builder, PostContentResponse> {
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("contentType").getter(PostContentResponse.getter(PostContentResponse::contentType)).setter(PostContentResponse.setter(Builder::contentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Content-Type").build()}).build();
    private static final SdkField<String> INTENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("intentName").getter(PostContentResponse.getter(PostContentResponse::intentName)).setter(PostContentResponse.setter(Builder::intentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-lex-intent-name").build()}).build();
    private static final SdkField<String> NLU_INTENT_CONFIDENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nluIntentConfidence").getter(PostContentResponse.getter(PostContentResponse::nluIntentConfidence)).setter(PostContentResponse.setter(Builder::nluIntentConfidence)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-lex-nlu-intent-confidence").build(), JsonValueTrait.create()}).build();
    private static final SdkField<String> ALTERNATIVE_INTENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("alternativeIntents").getter(PostContentResponse.getter(PostContentResponse::alternativeIntents)).setter(PostContentResponse.setter(Builder::alternativeIntents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-lex-alternative-intents").build(), JsonValueTrait.create()}).build();
    private static final SdkField<String> SLOTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("slots").getter(PostContentResponse.getter(PostContentResponse::slots)).setter(PostContentResponse.setter(Builder::slots)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-lex-slots").build(), JsonValueTrait.create()}).build();
    private static final SdkField<String> SESSION_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionAttributes").getter(PostContentResponse.getter(PostContentResponse::sessionAttributes)).setter(PostContentResponse.setter(Builder::sessionAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-lex-session-attributes").build(), JsonValueTrait.create()}).build();
    private static final SdkField<String> SENTIMENT_RESPONSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sentimentResponse").getter(PostContentResponse.getter(PostContentResponse::sentimentResponse)).setter(PostContentResponse.setter(Builder::sentimentResponse)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-lex-sentiment").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("message").getter(PostContentResponse.getter(PostContentResponse::message)).setter(PostContentResponse.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-lex-message").build()}).build();
    private static final SdkField<String> ENCODED_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("encodedMessage").getter(PostContentResponse.getter(PostContentResponse::encodedMessage)).setter(PostContentResponse.setter(Builder::encodedMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-lex-encoded-message").build()}).build();
    private static final SdkField<String> MESSAGE_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("messageFormat").getter(PostContentResponse.getter(PostContentResponse::messageFormatAsString)).setter(PostContentResponse.setter(Builder::messageFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-lex-message-format").build()}).build();
    private static final SdkField<String> DIALOG_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dialogState").getter(PostContentResponse.getter(PostContentResponse::dialogStateAsString)).setter(PostContentResponse.setter(Builder::dialogState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-lex-dialog-state").build()}).build();
    private static final SdkField<String> SLOT_TO_ELICIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("slotToElicit").getter(PostContentResponse.getter(PostContentResponse::slotToElicit)).setter(PostContentResponse.setter(Builder::slotToElicit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-lex-slot-to-elicit").build()}).build();
    private static final SdkField<String> INPUT_TRANSCRIPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("inputTranscript").getter(PostContentResponse.getter(PostContentResponse::inputTranscript)).setter(PostContentResponse.setter(Builder::inputTranscript)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-lex-input-transcript").build()}).build();
    private static final SdkField<String> ENCODED_INPUT_TRANSCRIPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("encodedInputTranscript").getter(PostContentResponse.getter(PostContentResponse::encodedInputTranscript)).setter(PostContentResponse.setter(Builder::encodedInputTranscript)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-lex-encoded-input-transcript").build()}).build();
    private static final SdkField<String> BOT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botVersion").getter(PostContentResponse.getter(PostContentResponse::botVersion)).setter(PostContentResponse.setter(Builder::botVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-lex-bot-version").build()}).build();
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionId").getter(PostContentResponse.getter(PostContentResponse::sessionId)).setter(PostContentResponse.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-lex-session-id").build()}).build();
    private static final SdkField<String> ACTIVE_CONTEXTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("activeContexts").getter(PostContentResponse.getter(PostContentResponse::activeContexts)).setter(PostContentResponse.setter(Builder::activeContexts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-lex-active-contexts").build(), JsonValueTrait.create()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_TYPE_FIELD, INTENT_NAME_FIELD, NLU_INTENT_CONFIDENCE_FIELD, ALTERNATIVE_INTENTS_FIELD, SLOTS_FIELD, SESSION_ATTRIBUTES_FIELD, SENTIMENT_RESPONSE_FIELD, MESSAGE_FIELD, ENCODED_MESSAGE_FIELD, MESSAGE_FORMAT_FIELD, DIALOG_STATE_FIELD, SLOT_TO_ELICIT_FIELD, INPUT_TRANSCRIPT_FIELD, ENCODED_INPUT_TRANSCRIPT_FIELD, BOT_VERSION_FIELD, SESSION_ID_FIELD, ACTIVE_CONTEXTS_FIELD));
    private final String contentType;
    private final String intentName;
    private final String nluIntentConfidence;
    private final String alternativeIntents;
    private final String slots;
    private final String sessionAttributes;
    private final String sentimentResponse;
    private final String message;
    private final String encodedMessage;
    private final String messageFormat;
    private final String dialogState;
    private final String slotToElicit;
    private final String inputTranscript;
    private final String encodedInputTranscript;
    private final String botVersion;
    private final String sessionId;
    private final String activeContexts;

    private PostContentResponse(BuilderImpl builder) {
        super(builder);
        this.contentType = builder.contentType;
        this.intentName = builder.intentName;
        this.nluIntentConfidence = builder.nluIntentConfidence;
        this.alternativeIntents = builder.alternativeIntents;
        this.slots = builder.slots;
        this.sessionAttributes = builder.sessionAttributes;
        this.sentimentResponse = builder.sentimentResponse;
        this.message = builder.message;
        this.encodedMessage = builder.encodedMessage;
        this.messageFormat = builder.messageFormat;
        this.dialogState = builder.dialogState;
        this.slotToElicit = builder.slotToElicit;
        this.inputTranscript = builder.inputTranscript;
        this.encodedInputTranscript = builder.encodedInputTranscript;
        this.botVersion = builder.botVersion;
        this.sessionId = builder.sessionId;
        this.activeContexts = builder.activeContexts;
    }

    public final String contentType() {
        return this.contentType;
    }

    public final String intentName() {
        return this.intentName;
    }

    public final String nluIntentConfidence() {
        return this.nluIntentConfidence;
    }

    public final String alternativeIntents() {
        return this.alternativeIntents;
    }

    public final String slots() {
        return this.slots;
    }

    public final String sessionAttributes() {
        return this.sessionAttributes;
    }

    public final String sentimentResponse() {
        return this.sentimentResponse;
    }

    @Deprecated
    public final String message() {
        return this.message;
    }

    public final String encodedMessage() {
        return this.encodedMessage;
    }

    public final MessageFormatType messageFormat() {
        return MessageFormatType.fromValue(this.messageFormat);
    }

    public final String messageFormatAsString() {
        return this.messageFormat;
    }

    public final DialogState dialogState() {
        return DialogState.fromValue(this.dialogState);
    }

    public final String dialogStateAsString() {
        return this.dialogState;
    }

    public final String slotToElicit() {
        return this.slotToElicit;
    }

    @Deprecated
    public final String inputTranscript() {
        return this.inputTranscript;
    }

    public final String encodedInputTranscript() {
        return this.encodedInputTranscript;
    }

    public final String botVersion() {
        return this.botVersion;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    public final String activeContexts() {
        return this.activeContexts;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.contentType());
        hashCode = 31 * hashCode + Objects.hashCode(this.intentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.nluIntentConfidence());
        hashCode = 31 * hashCode + Objects.hashCode(this.alternativeIntents());
        hashCode = 31 * hashCode + Objects.hashCode(this.slots());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.sentimentResponse());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.encodedMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dialogStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.slotToElicit());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputTranscript());
        hashCode = 31 * hashCode + Objects.hashCode(this.encodedInputTranscript());
        hashCode = 31 * hashCode + Objects.hashCode(this.botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.activeContexts());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PostContentResponse)) {
            return false;
        }
        PostContentResponse other = (PostContentResponse)((Object)obj);
        return Objects.equals(this.contentType(), other.contentType()) && Objects.equals(this.intentName(), other.intentName()) && Objects.equals(this.nluIntentConfidence(), other.nluIntentConfidence()) && Objects.equals(this.alternativeIntents(), other.alternativeIntents()) && Objects.equals(this.slots(), other.slots()) && Objects.equals(this.sessionAttributes(), other.sessionAttributes()) && Objects.equals(this.sentimentResponse(), other.sentimentResponse()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.encodedMessage(), other.encodedMessage()) && Objects.equals(this.messageFormatAsString(), other.messageFormatAsString()) && Objects.equals(this.dialogStateAsString(), other.dialogStateAsString()) && Objects.equals(this.slotToElicit(), other.slotToElicit()) && Objects.equals(this.inputTranscript(), other.inputTranscript()) && Objects.equals(this.encodedInputTranscript(), other.encodedInputTranscript()) && Objects.equals(this.botVersion(), other.botVersion()) && Objects.equals(this.sessionId(), other.sessionId()) && Objects.equals(this.activeContexts(), other.activeContexts());
    }

    public final String toString() {
        return ToString.builder((String)"PostContentResponse").add("ContentType", (Object)this.contentType()).add("IntentName", (Object)this.intentName()).add("NluIntentConfidence", (Object)this.nluIntentConfidence()).add("AlternativeIntents", (Object)this.alternativeIntents()).add("Slots", (Object)this.slots()).add("SessionAttributes", (Object)this.sessionAttributes()).add("SentimentResponse", (Object)this.sentimentResponse()).add("Message", (Object)(this.message() == null ? null : "*** Sensitive Data Redacted ***")).add("EncodedMessage", (Object)(this.encodedMessage() == null ? null : "*** Sensitive Data Redacted ***")).add("MessageFormat", (Object)this.messageFormatAsString()).add("DialogState", (Object)this.dialogStateAsString()).add("SlotToElicit", (Object)this.slotToElicit()).add("InputTranscript", (Object)this.inputTranscript()).add("EncodedInputTranscript", (Object)(this.encodedInputTranscript() == null ? null : "*** Sensitive Data Redacted ***")).add("BotVersion", (Object)this.botVersion()).add("SessionId", (Object)this.sessionId()).add("ActiveContexts", (Object)(this.activeContexts() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "contentType": {
                return Optional.ofNullable(clazz.cast(this.contentType()));
            }
            case "intentName": {
                return Optional.ofNullable(clazz.cast(this.intentName()));
            }
            case "nluIntentConfidence": {
                return Optional.ofNullable(clazz.cast(this.nluIntentConfidence()));
            }
            case "alternativeIntents": {
                return Optional.ofNullable(clazz.cast(this.alternativeIntents()));
            }
            case "slots": {
                return Optional.ofNullable(clazz.cast(this.slots()));
            }
            case "sessionAttributes": {
                return Optional.ofNullable(clazz.cast(this.sessionAttributes()));
            }
            case "sentimentResponse": {
                return Optional.ofNullable(clazz.cast(this.sentimentResponse()));
            }
            case "message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "encodedMessage": {
                return Optional.ofNullable(clazz.cast(this.encodedMessage()));
            }
            case "messageFormat": {
                return Optional.ofNullable(clazz.cast(this.messageFormatAsString()));
            }
            case "dialogState": {
                return Optional.ofNullable(clazz.cast(this.dialogStateAsString()));
            }
            case "slotToElicit": {
                return Optional.ofNullable(clazz.cast(this.slotToElicit()));
            }
            case "inputTranscript": {
                return Optional.ofNullable(clazz.cast(this.inputTranscript()));
            }
            case "encodedInputTranscript": {
                return Optional.ofNullable(clazz.cast(this.encodedInputTranscript()));
            }
            case "botVersion": {
                return Optional.ofNullable(clazz.cast(this.botVersion()));
            }
            case "sessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
            case "activeContexts": {
                return Optional.ofNullable(clazz.cast(this.activeContexts()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PostContentResponse, T> g) {
        return obj -> g.apply((PostContentResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexRuntimeResponse.BuilderImpl
    implements Builder {
        private String contentType;
        private String intentName;
        private String nluIntentConfidence;
        private String alternativeIntents;
        private String slots;
        private String sessionAttributes;
        private String sentimentResponse;
        private String message;
        private String encodedMessage;
        private String messageFormat;
        private String dialogState;
        private String slotToElicit;
        private String inputTranscript;
        private String encodedInputTranscript;
        private String botVersion;
        private String sessionId;
        private String activeContexts;

        private BuilderImpl() {
        }

        private BuilderImpl(PostContentResponse model) {
            super(model);
            this.contentType(model.contentType);
            this.intentName(model.intentName);
            this.nluIntentConfidence(model.nluIntentConfidence);
            this.alternativeIntents(model.alternativeIntents);
            this.slots(model.slots);
            this.sessionAttributes(model.sessionAttributes);
            this.sentimentResponse(model.sentimentResponse);
            this.message(model.message);
            this.encodedMessage(model.encodedMessage);
            this.messageFormat(model.messageFormat);
            this.dialogState(model.dialogState);
            this.slotToElicit(model.slotToElicit);
            this.inputTranscript(model.inputTranscript);
            this.encodedInputTranscript(model.encodedInputTranscript);
            this.botVersion(model.botVersion);
            this.sessionId(model.sessionId);
            this.activeContexts(model.activeContexts);
        }

        public final String getContentType() {
            return this.contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        @Transient
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final String getIntentName() {
            return this.intentName;
        }

        public final void setIntentName(String intentName) {
            this.intentName = intentName;
        }

        @Override
        @Transient
        public final Builder intentName(String intentName) {
            this.intentName = intentName;
            return this;
        }

        public final String getNluIntentConfidence() {
            return this.nluIntentConfidence;
        }

        public final void setNluIntentConfidence(String nluIntentConfidence) {
            this.nluIntentConfidence = nluIntentConfidence;
        }

        @Override
        @Transient
        public final Builder nluIntentConfidence(String nluIntentConfidence) {
            this.nluIntentConfidence = nluIntentConfidence;
            return this;
        }

        public final String getAlternativeIntents() {
            return this.alternativeIntents;
        }

        public final void setAlternativeIntents(String alternativeIntents) {
            this.alternativeIntents = alternativeIntents;
        }

        @Override
        @Transient
        public final Builder alternativeIntents(String alternativeIntents) {
            this.alternativeIntents = alternativeIntents;
            return this;
        }

        public final String getSlots() {
            return this.slots;
        }

        public final void setSlots(String slots) {
            this.slots = slots;
        }

        @Override
        @Transient
        public final Builder slots(String slots) {
            this.slots = slots;
            return this;
        }

        public final String getSessionAttributes() {
            return this.sessionAttributes;
        }

        public final void setSessionAttributes(String sessionAttributes) {
            this.sessionAttributes = sessionAttributes;
        }

        @Override
        @Transient
        public final Builder sessionAttributes(String sessionAttributes) {
            this.sessionAttributes = sessionAttributes;
            return this;
        }

        public final String getSentimentResponse() {
            return this.sentimentResponse;
        }

        public final void setSentimentResponse(String sentimentResponse) {
            this.sentimentResponse = sentimentResponse;
        }

        @Override
        @Transient
        public final Builder sentimentResponse(String sentimentResponse) {
            this.sentimentResponse = sentimentResponse;
            return this;
        }

        @Deprecated
        public final String getMessage() {
            return this.message;
        }

        @Deprecated
        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        @Transient
        @Deprecated
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final String getEncodedMessage() {
            return this.encodedMessage;
        }

        public final void setEncodedMessage(String encodedMessage) {
            this.encodedMessage = encodedMessage;
        }

        @Override
        @Transient
        public final Builder encodedMessage(String encodedMessage) {
            this.encodedMessage = encodedMessage;
            return this;
        }

        public final String getMessageFormat() {
            return this.messageFormat;
        }

        public final void setMessageFormat(String messageFormat) {
            this.messageFormat = messageFormat;
        }

        @Override
        @Transient
        public final Builder messageFormat(String messageFormat) {
            this.messageFormat = messageFormat;
            return this;
        }

        @Override
        @Transient
        public final Builder messageFormat(MessageFormatType messageFormat) {
            this.messageFormat(messageFormat == null ? null : messageFormat.toString());
            return this;
        }

        public final String getDialogState() {
            return this.dialogState;
        }

        public final void setDialogState(String dialogState) {
            this.dialogState = dialogState;
        }

        @Override
        @Transient
        public final Builder dialogState(String dialogState) {
            this.dialogState = dialogState;
            return this;
        }

        @Override
        @Transient
        public final Builder dialogState(DialogState dialogState) {
            this.dialogState(dialogState == null ? null : dialogState.toString());
            return this;
        }

        public final String getSlotToElicit() {
            return this.slotToElicit;
        }

        public final void setSlotToElicit(String slotToElicit) {
            this.slotToElicit = slotToElicit;
        }

        @Override
        @Transient
        public final Builder slotToElicit(String slotToElicit) {
            this.slotToElicit = slotToElicit;
            return this;
        }

        @Deprecated
        public final String getInputTranscript() {
            return this.inputTranscript;
        }

        @Deprecated
        public final void setInputTranscript(String inputTranscript) {
            this.inputTranscript = inputTranscript;
        }

        @Override
        @Transient
        @Deprecated
        public final Builder inputTranscript(String inputTranscript) {
            this.inputTranscript = inputTranscript;
            return this;
        }

        public final String getEncodedInputTranscript() {
            return this.encodedInputTranscript;
        }

        public final void setEncodedInputTranscript(String encodedInputTranscript) {
            this.encodedInputTranscript = encodedInputTranscript;
        }

        @Override
        @Transient
        public final Builder encodedInputTranscript(String encodedInputTranscript) {
            this.encodedInputTranscript = encodedInputTranscript;
            return this;
        }

        public final String getBotVersion() {
            return this.botVersion;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        @Override
        @Transient
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        @Transient
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final String getActiveContexts() {
            return this.activeContexts;
        }

        public final void setActiveContexts(String activeContexts) {
            this.activeContexts = activeContexts;
        }

        @Override
        @Transient
        public final Builder activeContexts(String activeContexts) {
            this.activeContexts = activeContexts;
            return this;
        }

        @Override
        public PostContentResponse build() {
            return new PostContentResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LexRuntimeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PostContentResponse> {
        public Builder contentType(String var1);

        public Builder intentName(String var1);

        public Builder nluIntentConfidence(String var1);

        public Builder alternativeIntents(String var1);

        public Builder slots(String var1);

        public Builder sessionAttributes(String var1);

        public Builder sentimentResponse(String var1);

        @Deprecated
        public Builder message(String var1);

        public Builder encodedMessage(String var1);

        public Builder messageFormat(String var1);

        public Builder messageFormat(MessageFormatType var1);

        public Builder dialogState(String var1);

        public Builder dialogState(DialogState var1);

        public Builder slotToElicit(String var1);

        @Deprecated
        public Builder inputTranscript(String var1);

        public Builder encodedInputTranscript(String var1);

        public Builder botVersion(String var1);

        public Builder sessionId(String var1);

        public Builder activeContexts(String var1);
    }
}

