/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexruntime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.JsonValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PostContentResponse extends LexRuntimeResponse implements
        ToCopyableBuilder<PostContentResponse.Builder, PostContentResponse> {
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("contentType").getter(getter(PostContentResponse::contentType)).setter(setter(Builder::contentType))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Content-Type").build()).build();

    private static final SdkField<String> INTENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("intentName").getter(getter(PostContentResponse::intentName)).setter(setter(Builder::intentName))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-lex-intent-name").build())
            .build();

    private static final SdkField<String> NLU_INTENT_CONFIDENCE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("nluIntentConfidence")
            .getter(getter(PostContentResponse::nluIntentConfidence))
            .setter(setter(Builder::nluIntentConfidence))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-lex-nlu-intent-confidence")
                    .build(), JsonValueTrait.create()).build();

    private static final SdkField<String> ALTERNATIVE_INTENTS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("alternativeIntents")
            .getter(getter(PostContentResponse::alternativeIntents))
            .setter(setter(Builder::alternativeIntents))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-lex-alternative-intents")
                    .build(), JsonValueTrait.create()).build();

    private static final SdkField<String> SLOTS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("slots")
            .getter(getter(PostContentResponse::slots))
            .setter(setter(Builder::slots))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-lex-slots").build(),
                    JsonValueTrait.create()).build();

    private static final SdkField<String> SESSION_ATTRIBUTES_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("sessionAttributes")
            .getter(getter(PostContentResponse::sessionAttributes))
            .setter(setter(Builder::sessionAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-lex-session-attributes")
                    .build(), JsonValueTrait.create()).build();

    private static final SdkField<String> SENTIMENT_RESPONSE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sentimentResponse").getter(getter(PostContentResponse::sentimentResponse))
            .setter(setter(Builder::sentimentResponse))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-lex-sentiment").build())
            .build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("message")
            .getter(getter(PostContentResponse::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-lex-message").build()).build();

    private static final SdkField<String> MESSAGE_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("messageFormat").getter(getter(PostContentResponse::messageFormatAsString))
            .setter(setter(Builder::messageFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-lex-message-format").build())
            .build();

    private static final SdkField<String> DIALOG_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dialogState").getter(getter(PostContentResponse::dialogStateAsString))
            .setter(setter(Builder::dialogState))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-lex-dialog-state").build())
            .build();

    private static final SdkField<String> SLOT_TO_ELICIT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("slotToElicit").getter(getter(PostContentResponse::slotToElicit)).setter(setter(Builder::slotToElicit))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-lex-slot-to-elicit").build())
            .build();

    private static final SdkField<String> INPUT_TRANSCRIPT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("inputTranscript").getter(getter(PostContentResponse::inputTranscript))
            .setter(setter(Builder::inputTranscript))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-lex-input-transcript").build())
            .build();

    private static final SdkField<String> BOT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botVersion").getter(getter(PostContentResponse::botVersion)).setter(setter(Builder::botVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-lex-bot-version").build())
            .build();

    private static final SdkField<String> SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionId").getter(getter(PostContentResponse::sessionId)).setter(setter(Builder::sessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-lex-session-id").build())
            .build();

    private static final SdkField<String> ACTIVE_CONTEXTS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("activeContexts")
            .getter(getter(PostContentResponse::activeContexts))
            .setter(setter(Builder::activeContexts))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-lex-active-contexts").build(),
                    JsonValueTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_TYPE_FIELD,
            INTENT_NAME_FIELD, NLU_INTENT_CONFIDENCE_FIELD, ALTERNATIVE_INTENTS_FIELD, SLOTS_FIELD, SESSION_ATTRIBUTES_FIELD,
            SENTIMENT_RESPONSE_FIELD, MESSAGE_FIELD, MESSAGE_FORMAT_FIELD, DIALOG_STATE_FIELD, SLOT_TO_ELICIT_FIELD,
            INPUT_TRANSCRIPT_FIELD, BOT_VERSION_FIELD, SESSION_ID_FIELD, ACTIVE_CONTEXTS_FIELD));

    private final String contentType;

    private final String intentName;

    private final String nluIntentConfidence;

    private final String alternativeIntents;

    private final String slots;

    private final String sessionAttributes;

    private final String sentimentResponse;

    private final String message;

    private final String messageFormat;

    private final String dialogState;

    private final String slotToElicit;

    private final String inputTranscript;

    private final String botVersion;

    private final String sessionId;

    private final String activeContexts;

    private PostContentResponse(BuilderImpl builder) {
        super(builder);
        this.contentType = builder.contentType;
        this.intentName = builder.intentName;
        this.nluIntentConfidence = builder.nluIntentConfidence;
        this.alternativeIntents = builder.alternativeIntents;
        this.slots = builder.slots;
        this.sessionAttributes = builder.sessionAttributes;
        this.sentimentResponse = builder.sentimentResponse;
        this.message = builder.message;
        this.messageFormat = builder.messageFormat;
        this.dialogState = builder.dialogState;
        this.slotToElicit = builder.slotToElicit;
        this.inputTranscript = builder.inputTranscript;
        this.botVersion = builder.botVersion;
        this.sessionId = builder.sessionId;
        this.activeContexts = builder.activeContexts;
    }

    /**
     * <p>
     * Content type as specified in the <code>Accept</code> HTTP header in the request.
     * </p>
     * 
     * @return Content type as specified in the <code>Accept</code> HTTP header in the request.
     */
    public String contentType() {
        return contentType;
    }

    /**
     * <p>
     * Current user intent that Amazon Lex is aware of.
     * </p>
     * 
     * @return Current user intent that Amazon Lex is aware of.
     */
    public String intentName() {
        return intentName;
    }

    /**
     * <p>
     * Provides a score that indicates how confident Amazon Lex is that the returned intent is the one that matches the
     * user's intent. The score is between 0.0 and 1.0.
     * </p>
     * <p>
     * The score is a relative score, not an absolute score. The score may change based on improvements to Amazon Lex.
     * </p>
     * 
     * @return Provides a score that indicates how confident Amazon Lex is that the returned intent is the one that
     *         matches the user's intent. The score is between 0.0 and 1.0.</p>
     *         <p>
     *         The score is a relative score, not an absolute score. The score may change based on improvements to
     *         Amazon Lex.
     */
    public String nluIntentConfidence() {
        return nluIntentConfidence;
    }

    /**
     * <p>
     * One to four alternative intents that may be applicable to the user's intent.
     * </p>
     * <p>
     * Each alternative includes a score that indicates how confident Amazon Lex is that the intent matches the user's
     * intent. The intents are sorted by the confidence score.
     * </p>
     * 
     * @return One to four alternative intents that may be applicable to the user's intent.</p>
     *         <p>
     *         Each alternative includes a score that indicates how confident Amazon Lex is that the intent matches the
     *         user's intent. The intents are sorted by the confidence score.
     */
    public String alternativeIntents() {
        return alternativeIntents;
    }

    /**
     * <p>
     * Map of zero or more intent slots (name/value pairs) Amazon Lex detected from the user input during the
     * conversation. The field is base-64 encoded.
     * </p>
     * <p>
     * Amazon Lex creates a resolution list containing likely values for a slot. The value that it returns is determined
     * by the <code>valueSelectionStrategy</code> selected when the slot type was created or updated. If
     * <code>valueSelectionStrategy</code> is set to <code>ORIGINAL_VALUE</code>, the value provided by the user is
     * returned, if the user value is similar to the slot values. If <code>valueSelectionStrategy</code> is set to
     * <code>TOP_RESOLUTION</code> Amazon Lex returns the first value in the resolution list or, if there is no
     * resolution list, null. If you don't specify a <code>valueSelectionStrategy</code>, the default is
     * <code>ORIGINAL_VALUE</code>.
     * </p>
     * 
     * @return Map of zero or more intent slots (name/value pairs) Amazon Lex detected from the user input during the
     *         conversation. The field is base-64 encoded.</p>
     *         <p>
     *         Amazon Lex creates a resolution list containing likely values for a slot. The value that it returns is
     *         determined by the <code>valueSelectionStrategy</code> selected when the slot type was created or updated.
     *         If <code>valueSelectionStrategy</code> is set to <code>ORIGINAL_VALUE</code>, the value provided by the
     *         user is returned, if the user value is similar to the slot values. If <code>valueSelectionStrategy</code>
     *         is set to <code>TOP_RESOLUTION</code> Amazon Lex returns the first value in the resolution list or, if
     *         there is no resolution list, null. If you don't specify a <code>valueSelectionStrategy</code>, the
     *         default is <code>ORIGINAL_VALUE</code>.
     */
    public String slots() {
        return slots;
    }

    /**
     * <p>
     * Map of key/value pairs representing the session-specific context information.
     * </p>
     * 
     * @return Map of key/value pairs representing the session-specific context information.
     */
    public String sessionAttributes() {
        return sessionAttributes;
    }

    /**
     * <p>
     * The sentiment expressed in an utterance.
     * </p>
     * <p>
     * When the bot is configured to send utterances to Amazon Comprehend for sentiment analysis, this field contains
     * the result of the analysis.
     * </p>
     * 
     * @return The sentiment expressed in an utterance.</p>
     *         <p>
     *         When the bot is configured to send utterances to Amazon Comprehend for sentiment analysis, this field
     *         contains the result of the analysis.
     */
    public String sentimentResponse() {
        return sentimentResponse;
    }

    /**
     * <p>
     * The message to convey to the user. The message can come from the bot's configuration or from a Lambda function.
     * </p>
     * <p>
     * If the intent is not configured with a Lambda function, or if the Lambda function returned <code>Delegate</code>
     * as the <code>dialogAction.type</code> in its response, Amazon Lex decides on the next course of action and
     * selects an appropriate message from the bot's configuration based on the current interaction context. For
     * example, if Amazon Lex isn't able to understand user input, it uses a clarification prompt message.
     * </p>
     * <p>
     * When you create an intent you can assign messages to groups. When messages are assigned to groups Amazon Lex
     * returns one message from each group in the response. The message field is an escaped JSON string containing the
     * messages. For more information about the structure of the JSON string returned, see <a>msg-prompts-formats</a>.
     * </p>
     * <p>
     * If the Lambda function returns a message, Amazon Lex passes it to the client in its response.
     * </p>
     * 
     * @return The message to convey to the user. The message can come from the bot's configuration or from a Lambda
     *         function.</p>
     *         <p>
     *         If the intent is not configured with a Lambda function, or if the Lambda function returned
     *         <code>Delegate</code> as the <code>dialogAction.type</code> in its response, Amazon Lex decides on the
     *         next course of action and selects an appropriate message from the bot's configuration based on the
     *         current interaction context. For example, if Amazon Lex isn't able to understand user input, it uses a
     *         clarification prompt message.
     *         </p>
     *         <p>
     *         When you create an intent you can assign messages to groups. When messages are assigned to groups Amazon
     *         Lex returns one message from each group in the response. The message field is an escaped JSON string
     *         containing the messages. For more information about the structure of the JSON string returned, see
     *         <a>msg-prompts-formats</a>.
     *         </p>
     *         <p>
     *         If the Lambda function returns a message, Amazon Lex passes it to the client in its response.
     */
    public String message() {
        return message;
    }

    /**
     * <p>
     * The format of the response message. One of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PlainText</code> - The message contains plain UTF-8 text.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CustomPayload</code> - The message is a custom format for the client.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SSML</code> - The message contains text formatted for voice output.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Composite</code> - The message contains an escaped JSON object containing one or more messages from the
     * groups that messages were assigned to when the intent was created.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #messageFormat}
     * will return {@link MessageFormatType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #messageFormatAsString}.
     * </p>
     * 
     * @return The format of the response message. One of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PlainText</code> - The message contains plain UTF-8 text.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CustomPayload</code> - The message is a custom format for the client.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SSML</code> - The message contains text formatted for voice output.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Composite</code> - The message contains an escaped JSON object containing one or more messages from
     *         the groups that messages were assigned to when the intent was created.
     *         </p>
     *         </li>
     * @see MessageFormatType
     */
    public MessageFormatType messageFormat() {
        return MessageFormatType.fromValue(messageFormat);
    }

    /**
     * <p>
     * The format of the response message. One of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PlainText</code> - The message contains plain UTF-8 text.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CustomPayload</code> - The message is a custom format for the client.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SSML</code> - The message contains text formatted for voice output.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Composite</code> - The message contains an escaped JSON object containing one or more messages from the
     * groups that messages were assigned to when the intent was created.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #messageFormat}
     * will return {@link MessageFormatType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #messageFormatAsString}.
     * </p>
     * 
     * @return The format of the response message. One of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PlainText</code> - The message contains plain UTF-8 text.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CustomPayload</code> - The message is a custom format for the client.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SSML</code> - The message contains text formatted for voice output.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Composite</code> - The message contains an escaped JSON object containing one or more messages from
     *         the groups that messages were assigned to when the intent was created.
     *         </p>
     *         </li>
     * @see MessageFormatType
     */
    public String messageFormatAsString() {
        return messageFormat;
    }

    /**
     * <p>
     * Identifies the current state of the user interaction. Amazon Lex returns one of the following values as
     * <code>dialogState</code>. The client can optionally use this information to customize the user interface.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ElicitIntent</code> - Amazon Lex wants to elicit the user's intent. Consider the following examples:
     * </p>
     * <p>
     * For example, a user might utter an intent ("I want to order a pizza"). If Amazon Lex cannot infer the user intent
     * from this utterance, it will return this dialog state.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ConfirmIntent</code> - Amazon Lex is expecting a "yes" or "no" response.
     * </p>
     * <p>
     * For example, Amazon Lex wants user confirmation before fulfilling an intent. Instead of a simple "yes" or "no"
     * response, a user might respond with additional information. For example, "yes, but make it a thick crust pizza"
     * or "no, I want to order a drink." Amazon Lex can process such additional information (in these examples, update
     * the crust type slot or change the intent from OrderPizza to OrderDrink).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ElicitSlot</code> - Amazon Lex is expecting the value of a slot for the current intent.
     * </p>
     * <p>
     * For example, suppose that in the response Amazon Lex sends this message: "What size pizza would you like?". A
     * user might reply with the slot value (e.g., "medium"). The user might also provide additional information in the
     * response (e.g., "medium thick crust pizza"). Amazon Lex can process such additional information appropriately.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Fulfilled</code> - Conveys that the Lambda function has successfully fulfilled the intent.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ReadyForFulfillment</code> - Conveys that the client has to fulfill the request.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Failed</code> - Conveys that the conversation with the user failed.
     * </p>
     * <p>
     * This can happen for various reasons, including that the user does not provide an appropriate response to prompts
     * from the service (you can configure how many times Amazon Lex can prompt a user for specific information), or if
     * the Lambda function fails to fulfill the intent.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dialogState} will
     * return {@link DialogState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dialogStateAsString}.
     * </p>
     * 
     * @return Identifies the current state of the user interaction. Amazon Lex returns one of the following values as
     *         <code>dialogState</code>. The client can optionally use this information to customize the user interface.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ElicitIntent</code> - Amazon Lex wants to elicit the user's intent. Consider the following
     *         examples:
     *         </p>
     *         <p>
     *         For example, a user might utter an intent ("I want to order a pizza"). If Amazon Lex cannot infer the
     *         user intent from this utterance, it will return this dialog state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ConfirmIntent</code> - Amazon Lex is expecting a "yes" or "no" response.
     *         </p>
     *         <p>
     *         For example, Amazon Lex wants user confirmation before fulfilling an intent. Instead of a simple "yes" or
     *         "no" response, a user might respond with additional information. For example,
     *         "yes, but make it a thick crust pizza" or "no, I want to order a drink." Amazon Lex can process such
     *         additional information (in these examples, update the crust type slot or change the intent from
     *         OrderPizza to OrderDrink).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ElicitSlot</code> - Amazon Lex is expecting the value of a slot for the current intent.
     *         </p>
     *         <p>
     *         For example, suppose that in the response Amazon Lex sends this message:
     *         "What size pizza would you like?". A user might reply with the slot value (e.g., "medium"). The user
     *         might also provide additional information in the response (e.g., "medium thick crust pizza"). Amazon Lex
     *         can process such additional information appropriately.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Fulfilled</code> - Conveys that the Lambda function has successfully fulfilled the intent.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ReadyForFulfillment</code> - Conveys that the client has to fulfill the request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Failed</code> - Conveys that the conversation with the user failed.
     *         </p>
     *         <p>
     *         This can happen for various reasons, including that the user does not provide an appropriate response to
     *         prompts from the service (you can configure how many times Amazon Lex can prompt a user for specific
     *         information), or if the Lambda function fails to fulfill the intent.
     *         </p>
     *         </li>
     * @see DialogState
     */
    public DialogState dialogState() {
        return DialogState.fromValue(dialogState);
    }

    /**
     * <p>
     * Identifies the current state of the user interaction. Amazon Lex returns one of the following values as
     * <code>dialogState</code>. The client can optionally use this information to customize the user interface.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ElicitIntent</code> - Amazon Lex wants to elicit the user's intent. Consider the following examples:
     * </p>
     * <p>
     * For example, a user might utter an intent ("I want to order a pizza"). If Amazon Lex cannot infer the user intent
     * from this utterance, it will return this dialog state.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ConfirmIntent</code> - Amazon Lex is expecting a "yes" or "no" response.
     * </p>
     * <p>
     * For example, Amazon Lex wants user confirmation before fulfilling an intent. Instead of a simple "yes" or "no"
     * response, a user might respond with additional information. For example, "yes, but make it a thick crust pizza"
     * or "no, I want to order a drink." Amazon Lex can process such additional information (in these examples, update
     * the crust type slot or change the intent from OrderPizza to OrderDrink).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ElicitSlot</code> - Amazon Lex is expecting the value of a slot for the current intent.
     * </p>
     * <p>
     * For example, suppose that in the response Amazon Lex sends this message: "What size pizza would you like?". A
     * user might reply with the slot value (e.g., "medium"). The user might also provide additional information in the
     * response (e.g., "medium thick crust pizza"). Amazon Lex can process such additional information appropriately.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Fulfilled</code> - Conveys that the Lambda function has successfully fulfilled the intent.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ReadyForFulfillment</code> - Conveys that the client has to fulfill the request.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Failed</code> - Conveys that the conversation with the user failed.
     * </p>
     * <p>
     * This can happen for various reasons, including that the user does not provide an appropriate response to prompts
     * from the service (you can configure how many times Amazon Lex can prompt a user for specific information), or if
     * the Lambda function fails to fulfill the intent.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dialogState} will
     * return {@link DialogState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dialogStateAsString}.
     * </p>
     * 
     * @return Identifies the current state of the user interaction. Amazon Lex returns one of the following values as
     *         <code>dialogState</code>. The client can optionally use this information to customize the user interface.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ElicitIntent</code> - Amazon Lex wants to elicit the user's intent. Consider the following
     *         examples:
     *         </p>
     *         <p>
     *         For example, a user might utter an intent ("I want to order a pizza"). If Amazon Lex cannot infer the
     *         user intent from this utterance, it will return this dialog state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ConfirmIntent</code> - Amazon Lex is expecting a "yes" or "no" response.
     *         </p>
     *         <p>
     *         For example, Amazon Lex wants user confirmation before fulfilling an intent. Instead of a simple "yes" or
     *         "no" response, a user might respond with additional information. For example,
     *         "yes, but make it a thick crust pizza" or "no, I want to order a drink." Amazon Lex can process such
     *         additional information (in these examples, update the crust type slot or change the intent from
     *         OrderPizza to OrderDrink).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ElicitSlot</code> - Amazon Lex is expecting the value of a slot for the current intent.
     *         </p>
     *         <p>
     *         For example, suppose that in the response Amazon Lex sends this message:
     *         "What size pizza would you like?". A user might reply with the slot value (e.g., "medium"). The user
     *         might also provide additional information in the response (e.g., "medium thick crust pizza"). Amazon Lex
     *         can process such additional information appropriately.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Fulfilled</code> - Conveys that the Lambda function has successfully fulfilled the intent.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ReadyForFulfillment</code> - Conveys that the client has to fulfill the request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Failed</code> - Conveys that the conversation with the user failed.
     *         </p>
     *         <p>
     *         This can happen for various reasons, including that the user does not provide an appropriate response to
     *         prompts from the service (you can configure how many times Amazon Lex can prompt a user for specific
     *         information), or if the Lambda function fails to fulfill the intent.
     *         </p>
     *         </li>
     * @see DialogState
     */
    public String dialogStateAsString() {
        return dialogState;
    }

    /**
     * <p>
     * If the <code>dialogState</code> value is <code>ElicitSlot</code>, returns the name of the slot for which Amazon
     * Lex is eliciting a value.
     * </p>
     * 
     * @return If the <code>dialogState</code> value is <code>ElicitSlot</code>, returns the name of the slot for which
     *         Amazon Lex is eliciting a value.
     */
    public String slotToElicit() {
        return slotToElicit;
    }

    /**
     * <p>
     * The text used to process the request.
     * </p>
     * <p>
     * If the input was an audio stream, the <code>inputTranscript</code> field contains the text extracted from the
     * audio stream. This is the text that is actually processed to recognize intents and slot values. You can use this
     * information to determine if Amazon Lex is correctly processing the audio that you send.
     * </p>
     * 
     * @return The text used to process the request.</p>
     *         <p>
     *         If the input was an audio stream, the <code>inputTranscript</code> field contains the text extracted from
     *         the audio stream. This is the text that is actually processed to recognize intents and slot values. You
     *         can use this information to determine if Amazon Lex is correctly processing the audio that you send.
     */
    public String inputTranscript() {
        return inputTranscript;
    }

    /**
     * <p>
     * The version of the bot that responded to the conversation. You can use this information to help determine if one
     * version of a bot is performing better than another version.
     * </p>
     * 
     * @return The version of the bot that responded to the conversation. You can use this information to help determine
     *         if one version of a bot is performing better than another version.
     */
    public String botVersion() {
        return botVersion;
    }

    /**
     * <p>
     * The unique identifier for the session.
     * </p>
     * 
     * @return The unique identifier for the session.
     */
    public String sessionId() {
        return sessionId;
    }

    /**
     * <p>
     * A list of active contexts for the session. A context can be set when an intent is fulfilled or by calling the
     * <code>PostContent</code>, <code>PostText</code>, or <code>PutSession</code> operation.
     * </p>
     * <p>
     * You can use a context to control the intents that can follow up an intent, or to modify the operation of your
     * application.
     * </p>
     * 
     * @return A list of active contexts for the session. A context can be set when an intent is fulfilled or by calling
     *         the <code>PostContent</code>, <code>PostText</code>, or <code>PutSession</code> operation.</p>
     *         <p>
     *         You can use a context to control the intents that can follow up an intent, or to modify the operation of
     *         your application.
     */
    public String activeContexts() {
        return activeContexts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(contentType());
        hashCode = 31 * hashCode + Objects.hashCode(intentName());
        hashCode = 31 * hashCode + Objects.hashCode(nluIntentConfidence());
        hashCode = 31 * hashCode + Objects.hashCode(alternativeIntents());
        hashCode = 31 * hashCode + Objects.hashCode(slots());
        hashCode = 31 * hashCode + Objects.hashCode(sessionAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(sentimentResponse());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(messageFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dialogStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(slotToElicit());
        hashCode = 31 * hashCode + Objects.hashCode(inputTranscript());
        hashCode = 31 * hashCode + Objects.hashCode(botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(activeContexts());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PostContentResponse)) {
            return false;
        }
        PostContentResponse other = (PostContentResponse) obj;
        return Objects.equals(contentType(), other.contentType()) && Objects.equals(intentName(), other.intentName())
                && Objects.equals(nluIntentConfidence(), other.nluIntentConfidence())
                && Objects.equals(alternativeIntents(), other.alternativeIntents()) && Objects.equals(slots(), other.slots())
                && Objects.equals(sessionAttributes(), other.sessionAttributes())
                && Objects.equals(sentimentResponse(), other.sentimentResponse()) && Objects.equals(message(), other.message())
                && Objects.equals(messageFormatAsString(), other.messageFormatAsString())
                && Objects.equals(dialogStateAsString(), other.dialogStateAsString())
                && Objects.equals(slotToElicit(), other.slotToElicit())
                && Objects.equals(inputTranscript(), other.inputTranscript()) && Objects.equals(botVersion(), other.botVersion())
                && Objects.equals(sessionId(), other.sessionId()) && Objects.equals(activeContexts(), other.activeContexts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PostContentResponse").add("ContentType", contentType()).add("IntentName", intentName())
                .add("NluIntentConfidence", nluIntentConfidence()).add("AlternativeIntents", alternativeIntents())
                .add("Slots", slots()).add("SessionAttributes", sessionAttributes())
                .add("SentimentResponse", sentimentResponse())
                .add("Message", message() == null ? null : "*** Sensitive Data Redacted ***")
                .add("MessageFormat", messageFormatAsString()).add("DialogState", dialogStateAsString())
                .add("SlotToElicit", slotToElicit()).add("InputTranscript", inputTranscript()).add("BotVersion", botVersion())
                .add("SessionId", sessionId())
                .add("ActiveContexts", activeContexts() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "contentType":
            return Optional.ofNullable(clazz.cast(contentType()));
        case "intentName":
            return Optional.ofNullable(clazz.cast(intentName()));
        case "nluIntentConfidence":
            return Optional.ofNullable(clazz.cast(nluIntentConfidence()));
        case "alternativeIntents":
            return Optional.ofNullable(clazz.cast(alternativeIntents()));
        case "slots":
            return Optional.ofNullable(clazz.cast(slots()));
        case "sessionAttributes":
            return Optional.ofNullable(clazz.cast(sessionAttributes()));
        case "sentimentResponse":
            return Optional.ofNullable(clazz.cast(sentimentResponse()));
        case "message":
            return Optional.ofNullable(clazz.cast(message()));
        case "messageFormat":
            return Optional.ofNullable(clazz.cast(messageFormatAsString()));
        case "dialogState":
            return Optional.ofNullable(clazz.cast(dialogStateAsString()));
        case "slotToElicit":
            return Optional.ofNullable(clazz.cast(slotToElicit()));
        case "inputTranscript":
            return Optional.ofNullable(clazz.cast(inputTranscript()));
        case "botVersion":
            return Optional.ofNullable(clazz.cast(botVersion()));
        case "sessionId":
            return Optional.ofNullable(clazz.cast(sessionId()));
        case "activeContexts":
            return Optional.ofNullable(clazz.cast(activeContexts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PostContentResponse, T> g) {
        return obj -> g.apply((PostContentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexRuntimeResponse.Builder, SdkPojo, CopyableBuilder<Builder, PostContentResponse> {
        /**
         * <p>
         * Content type as specified in the <code>Accept</code> HTTP header in the request.
         * </p>
         * 
         * @param contentType
         *        Content type as specified in the <code>Accept</code> HTTP header in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentType(String contentType);

        /**
         * <p>
         * Current user intent that Amazon Lex is aware of.
         * </p>
         * 
         * @param intentName
         *        Current user intent that Amazon Lex is aware of.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intentName(String intentName);

        /**
         * <p>
         * Provides a score that indicates how confident Amazon Lex is that the returned intent is the one that matches
         * the user's intent. The score is between 0.0 and 1.0.
         * </p>
         * <p>
         * The score is a relative score, not an absolute score. The score may change based on improvements to Amazon
         * Lex.
         * </p>
         * 
         * @param nluIntentConfidence
         *        Provides a score that indicates how confident Amazon Lex is that the returned intent is the one that
         *        matches the user's intent. The score is between 0.0 and 1.0.</p>
         *        <p>
         *        The score is a relative score, not an absolute score. The score may change based on improvements to
         *        Amazon Lex.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nluIntentConfidence(String nluIntentConfidence);

        /**
         * <p>
         * One to four alternative intents that may be applicable to the user's intent.
         * </p>
         * <p>
         * Each alternative includes a score that indicates how confident Amazon Lex is that the intent matches the
         * user's intent. The intents are sorted by the confidence score.
         * </p>
         * 
         * @param alternativeIntents
         *        One to four alternative intents that may be applicable to the user's intent.</p>
         *        <p>
         *        Each alternative includes a score that indicates how confident Amazon Lex is that the intent matches
         *        the user's intent. The intents are sorted by the confidence score.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alternativeIntents(String alternativeIntents);

        /**
         * <p>
         * Map of zero or more intent slots (name/value pairs) Amazon Lex detected from the user input during the
         * conversation. The field is base-64 encoded.
         * </p>
         * <p>
         * Amazon Lex creates a resolution list containing likely values for a slot. The value that it returns is
         * determined by the <code>valueSelectionStrategy</code> selected when the slot type was created or updated. If
         * <code>valueSelectionStrategy</code> is set to <code>ORIGINAL_VALUE</code>, the value provided by the user is
         * returned, if the user value is similar to the slot values. If <code>valueSelectionStrategy</code> is set to
         * <code>TOP_RESOLUTION</code> Amazon Lex returns the first value in the resolution list or, if there is no
         * resolution list, null. If you don't specify a <code>valueSelectionStrategy</code>, the default is
         * <code>ORIGINAL_VALUE</code>.
         * </p>
         * 
         * @param slots
         *        Map of zero or more intent slots (name/value pairs) Amazon Lex detected from the user input during the
         *        conversation. The field is base-64 encoded.</p>
         *        <p>
         *        Amazon Lex creates a resolution list containing likely values for a slot. The value that it returns is
         *        determined by the <code>valueSelectionStrategy</code> selected when the slot type was created or
         *        updated. If <code>valueSelectionStrategy</code> is set to <code>ORIGINAL_VALUE</code>, the value
         *        provided by the user is returned, if the user value is similar to the slot values. If
         *        <code>valueSelectionStrategy</code> is set to <code>TOP_RESOLUTION</code> Amazon Lex returns the first
         *        value in the resolution list or, if there is no resolution list, null. If you don't specify a
         *        <code>valueSelectionStrategy</code>, the default is <code>ORIGINAL_VALUE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slots(String slots);

        /**
         * <p>
         * Map of key/value pairs representing the session-specific context information.
         * </p>
         * 
         * @param sessionAttributes
         *        Map of key/value pairs representing the session-specific context information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionAttributes(String sessionAttributes);

        /**
         * <p>
         * The sentiment expressed in an utterance.
         * </p>
         * <p>
         * When the bot is configured to send utterances to Amazon Comprehend for sentiment analysis, this field
         * contains the result of the analysis.
         * </p>
         * 
         * @param sentimentResponse
         *        The sentiment expressed in an utterance.</p>
         *        <p>
         *        When the bot is configured to send utterances to Amazon Comprehend for sentiment analysis, this field
         *        contains the result of the analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sentimentResponse(String sentimentResponse);

        /**
         * <p>
         * The message to convey to the user. The message can come from the bot's configuration or from a Lambda
         * function.
         * </p>
         * <p>
         * If the intent is not configured with a Lambda function, or if the Lambda function returned
         * <code>Delegate</code> as the <code>dialogAction.type</code> in its response, Amazon Lex decides on the next
         * course of action and selects an appropriate message from the bot's configuration based on the current
         * interaction context. For example, if Amazon Lex isn't able to understand user input, it uses a clarification
         * prompt message.
         * </p>
         * <p>
         * When you create an intent you can assign messages to groups. When messages are assigned to groups Amazon Lex
         * returns one message from each group in the response. The message field is an escaped JSON string containing
         * the messages. For more information about the structure of the JSON string returned, see
         * <a>msg-prompts-formats</a>.
         * </p>
         * <p>
         * If the Lambda function returns a message, Amazon Lex passes it to the client in its response.
         * </p>
         * 
         * @param message
         *        The message to convey to the user. The message can come from the bot's configuration or from a Lambda
         *        function.</p>
         *        <p>
         *        If the intent is not configured with a Lambda function, or if the Lambda function returned
         *        <code>Delegate</code> as the <code>dialogAction.type</code> in its response, Amazon Lex decides on the
         *        next course of action and selects an appropriate message from the bot's configuration based on the
         *        current interaction context. For example, if Amazon Lex isn't able to understand user input, it uses a
         *        clarification prompt message.
         *        </p>
         *        <p>
         *        When you create an intent you can assign messages to groups. When messages are assigned to groups
         *        Amazon Lex returns one message from each group in the response. The message field is an escaped JSON
         *        string containing the messages. For more information about the structure of the JSON string returned,
         *        see <a>msg-prompts-formats</a>.
         *        </p>
         *        <p>
         *        If the Lambda function returns a message, Amazon Lex passes it to the client in its response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The format of the response message. One of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PlainText</code> - The message contains plain UTF-8 text.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CustomPayload</code> - The message is a custom format for the client.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SSML</code> - The message contains text formatted for voice output.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Composite</code> - The message contains an escaped JSON object containing one or more messages from the
         * groups that messages were assigned to when the intent was created.
         * </p>
         * </li>
         * </ul>
         * 
         * @param messageFormat
         *        The format of the response message. One of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PlainText</code> - The message contains plain UTF-8 text.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CustomPayload</code> - The message is a custom format for the client.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SSML</code> - The message contains text formatted for voice output.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Composite</code> - The message contains an escaped JSON object containing one or more messages
         *        from the groups that messages were assigned to when the intent was created.
         *        </p>
         *        </li>
         * @see MessageFormatType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MessageFormatType
         */
        Builder messageFormat(String messageFormat);

        /**
         * <p>
         * The format of the response message. One of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PlainText</code> - The message contains plain UTF-8 text.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CustomPayload</code> - The message is a custom format for the client.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SSML</code> - The message contains text formatted for voice output.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Composite</code> - The message contains an escaped JSON object containing one or more messages from the
         * groups that messages were assigned to when the intent was created.
         * </p>
         * </li>
         * </ul>
         * 
         * @param messageFormat
         *        The format of the response message. One of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PlainText</code> - The message contains plain UTF-8 text.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CustomPayload</code> - The message is a custom format for the client.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SSML</code> - The message contains text formatted for voice output.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Composite</code> - The message contains an escaped JSON object containing one or more messages
         *        from the groups that messages were assigned to when the intent was created.
         *        </p>
         *        </li>
         * @see MessageFormatType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MessageFormatType
         */
        Builder messageFormat(MessageFormatType messageFormat);

        /**
         * <p>
         * Identifies the current state of the user interaction. Amazon Lex returns one of the following values as
         * <code>dialogState</code>. The client can optionally use this information to customize the user interface.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ElicitIntent</code> - Amazon Lex wants to elicit the user's intent. Consider the following examples:
         * </p>
         * <p>
         * For example, a user might utter an intent ("I want to order a pizza"). If Amazon Lex cannot infer the user
         * intent from this utterance, it will return this dialog state.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ConfirmIntent</code> - Amazon Lex is expecting a "yes" or "no" response.
         * </p>
         * <p>
         * For example, Amazon Lex wants user confirmation before fulfilling an intent. Instead of a simple "yes" or
         * "no" response, a user might respond with additional information. For example,
         * "yes, but make it a thick crust pizza" or "no, I want to order a drink." Amazon Lex can process such
         * additional information (in these examples, update the crust type slot or change the intent from OrderPizza to
         * OrderDrink).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ElicitSlot</code> - Amazon Lex is expecting the value of a slot for the current intent.
         * </p>
         * <p>
         * For example, suppose that in the response Amazon Lex sends this message: "What size pizza would you like?". A
         * user might reply with the slot value (e.g., "medium"). The user might also provide additional information in
         * the response (e.g., "medium thick crust pizza"). Amazon Lex can process such additional information
         * appropriately.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Fulfilled</code> - Conveys that the Lambda function has successfully fulfilled the intent.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ReadyForFulfillment</code> - Conveys that the client has to fulfill the request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Failed</code> - Conveys that the conversation with the user failed.
         * </p>
         * <p>
         * This can happen for various reasons, including that the user does not provide an appropriate response to
         * prompts from the service (you can configure how many times Amazon Lex can prompt a user for specific
         * information), or if the Lambda function fails to fulfill the intent.
         * </p>
         * </li>
         * </ul>
         * 
         * @param dialogState
         *        Identifies the current state of the user interaction. Amazon Lex returns one of the following values
         *        as <code>dialogState</code>. The client can optionally use this information to customize the user
         *        interface. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ElicitIntent</code> - Amazon Lex wants to elicit the user's intent. Consider the following
         *        examples:
         *        </p>
         *        <p>
         *        For example, a user might utter an intent ("I want to order a pizza"). If Amazon Lex cannot infer the
         *        user intent from this utterance, it will return this dialog state.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ConfirmIntent</code> - Amazon Lex is expecting a "yes" or "no" response.
         *        </p>
         *        <p>
         *        For example, Amazon Lex wants user confirmation before fulfilling an intent. Instead of a simple "yes"
         *        or "no" response, a user might respond with additional information. For example,
         *        "yes, but make it a thick crust pizza" or "no, I want to order a drink." Amazon Lex can process such
         *        additional information (in these examples, update the crust type slot or change the intent from
         *        OrderPizza to OrderDrink).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ElicitSlot</code> - Amazon Lex is expecting the value of a slot for the current intent.
         *        </p>
         *        <p>
         *        For example, suppose that in the response Amazon Lex sends this message:
         *        "What size pizza would you like?". A user might reply with the slot value (e.g., "medium"). The user
         *        might also provide additional information in the response (e.g., "medium thick crust pizza"). Amazon
         *        Lex can process such additional information appropriately.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Fulfilled</code> - Conveys that the Lambda function has successfully fulfilled the intent.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ReadyForFulfillment</code> - Conveys that the client has to fulfill the request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Failed</code> - Conveys that the conversation with the user failed.
         *        </p>
         *        <p>
         *        This can happen for various reasons, including that the user does not provide an appropriate response
         *        to prompts from the service (you can configure how many times Amazon Lex can prompt a user for
         *        specific information), or if the Lambda function fails to fulfill the intent.
         *        </p>
         *        </li>
         * @see DialogState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DialogState
         */
        Builder dialogState(String dialogState);

        /**
         * <p>
         * Identifies the current state of the user interaction. Amazon Lex returns one of the following values as
         * <code>dialogState</code>. The client can optionally use this information to customize the user interface.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ElicitIntent</code> - Amazon Lex wants to elicit the user's intent. Consider the following examples:
         * </p>
         * <p>
         * For example, a user might utter an intent ("I want to order a pizza"). If Amazon Lex cannot infer the user
         * intent from this utterance, it will return this dialog state.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ConfirmIntent</code> - Amazon Lex is expecting a "yes" or "no" response.
         * </p>
         * <p>
         * For example, Amazon Lex wants user confirmation before fulfilling an intent. Instead of a simple "yes" or
         * "no" response, a user might respond with additional information. For example,
         * "yes, but make it a thick crust pizza" or "no, I want to order a drink." Amazon Lex can process such
         * additional information (in these examples, update the crust type slot or change the intent from OrderPizza to
         * OrderDrink).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ElicitSlot</code> - Amazon Lex is expecting the value of a slot for the current intent.
         * </p>
         * <p>
         * For example, suppose that in the response Amazon Lex sends this message: "What size pizza would you like?". A
         * user might reply with the slot value (e.g., "medium"). The user might also provide additional information in
         * the response (e.g., "medium thick crust pizza"). Amazon Lex can process such additional information
         * appropriately.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Fulfilled</code> - Conveys that the Lambda function has successfully fulfilled the intent.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ReadyForFulfillment</code> - Conveys that the client has to fulfill the request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Failed</code> - Conveys that the conversation with the user failed.
         * </p>
         * <p>
         * This can happen for various reasons, including that the user does not provide an appropriate response to
         * prompts from the service (you can configure how many times Amazon Lex can prompt a user for specific
         * information), or if the Lambda function fails to fulfill the intent.
         * </p>
         * </li>
         * </ul>
         * 
         * @param dialogState
         *        Identifies the current state of the user interaction. Amazon Lex returns one of the following values
         *        as <code>dialogState</code>. The client can optionally use this information to customize the user
         *        interface. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ElicitIntent</code> - Amazon Lex wants to elicit the user's intent. Consider the following
         *        examples:
         *        </p>
         *        <p>
         *        For example, a user might utter an intent ("I want to order a pizza"). If Amazon Lex cannot infer the
         *        user intent from this utterance, it will return this dialog state.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ConfirmIntent</code> - Amazon Lex is expecting a "yes" or "no" response.
         *        </p>
         *        <p>
         *        For example, Amazon Lex wants user confirmation before fulfilling an intent. Instead of a simple "yes"
         *        or "no" response, a user might respond with additional information. For example,
         *        "yes, but make it a thick crust pizza" or "no, I want to order a drink." Amazon Lex can process such
         *        additional information (in these examples, update the crust type slot or change the intent from
         *        OrderPizza to OrderDrink).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ElicitSlot</code> - Amazon Lex is expecting the value of a slot for the current intent.
         *        </p>
         *        <p>
         *        For example, suppose that in the response Amazon Lex sends this message:
         *        "What size pizza would you like?". A user might reply with the slot value (e.g., "medium"). The user
         *        might also provide additional information in the response (e.g., "medium thick crust pizza"). Amazon
         *        Lex can process such additional information appropriately.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Fulfilled</code> - Conveys that the Lambda function has successfully fulfilled the intent.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ReadyForFulfillment</code> - Conveys that the client has to fulfill the request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Failed</code> - Conveys that the conversation with the user failed.
         *        </p>
         *        <p>
         *        This can happen for various reasons, including that the user does not provide an appropriate response
         *        to prompts from the service (you can configure how many times Amazon Lex can prompt a user for
         *        specific information), or if the Lambda function fails to fulfill the intent.
         *        </p>
         *        </li>
         * @see DialogState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DialogState
         */
        Builder dialogState(DialogState dialogState);

        /**
         * <p>
         * If the <code>dialogState</code> value is <code>ElicitSlot</code>, returns the name of the slot for which
         * Amazon Lex is eliciting a value.
         * </p>
         * 
         * @param slotToElicit
         *        If the <code>dialogState</code> value is <code>ElicitSlot</code>, returns the name of the slot for
         *        which Amazon Lex is eliciting a value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slotToElicit(String slotToElicit);

        /**
         * <p>
         * The text used to process the request.
         * </p>
         * <p>
         * If the input was an audio stream, the <code>inputTranscript</code> field contains the text extracted from the
         * audio stream. This is the text that is actually processed to recognize intents and slot values. You can use
         * this information to determine if Amazon Lex is correctly processing the audio that you send.
         * </p>
         * 
         * @param inputTranscript
         *        The text used to process the request.</p>
         *        <p>
         *        If the input was an audio stream, the <code>inputTranscript</code> field contains the text extracted
         *        from the audio stream. This is the text that is actually processed to recognize intents and slot
         *        values. You can use this information to determine if Amazon Lex is correctly processing the audio that
         *        you send.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputTranscript(String inputTranscript);

        /**
         * <p>
         * The version of the bot that responded to the conversation. You can use this information to help determine if
         * one version of a bot is performing better than another version.
         * </p>
         * 
         * @param botVersion
         *        The version of the bot that responded to the conversation. You can use this information to help
         *        determine if one version of a bot is performing better than another version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botVersion(String botVersion);

        /**
         * <p>
         * The unique identifier for the session.
         * </p>
         * 
         * @param sessionId
         *        The unique identifier for the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionId(String sessionId);

        /**
         * <p>
         * A list of active contexts for the session. A context can be set when an intent is fulfilled or by calling the
         * <code>PostContent</code>, <code>PostText</code>, or <code>PutSession</code> operation.
         * </p>
         * <p>
         * You can use a context to control the intents that can follow up an intent, or to modify the operation of your
         * application.
         * </p>
         * 
         * @param activeContexts
         *        A list of active contexts for the session. A context can be set when an intent is fulfilled or by
         *        calling the <code>PostContent</code>, <code>PostText</code>, or <code>PutSession</code> operation.</p>
         *        <p>
         *        You can use a context to control the intents that can follow up an intent, or to modify the operation
         *        of your application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeContexts(String activeContexts);
    }

    static final class BuilderImpl extends LexRuntimeResponse.BuilderImpl implements Builder {
        private String contentType;

        private String intentName;

        private String nluIntentConfidence;

        private String alternativeIntents;

        private String slots;

        private String sessionAttributes;

        private String sentimentResponse;

        private String message;

        private String messageFormat;

        private String dialogState;

        private String slotToElicit;

        private String inputTranscript;

        private String botVersion;

        private String sessionId;

        private String activeContexts;

        private BuilderImpl() {
        }

        private BuilderImpl(PostContentResponse model) {
            super(model);
            contentType(model.contentType);
            intentName(model.intentName);
            nluIntentConfidence(model.nluIntentConfidence);
            alternativeIntents(model.alternativeIntents);
            slots(model.slots);
            sessionAttributes(model.sessionAttributes);
            sentimentResponse(model.sentimentResponse);
            message(model.message);
            messageFormat(model.messageFormat);
            dialogState(model.dialogState);
            slotToElicit(model.slotToElicit);
            inputTranscript(model.inputTranscript);
            botVersion(model.botVersion);
            sessionId(model.sessionId);
            activeContexts(model.activeContexts);
        }

        public final String getContentType() {
            return contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public final String getIntentName() {
            return intentName;
        }

        @Override
        public final Builder intentName(String intentName) {
            this.intentName = intentName;
            return this;
        }

        public final void setIntentName(String intentName) {
            this.intentName = intentName;
        }

        public final String getNluIntentConfidence() {
            return nluIntentConfidence;
        }

        @Override
        public final Builder nluIntentConfidence(String nluIntentConfidence) {
            this.nluIntentConfidence = nluIntentConfidence;
            return this;
        }

        public final void setNluIntentConfidence(String nluIntentConfidence) {
            this.nluIntentConfidence = nluIntentConfidence;
        }

        public final String getAlternativeIntents() {
            return alternativeIntents;
        }

        @Override
        public final Builder alternativeIntents(String alternativeIntents) {
            this.alternativeIntents = alternativeIntents;
            return this;
        }

        public final void setAlternativeIntents(String alternativeIntents) {
            this.alternativeIntents = alternativeIntents;
        }

        public final String getSlots() {
            return slots;
        }

        @Override
        public final Builder slots(String slots) {
            this.slots = slots;
            return this;
        }

        public final void setSlots(String slots) {
            this.slots = slots;
        }

        public final String getSessionAttributes() {
            return sessionAttributes;
        }

        @Override
        public final Builder sessionAttributes(String sessionAttributes) {
            this.sessionAttributes = sessionAttributes;
            return this;
        }

        public final void setSessionAttributes(String sessionAttributes) {
            this.sessionAttributes = sessionAttributes;
        }

        public final String getSentimentResponse() {
            return sentimentResponse;
        }

        @Override
        public final Builder sentimentResponse(String sentimentResponse) {
            this.sentimentResponse = sentimentResponse;
            return this;
        }

        public final void setSentimentResponse(String sentimentResponse) {
            this.sentimentResponse = sentimentResponse;
        }

        public final String getMessage() {
            return message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final String getMessageFormat() {
            return messageFormat;
        }

        @Override
        public final Builder messageFormat(String messageFormat) {
            this.messageFormat = messageFormat;
            return this;
        }

        @Override
        public final Builder messageFormat(MessageFormatType messageFormat) {
            this.messageFormat(messageFormat == null ? null : messageFormat.toString());
            return this;
        }

        public final void setMessageFormat(String messageFormat) {
            this.messageFormat = messageFormat;
        }

        public final String getDialogState() {
            return dialogState;
        }

        @Override
        public final Builder dialogState(String dialogState) {
            this.dialogState = dialogState;
            return this;
        }

        @Override
        public final Builder dialogState(DialogState dialogState) {
            this.dialogState(dialogState == null ? null : dialogState.toString());
            return this;
        }

        public final void setDialogState(String dialogState) {
            this.dialogState = dialogState;
        }

        public final String getSlotToElicit() {
            return slotToElicit;
        }

        @Override
        public final Builder slotToElicit(String slotToElicit) {
            this.slotToElicit = slotToElicit;
            return this;
        }

        public final void setSlotToElicit(String slotToElicit) {
            this.slotToElicit = slotToElicit;
        }

        public final String getInputTranscript() {
            return inputTranscript;
        }

        @Override
        public final Builder inputTranscript(String inputTranscript) {
            this.inputTranscript = inputTranscript;
            return this;
        }

        public final void setInputTranscript(String inputTranscript) {
            this.inputTranscript = inputTranscript;
        }

        public final String getBotVersion() {
            return botVersion;
        }

        @Override
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        public final String getSessionId() {
            return sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        public final String getActiveContexts() {
            return activeContexts;
        }

        @Override
        public final Builder activeContexts(String activeContexts) {
            this.activeContexts = activeContexts;
            return this;
        }

        public final void setActiveContexts(String activeContexts) {
            this.activeContexts = activeContexts;
        }

        @Override
        public PostContentResponse build() {
            return new PostContentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
