/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexruntime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.JsonValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PostContentRequest extends LexRuntimeRequest implements
        ToCopyableBuilder<PostContentRequest.Builder, PostContentRequest> {
    private static final SdkField<String> BOT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botName").getter(getter(PostContentRequest::botName)).setter(setter(Builder::botName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("botName").build()).build();

    private static final SdkField<String> BOT_ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botAlias").getter(getter(PostContentRequest::botAlias)).setter(setter(Builder::botAlias))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("botAlias").build()).build();

    private static final SdkField<String> USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("userId")
            .getter(getter(PostContentRequest::userId)).setter(setter(Builder::userId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("userId").build()).build();

    private static final SdkField<String> SESSION_ATTRIBUTES_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("sessionAttributes")
            .getter(getter(PostContentRequest::sessionAttributes))
            .setter(setter(Builder::sessionAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-lex-session-attributes")
                    .build(), JsonValueTrait.create()).build();

    private static final SdkField<String> REQUEST_ATTRIBUTES_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("requestAttributes")
            .getter(getter(PostContentRequest::requestAttributes))
            .setter(setter(Builder::requestAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-lex-request-attributes")
                    .build(), JsonValueTrait.create()).build();

    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("contentType").getter(getter(PostContentRequest::contentType)).setter(setter(Builder::contentType))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Content-Type").build()).build();

    private static final SdkField<String> ACCEPT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("accept")
            .getter(getter(PostContentRequest::accept)).setter(setter(Builder::accept))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Accept").build()).build();

    private static final SdkField<String> ACTIVE_CONTEXTS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("activeContexts")
            .getter(getter(PostContentRequest::activeContexts))
            .setter(setter(Builder::activeContexts))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-lex-active-contexts").build(),
                    JsonValueTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_NAME_FIELD,
            BOT_ALIAS_FIELD, USER_ID_FIELD, SESSION_ATTRIBUTES_FIELD, REQUEST_ATTRIBUTES_FIELD, CONTENT_TYPE_FIELD, ACCEPT_FIELD,
            ACTIVE_CONTEXTS_FIELD));

    private final String botName;

    private final String botAlias;

    private final String userId;

    private final String sessionAttributes;

    private final String requestAttributes;

    private final String contentType;

    private final String accept;

    private final String activeContexts;

    private PostContentRequest(BuilderImpl builder) {
        super(builder);
        this.botName = builder.botName;
        this.botAlias = builder.botAlias;
        this.userId = builder.userId;
        this.sessionAttributes = builder.sessionAttributes;
        this.requestAttributes = builder.requestAttributes;
        this.contentType = builder.contentType;
        this.accept = builder.accept;
        this.activeContexts = builder.activeContexts;
    }

    /**
     * <p>
     * Name of the Amazon Lex bot.
     * </p>
     * 
     * @return Name of the Amazon Lex bot.
     */
    public String botName() {
        return botName;
    }

    /**
     * <p>
     * Alias of the Amazon Lex bot.
     * </p>
     * 
     * @return Alias of the Amazon Lex bot.
     */
    public String botAlias() {
        return botAlias;
    }

    /**
     * <p>
     * The ID of the client application user. Amazon Lex uses this to identify a user's conversation with your bot. At
     * runtime, each request must contain the <code>userID</code> field.
     * </p>
     * <p>
     * To decide the user ID to use for your application, consider the following factors.
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>userID</code> field must not contain any personally identifiable information of the user, for example,
     * name, personal identification numbers, or other end user personal information.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you want a user to start a conversation on one device and continue on another device, use a user-specific
     * identifier.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you want the same user to be able to have two independent conversations on two different devices, choose a
     * device-specific identifier.
     * </p>
     * </li>
     * <li>
     * <p>
     * A user can't have two independent conversations with two different versions of the same bot. For example, a user
     * can't have a conversation with the PROD and BETA versions of the same bot. If you anticipate that a user will
     * need to have conversation with two different versions, for example, while testing, include the bot alias in the
     * user ID to separate the two conversations.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The ID of the client application user. Amazon Lex uses this to identify a user's conversation with your
     *         bot. At runtime, each request must contain the <code>userID</code> field.</p>
     *         <p>
     *         To decide the user ID to use for your application, consider the following factors.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The <code>userID</code> field must not contain any personally identifiable information of the user, for
     *         example, name, personal identification numbers, or other end user personal information.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you want a user to start a conversation on one device and continue on another device, use a
     *         user-specific identifier.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you want the same user to be able to have two independent conversations on two different devices,
     *         choose a device-specific identifier.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A user can't have two independent conversations with two different versions of the same bot. For example,
     *         a user can't have a conversation with the PROD and BETA versions of the same bot. If you anticipate that
     *         a user will need to have conversation with two different versions, for example, while testing, include
     *         the bot alias in the user ID to separate the two conversations.
     *         </p>
     *         </li>
     */
    public String userId() {
        return userId;
    }

    /**
     * <p>
     * You pass this value as the <code>x-amz-lex-session-attributes</code> HTTP header.
     * </p>
     * <p>
     * Application-specific information passed between Amazon Lex and a client application. The value must be a JSON
     * serialized and base64 encoded map with string keys and values. The total size of the
     * <code>sessionAttributes</code> and <code>requestAttributes</code> headers is limited to 12 KB.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/lex/latest/dg/context-mgmt.html#context-mgmt-session-attribs">Setting Session
     * Attributes</a>.
     * </p>
     * 
     * @return You pass this value as the <code>x-amz-lex-session-attributes</code> HTTP header.</p>
     *         <p>
     *         Application-specific information passed between Amazon Lex and a client application. The value must be a
     *         JSON serialized and base64 encoded map with string keys and values. The total size of the
     *         <code>sessionAttributes</code> and <code>requestAttributes</code> headers is limited to 12 KB.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/lex/latest/dg/context-mgmt.html#context-mgmt-session-attribs">Setting
     *         Session Attributes</a>.
     */
    public String sessionAttributes() {
        return sessionAttributes;
    }

    /**
     * <p>
     * You pass this value as the <code>x-amz-lex-request-attributes</code> HTTP header.
     * </p>
     * <p>
     * Request-specific information passed between Amazon Lex and a client application. The value must be a JSON
     * serialized and base64 encoded map with string keys and values. The total size of the
     * <code>requestAttributes</code> and <code>sessionAttributes</code> headers is limited to 12 KB.
     * </p>
     * <p>
     * The namespace <code>x-amz-lex:</code> is reserved for special attributes. Don't create any request attributes
     * with the prefix <code>x-amz-lex:</code>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/lex/latest/dg/context-mgmt.html#context-mgmt-request-attribs">Setting Request
     * Attributes</a>.
     * </p>
     * 
     * @return You pass this value as the <code>x-amz-lex-request-attributes</code> HTTP header.</p>
     *         <p>
     *         Request-specific information passed between Amazon Lex and a client application. The value must be a JSON
     *         serialized and base64 encoded map with string keys and values. The total size of the
     *         <code>requestAttributes</code> and <code>sessionAttributes</code> headers is limited to 12 KB.
     *         </p>
     *         <p>
     *         The namespace <code>x-amz-lex:</code> is reserved for special attributes. Don't create any request
     *         attributes with the prefix <code>x-amz-lex:</code>.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/lex/latest/dg/context-mgmt.html#context-mgmt-request-attribs">Setting
     *         Request Attributes</a>.
     */
    public String requestAttributes() {
        return requestAttributes;
    }

    /**
     * <p>
     * You pass this value as the <code>Content-Type</code> HTTP header.
     * </p>
     * <p>
     * Indicates the audio format or text. The header value must start with one of the following prefixes:
     * </p>
     * <ul>
     * <li>
     * <p>
     * PCM format, audio data must be in little-endian byte order.
     * </p>
     * <ul>
     * <li>
     * <p>
     * audio/l16; rate=16000; channels=1
     * </p>
     * </li>
     * <li>
     * <p>
     * audio/x-l16; sample-rate=16000; channel-count=1
     * </p>
     * </li>
     * <li>
     * <p>
     * audio/lpcm; sample-rate=8000; sample-size-bits=16; channel-count=1; is-big-endian=false
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Opus format
     * </p>
     * <ul>
     * <li>
     * <p>
     * audio/x-cbr-opus-with-preamble; preamble-size=0; bit-rate=256000; frame-size-milliseconds=4
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Text format
     * </p>
     * <ul>
     * <li>
     * <p>
     * text/plain; charset=utf-8
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * 
     * @return You pass this value as the <code>Content-Type</code> HTTP header. </p>
     *         <p>
     *         Indicates the audio format or text. The header value must start with one of the following prefixes:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         PCM format, audio data must be in little-endian byte order.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         audio/l16; rate=16000; channels=1
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         audio/x-l16; sample-rate=16000; channel-count=1
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         audio/lpcm; sample-rate=8000; sample-size-bits=16; channel-count=1; is-big-endian=false
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Opus format
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         audio/x-cbr-opus-with-preamble; preamble-size=0; bit-rate=256000; frame-size-milliseconds=4
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Text format
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         text/plain; charset=utf-8
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     */
    public String contentType() {
        return contentType;
    }

    /**
     * <p>
     * You pass this value as the <code>Accept</code> HTTP header.
     * </p>
     * <p>
     * The message Amazon Lex returns in the response can be either text or speech based on the <code>Accept</code> HTTP
     * header value in the request.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the value is <code>text/plain; charset=utf-8</code>, Amazon Lex returns text in the response.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the value begins with <code>audio/</code>, Amazon Lex returns speech in the response. Amazon Lex uses Amazon
     * Polly to generate the speech (using the configuration you specified in the <code>Accept</code> header). For
     * example, if you specify <code>audio/mpeg</code> as the value, Amazon Lex returns speech in the MPEG format.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the value is <code>audio/pcm</code>, the speech returned is <code>audio/pcm</code> in 16-bit, little endian
     * format.
     * </p>
     * </li>
     * <li>
     * <p>
     * The following are the accepted values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * audio/mpeg
     * </p>
     * </li>
     * <li>
     * <p>
     * audio/ogg
     * </p>
     * </li>
     * <li>
     * <p>
     * audio/pcm
     * </p>
     * </li>
     * <li>
     * <p>
     * text/plain; charset=utf-8
     * </p>
     * </li>
     * <li>
     * <p>
     * audio/* (defaults to mpeg)
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * 
     * @return You pass this value as the <code>Accept</code> HTTP header. </p>
     *         <p>
     *         The message Amazon Lex returns in the response can be either text or speech based on the
     *         <code>Accept</code> HTTP header value in the request.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If the value is <code>text/plain; charset=utf-8</code>, Amazon Lex returns text in the response.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If the value begins with <code>audio/</code>, Amazon Lex returns speech in the response. Amazon Lex uses
     *         Amazon Polly to generate the speech (using the configuration you specified in the <code>Accept</code>
     *         header). For example, if you specify <code>audio/mpeg</code> as the value, Amazon Lex returns speech in
     *         the MPEG format.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If the value is <code>audio/pcm</code>, the speech returned is <code>audio/pcm</code> in 16-bit, little
     *         endian format.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The following are the accepted values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         audio/mpeg
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         audio/ogg
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         audio/pcm
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         text/plain; charset=utf-8
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         audio/* (defaults to mpeg)
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     */
    public String accept() {
        return accept;
    }

    /**
     * <p>
     * A list of contexts active for the request. A context can be activated when a previous intent is fulfilled, or by
     * including the context in the request,
     * </p>
     * <p>
     * If you don't specify a list of contexts, Amazon Lex will use the current list of contexts for the session. If you
     * specify an empty list, all contexts for the session are cleared.
     * </p>
     * 
     * @return A list of contexts active for the request. A context can be activated when a previous intent is
     *         fulfilled, or by including the context in the request,</p>
     *         <p>
     *         If you don't specify a list of contexts, Amazon Lex will use the current list of contexts for the
     *         session. If you specify an empty list, all contexts for the session are cleared.
     */
    public String activeContexts() {
        return activeContexts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(botName());
        hashCode = 31 * hashCode + Objects.hashCode(botAlias());
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        hashCode = 31 * hashCode + Objects.hashCode(sessionAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(requestAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(contentType());
        hashCode = 31 * hashCode + Objects.hashCode(accept());
        hashCode = 31 * hashCode + Objects.hashCode(activeContexts());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PostContentRequest)) {
            return false;
        }
        PostContentRequest other = (PostContentRequest) obj;
        return Objects.equals(botName(), other.botName()) && Objects.equals(botAlias(), other.botAlias())
                && Objects.equals(userId(), other.userId()) && Objects.equals(sessionAttributes(), other.sessionAttributes())
                && Objects.equals(requestAttributes(), other.requestAttributes())
                && Objects.equals(contentType(), other.contentType()) && Objects.equals(accept(), other.accept())
                && Objects.equals(activeContexts(), other.activeContexts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PostContentRequest").add("BotName", botName()).add("BotAlias", botAlias())
                .add("UserId", userId())
                .add("SessionAttributes", sessionAttributes() == null ? null : "*** Sensitive Data Redacted ***")
                .add("RequestAttributes", requestAttributes() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ContentType", contentType()).add("Accept", accept())
                .add("ActiveContexts", activeContexts() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "botName":
            return Optional.ofNullable(clazz.cast(botName()));
        case "botAlias":
            return Optional.ofNullable(clazz.cast(botAlias()));
        case "userId":
            return Optional.ofNullable(clazz.cast(userId()));
        case "sessionAttributes":
            return Optional.ofNullable(clazz.cast(sessionAttributes()));
        case "requestAttributes":
            return Optional.ofNullable(clazz.cast(requestAttributes()));
        case "contentType":
            return Optional.ofNullable(clazz.cast(contentType()));
        case "accept":
            return Optional.ofNullable(clazz.cast(accept()));
        case "activeContexts":
            return Optional.ofNullable(clazz.cast(activeContexts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PostContentRequest, T> g) {
        return obj -> g.apply((PostContentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexRuntimeRequest.Builder, SdkPojo, CopyableBuilder<Builder, PostContentRequest> {
        /**
         * <p>
         * Name of the Amazon Lex bot.
         * </p>
         * 
         * @param botName
         *        Name of the Amazon Lex bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botName(String botName);

        /**
         * <p>
         * Alias of the Amazon Lex bot.
         * </p>
         * 
         * @param botAlias
         *        Alias of the Amazon Lex bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botAlias(String botAlias);

        /**
         * <p>
         * The ID of the client application user. Amazon Lex uses this to identify a user's conversation with your bot.
         * At runtime, each request must contain the <code>userID</code> field.
         * </p>
         * <p>
         * To decide the user ID to use for your application, consider the following factors.
         * </p>
         * <ul>
         * <li>
         * <p>
         * The <code>userID</code> field must not contain any personally identifiable information of the user, for
         * example, name, personal identification numbers, or other end user personal information.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you want a user to start a conversation on one device and continue on another device, use a user-specific
         * identifier.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you want the same user to be able to have two independent conversations on two different devices, choose a
         * device-specific identifier.
         * </p>
         * </li>
         * <li>
         * <p>
         * A user can't have two independent conversations with two different versions of the same bot. For example, a
         * user can't have a conversation with the PROD and BETA versions of the same bot. If you anticipate that a user
         * will need to have conversation with two different versions, for example, while testing, include the bot alias
         * in the user ID to separate the two conversations.
         * </p>
         * </li>
         * </ul>
         * 
         * @param userId
         *        The ID of the client application user. Amazon Lex uses this to identify a user's conversation with
         *        your bot. At runtime, each request must contain the <code>userID</code> field.</p>
         *        <p>
         *        To decide the user ID to use for your application, consider the following factors.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The <code>userID</code> field must not contain any personally identifiable information of the user,
         *        for example, name, personal identification numbers, or other end user personal information.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you want a user to start a conversation on one device and continue on another device, use a
         *        user-specific identifier.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you want the same user to be able to have two independent conversations on two different devices,
         *        choose a device-specific identifier.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        A user can't have two independent conversations with two different versions of the same bot. For
         *        example, a user can't have a conversation with the PROD and BETA versions of the same bot. If you
         *        anticipate that a user will need to have conversation with two different versions, for example, while
         *        testing, include the bot alias in the user ID to separate the two conversations.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);

        /**
         * <p>
         * You pass this value as the <code>x-amz-lex-session-attributes</code> HTTP header.
         * </p>
         * <p>
         * Application-specific information passed between Amazon Lex and a client application. The value must be a JSON
         * serialized and base64 encoded map with string keys and values. The total size of the
         * <code>sessionAttributes</code> and <code>requestAttributes</code> headers is limited to 12 KB.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/lex/latest/dg/context-mgmt.html#context-mgmt-session-attribs">Setting
         * Session Attributes</a>.
         * </p>
         * 
         * @param sessionAttributes
         *        You pass this value as the <code>x-amz-lex-session-attributes</code> HTTP header.</p>
         *        <p>
         *        Application-specific information passed between Amazon Lex and a client application. The value must be
         *        a JSON serialized and base64 encoded map with string keys and values. The total size of the
         *        <code>sessionAttributes</code> and <code>requestAttributes</code> headers is limited to 12 KB.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/lex/latest/dg/context-mgmt.html#context-mgmt-session-attribs"
         *        >Setting Session Attributes</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionAttributes(String sessionAttributes);

        /**
         * <p>
         * You pass this value as the <code>x-amz-lex-request-attributes</code> HTTP header.
         * </p>
         * <p>
         * Request-specific information passed between Amazon Lex and a client application. The value must be a JSON
         * serialized and base64 encoded map with string keys and values. The total size of the
         * <code>requestAttributes</code> and <code>sessionAttributes</code> headers is limited to 12 KB.
         * </p>
         * <p>
         * The namespace <code>x-amz-lex:</code> is reserved for special attributes. Don't create any request attributes
         * with the prefix <code>x-amz-lex:</code>.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/lex/latest/dg/context-mgmt.html#context-mgmt-request-attribs">Setting
         * Request Attributes</a>.
         * </p>
         * 
         * @param requestAttributes
         *        You pass this value as the <code>x-amz-lex-request-attributes</code> HTTP header.</p>
         *        <p>
         *        Request-specific information passed between Amazon Lex and a client application. The value must be a
         *        JSON serialized and base64 encoded map with string keys and values. The total size of the
         *        <code>requestAttributes</code> and <code>sessionAttributes</code> headers is limited to 12 KB.
         *        </p>
         *        <p>
         *        The namespace <code>x-amz-lex:</code> is reserved for special attributes. Don't create any request
         *        attributes with the prefix <code>x-amz-lex:</code>.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/lex/latest/dg/context-mgmt.html#context-mgmt-request-attribs"
         *        >Setting Request Attributes</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestAttributes(String requestAttributes);

        /**
         * <p>
         * You pass this value as the <code>Content-Type</code> HTTP header.
         * </p>
         * <p>
         * Indicates the audio format or text. The header value must start with one of the following prefixes:
         * </p>
         * <ul>
         * <li>
         * <p>
         * PCM format, audio data must be in little-endian byte order.
         * </p>
         * <ul>
         * <li>
         * <p>
         * audio/l16; rate=16000; channels=1
         * </p>
         * </li>
         * <li>
         * <p>
         * audio/x-l16; sample-rate=16000; channel-count=1
         * </p>
         * </li>
         * <li>
         * <p>
         * audio/lpcm; sample-rate=8000; sample-size-bits=16; channel-count=1; is-big-endian=false
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * Opus format
         * </p>
         * <ul>
         * <li>
         * <p>
         * audio/x-cbr-opus-with-preamble; preamble-size=0; bit-rate=256000; frame-size-milliseconds=4
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * Text format
         * </p>
         * <ul>
         * <li>
         * <p>
         * text/plain; charset=utf-8
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param contentType
         *        You pass this value as the <code>Content-Type</code> HTTP header. </p>
         *        <p>
         *        Indicates the audio format or text. The header value must start with one of the following prefixes:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        PCM format, audio data must be in little-endian byte order.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        audio/l16; rate=16000; channels=1
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        audio/x-l16; sample-rate=16000; channel-count=1
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        audio/lpcm; sample-rate=8000; sample-size-bits=16; channel-count=1; is-big-endian=false
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        Opus format
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        audio/x-cbr-opus-with-preamble; preamble-size=0; bit-rate=256000; frame-size-milliseconds=4
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        Text format
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        text/plain; charset=utf-8
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentType(String contentType);

        /**
         * <p>
         * You pass this value as the <code>Accept</code> HTTP header.
         * </p>
         * <p>
         * The message Amazon Lex returns in the response can be either text or speech based on the <code>Accept</code>
         * HTTP header value in the request.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If the value is <code>text/plain; charset=utf-8</code>, Amazon Lex returns text in the response.
         * </p>
         * </li>
         * <li>
         * <p>
         * If the value begins with <code>audio/</code>, Amazon Lex returns speech in the response. Amazon Lex uses
         * Amazon Polly to generate the speech (using the configuration you specified in the <code>Accept</code>
         * header). For example, if you specify <code>audio/mpeg</code> as the value, Amazon Lex returns speech in the
         * MPEG format.
         * </p>
         * </li>
         * <li>
         * <p>
         * If the value is <code>audio/pcm</code>, the speech returned is <code>audio/pcm</code> in 16-bit, little
         * endian format.
         * </p>
         * </li>
         * <li>
         * <p>
         * The following are the accepted values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * audio/mpeg
         * </p>
         * </li>
         * <li>
         * <p>
         * audio/ogg
         * </p>
         * </li>
         * <li>
         * <p>
         * audio/pcm
         * </p>
         * </li>
         * <li>
         * <p>
         * text/plain; charset=utf-8
         * </p>
         * </li>
         * <li>
         * <p>
         * audio/* (defaults to mpeg)
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param accept
         *        You pass this value as the <code>Accept</code> HTTP header. </p>
         *        <p>
         *        The message Amazon Lex returns in the response can be either text or speech based on the
         *        <code>Accept</code> HTTP header value in the request.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If the value is <code>text/plain; charset=utf-8</code>, Amazon Lex returns text in the response.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If the value begins with <code>audio/</code>, Amazon Lex returns speech in the response. Amazon Lex
         *        uses Amazon Polly to generate the speech (using the configuration you specified in the
         *        <code>Accept</code> header). For example, if you specify <code>audio/mpeg</code> as the value, Amazon
         *        Lex returns speech in the MPEG format.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If the value is <code>audio/pcm</code>, the speech returned is <code>audio/pcm</code> in 16-bit,
         *        little endian format.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The following are the accepted values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        audio/mpeg
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        audio/ogg
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        audio/pcm
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        text/plain; charset=utf-8
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        audio/* (defaults to mpeg)
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accept(String accept);

        /**
         * <p>
         * A list of contexts active for the request. A context can be activated when a previous intent is fulfilled, or
         * by including the context in the request,
         * </p>
         * <p>
         * If you don't specify a list of contexts, Amazon Lex will use the current list of contexts for the session. If
         * you specify an empty list, all contexts for the session are cleared.
         * </p>
         * 
         * @param activeContexts
         *        A list of contexts active for the request. A context can be activated when a previous intent is
         *        fulfilled, or by including the context in the request,</p>
         *        <p>
         *        If you don't specify a list of contexts, Amazon Lex will use the current list of contexts for the
         *        session. If you specify an empty list, all contexts for the session are cleared.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeContexts(String activeContexts);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LexRuntimeRequest.BuilderImpl implements Builder {
        private String botName;

        private String botAlias;

        private String userId;

        private String sessionAttributes;

        private String requestAttributes;

        private String contentType;

        private String accept;

        private String activeContexts;

        private BuilderImpl() {
        }

        private BuilderImpl(PostContentRequest model) {
            super(model);
            botName(model.botName);
            botAlias(model.botAlias);
            userId(model.userId);
            sessionAttributes(model.sessionAttributes);
            requestAttributes(model.requestAttributes);
            contentType(model.contentType);
            accept(model.accept);
            activeContexts(model.activeContexts);
        }

        public final String getBotName() {
            return botName;
        }

        @Override
        public final Builder botName(String botName) {
            this.botName = botName;
            return this;
        }

        public final void setBotName(String botName) {
            this.botName = botName;
        }

        public final String getBotAlias() {
            return botAlias;
        }

        @Override
        public final Builder botAlias(String botAlias) {
            this.botAlias = botAlias;
            return this;
        }

        public final void setBotAlias(String botAlias) {
            this.botAlias = botAlias;
        }

        public final String getUserId() {
            return userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        public final String getSessionAttributes() {
            return sessionAttributes;
        }

        @Override
        public final Builder sessionAttributes(String sessionAttributes) {
            this.sessionAttributes = sessionAttributes;
            return this;
        }

        public final void setSessionAttributes(String sessionAttributes) {
            this.sessionAttributes = sessionAttributes;
        }

        public final String getRequestAttributes() {
            return requestAttributes;
        }

        @Override
        public final Builder requestAttributes(String requestAttributes) {
            this.requestAttributes = requestAttributes;
            return this;
        }

        public final void setRequestAttributes(String requestAttributes) {
            this.requestAttributes = requestAttributes;
        }

        public final String getContentType() {
            return contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public final String getAccept() {
            return accept;
        }

        @Override
        public final Builder accept(String accept) {
            this.accept = accept;
            return this;
        }

        public final void setAccept(String accept) {
            this.accept = accept;
        }

        public final String getActiveContexts() {
            return activeContexts;
        }

        @Override
        public final Builder activeContexts(String activeContexts) {
            this.activeContexts = activeContexts;
            return this;
        }

        public final void setActiveContexts(String activeContexts) {
            this.activeContexts = activeContexts;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PostContentRequest build() {
            return new PostContentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
