/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A context is a variable that contains information about the current state of the conversation between a user and
 * Amazon Lex. Context can be set automatically by Amazon Lex when an intent is fulfilled, or it can be set at runtime
 * using the <code>PutContent</code>, <code>PutText</code>, or <code>PutSession</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ActiveContext implements SdkPojo, Serializable, ToCopyableBuilder<ActiveContext.Builder, ActiveContext> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(ActiveContext::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<ActiveContextTimeToLive> TIME_TO_LIVE_FIELD = SdkField
            .<ActiveContextTimeToLive> builder(MarshallingType.SDK_POJO).memberName("timeToLive")
            .getter(getter(ActiveContext::timeToLive)).setter(setter(Builder::timeToLive))
            .constructor(ActiveContextTimeToLive::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeToLive").build()).build();

    private static final SdkField<Map<String, String>> PARAMETERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("parameters")
            .getter(getter(ActiveContext::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            TIME_TO_LIVE_FIELD, PARAMETERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final ActiveContextTimeToLive timeToLive;

    private final Map<String, String> parameters;

    private ActiveContext(BuilderImpl builder) {
        this.name = builder.name;
        this.timeToLive = builder.timeToLive;
        this.parameters = builder.parameters;
    }

    /**
     * <p>
     * The name of the context.
     * </p>
     * 
     * @return The name of the context.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The length of time or number of turns that a context remains active.
     * </p>
     * 
     * @return The length of time or number of turns that a context remains active.
     */
    public ActiveContextTimeToLive timeToLive() {
        return timeToLive;
    }

    /**
     * Returns true if the Parameters property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * State variables for the current context. You can use these values as default values for slots in subsequent
     * events.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasParameters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return State variables for the current context. You can use these values as default values for slots in
     *         subsequent events.
     */
    public Map<String, String> parameters() {
        return parameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(timeToLive());
        hashCode = 31 * hashCode + Objects.hashCode(hasParameters() ? parameters() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActiveContext)) {
            return false;
        }
        ActiveContext other = (ActiveContext) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(timeToLive(), other.timeToLive())
                && hasParameters() == other.hasParameters() && Objects.equals(parameters(), other.parameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ActiveContext").add("Name", name()).add("TimeToLive", timeToLive())
                .add("Parameters", parameters() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "timeToLive":
            return Optional.ofNullable(clazz.cast(timeToLive()));
        case "parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ActiveContext, T> g) {
        return obj -> g.apply((ActiveContext) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ActiveContext> {
        /**
         * <p>
         * The name of the context.
         * </p>
         * 
         * @param name
         *        The name of the context.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The length of time or number of turns that a context remains active.
         * </p>
         * 
         * @param timeToLive
         *        The length of time or number of turns that a context remains active.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeToLive(ActiveContextTimeToLive timeToLive);

        /**
         * <p>
         * The length of time or number of turns that a context remains active.
         * </p>
         * This is a convenience that creates an instance of the {@link ActiveContextTimeToLive.Builder} avoiding the
         * need to create one manually via {@link ActiveContextTimeToLive#builder()}.
         *
         * When the {@link Consumer} completes, {@link ActiveContextTimeToLive.Builder#build()} is called immediately
         * and its result is passed to {@link #timeToLive(ActiveContextTimeToLive)}.
         * 
         * @param timeToLive
         *        a consumer that will call methods on {@link ActiveContextTimeToLive.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timeToLive(ActiveContextTimeToLive)
         */
        default Builder timeToLive(Consumer<ActiveContextTimeToLive.Builder> timeToLive) {
            return timeToLive(ActiveContextTimeToLive.builder().applyMutation(timeToLive).build());
        }

        /**
         * <p>
         * State variables for the current context. You can use these values as default values for slots in subsequent
         * events.
         * </p>
         * 
         * @param parameters
         *        State variables for the current context. You can use these values as default values for slots in
         *        subsequent events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Map<String, String> parameters);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private ActiveContextTimeToLive timeToLive;

        private Map<String, String> parameters = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ActiveContext model) {
            name(model.name);
            timeToLive(model.timeToLive);
            parameters(model.parameters);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final ActiveContextTimeToLive.Builder getTimeToLive() {
            return timeToLive != null ? timeToLive.toBuilder() : null;
        }

        @Override
        public final Builder timeToLive(ActiveContextTimeToLive timeToLive) {
            this.timeToLive = timeToLive;
            return this;
        }

        public final void setTimeToLive(ActiveContextTimeToLive.BuilderImpl timeToLive) {
            this.timeToLive = timeToLive != null ? timeToLive.build() : null;
        }

        public final Map<String, String> getParameters() {
            if (parameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return parameters;
        }

        @Override
        public final Builder parameters(Map<String, String> parameters) {
            this.parameters = ActiveContextParametersMapCopier.copy(parameters);
            return this;
        }

        public final void setParameters(Map<String, String> parameters) {
            this.parameters = ActiveContextParametersMapCopier.copy(parameters);
        }

        @Override
        public ActiveContext build() {
            return new ActiveContext(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
