/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexruntime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.lexruntime.model.LexRuntimeRequest;
import software.amazon.awssdk.services.lexruntime.model.StringMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PostTextRequest
extends LexRuntimeRequest
implements ToCopyableBuilder<Builder, PostTextRequest> {
    private static final SdkField<String> BOT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botName").getter(PostTextRequest.getter(PostTextRequest::botName)).setter(PostTextRequest.setter(Builder::botName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("botName").build()}).build();
    private static final SdkField<String> BOT_ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botAlias").getter(PostTextRequest.getter(PostTextRequest::botAlias)).setter(PostTextRequest.setter(Builder::botAlias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("botAlias").build()}).build();
    private static final SdkField<String> USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userId").getter(PostTextRequest.getter(PostTextRequest::userId)).setter(PostTextRequest.setter(Builder::userId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("userId").build()}).build();
    private static final SdkField<Map<String, String>> SESSION_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("sessionAttributes").getter(PostTextRequest.getter(PostTextRequest::sessionAttributes)).setter(PostTextRequest.setter(Builder::sessionAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionAttributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> REQUEST_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("requestAttributes").getter(PostTextRequest.getter(PostTextRequest::requestAttributes)).setter(PostTextRequest.setter(Builder::requestAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestAttributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> INPUT_TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("inputText").getter(PostTextRequest.getter(PostTextRequest::inputText)).setter(PostTextRequest.setter(Builder::inputText)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputText").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_NAME_FIELD, BOT_ALIAS_FIELD, USER_ID_FIELD, SESSION_ATTRIBUTES_FIELD, REQUEST_ATTRIBUTES_FIELD, INPUT_TEXT_FIELD));
    private final String botName;
    private final String botAlias;
    private final String userId;
    private final Map<String, String> sessionAttributes;
    private final Map<String, String> requestAttributes;
    private final String inputText;

    private PostTextRequest(BuilderImpl builder) {
        super(builder);
        this.botName = builder.botName;
        this.botAlias = builder.botAlias;
        this.userId = builder.userId;
        this.sessionAttributes = builder.sessionAttributes;
        this.requestAttributes = builder.requestAttributes;
        this.inputText = builder.inputText;
    }

    public String botName() {
        return this.botName;
    }

    public String botAlias() {
        return this.botAlias;
    }

    public String userId() {
        return this.userId;
    }

    public boolean hasSessionAttributes() {
        return this.sessionAttributes != null && !(this.sessionAttributes instanceof SdkAutoConstructMap);
    }

    public Map<String, String> sessionAttributes() {
        return this.sessionAttributes;
    }

    public boolean hasRequestAttributes() {
        return this.requestAttributes != null && !(this.requestAttributes instanceof SdkAutoConstructMap);
    }

    public Map<String, String> requestAttributes() {
        return this.requestAttributes;
    }

    public String inputText() {
        return this.inputText;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.botName());
        hashCode = 31 * hashCode + Objects.hashCode(this.botAlias());
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputText());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PostTextRequest)) {
            return false;
        }
        PostTextRequest other = (PostTextRequest)((Object)obj);
        return Objects.equals(this.botName(), other.botName()) && Objects.equals(this.botAlias(), other.botAlias()) && Objects.equals(this.userId(), other.userId()) && Objects.equals(this.sessionAttributes(), other.sessionAttributes()) && Objects.equals(this.requestAttributes(), other.requestAttributes()) && Objects.equals(this.inputText(), other.inputText());
    }

    public String toString() {
        return ToString.builder((String)"PostTextRequest").add("BotName", (Object)this.botName()).add("BotAlias", (Object)this.botAlias()).add("UserId", (Object)this.userId()).add("SessionAttributes", (Object)(this.sessionAttributes() == null ? null : "*** Sensitive Data Redacted ***")).add("RequestAttributes", (Object)(this.requestAttributes() == null ? null : "*** Sensitive Data Redacted ***")).add("InputText", (Object)(this.inputText() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "botName": {
                return Optional.ofNullable(clazz.cast(this.botName()));
            }
            case "botAlias": {
                return Optional.ofNullable(clazz.cast(this.botAlias()));
            }
            case "userId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
            case "sessionAttributes": {
                return Optional.ofNullable(clazz.cast(this.sessionAttributes()));
            }
            case "requestAttributes": {
                return Optional.ofNullable(clazz.cast(this.requestAttributes()));
            }
            case "inputText": {
                return Optional.ofNullable(clazz.cast(this.inputText()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PostTextRequest, T> g) {
        return obj -> g.apply((PostTextRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexRuntimeRequest.BuilderImpl
    implements Builder {
        private String botName;
        private String botAlias;
        private String userId;
        private Map<String, String> sessionAttributes = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> requestAttributes = DefaultSdkAutoConstructMap.getInstance();
        private String inputText;

        private BuilderImpl() {
        }

        private BuilderImpl(PostTextRequest model) {
            super(model);
            this.botName(model.botName);
            this.botAlias(model.botAlias);
            this.userId(model.userId);
            this.sessionAttributes(model.sessionAttributes);
            this.requestAttributes(model.requestAttributes);
            this.inputText(model.inputText);
        }

        public final String getBotName() {
            return this.botName;
        }

        @Override
        public final Builder botName(String botName) {
            this.botName = botName;
            return this;
        }

        public final void setBotName(String botName) {
            this.botName = botName;
        }

        public final String getBotAlias() {
            return this.botAlias;
        }

        @Override
        public final Builder botAlias(String botAlias) {
            this.botAlias = botAlias;
            return this;
        }

        public final void setBotAlias(String botAlias) {
            this.botAlias = botAlias;
        }

        public final String getUserId() {
            return this.userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        public final Map<String, String> getSessionAttributes() {
            return this.sessionAttributes;
        }

        @Override
        public final Builder sessionAttributes(Map<String, String> sessionAttributes) {
            this.sessionAttributes = StringMapCopier.copy(sessionAttributes);
            return this;
        }

        public final void setSessionAttributes(Map<String, String> sessionAttributes) {
            this.sessionAttributes = StringMapCopier.copy(sessionAttributes);
        }

        public final Map<String, String> getRequestAttributes() {
            return this.requestAttributes;
        }

        @Override
        public final Builder requestAttributes(Map<String, String> requestAttributes) {
            this.requestAttributes = StringMapCopier.copy(requestAttributes);
            return this;
        }

        public final void setRequestAttributes(Map<String, String> requestAttributes) {
            this.requestAttributes = StringMapCopier.copy(requestAttributes);
        }

        public final String getInputText() {
            return this.inputText;
        }

        @Override
        public final Builder inputText(String inputText) {
            this.inputText = inputText;
            return this;
        }

        public final void setInputText(String inputText) {
            this.inputText = inputText;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PostTextRequest build() {
            return new PostTextRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LexRuntimeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PostTextRequest> {
        public Builder botName(String var1);

        public Builder botAlias(String var1);

        public Builder userId(String var1);

        public Builder sessionAttributes(Map<String, String> var1);

        public Builder requestAttributes(Map<String, String> var1);

        public Builder inputText(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

